@extends('online.masters.app')
@section('styles')
<style>
	iframe{
		width: 600px;		
		height: 450px;
		border: 0px !important;
		border-radius: 0px !important;
	}
</style>
@endsection
@section('content')
    <!-- Page content start -->
    <main class="content-wrapper">
		{{-- page title start  --}}
		<nav class="container pt-3 my-3 my-md-4" aria-label="breadcrumb">
			<h2 class="text-center">@lang('menu.AboutUs')</h2>
		</nav>  
		{{-- page title end  --}}
		{{-- main contents start  --}}
		<section class="container">
		  <div class="row">
			<!-- Cover image -->
			<div class="col-md-7 order-md-2 mb-4 mb-md-0">
			  <div class="position-relative h-100">
				<div class="ratio ratio-16x9"></div>
				@if($company->company_image)
				<img src="{{onlineSystemConfig()['back_site_link'].'/uploads/logo/'.$company->company_image}}" class="position-absolute top-0 start-0 w-100 h-100 object-fit-cover rounded-5" alt="Image">
				@else
				<img src="{{url('/online/assets/media/avatars/blank.png')}}" class="position-absolute top-0 start-0 w-100 h-100 object-fit-cover rounded-5" alt="Image">
				@endif
			  </div>
			</div>
			<!-- Text + button -->
			<div class="col-md-5 order-md-1">
			  <div class="position-relative pb-5 px-4 px-sm-5">
				<span class="position-absolute top-0 start-0 w-100 h-100 rounded-5 d-none-dark rtl-flip" style="background: linear-gradient(-90deg, #accbee 0%, #e7f0fd 100%)"></span>
				<span class="position-absolute top-0 start-0 w-100 h-100 rounded-5 d-none d-block-dark rtl-flip" style="background: linear-gradient(-90deg, #1b273a 0%, #1f2632 100%)"></span>
				<div class="position-relative z-1 py-md-2 py-lg-4 py-xl-5 px-xl-2 px-xxl-4 my-xxl-3">
				  	<h3 class="pb-1 pb-md-2 pb-lg-3 text-center pt-3">
						@if($company)
							{{$company->company_name}}
						@endif
					</h3>
					<p class="text-dark-emphasis pb-sm-2 pb-lg-0 mb-lg-5 fs-5" style="text-align: justify;text-align-last: center;">
						@if($company && $company->description)
						{{$company->description}}
						@endif
					</p>					
				</div>
			  </div>
			</div>
		  </div>
		</section>
		{{-- main contents end  --}}
		{{-- counter part start  --}}
		<section class="container py-5 mt-md-2 mt-lg-4">
		  <div class="">
			@if($info_details)
			<div class="swiper pb-lg-2" data-swiper="{
				&quot;slidesPerView&quot;: 1, &quot;spaceBetween&quot;: 24, &quot;pagination&quot;: { &quot;el&quot;: &quot;.swiper-pagination&quot;, &quot;clickable&quot;: true }, &quot;breakpoints&quot;: { &quot;500&quot;: { &quot;slidesPerView&quot;: 2 }, &quot;768&quot;: { &quot;slidesPerView&quot;: 3 }, &quot;992&quot;: { &quot;slidesPerView&quot;: 5 } } }">
				<div class="swiper-wrapper">
				  <!-- Category -->
				  @foreach($info_details AS $record)
				  @if($record->company_type =="statistic")
				  <div class="swiper-slide text-center">
						<div class="display-6 text-dark-emphasis mb-2 CounterPart" data-number="+{{$record->company_qty}}"></div>
						<p class="fs-sm mb-0">{{$record->title}}</p>
				  </div>
				  @endif
				  @endforeach
				</div>
				<!-- Slider pagination (Bullets) -->
				<div class="swiper-pagination position-static mt-3 mt-sm-4"></div>
			</div>
			@endif
		  </div>
		</section>
		{{-- counter part end  --}}
		{{-- description part start  --}}
		<section class="container-start pt-5 pb-5">
		  <div class="row align-items-center g-0 pt-2 pt-sm-3 pt-md-4 pt-lg-5">
			<div class="col-md-5 col-lg-3 pb-1 pb-md-0 pe-3 ps-md-0 mb-4 mb-md-0">
			  <div class="d-flex flex-md-column align-items-end align-items-md-start">
				<div class="mb-md-5 me-3 me-md-0">
				  	<h3 class="h1 mb-0">
						@if($company)
							{{$company->company_name}}
						@endif
					</h3>
				</div>
				<!-- External slider prev/next buttons -->
				<div class="d-flex gap-2">
				  <button type="button" id="prev-values" class="btn btn-icon btn-outline-secondary rounded-circle animate-slide-start me-1" aria-label="Prev">
					<i class="ci-chevron-left fs-xl animate-target"></i>
				  </button>
				  <button type="button" id="next-values" class="btn btn-icon btn-outline-secondary rounded-circle animate-slide-end" aria-label="Next">
					<i class="ci-chevron-right fs-xl animate-target"></i>
				  </button>
				</div>
			  </div>
			</div>
			<div class="col-md-7 col-lg-7">
			  <div class="ps-md-4 ps-lg-5">
				<div class="swiper" data-swiper="{ &quot;slidesPerView&quot;: &quot;auto&quot;, &quot;spaceBetween&quot;: 30,  &quot;loop&quot;: true, &quot;navigation&quot;: {&quot;prevEl&quot;: &quot;#prev-values&quot;,&quot;nextEl&quot;: &quot;#next-values&quot; }}">
				  <div class="swiper-wrapper">
					@if($info_details)
					@foreach($info_details AS $record)
					@if($record->company_type =="descriptive")
					<!-- Item -->
					<div class="swiper-slide w-auto h-auto">
					  <div class="card h-100 rounded-4 px-3 pb-2 container" style="max-width: 430px; background-size: cover; background-repeat: no-repeat; background-position: center center;">
						<div class="card-body px-2">
							<div class="h4 h5 d-flex align-items-center justify-content-center">
								{{$record->title}}
							</div>
							<p class="mb-0" style="text-align: justify;text-align-last: center;" id="short-text">{{Str::limit($record->description, 300, '...');}}</p>
						</div>
						<div class="d-flex justify-content-between" id="info_modal">
							@if($record->image)
							<img src="{{onlineSystemConfig()['back_site_link'].'uploads/online_about/'.$record->image}}" alt="" width="50" class="thumbnail" id="imageElement{{$record->id}}" style="cursor: zoom-in; border-radius: 7px;" onclick="openFullscreen('imageElement{{$record->id}}')">
							@else
							<img src="{{url('online/assets/blank.png')}}" alt="" width="50" class="thumbnail" id="imageElement{{$record->id}}" style="cursor: zoom-in; border-radius: 7px;" onclick="openFullscreen('imageElement{{$record->id}}')">
							@endif
							<a href="#addPaymentModal1" data-bs-toggle="modal" class="text-muted btn btn-outline-secondary" onclick="showModal('{{$record->title}}', '{{$record->description}}')" id="show-more-btn"> @lang('layout.More') <i class="ci-info cursor-pointer ms-2"></i></a>
						</div>
					  </div>
					</div>
					@endif
					@endforeach
					@endif
				  </div>
				</div>
			  </div>
			</div>
		  </div>
		</section>
		<!-- modal start -->
		<div class="modal fade" id="addPaymentModal1" tabindex="-1" aria-labelledby="addPaymentModalLabel" aria-hidden="true">
			<div class="modal-dialog modal-dialog-centered modal-lg">
			  <div class="modal-content">
				<div class="modal-header">
					<h5 class="modal-title" id="modal-title"></h5>
				  <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close" ></button>
				</div>
				<div class="modal-body">
				<p id="descriptionPart" style="text-align: justify;text-align-last: center;"></p>
				</div>
			  </div>
			</div>
		</div>
		{{-- modal end  --}}
		{{-- decription part end  --}}
		<!-- Map Start-->
		@if(session()->get('online_system_config'))
		<section class="position-relative bg-body-tertiary">
				{{-- <iframe src=" {!! session()->get('online_system_config')->map !!} " width="600" height="450" style="border:0;" allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe> --}}
				{!! session()->get('online_system_config')->map !!}
				{{-- <iframe src=""  style="border:0;" allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe> --}}
		</section>
		@endif
		{{-- Map End --}}
		{{-- Company Visisons or comments start--}}
		<section class="container pb-5 mb-2 mb-sm-3 mb-lg-4 mb-xl-5 mt-4 pt-3">
			@if($info_details)
			<div class="swiper pb-lg-2" data-swiper="{&quot;slidesPerView&quot;: 1, &quot;spaceBetween&quot;: 24, &quot;pagination&quot;: { &quot;el&quot;: &quot;.swiper-pagination&quot;, &quot;clickable&quot;: true }, &quot;breakpoints&quot;: { &quot;500&quot;: { &quot;slidesPerView&quot;: 2 }, &quot;768&quot;: { &quot;slidesPerView&quot;: 3 }, &quot;992&quot;: { &quot;slidesPerView&quot;: 1 } } }">
				<div class="swiper-wrapper">
				  <!-- Category -->
				  @foreach($info_details AS $record)
				  @if($record->company_type == "comment")
				  <div class="swiper-slide text-center">
					<h3 class="h1 pb-2 pb-md-3 mx-auto" style="max-width: 400px">{{$record->title}}</h3>
					<p class="fs-xl pb-lg-4 p-3 " style="text-align: justify;text-align-last: center;border-radius: 10px;"><i class="fa fa-quote-right"></i>&nbsp; {{$record->description}} &nbsp;<i class="fa fa-quote-left"></i></p>	
					@if($record->image)
					<img src="{{onlineSystemConfig()['back_site_link'].'uploads/online_about/'.$record->image}}" width="64" class="d-block rounded-circle mx-auto mb-3" alt="Avatar">
					@else
					<img src="{{url('/online/assets/blank.png')}}" width="64" class="d-block rounded-circle mx-auto mb-3" alt="Avatar">
					@endif
					<h6 class="mb-0">{{$record->company_name}}</h6>
				  </div>
				  @endif
				  @endforeach
				</div>
				<!-- Slider pagination (Bullets) -->
				<div class="swiper-pagination position-static mt-3 mt-sm-4"></div>
			</div>
			@endif
		</section>
		{{-- Company Visisons or Comments end  --}}
		<!-- testimonels Part start -->
		<section class="container pb-5 mb-2 mb-sm-3 mb-lg-4 mb-xl-5">
			<div>
				<h2 class="h3 text-center pb-1 pb-sm-2 pb-md-3 pb-lg-0 mb-4 mb-lg-5" >@lang('layout.Comments')</h2>
				<div class="swiper pb-lg-2" data-swiper="{ &quot;slidesPerView&quot;: 1, &quot;spaceBetween&quot;: 24, &quot;pagination&quot;:{ &quot;el&quot;: &quot;.swiper-pagination&quot;, &quot;clickable&quot;: true }, &quot;breakpoints&quot;: { &quot;500&quot;: { &quot;slidesPerView&quot;: 2 }, &quot;768&quot;: { &quot;slidesPerView&quot;: 3 }, &quot;992&quot;: { &quot;slidesPerView&quot;: 5 }}}">
					<div class="swiper-wrapper">
						<!-- Category -->
						@foreach($online_about_comment as $coment)
						<div class="swiper-slide text-center rounded border" style="padding: 0px 10px;height: 25vh;overflow-y: auto;">
							<div class="position-relative d-inline-block text-dark-emphasis bg-warning-subtle p-1 mt-2" style="width: 4rem;height: 4rem;border-radius: 50%">
								<img src="{{url('online/assets/blank.png')}}" class="" style="border-radius: 50%; width: 100%" loading="lazy" alt="" />
							</div>
							<h3 class="h5 mb-2">
								<a class="animate-underline stretched-link" href="#">
									<span class="animate-target">{{$coment->user_name}}</span>
								</a>
							</h3>
							<p class="fs-sm mb-0">{{$coment->description}}</p>
						</div>
						@endforeach
					</div>
					<!-- Slider pagination (Bullets) -->
					<div class="swiper-pagination position-static mt-3 mt-sm-4"></div>
				</div>
			</div>
			</div>
		</section>
		<!-- testimonels Part end -->
		{{-- mesasage sending part start  --}}
		@section('form_sub')
		<div class="border-bottom py-5" >
			<div class="container py-sm-1 py-md-2 py-lg-3" style="border: 1px solid rgb(76, 76, 76);border-radius: 10px;">
				<div>
					<h3 class="pb-1 mb-2 text-center mt-2" style="margin: auto auto">@lang('layout.ContactUs')</h3>
					{{Form::open(['route' => 'comment.store','method' => 'POST','class' => 'needs-validation position-relative d-flex flex-column flex-sm-row gap-2 pt-3','id'=>'comment-form'])}}
					{{ csrf_field() }}
					<input type="hidden" value="about" name="category">
					<div class="col-lg-12 col-md-12 col-sm-12">
						<div class="row">
							<div class="col-lg-6 col-md-6 col-sm-12">
								<div class="form-group">
									<label for="name" class="form-label">@lang('layout.Name')</label>
									<input type="text"class="form-control form-control-lg rounded text-start" name="name" v-validate="'required'" data-vv-as="@lang('layout.Name')" required="">
								</div>
							</div>
							<div class="col-lg-6 col-md-6 col-sm-12">
								<div class="form-group">
									<label for="name" class="form-label">@lang('layout.Email')</label>
									<input type="email" class="form-control form-control-lg rounded text-start" name="email" v-validate="'required'" data-vv-as="@lang('layout.Email')" required="">
								</div>
							</div>
							<div class="col-lg-12 col-md-12 col-sm-12">
								<div class="form-group">
									<label for="name" class="form-label">@lang('layout.Message')</label>
									<textarea class="form-control form-control-lg rounded text-start" rows="2" name="message" v-validate="'required'" data-vv-as="@lang('layout.Message')" required=""></textarea>
								</div>
							</div>
							<button type="submit" class="btn btn-primary mt-3 mb-3" style="width: fit-content;margin: auto auto; border-radius: 7px;" @click="saveAndNew($event)">@lang('layout.SendMessage')</button>
						</div>
					</div>
					{!! Form::close() !!}
				</div>
			</div>
		</div>
		@endsection
		{{-- mesasage sending part end  --}}
	</main>
	{{-- Page content end  --}}
@endsection
@push('scripts')
<!--begin::Page Scripts(used by this page)-->
<script src="{{url('/online/assets-v7/js/pages/widgets.js')}}"></script>
<script src="{{url('/online/assets-v7/js/pages/custom/profile/profile.js')}}"></script>
<!--end::Page Scripts-->
<?php
    $company_number =  null;
    $site_link =  null;
    if( onlineSystemConfig()['advertisment'] == 1)
    {
        $company_number =  onlineSystemConfig()['company_number'];
        $site_link =  onlineSystemConfig()['site_link'];
    }
?>
<script type="text/javascript">
	var session_id = "{{session()->get('online_session')}}";
    var url = "{{\URL::to('/')}}";
	function getAdvertisment(com_num, type, loc) {
        if (com_num != null && type != null && loc != null) {
            $.ajax({
                type: 'GET',
                url: uploads_adve + "/get_advertisment/" + com_num + "/" + type + "/" + loc,
				data:{session_id:session_id,url:url},
                success: function(result) {
                    if (result) {
                        if (result.image != null) {
                            if (result.location == 'top') {
                                top_adver.image = uploads_adve+'/uploads/'+result.image;
                                top_adver.link = result.link;
                                top_adver.title = result.title;
                            }
                            if (result.location == 'left') {
                                left_adver.image = uploads_adve+'/uploads/'+result.image;
                                left_adver.link = result.link;
                                left_adver.title = result.title;
                            }
                        }
                    }
                },
                error: function(error) {
                    console.log(140,error);
                }
            });
        }
    }
	var uploads_adve = '{{$site_link}}';
    var top_adver = new Vue({
        el: '#top_adver',
        data: {
            title: '',
            link: '',
            image: '',
            com_num: '{{$company_number}}',
            uploads_adve: '{{$site_link}}'
        },
        mounted: function () {
            if (this.com_num) {
                getAdvertisment(this.com_num, 4, 'top'); 
            }
        },
        methods: {
        }
    });    
    var left_adver = new Vue({
        el: '#left_adver',
        data: {
            title: '',
            link: '',
            image: '',
            com_num: '{{$company_number}}',
            uploads_adve: '{{$site_link}}'
        },
        mounted: function () {
            if (this.com_num) {
                getAdvertisment(this.com_num, 4, 'left'); 
            }
        },
        methods: {
        }
    });
	var v = new Vue({
		el: '#contact_form',
		data: {
			part: '',
			coment: [],
		},
		computed: {
			setRates() {}
		},
		mounted: function() {
			this.getComent();
		},
		methods: {
			getComent() {
				axios.get("{{route('comment.home')}}", {
					params: {
						category: 'home'
					}
				})
				.then(function(response) {
					if (response.data.length > 0) {
						v.coment = [];
						v.coment = response.data;
					}
				})
				.catch(function(error) {
					console.log(error);
				});
			},
			saveAndNew() {
				this.$validator.validate()
				.then(valid => {
					if (valid) {
						console.log('sss11', valid);
						var url = "{{route('comment.store')}}";
						form_id = 'comment-form';
						var data = $('#' + form_id).serialize();
						axios.post(url, data)
						.then(function(response) {
							console.log('sss11', response.data);
							if (response.data.result == 1) {
								$('#' + form_id).trigger('reset');
								toastr.success('', response.data.message);
							} else {
								var message = "{{__('message.Warning')}}";
								toastr.warning('', message);
							}
						})
						.catch(function(error) {
							console.log(error);
							var message = "{{__('message.Warning')}}";
							toastr.warning('', message);
						});
					}
				})
			},
		},
		created: function() {
		}
	});	
	function toggleFullscreen(imageElement){
		imageElement.classList.toggle('fullscreen');
	}
	function showModal(title, description){
		document.getElementById('modal-title').innerText = title;
		document.getElementById('descriptionPart').innerText = description;
	}
	let count = document.querySelectorAll('.CounterPart');
	let arr = Array.from(count);
	arr.map(function (item){
		let startnumber = 0;
		function counterup(){
			startnumber++;
			item.innerHTML = startnumber;
			if(startnumber == item.dataset.number){
				clearInterval(stop);
			}
		}
		let stop = setInterval(function(){
			counterup();
		}, 20);
	});
	function openFullscreen(imageId){
		var imageElement = document.getElementById(imageId);
		if(imageElement.requestFullscreen){
			imageElement.requestFullscreen();
		}
		else if(imageElement.mozRequestFullScreen){
			imageElement.mozRequestFullScreen();
		}
		else if(imageElement.webkitRequestFullscreen){
			imageElement.webkitRequestFullscreen();
		}
		else if(imageElement.msRequestFullscreen){
			imageElement.msRequestFullscreen();
		}
	}
</script>
@endpush