@extends('layouts.app')
@section('style')
<style type="text/css">
    body, html{
        height: 100%;
    }
    .background{
        position: relative;
        width: 100%;
        height: 100vh;
        background-image: url('{{asset('menu_img/SaleImages/Capture6.PNG')}}');
        background-size: cover;
        background-position: center;
        background-repeat: no-repeat;
        overflow-y: auto;
    }
    .overlay{
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100vh;
        background-color: rgba(0, 0, 0, 0.651);
        display: flex;
        justify-content: center;
        align-items: flex-start;
        padding-top: 20px;
    }
    .cards{
        display: flex;
        flex-wrap: wrap;
        justify-content: center;
        width: 100%;
        max-width: 1600px;
        padding: 10px;
        box-sizing: border-box;
        gap: 10px;
    }
    .allCards{ 
        width: 19%;
        /* height: 80px; */
        min-height: 90px;
        background-color: white;
        border-radius: 10px;
        box-shadow: 0 4px 8px rgba(235, 232, 232, 0.877);
        transition: .5s;
    }
    .allMainCard{ 
        width: 19%;
        /* height: 80px; */
        min-height: 100px;
        border-radius: 10px;
        transition: .5s;
    }
    .allMainCard:hover{
        text-decoration: none;
    }
    .allCards:hover{
        background-color: rgba(255, 255, 255, 0.787);
        transition: .5s;
    }
    .allCards:hover a{
        text-decoration: none;
    }
    @media(max-width: 1024px){
        .allCards{
            width: 22%;
        }
        .allMainCard{
            width: 22%;
        }
    }
    @media(max-width: 768px){
        .allCards{
            width: 45%;
        }
        .allMainCard{
            width: 45%;
        }
    }
    @media(max-width: 480px){
        .allCards{
            width: 90%;
        }
        .allMainCard{
            width: 90%;
        }
    }
    .caret{
        transition: transform 0.3s ease;
    }
    .caret.open{
        transform: rotate(90deg);
    }
</style>
@stop
@section('content')
<div class="background">
    <div class="overlay">
        <div class="cards">
            <div class="mainHeader" style="display: flex; justify-content: space-between;width: 100%;flex-wrap: wrap;">
                <h3 style="color: white;">@lang('menu.OilAndGas')</h3>
                <div >
                    <div class="btn-group">
                        @if(systemConfig()[7] != 0 )
                        @permission('vehicleCategory-create')
                        <a href="{{route('vehicleCategory.create')}}" type="button" class="btn topBtn" style="background-color: #50818d;color: white;">@lang('layout.AddNew')</a>
                        <button type="button" class="btn topBtn dropdown-toggle btn-success" data-toggle="dropdown" id="dropdownButton">
                            <span class="caret"></span>
                        </button>
                        @endpermission
                        @endif
                        <ul class="dropdown-menu dropdown-menu-right" role="menu">
                            @if(systemConfig()[7] != 0 )
                            @permission('vehicleCategory-create')
                            <li>
                                <a href="{{route('vehicleCategory.create')}}">@lang('menu.VehicleCategory')</a>
                            </li>
                            @endpermission
                            @endif
                            @if(systemConfig()[7] != 0 )
                            @permission('vehicle-create')
                            <li>
                                <a href="{{route('vehicleType.create')}}">@lang('menu.VehicleType')</a>
                            </li>
                            @endpermission
                            @endif
                            @if(systemConfig()[7] != 0 )
                            @permission('vehicle-create')
                            <li>
                                <a href="{{route('vehicle.create')}}">@lang('menu.Vehicle')</a>
                            </li>
                            @endpermission
                            @endif
                            @if(systemConfig()[7] != 0 )
                            @permission('vehicle-create')
                            <li>
                                <a href="{{route('vehicleEquipment.create')}}">@lang('menu.VehicleEquipment')</a>
                            </li>
                            @endpermission
                            @endif
                            @if(systemConfig()[7] != 0 )
                            @permission('vehicle-create')
                            <li>
                                <a href="{{route('vehicleLocation.create')}}">@lang('menu.Location')</a>
                            </li>
                            @endpermission
                            @endif
                            @if(systemConfig()[7] != 0 )
                            @permission('VehicleCMR-create')
                            <li>
                                <a href="{{route('vehicleIntroduce.create')}}">@lang('layout.VehicleIntroduce')</a>
                            </li>
                            @endpermission
                            @endif
                            @if(systemConfig()[7] != 0 )
                            @permission('VehicleCMR-create')
                            <li>
                                <a href="{{route('vehicleCMR.create')}}"> @lang('layout.VehicleCMR')</a>
                            </li>
                            @endpermission
                            @endif
                            @if(systemConfig()[7] != 0 )
                            @permission('VehicleLogBook-create')
                            <li>
                                <a href="{{route('vehicleLogBook.create')}}"> @lang('menu.vehicleLogBook')</a>
                            </li>
                            @endpermission
                            @endif
                            @if(systemConfig()[7] != 0 )
                            @permission('toRentVehicle-create')
                            <li>
                                <a href="{{route('rentVehicle.create')}}"> @lang('menu.ToRentVehicle')</a>
                            </li>
                            @endpermission
                            @endif
                            @if(systemConfig()[7] != 0 )
                            @permission('toRentVehicle-list')
                            <li>
                                <a href="{{route('vehicleExpenseCategory.index')}}"> @lang('menu.VehicleExpensesCategories')</a>
                            </li>
                            @endpermission
                            @endif
                            @if(systemConfig()[7] != 0 )
                            @permission('toRentVehicle-create')
                            <li>
                                <a href="{{route('vehicleExpense.create')}}"> @lang('menu.VehicleExpenses')</a>
                            </li>
                            @endpermission
                            @endif
                            @if(systemConfig()[7] != 0 )
                            @permission('toRentVehicle-create')
                            <li>
                                <a href="{{route('vehicleExpenseReturn.create')}}"> @lang('menu.ReturnVehicleExpenses')</a>
                            </li>
                            @endpermission
                            @endif
                            @if(systemConfig()[7] != 0 )
                            @permission('toRentVehicle-create')
                            <li>
                                <a href="{{route('vehicleOilSale.create')}}"> @lang('menu.SaleOilToVehicle')</a>
                            </li>
                            @endpermission
                            @endif
                        </ul>
                    </div>
                    <a href="#" class="btn btn-danger">@lang('layout.Back') <i class="fa fa-reply"></i></a>
                </div>
            </div>
            <div class="cards">
                @if(systemConfig()[7] != 0 )
                @permission('vehicleCategory-list')
                <a href="{{route('vehicleCategory.index')}}"   class="allMainCard" style="cursor: pointer;">
                    <div class="allCards" style="width: 100%;">
                        <div style="padding: 0px 10px;display: flex;justify-content: space-between;width: 100%;">
                            <div style="padding: 0px !important; margin: 0px !important;">
                                <div class="titleBtn"><p style="padding:5px 0px !important; margin: 0px !important;font-weight: bold;">@lang('menu.VehicleCategory')</p></div>
                            </div>
                            <div>
                                <div><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: #7ccc04;" class="fa fa-tablet"></i></div>
                            </div>
                        </div>
                        <div style="padding: 0px 5px !important; margin: 0px !important;">
                            <p style="padding: 0px !important; margin: 0px !important;">{{$vehicleCategory}}</p>
                        </div>
                    </div>
                </a>
                @endpermission
                @endif
                @if(systemConfig()[7] != 0 )
                @permission('vehicle-list')
                <a href="{{route('vehicleType.index')}}"   class="allMainCard" style="cursor: pointer;">
                    <div class="allCards" style="width: 100%;">
                        <div style="padding: 0px 10px;display: flex;justify-content: space-between;width: 100%;">
                            <div style="padding: 0px !important; margin: 0px !important;">
                                <div class="titleBtn"><p style="padding:5px 0px !important; margin: 0px !important;font-weight: bold;">@lang('menu.VehicleType')</p></div>
                            </div>
                            <div>
                                <div><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: #b6babf;" class="fa fa-car"></i></div>
                            </div>
                        </div>
                        <div style="padding: 0px 5px !important; margin: 0px !important;">
                            <p style="padding: 0px !important; margin: 0px !important;">{{$vehicleType}}</p>
                        </div>
                    </div>
                </a>
                @endpermission
                @endif
                @if(systemConfig()[7] != 0 )
                @permission('vehicle-list')
                <a href="{{route('vehicle.index')}}"  class="allMainCard" style="cursor: pointer;">
                    <div class="allCards" style="width: 100%;">
                        <div style="padding: 0px 10px;display: flex;justify-content: space-between;width: 100%;">
                            <div style="padding: 0px !important; margin: 0px !important;">
                                <div class="titleBtn"><p style="padding:5px 0px !important; margin: 0px !important;font-weight: bold;">@lang('menu.Vehicle')</p></div>
                            </div>
                            <div>
                                <div><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: #fb8001;" class="fa fa-truck"></i></div>
                            </div>
                        </div>
                        <div style="padding: 0px 5px !important; margin: 0px !important;">
                            <p style="padding: 0px !important; margin: 0px !important;">{{$vehicle}}</p>
                        </div>
                    </div>
                </a>
                @endpermission
                @endif
                @if(systemConfig()[7] != 0 )
                @permission('vehicle-list')
                <a href="{{route('vehicleEquipment.index')}}"  class="allMainCard" style="cursor: pointer;">
                    <div class="allCards" style="width: 100%;">
                        <div style="padding: 0px 10px;display: flex;justify-content: space-between;width: 100%;">
                            <div style="padding: 0px !important; margin: 0px !important;">
                                <div class="titleBtn"><p style="padding:5px 0px !important; margin: 0px !important;font-weight: bold;">@lang('menu.VehicleEquipment')</p></div>
                            </div>
                            <div>
                                <div><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: #0175c0;" class="fa fa-cog"></i></div>
                            </div>
                        </div>
                        <div style="padding: 0px 5px !important; margin: 0px !important;">
                            <p style="padding: 0px !important; margin: 0px !important;">{{$vehicleEquipment}}</p>
                        </div>
                    </div>
                </a>
                @endpermission
                @endif
                @if(systemConfig()[7] != 0 )
                @permission('vehicle-list')
                <a href="{{route('vehicleLocation.index')}}"  class="allMainCard" style="cursor: pointer;">
                    <div class="allCards" style="width: 100%;">
                        <div style="padding: 0px 10px;display: flex;justify-content: space-between;width: 100%;">
                            <div style="padding: 0px !important; margin: 0px !important;">
                                <div class="titleBtn"><p style="padding:5px 0px !important; margin: 0px !important;font-weight: bold;">@lang('menu.Location')</p></div>
                            </div>
                            <div>
                                <div><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: #259ce0;" class="fa fa-map-marker"></i></div>
                            </div>
                        </div>
                        <div style="padding: 0px 5px !important; margin: 0px !important;">
                            <p style="padding: 0px !important; margin: 0px !important;">{{$vehicleLocation}}</p>
                        </div>
                    </div>
                </a>
                @endpermission
                @endif
                @if(systemConfig()[7] != 0 )
                @permission('VehicleCMR-list')
                <a href="{{route('vehicleIntroduce.index')}}"  class="allMainCard" style="cursor: pointer;">
                    <div class="allCards" style="width: 100%;">
                        <div style="padding: 0px 10px;display: flex;justify-content: space-between;width: 100%;">
                            <div style="padding: 0px !important; margin: 0px !important;">
                                <div class="titleBtn"><p style="padding:5px 0px !important; margin: 0px !important;font-weight: bold;">@lang('layout.VehicleIntroduce')</p></div>
                            </div>
                            <div>
                                <div><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: #1fa7f2;" class="fa fa-book"></i></div>
                            </div>
                        </div>
                        <div style="padding: 0px 5px !important; margin: 0px !important;">
                            <p style="padding: 0px !important; margin: 0px !important;">{{$VehicleM}}</p>
                        </div>
                    </div>
                </a>
                @endpermission
                @endif
                @if(systemConfig()[7] != 0 )
                @permission('VehicleCMR-list')
                <a href="{{route('vehicleCMR.index')}}"  class="allMainCard" style="cursor: pointer;">
                    <div class="allCards" style="width: 100%;">
                        <div style="padding: 0px 10px;display: flex;justify-content: space-between;width: 100%;">
                            <div style="padding: 0px !important; margin: 0px !important;">
                                <div class="titleBtn"><p style="padding:5px 0px !important; margin: 0px !important;font-weight: bold;">@lang('layout.VehicleCMR')</p></div>
                            </div>
                            <div>
                                <div><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: rgb(193, 179, 22);" class="fa fa-book"></i></div>
                            </div>
                        </div>
                        <div style="padding: 0px 5px !important; margin: 0px !important;">
                            <p style="padding: 0px !important; margin: 0px !important;">{{$VehicleMs}}</p>
                        </div>
                    </div>
                </a>
                @endpermission
                @endif
                @if(systemConfig()[7] != 0 )
                @permission('VehicleLogBook-list')
                <a href="{{route('vehicleLogBook.index')}}"  class="allMainCard" style="cursor: pointer;">
                    <div class="allCards" style="width: 100%;">
                        <div style="padding: 0px 10px;display: flex;justify-content: space-between;width: 100%;">
                            <div style="padding: 0px !important; margin: 0px !important;">
                                <div class="titleBtn"><p style="padding:5px 0px !important; margin: 0px !important;font-weight: bold;">@lang('menu.vehicleLogBook')</p></div>
                            </div>
                            <div>
                                <div><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: rgba(163, 209, 118, 1);" class="fa fa-book"></i></div>
                            </div>
                        </div>
                        <div style="padding: 0px 5px !important; margin: 0px !important;">
                            <p style="padding: 0px !important; margin: 0px !important;">{{$vehicleLogBook}}</p>
                        </div>
                    </div>
                </a>
                @endpermission
                @endif
                @if(systemConfig()[7] != 0 )
                @permission('toRentVehicle-list')
                <a href="{{route('rentVehicle.index')}}" class="allMainCard" style="cursor: pointer;">
                    <div class="allCards" style="width: 100%;">
                        <div style="padding: 0px 10px;display: flex;justify-content: space-between;width: 100%;">
                            <div style="padding: 0px !important; margin: 0px !important;">
                                <div class="titleBtn"><p style="padding:5px 0px !important; margin: 0px !important;font-weight: bold;">@lang('menu.ToRentVehicle')</p></div>
                            </div>
                            <div>
                                <div><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: rgba(1, 131, 128, 1);" class="fa fa-money"></i></div>
                            </div>
                        </div>
                        <div style="padding: 0px 5px !important; margin: 0px !important;">
                            <p style="padding: 0px !important; margin: 0px !important;">{{myround($getAllVehicleRent)}} {{getHomeCurrency()['code']}}</p>
                        </div>
                    </div>
                </a>
                @endpermission
                @endif
                @if(systemConfig()[7] != 0 )
                @permission('toRentVehicle-list')
                <a href="{{route('vehicleExpenseCategory.index')}}" class="allMainCard" style="cursor: pointer;">
                    <div class="allCards" style="width: 100%;">
                        <div style="padding: 0px 10px;display: flex;justify-content: space-between;width: 100%;">
                            <div style="padding: 0px !important; margin: 0px !important;">
                                <div class="titleBtn"><p style="padding:5px 0px !important; margin: 0px !important;font-weight: bold;">@lang('menu.VehicleExpensesCategories')</p></div>
                            </div>
                            <div>
                                <div><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: rgba(1, 166, 164, 1);" class="fa fa-money"></i></div>
                            </div>
                        </div>
                        <div style="padding: 0px 5px !important; margin: 0px !important;">
                            <p style="padding: 0px !important; margin: 0px !important;">{{$VehicleExpenseCategory}}</p>
                        </div>
                    </div>
                </a>
                @endpermission
                @endif
                @if(systemConfig()[7] != 0 )
                @permission('toRentVehicle-list')
                <a href="{{route('vehicleExpense.index')}}" class="allMainCard" style="cursor: pointer;">
                    <div class="allCards" style="width: 100%;">
                        <div style="padding: 0px 10px;display: flex;justify-content: space-between;width: 100%;">
                            <div style="padding: 0px !important; margin: 0px !important;">
                                <div class="titleBtn"><p style="padding:5px 0px !important; margin: 0px !important;font-weight: bold;">@lang('menu.VehicleExpenses')</p></div>
                            </div>
                            <div>
                                <div><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: rgba(1, 193, 191, 1);" class="fa fa-money"></i></div>
                            </div>
                        </div>
                        <div style="padding: 0px 5px !important; margin: 0px !important;">
                            <p style="padding: 0px !important; margin: 0px !important;">{{$vehicleExpense}}</p>
                        </div>
                    </div>
                </a>
                @endpermission
                @endif
                @if(systemConfig()[7] != 0 )
                @permission('toRentVehicle-list')
                <a href="{{route('vehicleExpenseReturn.index')}}" class="allMainCard" style="cursor: pointer;">
                    <div class="allCards" style="width: 100%;">
                        <div style="padding: 0px 10px;display: flex;justify-content: space-between;width: 100%;">
                            <div style="padding: 0px !important; margin: 0px !important;">
                                <div class="titleBtn"><p style="padding:5px 0px !important; margin: 0px !important;font-weight: bold;">@lang('menu.ReturnVehicleExpenses')</p></div>
                            </div>
                            <div>
                                <div><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: rgba(21, 239, 233, 1);" class="fa fa-money"></i></div>
                            </div>
                        </div>
                        <div style="padding: 0px 5px !important; margin: 0px !important;">
                            <p style="padding: 0px !important; margin: 0px !important;">@if($vehicleExpenseReturn){{myround($vehicleExpenseReturn)}} {{getHomeCurrency()['code']}} @else 0 @endif</p>
                        </div>
                    </div>
                </a>
                @endpermission
                @endif
                @if(systemConfig()[7] != 0 )
                @permission('toRentVehicle-list')
                <a href="{{route('vehicleOilSale.index')}}" class="allMainCard" style="cursor: pointer;">
                    <div class="allCards" style="width: 100%;">
                        <div style="padding: 0px 10px;display: flex;justify-content: space-between;width: 100%;">
                            <div style="padding: 0px !important; margin: 0px !important;">
                                <div class="titleBtn"><p style="padding:5px 0px !important; margin: 0px !important;font-weight: bold;">@lang('menu.SaleOilToVehicle')</p></div>
                            </div>
                            <div>
                                <div><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: rgba(77, 94, 137, 1);" class="fa fa-shopping-cart"></i></div>
                            </div>
                        </div>
                        <div style="padding: 0px 5px !important; margin: 0px !important;">
                            <p style="padding: 0px !important; margin: 0px !important;">{{$sale}}</p>
                        </div>
                    </div>
                </a>
                @endpermission
                @endif
            </div>
        </div>
    </div>
</div>
@endsection
@push('scripts')
<script>
    const dropdownButton = document.getElementById('dropdownButton');
    const caret = dropdownButton.querySelector('.caret');
    dropdownButton.addEventListener('click', ()=>{
        caret.classList.toggle('open');
    });
    function toggleContent(){
        var content = document.querySelector('.content');
        var icon = document.getElementById('icon');
        if(content.classList.contains('collapsed')){
            content.classList.remove('collapsed');
            content.classList.add('expanded');
            icon.classList.remove('fa-chevron-down');
            icon.classList.add('fa-chevron-up');
        }else{
            content.classList.remove('expanded');
            content.classList.add('collapsed');
            icon.classList.remove('fa-chevron-up');
            icon.classList.add('fa-chevron-down');
        }
    }
</script>
<script type="text/javascript">
    new Vue({
        el: "#system_setting",
        data: {
            settings: settingAll,
            measures: measures,
            sites: sites,
            enable_notify: false
        },
        mounted() {
        },
        methods: {
        }
    });
</script>
@endpush