@extends('layouts.app')
@section('style')
<style>
    .tiles .tile {
        float: {{(session()->get("system_direction") == "ltr"?"left":"right")}};      
        /* width: 100% !important; */
    }
    .tiles{
        display: flex;
        justify-content: center;
        flex-wrap: wrap;
        width: 100%;
        margin: auto auto;
    }
    .tiles .tile{
        width: 16em !important;
    }
    .tiles .tile i{
        transition: .5s;
    }
    .tiles .tile:hover i{
        transform: scale(1.2);
        transition: .5s;
    }
</style>
@endsection
@section('content')
<div id="print-modal">
    <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show" :value-type="'vehicle_Location_On'" @closed="closeModal">
        <div slot="body">
            <div class="row">
                <div class="form-group">
                    <div class="col-md-6">
                        <label class="control-label ">@lang('menu.Vehicle') </label>
                        <select name="vehicle_id" id="" class="form-control">
                            <option value="">@lang('menu.Vehicle')</option>
                            @foreach($vehicle as $v)
                            <option value="{{$v->id}}">{{$v->name}}</option>
                            @endforeach
                        </select>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="form-group">
                    <div class="col-md-12">
                        <div class="form-group">
                            <label class="control-label"> @lang('layout.Date')</label>
                            <div class="input-group">
                                <input class="form-control date" id="range-from-example" name="from_date" autocomplete="off">

                                <span class="input-group-addon"> @lang('layout.To') </span>
                                <input class="form-control date" id="range-to-example" name="to_date" autocomplete="off">

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </report-modal>
</div>
<!-- END PAGE HEADER-->
<div id="print-modal1">
    <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show" :value-type="'loading'" @closed="closeModal">
        <div slot="body"> 
            <div class="row" v-cloak>
                <div class="tabbable tabbable-tabdrop"> 
                    <ul class="nav nav-tabs"> 
                        <li class="active">
                            <a href="#tab1" data-toggle="tab" id="tab_main">@lang('menu.Report')</a>
                        </li>
                        @if(systemConfig()[2] != 0 )
                        @permission(['EmployeeRewards-list'])
                        <li class="">
                            <a href="#tab2" data-toggle="tab" id="tab_custome">@lang('layout.CustomReportM')</a>
                        </li>
                        @endpermission
                        @endif
                    </ul>

                    <div class="tab-content">
                        <div class="tab-pane active" id="tab1">
                            <div class="portlet light bordered">
                                <div class="portlet-body">
                                    <div class="row">
                                        <input type="hidden" name="type_all" value="No">
 
                                        <div class="col-md-6">
                                            <label class="control-label ">@lang('layout.Contract') </label>
                                            <v-select class="vue-select2" v-model="selectedContract" label="company_name" :options="contracts">
                                            </v-select>
                                            <input type="hidden" name="contract_id" v-model.number="(!selectedContract)?null:selectedContract.id">
                                        </div> 
                                        <div class="col-md-6"> 
                                            <label class="control-label ">@lang('layout.Driver') </label>
                                            <v-select class="vue-select2" v-model="selecteddriver" label="name" :options="drivers">
                                            </v-select>
                                            <input type="hidden" name="driver_id" v-model.number="(!selecteddriver)?null:selecteddriver.id">
                                        </div> 
                                        </div> 
                                        <div class="row">
                                        <div class="col-md-6">
                                            <label class="control-label ">@lang('layout.Site') </label>
                                            <select name="site_id" id="" class="form-control">
                                                <option value="">@lang('layout.SelectSite')</option>
                                                @foreach($loadingSites as $row)
                                                <option value="{{$row['id']}}">{{$row['name']}}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                        <div class="col-md-6">
                                            <label class="control-label ">@lang('layout.Location') </label>
                                            <v-select label="name" v-model="loadingLocationSel" :options="loadingLocation"></v-select>
                                            <input type="hidden" name="location" :value="(!loadingLocationSel)?null:loadingLocationSel.name">
                                        </div>
                                        <div class="col-md-6">
                                            <label class="control-label ">@lang('layout.Source') </label>
                                            <v-select label="name" v-model="loadingSourceSel" :options="loadingSource"></v-select>
                                            <input type="hidden" name="source" :value="(!loadingSourceSel)?null:loadingSourceSel.name">
                                        </div>
                                        <div class="col-md-6">
                                            <label class="control-label ">@lang('layout.Destination') </label>
                                            <v-select label="name" v-model="loadingDestinationSel" :options="loadingDestination"></v-select>
                                            <input type="hidden" name="destination" :value="(!loadingDestinationSel)?null:loadingDestinationSel.name">
                                        </div>
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label class="control-label"> @lang('layout.Date')</label>
                                                <div class="input-group">
                                                    <input class="form-control date" id="range-from-example" name="from_date" autocomplete="off">
                    
                                                    <span class="input-group-addon"> @lang('layout.To') </span>
                                                    <input class="form-control date" id="range-to-example" name="to_date" autocomplete="off">
                    
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="tab-pane" id="tab2">
                            <div class="portlet light bordered">
                                <div class="portlet-body">

                                    <form id="saveCustomeReport" role="form"
                                        action="{{route('customeReport.storeCustomeReport')}}" method="post">
                                        @csrf
                                        <input type="hidden" name="part_name" value="dashboard_loading_index">


                                        <div class="col-md-12 col-sm-12 col-xs-12">

                                            <div class="mt-checkbox-inline col-md-2" style="padding: 0px;" v-for="(row,itemIndex) in customReportData">

                                                <div class="form-group">
                                                <table class="table table-striped table-bordered table-advance table-hover">
                                                                <tr>
                                                                    <td style="text-align: center;">@{{ row.Name }}</td>
                                                                </tr>
                                                                <tr>
                                                                    <td style="text-align: center;">
                                                                        <input type="hidden" :name="'column_name['+itemIndex+']'" class="form-control" v-model="row.column_name">


                                                                        <label class="switch">
                                                                            <input type="checkbox" :name="'column_status['+itemIndex+']'" 
                                                                            :checked="row.checkedColumn" >
                                                                            <span class="slider round"></span>
                                                                        </label>
                                                                        <select :name="'column_percentage['+itemIndex+']'" v-model="row.column_percentage" class="form-control" style="width: 90%;">
                                                                            <option value="">@lang('layout.Select')</option>
                                                                            <option value="2">2 %</option>
                                                                            <option value="6">6 %</option>
                                                                            <option value="10">10 %</option>
                                                                            <option value="15">15 %</option>
                                                                            <option value="20">20 %</option>
                                                                            <option value="25">25 %</option>
                                                                            <option value="30">30 %</option>
                                                                            <option value="40">40 %</option>
                                                                            <option value="50">50 %</option>
                                                                            <option value="60">60 %</option>
                                                                        </select>
                                                                    </td>
                                                                </tr>
                                                            </table>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="margiv-top-10">
                                            <!-- <button type="button" onclick="regForm(this)" class="btn green"> <i class="fa fa-save"></i> </button> -->

                                            <button type="button" onclick="saveCustomeReport(this)" class="btn blue"> <i
                                                    class="fa fa-save"></i> </button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>
            </div>



        </div>
    </report-modal>
</div>
<!-- END PAGE HEADER-->
<div class="row">
    <!-- BEGIN EXAMPLE TABLE PORTLET-->
    <div class="portlet light bordered">
        <div class="portlet-title">
            <div class="caption font-dark">
                <i class="fa fa-dashboard font-dark"></i>&nbsp;
                <span class="caption-subject bold uppercase">@lang('menu.Dashboard')</span>
            </div>
            <div class="tools"> </div>
            <div class="pull-right">
            </div>
        </div>
        <div class="portlet-body">
            <div class="row">
                <div class="tiles" style="">
                    <a href="{{route('vehicleType.index')}}">
                        <div class="tile bg-red-sunglo">
                            <div class="tile-body">
                                <i class="fa fa-car"></i>
                            </div>
                            <div class="tile-object">
                                <div class="name" style=""> @lang('menu.VehicleType') </div>
                                <div class="number"> </div>
                            </div>
                        </div>
                    </a>
                    <a href="{{route('vehicle.index')}}">
                        <div class="tile selected bg-yellow-saffron">
                            <div class="corner"> </div>
                            <div class="tile-body">
                                <i class="fa fa-truck"></i>
                            </div>
                            <div class="tile-object">
                                <div class="name"> @lang('menu.Vehicle') </div>
                                <div class="number"> </div>
                            </div>
                        </div>
                    </a>
                    <a href="{{route('vehicleEquipment.index')}}">
                        <div class="tile bg-purple-studio">
                            <div class="tile-body">
                                <i class="fa fa-cog"></i>
                            </div>
                            <div class="tile-object">
                                <div class="name"> @lang('menu.VehicleEquipment') </div>
                                <div class="number"> </div>
                            </div>
                        </div>
                    </a>
                    <a href="{{route('vehicleLocation.index')}}">
                        <div class="tile bg-green-meadow">
                            <div class="tile-body">
                                <i class="fa fa-map-marker"></i>
                            </div>
                            <div class="tile-object">
                                <div class="name"> @lang('menu.Location') </div>
                                <div class="number"> </div>
                            </div>
                        </div>
                    </a>
                    <a href="{{route('rentVehicle.index')}}">
                        <div class="tile bg-red-intense">
                            <div class="tile-body">
                                <i class="fa fa-money"></i>
                            </div>
                            <div class="tile-object">
                                <div class="name"> @lang('menu.ToRentVehicle') </div>
                                <div class="number"> </div>
                            </div>
                        </div>
                    </a>
                    <a href="{{route('vehicleExpense.index')}}">
                        <div class="tile bg-green">
                            <div class="tile-body">
                                <i class="fa fa-money"></i>
                            </div>
                            <div class="tile-object">
                                <div class="name"> @lang('menu.VehicleExpenses') </div>
                                <div class="number"> </div>
                            </div>
                        </div>
                    </a>
                    <a href="{{route('vehicleExpenseReturn.index')}}">
                        <div class="tile bg-blue-steel">
                            <div class="tile-body">
                                <i class="fa fa-money"></i>
                            </div>
                            <div class="tile-object">
                                <div class="name"> @lang('menu.ReturnVehicleExpenses') </div>
                                <div class="number"> </div>
                            </div>
                        </div>
                    </a>
                </div>
            </div>
        </div>
    </div>
    <!-- END EXAMPLE TABLE PORTLET-->
</div>

<div class="row" style="overflow: hidden;">
    <div class="col-md-12">
        <div class="portlet light" style="box-shadow: 0px 0px 3px rgba(187, 187, 187, 0.69);border-radius: 8px;padding: 20px;border-top: 1px solid rgba(187, 187, 187, 0.266);">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="fa fa-truck font-green" style="font-size: 25px"></i>&nbsp;
                    <span class="caption-subject bold uppercase">@lang('layout.Loading')</span>
                </div>
                <div class="tools"> </div>
                <div class="pull-right">
                    <span id="anchore-modal1">
                        <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                            <i class="fa fa-print"></i>
                        </a>
                    </span>
                </div>
            </div>
            <div class="portlet-body">
                <div id="sites">
                <div class="col-md-3">
                    <div class="form-group">
                        <!-- label class="control-label ">@lang('menu.TransportCompany') </label -->
                        <select name="site_id" @Click="getData()" v-model="site_id" class="form-control">
                            <option value="0">@lang('layout.SelectSite')</option>
                            @foreach($loadingSites as $row)
                            <option value="{{$row['id']}}">{{$row['name']}}</option>
                            @endforeach
                        </select>
                    </div>
                </div>
                <div class="col-md-2">
                    <div class="form-group">
                        <!-- label class="control-label ">@lang('menu.TransportCompany') </label -->
                        <select name="source" @Click="getData()" v-model="loadingSourceSel" class="form-control">
                            <option value="0">@lang('layout.Source')</option>
                            @foreach($loadingSource as $row1)
                            <option value="{{$row1['name']}}">{{$row1['name']}}</option>
                            @endforeach
                        </select>
                    </div>
                </div>
                <div class="col-md-2">
                    <div class="form-group">
                        <!-- label class="control-label ">@lang('menu.TransportCompany') </label -->
                        <select name="destination" @Click="getData()" v-model="loadingDestinationSel" class="form-control">
                            <option value="0">@lang('layout.Destination')</option>
                            @foreach($loadingDestination as $row2)
                            <option value="{{$row2['name']}}">{{$row2['name']}}</option>
                            @endforeach
                        </select>
                    </div>
                </div>
                </div>
                <table class="table table-striped table-bordered table-hover" id="loading">
                    <thead>
                        <tr>
                            <th style="min-width: 100px">@lang('layout.Driver') </th>
                            <th style="min-width: 100px">@lang('layout.Transporter_name') </th>
                            <th style="min-width: 100px">@lang('layout.VehicleName')</th>
                            <th style="min-width: 100px">@lang('layout.TankerNumber')</th>
                            <th style="min-width: 100px">@lang('layout.DriverType')</th>
                            <th style="min-width: 100px">@lang('layout.Type')</th>
                            <th style="min-width: 100px">@lang('layout.TypeNumber')</th> 
                            <th style="min-width: 100px">@lang('layout.WayBillNumber') </th>
                            <th style="min-width: 100px">@lang('layout.TransitNumber') </th>
                            <th style="min-width: 100px">@lang('layout.SourcePlace') </th>
                            <th style="min-width: 100px">@lang('layout.Location') </th>
                            <th style="min-width: 100px">@lang('layout.Destination') </th>
                            <th style="min-width: 100px">@lang('layout.LoadingDate') </th>
                            <th style="min-width: 100px">@lang('layout.DeliveryDate') </th>
                            <th style="min-width: 100px">@lang('layout.ItemName') </th>
                            <th style="min-width: 100px">@lang('layout.Site') </th>
                            <th style="min-width: 100px">@lang('layout.Measure') </th>
                            <th>@lang('layout.Quantity') </th>
                            <th>@lang('layout.RentQuantity') </th>
                            <th>@lang('layout.Price') </th>
                            <th>@lang('layout.Currency') </th>
                            <th>@lang('layout.Rate') </th>
                            <th>@lang('layout.TotalTransferFee') </th>
                            <th>@lang('layout.Action') </th>
                        </tr>
                    </thead>
                </table>
            </div>
        </div>
    </div>
    <div class="col-md-12 margin-bottom-20">
        <div class="portlet-body" style="box-shadow: 0px 0px 3px rgba(187, 187, 187, 0.69);border-radius: 8px;padding: 20px;">
            <div class="col-md-4" id="driver_t">
                <div class="form-group">
                    <!-- label class="control-label ">@lang('menu.TransportCompany') </label -->
                    <select name="tcompany_id" @Click="getData()" v-model="tcompany_id" class="form-control">
                        <option value="0">@lang('layout.SelectTransportCompany')</option>
                        @foreach($transportCompany as $tcompany)
                        <option value="{{$tcompany['id']}}">{{$tcompany['name']}}</option>
                        @endforeach
                    </select>
                </div>
            </div>
            <template v-cloak id="company_ll">
                <company @company="setCompany"></company>
            </template>
            <table class="table table-striped table-bordered table-hover" cellspacing="0" width="100%" id="driver">
                <thead>
                    <tr>
                        {{--<th>Code</th>--}}
                        <!-- <th>@lang('layout.Number')</th> -->
                        <th>@lang('layout.FullName') </th>
                        <th>@lang('layout.LastName') </th>
                        <th>@lang('layout.FatherName') </th>
                        <th>@lang('layout.SSID') </th>
                        @if(getCustomerStatement() =="true")
                        <th>@lang('layout.TotalBalances') {{getHomeCurrency()["code"]}} </th>
                        @endif
                        <th>@lang('layout.Phone') </th>
                        <th>@lang('layout.CreatedAt') </th>
                        <th>@lang('layout.User') </th>
                        <th>@lang('layout.Actions') </th>
                    </tr>
                </thead>
                <tfoot>
                </tfoot>
            </table>
        </div>
    </div> 
    <div class="col-md-12">
        <div class="portlet light" style="box-shadow: 0px 0px 3px rgba(187, 187, 187, 0.69);border-radius: 8px;padding: 20px;">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="fa fa-map-marker font-red" style="font-size: 25px"></i>&nbsp;
                    <span class="caption-subject bold uppercase">@lang('menu.Location')</span>
                </div>
                <div class="tools"> </div>
                <div class="pull-right">
                    <span id="anchore-modal">
                        <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                            <i class="fa fa-print"></i>
                        </a>
                    </span>
                </div>
            </div>
            <div class="portlet-body">
                <table class="table table-striped table-bordered table-hover" id="vehicleLocations">
                    <thead>
                        <tr>
                            <th>@lang('layout.Driver')</th>
                            <th>@lang('layout.VehicleName')</th>
                            <th>@lang('layout.State')</th>
                            <th>@lang('layout.Source')</th>
                            <th>@lang('layout.Destination')</th>
                            <th>@lang('layout.Location')</th>
                            <th>@lang('layout.Date')</th>
                            <th>@lang('layout.User')</th>
                            <th>@lang('layout.Actions')</th>
                        </tr>
                    </thead>
                </table>
            </div>
        </div>
    </div>
    <div class="col-md-12">
        <div class="portlet light" style="box-shadow: 0px 0px 3px rgba(187, 187, 187, 0.69);border-radius: 8px;padding: 20px;">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="fa fa-money font-green" style="font-size: 25px"></i>&nbsp;
                    <span class="caption-subject bold uppercase">@lang('menu.ToRentVehicle')</span>
                </div>
                <div class="tools"> </div>
                <div class="pull-right">
                </div>
            </div>
            <div class="portlet-body">
                <table class="table table-striped table-bordered table-hover" id="vehicleRent">
                    <thead>
                        <tr>
                            <th>@lang('layout.RentCode')</th>
                            <th>@lang('layout.Amount')</th>
                            <th>@lang('layout.Driver')</th>
                            <th>@lang('layout.VehicleName')</th>
                            <th>@lang('layout.State')</th>
                            <th>@lang('layout.Source')</th>
                            <th>@lang('layout.Destination')</th>
                            <th>@lang('layout.Location')</th>
                            <th>@lang('layout.Customer')</th>
                            <th>@lang('layout.Balance')</th>
                            <th>@lang('layout.Date')</th>
                            <th>@lang('layout.User')</th>
                            <th>@lang('layout.Actions')</th>
                        </tr>
                    </thead>
                </table>
            </div>
        </div>
    </div>
</div>
<!-- END TAB PORTLET-->

<!-- END CONTENT BODY -->

@stop
@include('print.modal')
@push('scripts')
<script>
    $(document).ready(function() {
        $('#vehicleLocations').DataTable({
            ajax: {
                ajax: '{{route("oilAndGasDashboard.index")}}',
                data: {
                    type: 'last_location'
                }
            },
            pageLength: '{{getPageRows()}}',
            order: [
                ["{{orderByColumn()=='number'?1:6}}", "{{getRowOrder()}}"]
            ],
            scrollCollapse: true,
            paging: true,
            serverSide: true,


            columns: [{
                    data: 'name',
                    name: 'members.name'
                },
                {
                    data: 'vname',
                    name: 'vehicles.palet_number'
                },
                {
                    data: 'state',
                    name: 'vehicle_locations.state'
                },
                {
                    data: 'source',
                    name: 'vehicle_locations.source'
                },
                {
                    data: 'destination',
                    name: 'vehicle_locations.destination'
                },
                {
                    data: 'location',
                    name: 'vehicle_locations.location'
                },
                {
                    data: 'Date',
                    name: 'vehicle_locations.date'
                },
                {
                    data: 'user',
                    name: 'users.name'
                },
                {
                    data: 'actions',
                    name: 'actions',
                    orderable: false,
                    searchable: false
                }
            ]
        });

        $('#vehicleRent').DataTable({


            ajax: {
                ajax: '{{route("oilAndGasDashboard.index")}}',
                data: {
                    type: 'last_rent'
                }
            },
            pageLength: '{{getPageRows()}}',
            order: [
                ["{{orderByColumn()=='number'?0:10}}", "{{getRowOrder()}}"]
            ],
            scrollCollapse: true,
            paging: true,
            serverSide: true,

            columns: [{
                    data: 'code',
                    name: 'vehicle_managements.code'
                },
                {
                    data: 'amount',
                    name: 'amount',
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'driver_name',
                    name: 'driver_name',
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'vehicle_name',
                    name: 'vehicles.palet_number'
                },
                {
                    data: 'state',
                    name: 'vehicle_locations.state'
                },
                {
                    data: 'source',
                    name: 'vehicle_locations.source'
                },
                {
                    data: 'destination',
                    name: 'vehicle_locations.destination'
                },
                {
                    data: 'location',
                    name: 'vehicle_locations.location'
                },
                {
                    data: 'members_name',
                    name: 'members.name'
                },
                {
                    data: 'totalBalances',
                    name: 'totalBalances',
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'Date',
                    name: 'vehicle_managements.date'
                },
                {
                    data: 'user',
                    name: 'users.name'
                },
                {
                    data: 'actions',
                    name: 'actions',
                    orderable: false,
                    searchable: false
                }
            ]
        });


    });


    function getRecord() {
        // console.log(123,vtr.loadingSourceSel, vtr.loadingDestinationSel);
        $('#loading').DataTable({
            ajax: {
                ajax: '{{route("oilAndGasDashboard.index")}}',
                data: {
                    type: 'loading',
                    site_id: vtr.site_id,
                    loadingSource: vtr.loadingSourceSel,
                    loadingDestination: vtr.loadingDestinationSel
                }
            },
            pageLength: '{{getPageRows()}}',
            order: [
                ["{{orderByColumn()=='number'?2:12}}", "{{getRowOrder()}}"]
            ],
            destroy: true,
            scrollCollapse: true,
            paging: true,
            serverSide: true,
            columns: [{
                    data: 'driver_name',
                    name: 'driver_name',
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'other_driver_name',
                    name: 'other_driver_name',
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'vehicle_name',
                    name: 'loading_details.other_vehicle_name'
                },
                {
                    data: 'tanker_name',
                    name: 'tanker_name',
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'driver_type',
                    name: 'driver_type',
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'part_type',
                    name: 'part_type',
                    searchable: false
                },
                {
                    data: 'part_number',
                    name: 'part_number',
                    searchable: false
                },
                {
                    data: 'cmr_number',
                    name: 'cmr_number',
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'transit_number',
                    name: 'transit_number',
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'source',
                    name: 'source',
                    searchable: false
                },
                {
                    data: 'location',
                    name: 'loading_details.location'
                },
                {
                    data: 'destination',
                    name: 'destination',
                    searchable: false
                },
                {
                    data: 'loading_date',
                    name: 'loading_details.loading_date',
                    searchable: false
                }, 
                {
                    data: 'delivery_date',
                    name: 'loading_details.delivery_date',
                    searchable: false
                },
                {
                    data: 'items',
                    name: 'items.name'
                },
                {
                    data: 'site',
                    name: 'inventory_sites.name'
                },
                {
                    data: 'measure',
                    name: 'measure',
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'qty',
                    name: 'qty',
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'rent_quantity',
                    name: 'rent_quantity',
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'total_transfer_fee',
                    name: 'total_transfer_fee',
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'Currency',
                    name: 'Currency',
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'Rate',
                    name: 'Rate',
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'Total',
                    name: 'Total',
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'actions',
                    name: 'actions',
                    orderable: false,
                    searchable: false
                }
            ]
        });
    }

    function getDriverRecord() {
        $('#driver').DataTable({
            ajax: {
                ajax: '{{route("oilAndGasDashboard.index")}}',
                data: {
                    type: 'driver',
                    tcompany_id: driver_v.tcompany_id
                }
            },
            pageLength: '{{getPageRows()}}',
            destroy: true,
            scrollCollapse: true,
            serverSide: true,
            paging: true,
            order: [
                [0, 'asc']
            ],
            columns: [{
                    data: 'name',
                    name: 'name'
                },
                {
                    data: 'last_name',
                    name: 'last_name'
                },
                {
                    data: 'father_name',
                    name: 'father_name'
                },
                {
                    data: 'ss_id',
                    name: 'ss_id'
                },
                @if(getCustomerStatement() == "true") {
                    data: 'totalBalances',
                    name: 'totalBalances',
                    orderable: false,
                    searchable: false
                },
                @endif {
                    data: 'phone',
                    name: 'phone'
                },
                {
                    data: 'created_at',
                    name: 'created_at',
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'user',
                    name: 'user',
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'actions',
                    name: 'account',
                    orderable: false,
                    searchable: false
                },


            ]
        });
    }

    $(document).ready(function() {

        getRecord();
        getDriverRecord();

    });


    Vue.component('v-select', VueSelect.VueSelect)


    // new for modal


    var vml = new Vue({
        el: '#print-modal',
        data: {
            is_show: false,
            pdfRoute: '{!!route('export.PDFAll') !!}',
            excelRoute: '{!! route('export.ExcelAll') !!}',
        },
        methods: {
            closeModal: function() {
                this.is_show = !this.is_show
            },


        }
    });

    var loadingSource = {!!json_encode($loadingSource)!!};
    var loadingDestination = {!!json_encode($loadingDestination)!!};
    var loadingLocation = {!!json_encode($loadingLocation)!!};
    var cust_rep = {!!customeReportNewData('dashboard_loading_index')!!};

    var vm = new Vue({
        el: '#print-modal1',
        data: {
            is_show: false,
            pdfRoute: '{!!route('export.PDFAll') !!}',
            excelRoute: '{!! route('export.ExcelAll') !!}',
            contracts: {!! $contract !!},
            selectedContract: null,
            drivers: {!! $drivers !!},
            selecteddriver: null,
            loadingSource: loadingSource,
            loadingSourceSel: null,
            loadingDestination: loadingDestination,
            loadingDestinationSel: null,
            loadingLocation: loadingLocation,
            loadingLocationSel: null, 
            customReportData:
            [
            {Name: '@lang("layout.Driver")', column_name: 'driver',checkedColumn:(cust_rep.driver)?'checked':'',column_percentage:(cust_rep.driver___percent)?cust_rep.driver___percent:''},
            {Name: '@lang("layout.Transporter_name")', column_name: 'transporter_name',checkedColumn:(cust_rep.transporter_name)?'checked':'',column_percentage:(cust_rep.transporter_name___percent)?cust_rep.transporter_name___percent:''},
            {Name: '@lang("layout.VehicleName")', column_name: 'vehicle_name',checkedColumn:(cust_rep.vehicle_name)?'checked':'',column_percentage:(cust_rep.vehicle_name___percent)?cust_rep.vehicle_name___percent:''},
            {Name: '@lang("layout.TankerNumber")', column_name: 'tanker_number',checkedColumn:(cust_rep.tanker_number)?'checked':'',column_percentage:(cust_rep.tanker_number___percent)?cust_rep.tanker_number___percent:''},
            {Name: '@lang("layout.DriverType")', column_name: 'driver_type',checkedColumn:(cust_rep.driver_type)?'checked':'',column_percentage:(cust_rep.driver_type___percent)?cust_rep.driver_type___percent:''},
            {Name: '@lang("layout.Type")', column_name: 'type',checkedColumn:(cust_rep.type)?'checked':'',column_percentage:(cust_rep.type___percent)?cust_rep.type___percent:''},
            {Name: '@lang("layout.TypeNumber")', column_name: 'type_number',checkedColumn:(cust_rep.type_number)?'checked':'',column_percentage:(cust_rep.type_number___percent)?cust_rep.type_number___percent:''},
            {Name: '@lang("layout.WayBillNumber")', column_name: 'way_bill_number',checkedColumn:(cust_rep.way_bill_number)?'checked':'',column_percentage:(cust_rep.way_bill_number___percent)?cust_rep.way_bill_number___percent:''},
            {Name: '@lang("layout.TransitNumber")', column_name: 'transite_number',checkedColumn:(cust_rep.transite_number)?'checked':'',column_percentage:(cust_rep.transite_number___percent)?cust_rep.transite_number___percent:''},
            {Name: '@lang("layout.SourcePlace")', column_name: 'source_place',checkedColumn:(cust_rep.source_place)?'checked':'',column_percentage:(cust_rep.source_place___percent)?cust_rep.source_place___percent:''},
            {Name: '@lang("layout.Destination")', column_name: 'destination',checkedColumn:(cust_rep.destination)?'checked':'',column_percentage:(cust_rep.destination___percent)?cust_rep.destination___percent:''},
            {Name: '@lang("layout.Location")', column_name: 'location',checkedColumn:(cust_rep.location)?'checked':'',column_percentage:(cust_rep.location___percent)?cust_rep.location___percent:''},
            {Name: '@lang("layout.LoadingDate")', column_name: 'loading_date',checkedColumn:(cust_rep.loading_date)?'checked':'',column_percentage:(cust_rep.loading_date___percent)?cust_rep.loading_date___percent:''},
            {Name: '@lang("layout.DischargeDate")', column_name: 'discharge_date',checkedColumn:(cust_rep.discharge_date)?'checked':'',column_percentage:(cust_rep.discharge_date___percent)?cust_rep.discharge_date___percent:''},
            {Name: '@lang("layout.ItemName")', column_name: 'item_name',checkedColumn:(cust_rep.item_name)?'checked':'',column_percentage:(cust_rep.item_name___percent)?cust_rep.item_name___percent:''},
            {Name: '@lang("layout.Site")', column_name: 'site',checkedColumn:(cust_rep.site)?'checked':'',column_percentage:(cust_rep.site___percent)?cust_rep.site___percent:''},
            {Name: '@lang("layout.Measure")', column_name: 'measure',checkedColumn:(cust_rep.measure)?'checked':'',column_percentage:(cust_rep.measure___percent)?cust_rep.measure___percent:''},
            {Name: '@lang("layout.Quantity")', column_name: 'quantity',checkedColumn:(cust_rep.quantity)?'checked':'',column_percentage:(cust_rep.quantity___percent)?cust_rep.quantity___percent:''},
            {Name: '@lang("layout.RentQuantity")', column_name: 'rent_quantity',checkedColumn:(cust_rep.rent_quantity)?'checked':'',column_percentage:(cust_rep.rent_quantity___percent)?cust_rep.rent_quantity___percent:''},
            {Name: '@lang("layout.Price")', column_name: 'price',checkedColumn:(cust_rep.price)?'checked':'',column_percentage:(cust_rep.price___percent)?cust_rep.price___percent:''},
            {Name: '@lang("layout.Currency")', column_name: 'currency',checkedColumn:(cust_rep.currency)?'checked':'',column_percentage:(cust_rep.currency___percent)?cust_rep.currency___percent:''},
            {Name: '@lang("layout.Rate")', column_name: 'rate',checkedColumn:(cust_rep.rate)?'checked':'',column_percentage:(cust_rep.rate___percent)?cust_rep.rate___percent:''},
            {Name: '@lang("layout.TotalTransferFee")', column_name: 'total_transfer',checkedColumn:(cust_rep.total_transfer)?'checked':'',column_percentage:(cust_rep.total_transfer___percent)?cust_rep.total_transfer___percent:''},
            {Name: '@lang("layout.Amount") $', column_name: 'total_amount',checkedColumn:(cust_rep.total_amount)?'checked':'',column_percentage:(cust_rep.total_amount___percent)?cust_rep.total_amount___percent:''},
            {Name: '@lang("layout.Contract")', column_name: 'contract',checkedColumn:(cust_rep.contract)?'checked':'',column_percentage:(cust_rep.contract___percent)?cust_rep.contract___percent:''},
            ],
            cust_rep:cust_rep

        },
        methods: {
            closeModal: function() {
                this.is_show = !this.is_show
            },
        }
    });


    new Vue({
        el: '#anchore-modal',
        methods: {
            showModal: function() {
                console.log('trr')
                vml.$data.is_show = true;

            }
        }
    });

    new Vue({
        el: '#anchore-modal1',
        methods: {
            showModal: function() {
                console.log('trr')
                vm.$data.is_show = true;

            }
        }
    });
    // /new for modal

    var vtr = new Vue({
        el: '#sites',
        data: {
            site_id: 0,
            loadingSourceSel: 0,
            loadingDestinationSel: 0,
        },
        methods: {
            getData() {
                getRecord();
            }
        }
    });

    var driver_v = new Vue({
        el: '#driver_t',
        data: {
            tcompany_id: 0,
        },
        methods: {
            getData() {
                getDriverRecord();
            }
        }
    });
</script>
@endpush