@extends('layouts.app')
@section('content')
    <div class="row">

        <div class="portlet light bg-inverse" style="min-height: 100%;">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>&nbsp;
                    <span class="caption-subject font-green-haze bold uppercase">  @lang('layout.VehicleLocationEdit')</span>
                    <!-- <span class="caption-helper">some info...</span> -->
                </div>
                <div class="tools">
                    
                </div>
            </div>
            <div id="app" class="portlet-body form" style="margin-bottom:50%;">
                <!-- BEGIN FORM-->
                {!! Form::model($vehicleLocation, ['method' => 'PATCH','class'=>'form-horizontal','route' => ['vehicleLocation.update',$vehicleLocation->id]]) !!}
                {{ csrf_field() }}
                <div class="form-body">

                <div class="row">

                    <div class="col-md-3">
                        <div class="form-group">
                            <label class="control-label col-md-3">@lang('layout.Driver'):</label>
                            <div class="col-md-9">
                                <v-select placeholder="@lang('layout.SelectDriver')" label="name"
                                          v-model="selecteddriver"
                                          :options="allDrivers"
                                          @input="getVehicle"
                                          @click.native="getAllVehicle">
                                </v-select>
                                <input type="hidden" name="driver_id"
                                       v-model.number="(!selecteddriver)?null:selecteddriver.id">
                            </div>
                        </div>
                    </div>      

                    <div class="col-md-3">
                        <div class="form-group">
                            <label class="control-label col-md-3">@lang('menu.Vehicle'):</label>
                            <div class="col-md-9">
                                  <v-select 
                                    label="vehicle_name" 
                                    :options="allVehicles"
                                    v-model="selected_driverVehicle"
                                    >
                                </v-select>
                                <input type="hidden" name="vehicle_id"
                                   :value="!selected_driverVehicle?null:selected_driverVehicle.id">
                            </div>
                        </div>
                    </div>


   
                    <div class="col-md-2"> 
                        <div class="form-group">
                            <label class="control-label col-md-3">@lang('layout.Date'):</label>
                            <div class="col-md-9">
                                <input type="text" name="date" class="form-control date" value="{{convertDate($vehicleLocation->date)}}">
                            </div>
                        </div>
                        
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label class="control-label col-md-3">@lang('layout.Description'):</label>
                            <div class="col-md-9">
                                <textarea name="description" class="form-control" placeholder="@lang('layout.Description')">{{$vehicleLocation->description}}</textarea>
                            </div>
                        </div>
                        
                    </div>
       
                  
                </div>

                            <!--Begin Panels-->
                    <div class="tab-content">
                        <!-- GENERAL QUESTION TAB -->
                        <div class="tab-pane active" id="tab_1_1">
                            <div id="accordion1" class="panel-group">
                              
                                <div class="panel panel-success">
                                    <div class="panel-heading">
                                        <h4 class="panel-title">
                                            <a class="accordion-toggle accordion-toggle-styled" data-toggle="collapse" data-parent="#accordion1" href="#accordion1_3"> @lang('layout.OtherInformations')</a>
                                        </h4>
                                    </div>
                                    <div id="accordion1_3" class="panel-collapse ">
                                        <div class="panel-body">

                                       <div class="row">
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <label class="control-label col-md-3">@lang('layout.State')</label>
                                                    <div class="col-md-9">
                                                      <select name="state" class="form-control">
                                                          <option value="">@lang('layout.SelectState')</option>
                                                          <option value="fill" <?php if($vehicleLocation->state=="fill"){echo "selected";}?>>@lang('layout.Fill')</option>
                                                          <option value="empty" <?php if($vehicleLocation->state=="empty"){echo "selected";}?>>@lang('layout.Empty')</option>
                                                      </select>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <label class="control-label col-md-3">@lang('layout.Road')</label>
                                                    <div class="col-md-9">
                                                      {!! Form::text('road', null, array('placeholder' =>__('layout.Road'),'tabindex' =>'3','class' => 'form-control','autocomplete'=>'off')) !!}
                                                    </div>
                                                </div>
                                            </div>   
                                             <div class="col-md-4">
                                                <div class="form-group">
                                                    <label class="control-label col-md-3">@lang('layout.Location')</label>
                                                    <div class="col-md-9">
                                                      {!! Form::text('location', null, array('placeholder' =>__('layout.Location'),'tabindex' =>'3','class' => 'form-control','autocomplete'=>'off')) !!}
                                                    </div>
                                                </div>
                                            </div>     
                                        </div> 

                                       <div class="row">
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <label class="control-label col-md-3">@lang('layout.Source')</label>
                                                    <div class="col-md-9">
                                                      {!! Form::text('source', null, array('placeholder' =>__('layout.Source'),'tabindex' =>'3','class' => 'form-control','autocomplete'=>'off')) !!}
                                                    </div>
                                                </div>
                                            </div> 
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <label class="control-label col-md-3">@lang('layout.Destination')</label>
                                                    <div class="col-md-9">
                                                        {!! Form::text('destination', null, array('placeholder' =>__('layout.Destination'),'class' => 'form-control')) !!}
                                                    </div>
                                                </div>
                                             </div> 
                                         
                                        </div>  

                    
                         

                                        </div>
                                    </div>
                                </div>
                             
                            </div>
                        </div>
                        <!-- END GENERAL QUESTION TAB -->
                    </div>
            <!--END Panels-->

                   
                </div>
                <div class="col-xs-12 col-sm-10 col-md-11 text-center">
                    <button type="button" @click="handleSubmit($event)"
                            class="btn green">@lang('layout.Submit')</button>
                    <a href="{{route('vehicleLocation.index')}}" class="btn default"><i
                                class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                </div>
                {!! Form::close() !!}
            </div>
            <!-- END FORM-->
        </div>
    </div>
@endsection
@push('scripts')
    <script>
        @if(App::getLocale())
    Vue.use(VeeValidate, {
        locale: '{{App::getLocale()}}',
    });
    @else
        Vue.use(VeeValidate, {
            locale: 'en',
        });
        @endif

        $(document).ready(function () {
            $('#initial-value-example').persianDatepicker({
                observer: true,
                format: 'YYYY/MM/DD',
                altField: '#observer-example-alt',
                altFormat: 'u',
                autoClose: true,
            });
        });
        Vue.component("v-select", VueSelect.VueSelect);


        var allDrivers = {!! $allDrivers !!};
        var allVehicles = {!! $allVehicles !!};

        let vu = new Vue({
            el: '#app',
            data: {

                allDrivers: allDrivers,
                allVehicles: allVehicles,
                selected_driverVehicle: {!! json_encode($selected_driverVehicle) !!},
                selecteddriver        : {!! json_encode($selecteddriver) !!},

                driver_vehicle:allVehicles

            },


            methods: {
                handleSubmit(e) {
                    this.$validator.validate().then(valid => {
                        if (valid) {
                            // alert(e.target);
                            regForm(e.target);
                        }
                    });
                },

                 //Get Driver All Vehicles
                    getVehicle() {
                        if (this.selecteddriver) {
                            axios.get("{{route('callMethod.search')}}",
                                {
                                    params: {
                                        driver_vehicle_plate: this.selecteddriver.plate,
                                        method_name: 'Search_driver_vehicle'
                                    },
                                })
                                .then(function (response) {
                                    if (response.data.result != null) {
                                        vu.selected_driverVehicle=response.data.result;
                                    }
                                    else {
                                        // vu.selected_driverVehicle=null;
                                    }
                                })
                                .catch(function (error) {
                                    console.log(error);
                                });
                        }
                    },            

                    getAllVehicle() {
                        if (!vu.selecteddriver) {
                        vu.driver_vehicle=vu.allVehicles;
                        }
                    },
            }
        })

    </script>
@endpush 