@extends('layouts.factor-master')

@section('content')
<?php
$report = customeReport('salary_details');
$_date=in_array('date', $report);
$_name=in_array('name', $report);
$_phone=in_array('phone', $report);
$_currency=in_array('currency', $report);
$_amount=in_array('amount', $report);
?>


<h3 class="table-caption" style="text-align: center;">@lang('layout.VehicleLocationReport')</h3>
<table   class="main-table">
  <tr>
    @if($from_date)
   <td>
    <span>@lang('layout.FromDate')</span>:
    <BDO DIR="LTR">{{convertDate($from_date)}}</BDO>
  </td>
  @endif
  @if($to_date)
  <td>
    <span>@lang('layout.ToDate')</span>:
    <BDO DIR="LTR">{{convertDate($to_date)}}</BDO>
  </td>
  @endif
</tr>
</table>
<br>
<table class="main-table">

  <thead>
    <tr class="bg">
    <td  class="center"  ><div>  @lang('layout.Record') </div></td>
    @if($_date)<td  class="center"  ><div> @lang('layout.Driver')</div></td>@endif
    @if($_date)<td  class="center"  ><div> @lang('layout.VehicleName')</div></td>@endif
    @if($_date)<td  class="center"  ><div> @lang('layout.PlateNumber')</div></td>@endif
    @if($_name)<td  class="center"  ><div> @lang('layout.State') </div></td>@endif
    @if($_name)<td  class="center"  ><div> @lang('layout.Road') </div></td>@endif
    @if($_phone)<td  class="center"  ><div> @lang('layout.Location')</div></td>@endif
    @if($_phone)<td  class="center"  ><div> @lang('layout.Source')</div></td>@endif
    @if($_date)<td  class="center"  ><div> @lang('layout.Destination')</div></td>@endif
    @if($_date)<td  class="center"  ><div> @lang('layout.Date')</div></td>@endif
    @if($_currency)<td  class="center"  ><div> @lang('layout.Description')</div></td>@endif

  </tr>
  </thead>
  <?php
  $count = 0;
  ?>
  @foreach($data AS $record)
  <tr>
   
    <td class="center">{{++$count}}</td>
    @if($_name)<td class="center">{{$record->name}}</td>@endif
    @if($_name)<td class="center">{{$record->vehicle_name}}</td>@endif
    @if($_name)<td class="center">{{$record->palet_number}}</td>@endif
    @if($_name)<td class="center">{{__('type.' . $record->state) }}</td>@endif
    @if($_name)<td class="center">{{$record->road}}</td>@endif
    @if($_name)<td class="center">{{$record->location}}</td>@endif
    @if($_name)<td class="center">{{$record->source}}</td>@endif
    @if($_name)<td class="center">{{$record->destination}}</td>@endif
    @if($_date)<td class="center">{{convertDate($record->date)}}</td>@endif
    @if($_name)<td class="center">{{$record->description}}</td>@endif

   

  </tr>
  @endforeach
</table>

   <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->
@endsection