@extends('layouts.app')
@section('content')
@section('style')
@stop
<div class="row">

    <div class="portlet light bg-inverse">
        <div class="portlet-title">
            <div class="caption">
                <i class="icon-equalizer font-green-haze"></i>&nbsp;
                <span class="caption-subject font-green-haze bold uppercase">@lang('layout.OilPumpEdit')</span>
                <!-- <span class="caption-helper">some info...</span> -->
            </div>
            <div class="tools">

            </div>
        </div>
        <div class="portlet-body form" style="margin-bottom:50%;" id="oilPart">
            <!-- BEGIN FORM-->
            {!! Form::model($oilPart, ['method' => 'PATCH','class'=>'form-horizontal','route' => ['oilPart.update',$oilPart->id]]) !!}
            <div class="row">
                <div class="col-md-4">
                    <div class="form-group">
                        <label class="control-label col-md-4">@lang('layout.Number'):</label>
                        <div class="col-md-8">
                            {{Form::text('number',null,['class' => 'form-control','v-validate' =>'"required"','data-vv-as' => __('layout.Number'),'placeholder' => __('layout.Number')])}}
                        <span class="required">@{{ errors.first('number') }}</span>
                        </div>
                    </div>
                </div> 
                <div class="col-md-4">
                    <div class="form-group">
                        <label class="control-label col-md-4">@lang('layout.SaleNumber'):</label>
                        <div class="col-md-8">
                            {{Form::number('sale_number',null,['class' => 'form-control','v-validate' =>'"required"','data-vv-as' => __('layout.SaleNumber'),'placeholder' => __('layout.SaleNumber'),'autofocus'=>'autofocus'])}}
                        <span class="required">@{{ errors.first('sale_number') }}</span>
                        </div>
                    </div>
                </div> 
                <div class="col-lg-4 col-xs-12">
                    <div class="form-group">
                            <label class="control-label col-md-4">@lang('layout.Site') </label>
                            <div class="col-md-8">
                            <v-select label="name" :options="inventorySite" v-model="selected_site" @change="setAmount(selected_site)"></v-select>
                            <input type="hidden" name="site_id" v-bind:value="(!selected_site)?null:selected_site.id"/>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row" style="margin-top: 25px;">

                <div class="col-md-4">
                    <div class="form-group">
                        <label class="control-label col-md-4">@lang('layout.SaleNumber'):</label>
                        <div class="col-md-8">
                            {{Form::number('counter',null,['class' => 'form-control','placeholder' => __('layout.Counter')])}}
                        <span class="required">@{{ errors.first('counter') }}</span>
                        </div>
                    </div>
                </div> 

                <div class="col-md-4">
                    <div class="form-group">
                        <label class="control-label col-md-4">@lang('menu.Employee'):</label>
                        <div class="col-md-8">
                            <v-select placeholder="@lang('layout.SelectMember')" label="name" v-model="selected_member" :options="members">
                            </v-select>
                            <input type="hidden" name="employee_id" v-model.number="(!selected_member)?null:selected_member.id" v-validate="''" data-vv-as="@lang('menu.Employee')">
                            <span class="required">@{{ errors.first('employee_id') }}</span>
                        </div>
                    </div>
                </div> 
                    <div class="col-md-4"> 
                    <div class="form-group">
                        <label class="control-label col-md-2">@lang('layout.Description'):</label>
                        <div class="col-md-10">
                                {!! Form::textarea('description', null, array('placeholder' => __('layout.Description'),'class' => 'form-control','rows' => 3, 'cols' => 60)) !!}

                        </div>
                    </div>
                    
                </div>
            </div>
            <div class="col-xs-12 col-sm-12 col-md-11 text-center">
                <button type="button" onclick="regForm(this)" class="btn green">@lang('layout.Submit')</button>

                <button href="{{url('oilPart.index')}}" class="btn default"><i
                            class="fa fa-mail-reply"></i> @lang('layout.Cancel')</button>
            </div>
            {!! Form::close() !!}
        </div>
        <!-- END FORM-->
    </div>
</div>
@endsection


@push('scripts')

    <script>

        @if(App::getLocale())
    Vue.use(VeeValidate, {
        locale: '{{App::getLocale()}}',
    });
    @else
        Vue.use(VeeValidate, {
            locale: 'en',
        });
        @endif

        Vue.component("v-select", VueSelect.VueSelect);

        var members = {!! $members !!};
        var selected_member = {!! $selected_member !!};
        var inventorySite = {!! $inventorySite !!};

        let vu = new Vue({
                el: '#oilPart',
                data: {

                    members: members,
                    selected_member: selected_member,
                    inventorySite: inventorySite,
                    selected_site:null,
                },
                methods: {
                    handleSubmit(e) {
                        this.$validator.validate().then(valid => {
                            if (valid) {
                                // alert(e.target);
                                regForm(e.target);
                            }
                        });
                    },
                },
                mounted: function() {
                    @if($oilPart->site_id)
                        this.selected_site   = _.find(inventorySite, (o) => o.id == {{$oilPart->site_id}});
                    @endif
                }
            })
    </script>
@endpush
