@extends('layouts.app')
@section('style')
<style>
    .modal-container {
        width: 70% !important;
    }
</style>
@endsection
@section('content')
    {{-- <div id="print-modal">
        <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show"
                      :value-type="'oil_item_expense'"
                      @closed="closeModal">

            <div slot=body>
                <div class="row">
                    <div class="form-group">

                        <div class="col-md-12">
                            <div class="col-md-6">
                                <label class="control-label ">@lang('menu.ExpenseCategory') </label>
                                <select name="category_id" id="" class="form-control">
                                    <option value="">@lang('layout.SelectType')</option>
                                    @foreach($category as  $rec)
                                        <option value="{{$rec->id}}">{{$rec->name}}</option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-md-6">
                                <label class="control-label ">@lang('layout.Category') </label>
                                <select name="ex_category_id" id="" class="form-control">
                                    <option value="">@lang('layout.SelectCategory')</option>
                                    @foreach($ex_category as  $rec)
                                        <option value="{{$rec->id}}">{{$rec->name}}</option>
                                    @endforeach
                                </select>
                            </div>

                            <div class="col-md-4">
                                <label class="control-label ">@lang('layout.PaletNumber') </label>
                                <input class="form-control" name="palet_number" type="text">
                            </div>
                            <div class="col-md-4">
                                <label class="control-label">@lang('layout.Currency')</label>
                                <select name="currency" id="" class="form-control">
                                    <option value="">@lang('layout.SelectCategory')</option>
                                    @foreach($currency as  $cu)
                                        <option value="{{$cu->code}}">{{$cu->code}}</option>
                                    @endforeach
                                </select>
                            </div>

                             <div class="col-md-4">
                                <label class="control-label ">@lang('layout.Type') </label>
                                 <div class="input-group">
                                    <input type="radio" checked name="report_type" value="simple">@lang('layout.Simple')
                                    <input type="radio" name="report_type" value="detail">@lang('layout.Details')
                                </div>
                                
                            </div>

                        </div>
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="control-label"> @lang('layout.Date')</label>

                                <div slot="date">
                                    <div class="input-group">
                                        <input class="form-control date" id="range-from-example" autocomplete="off"
                                               name="from_date">

                                        <span class="input-group-addon"> @lang('layout.To') </span>
                                        <input class="form-control date" id="range-to-example" autocomplete="off"
                                               name="to_date">

                                    </div>
                                </div>


                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </report-modal>
    </div> --}}
    <!-- END PAGE HEADER-->
    <div id="print-modal">
        <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show" :value-type="'oil_item_expense'" @closed="closeModal">
            <div slot="body">
                <!----------------------------------------------
                    ----Begin Report Body And Custome Report-------
                ----------------------------------------------->
                <div class="row" v-cloak>
                    <div class="tabbable tabbable-tabdrop">
                        <ul class="nav nav-tabs">
                            <li class="active">
                                <a href="#tab1" data-toggle="tab" id="tab_main">@lang('menu.Report')</a>
                            </li>
                            @if(systemConfig()[2] != 0 )
                            @permission(['itemexpense-list'])
                            <li class="">
                                <a href="#tab2" data-toggle="tab" id="tab_custome">@lang('layout.CustomReportM')</a>
                            </li>
                            @endpermission
                            @endif
                        </ul>
                        <div class="tab-content">
                            <div class="tab-pane active" id="tab1">
                                <div class="portlet light bordered">
                                    <div class="portlet-body">
                                        <div class="row">
                                            <div class="form-group">
                                                <div class="col-md-12">
                                                    <div class="col-md-6">
                                                        <label class="control-label ">@lang('menu.ExpenseCategory') </label>
                                                        <select name="category_id" id="" class="form-control">
                                                            <option value="">@lang('layout.SelectType')</option>
                                                            @foreach($category as  $rec)
                                                                <option value="{{$rec->id}}">{{$rec->name}}</option>
                                                            @endforeach
                                                        </select>
                                                    </div>
                                                    <div class="col-md-6">
                                                        <label class="control-label ">@lang('layout.Category') </label>
                                                        <select name="ex_category_id" id="" class="form-control">
                                                            <option value="">@lang('layout.SelectCategory')</option>
                                                            @foreach($ex_category as  $rec)
                                                                <option value="{{$rec->id}}">{{$rec->name}}</option>
                                                            @endforeach
                                                        </select>
                                                    </div>
                                                    <div class="col-md-4">
                                                        <label class="control-label ">@lang('layout.PaletNumber') </label>
                                                        <input class="form-control" name="palet_number" type="text">
                                                    </div>
                                                    <div class="col-md-4">
                                                        <label class="control-label">@lang('layout.Currency')</label>
                                                        <select name="currency" id="" class="form-control">
                                                            <option value="">@lang('layout.SelectCategory')</option>
                                                            @foreach($currency as  $cu)
                                                                <option value="{{$cu->code}}">{{$cu->code}}</option>
                                                            @endforeach
                                                        </select>
                                                    </div>
                                                     <div class="col-md-4">
                                                        <label class="control-label ">@lang('layout.Type') </label>
                                                         <div class="input-group">
                                                            <input type="radio" checked name="report_type" value="simple">@lang('layout.Simple')
                                                            <input type="radio" name="report_type" value="detail">@lang('layout.Details')
                                                        </div>
                                                        
                                                    </div>
                                                </div>
                                                <div class="col-md-12">
                                                    <div class="form-group">
                                                        <label class="control-label"> @lang('layout.Date')</label>
                                                        <div slot="date">
                                                            <div class="input-group">
                                                                <input class="form-control date" id="range-from-example" autocomplete="off" name="from_date">
                                                                <span class="input-group-addon"> @lang('layout.To') </span>
                                                                <input class="form-control date" id="range-to-example" autocomplete="off" name="to_date">
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>                                                                     
                            <div class="tab-pane" id="tab2">
                                <div class="portlet light bordered">
                                    <div class="portlet-body">
                                        <form id="saveCustomeReport" role="form"
                                            action="{{route('customeReport.storeCustomeReport')}}" method="post">
                                            @csrf
                                            <input type="hidden" name="part_name" value="oil_item_expense">
                                            <div class="col-md-12 col-sm-12 col-xs-12">
                                                <div class="mt-checkbox-inline col-md-2" style="padding: 0px;" v-for="(row,itemIndex) in customReportData">
                                                    <div class="form-group">
                                                        <table class="table table-striped table-bordered table-advance table-hover">
                                                            <tr>
                                                                <td style="text-align: center;">@{{ row.Name }}</td>
                                                            </tr>
                                                            <tr>
                                                                <td style="text-align: center;">
                                                                    <input type="hidden" :name="'column_name['+itemIndex+']'" class="form-control" v-model="row.column_name">
                                                                    <label class="switch">
                                                                        <input type="checkbox" :name="'column_status['+itemIndex+']'" 
                                                                        :checked="row.checkedColumn" >
                                                                        <span class="slider round"></span>
                                                                    </label>
                                                                    <select :name="'column_percentage['+itemIndex+']'" v-model="row.column_percentage" class="form-control" style="width: 90%;">
                                                                        <option value="">@lang('layout.Select')</option>
                                                                        <option value="2">2 %</option>
                                                                        <option value="6">6 %</option>
                                                                        <option value="10">10 %</option>
                                                                        <option value="15">15 %</option>
                                                                        <option value="20">20 %</option>
                                                                        <option value="25">25 %</option>
                                                                        <option value="30">30 %</option>
                                                                        <option value="40">40 %</option>
                                                                        <option value="50">50 %</option>
                                                                        <option value="60">60 %</option>
                                                                    </select>
                                                                </td>
                                                            </tr>
                                                        </table>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="margiv-top-10">
                                                <!-- <button type="button" onclick="regForm(this)" class="btn green"> <i class="fa fa-save"></i> </button> -->
                                                <button type="button" onclick="saveCustomeReport(this)" class="btn blue"> <i class="fa fa-save"></i> </button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </report-modal>
    </div>
    <!-- BEGIN TAB PORTLET-->
    <div class="row">
        <!-- app -->
        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bortdered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>
                    <span class="caption-subject bold uppercase">@lang('layout.ItemExpense')</span>
                </div>
                <div class="tools"></div>
                <div class="pull-right">
                    @permission('itemexpense-export')
                    <span id="anchore-modal">
                        <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                            <i class="fa fa-print"></i>
                        </a>
                    </span>
                    @endpermission
                    @permission('itemexpense-create')
                    <a href="{{route('oilItemExpense.create')}}">
                        <!-- <button id="sample_editable_1_new" class="btn green btn-sm btn-outline"> -->
                        <button id="sample_editable_1_new" class="btn btn-success">
                            <i class="fa fa-plus"></i> @lang('layout.AddNew')
                        </button>
                    </a>
                    @endpermission
                </div>
            </div>
            <div class="portlet-body">
                <template v-cloak id="company_all">
                    <company @company="setCompany"></company>
                </template>
                <table class="table table-striped table-bordered table-hover" id="itemExpense">
                    <thead>
                        <tr>
                            <th>@lang('layout.Number')</th>
                            <th>@lang('layout.Currency')</th>
                            <th>@lang('layout.Rate')</th>
                            <th>@lang('layout.Date')</th>
                            <th>@lang('layout.Hour')</th>
                            <!-- th>@lang('layout.Type')</th -->
                            <th>@lang('layout.Description')</th>
                            <th>@lang('layout.User')</th>
                            <th>@lang('layout.Actions')</th>
                        </tr>
                    </thead>
                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>
    <!-- END TAB PORTLET-->
    <!-- END CONTENT BODY -->
@stop
@include('print.modal')
@include('groupCompanyFilter.select')
@push('scripts')
    <script>
        Vue.component("v-select", VueSelect.VueSelect);

        function factorPrint(id,sendWhatsapp = null,type = null) {
            if (sendWhatsapp == null || sendWhatsapp == '') {
                sendWhatsapp = 'not';
            }
            if (type == null || type == '') {
                type = 1;
            }
            var a = document.createElement('a');
            a.href = "{{url('printOilItemExpense')}}/" + id + "/" + sendWhatsapp + "/" + type;
            a.target = "_blank";
            document.body.appendChild(a);
            a.click();
            document.body.removeChild(a);
        }

        var cust_rep = {!!customeReportNewData('oil_item_expense')!!}; 
        let data_table;

        $(document).ready(function () {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
            data_table =$('#itemExpense').DataTable({
                ajax: '{{route("oilItemExpense.index")}}',
                pageLength:'{{getPageRows()}}',
                order: [["{{orderByColumn()=='number'?0:3}}", "{{getRowOrder()}}"]],
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                scrollCollapse: true,
                paging: true,
                serverSide: true,
                buttons: [{
                    extend: 'excel',
                    text: '',
                    key: {
                        key: 'x',
                        altkey: true
                    }
                }],
                columns: [
                    {data: 'number', name: 'item_expenses.number'},
                    {data: 'currency', name: 'item_expenses.currency'},
                    {data: 'rate', name: 'item_expenses.rate', orderable: false, searchable: false},
                    {data: 'date', name: 'item_expenses.date', searchable: false},
                    {data: 'hour', name: 'purchases.hour', searchable: false},
                    // {data: 'type', name: 'item_expenses.type', orderable: false, searchable: false},
                    {data: 'description', name: 'item_expenses.description'},
                    {data: 'user', name: 'users.name'},
                    {data: 'actions', name: 'actions', orderable: false, searchable: false}
                ]
            });
        });


        var vm = new Vue({
            el: '#print-modal',
            data: {
                is_show: false,
                selected_currency: null,
                pdfRoute: '{!!route('oilItemExpense.report') !!}',
                excelRoute: '{!! route('oilItemExpense.report') !!}',
                customReportData:
                [
                 {Name: '@lang("layout.Record")', column_name: 'record',checkedColumn:(cust_rep.record)?'checked':'',column_percentage:(cust_rep.record___percent)?cust_rep.record___percent:''},
                 {Name: '@lang("layout.Number")', column_name: 'number',checkedColumn:(cust_rep.number)?'checked':'',column_percentage:(cust_rep.number___percent)?cust_rep.number___percent:''},
                 {Name: '@lang("layout.Date")', column_name: 'date',checkedColumn:(cust_rep.date)?'checked':'',column_percentage:(cust_rep.date___percent)?cust_rep.date___percent:''},
                 {Name: '@lang("layout.Hour")', column_name: 'hour',checkedColumn:(cust_rep.hour)?'checked':'',column_percentage:(cust_rep.hour___percent)?cust_rep.hour___percent:''},
                 {Name: '@lang("layout.Member")', column_name: 'member',checkedColumn:(cust_rep.member)?'checked':'',column_percentage:(cust_rep.member___percent)?cust_rep.member___percent:''},
                 {Name: '@lang("layout.Description")', column_name: 'description',checkedColumn:(cust_rep.description)?'checked':'',column_percentage:(cust_rep.description___percent)?cust_rep.description___percent:''},
                 {Name: '@lang("layout.Type")', column_name: 'type',checkedColumn:(cust_rep.type)?'checked':'',column_percentage:(cust_rep.type___percent)?cust_rep.type___percent:''},
                 {Name: '@lang("layout.TypeNumber")', column_name: 'type_number',checkedColumn:(cust_rep.type_number)?'checked':'',column_percentage:(cust_rep.type_number___percent)?cust_rep.type_number___percent:''},
                 {Name: '@lang("layout.ExpenseType")', column_name: 'expense_type',checkedColumn:(cust_rep.expense_type)?'checked':'',column_percentage:(cust_rep.expense_type___percent)?cust_rep.expense_type___percent:''},
                 {Name: '@lang("layout.Category")', column_name: 'category',checkedColumn:(cust_rep.category)?'checked':'',column_percentage:(cust_rep.category___percent)?cust_rep.category___percent:''},
                 {Name: '@lang("layout.Currency")', column_name: 'currency',checkedColumn:(cust_rep.currency)?'checked':'',column_percentage:(cust_rep.currency___percent)?cust_rep.currency___percent:''},
                 {Name: '@lang("layout.Rate")', column_name: 'rate',checkedColumn:(cust_rep.rate)?'checked':'',column_percentage:(cust_rep.rate___percent)?cust_rep.rate___percent:''},
                 {Name: '@lang("layout.Total")', column_name: 'total',checkedColumn:(cust_rep.total)?'checked':'',column_percentage:(cust_rep.total___percent)?cust_rep.total___percent:''},
                 {Name: '@lang("layout.User")', column_name: 'user',checkedColumn:(cust_rep.user)?'checked':'',column_percentage:(cust_rep.user___percent)?cust_rep.user___percent:''},
                 {Name: '@lang("layout.PaletNumber")', column_name: 'palate_number',checkedColumn:(cust_rep.palate_number)?'checked':'',column_percentage:(cust_rep.palate_number___percent)?cust_rep.palate_number___percent:''},
                 {Name: '@lang("layout.ItemName")', column_name: 'item_name',checkedColumn:(cust_rep.item_name)?'checked':'',column_percentage:(cust_rep.item_name___percent)?cust_rep.item_name___percent:''},
                 {Name: '@lang("layout.Measure")', column_name: 'measure',checkedColumn:(cust_rep.measure)?'checked':'',column_percentage:(cust_rep.measure___percent)?cust_rep.measure___percent:''},
                 {Name: '@lang("layout.Quantity")', column_name: 'quantity',checkedColumn:(cust_rep.quantity)?'checked':'',column_percentage:(cust_rep.quantity___percent)?cust_rep.quantity___percent:''},
                ],
                  cust_rep:cust_rep


            },
            methods: {
                closeModal: function () {
                    this.is_show = !this.is_show
                },

            }
        });


        new Vue({
            el: '#anchore-modal',
            methods: {
                showModal: function () {
                    console.log('trr')
                    vm.$data.is_show = true;
                }
            }
        });

        new Vue({
            el: '#company_all',
            methods: {
                setCompany: function (event) {
                   if (typeof data_table == 'object'){
                       data_table.clear();
                       data_table.ajax.reload();
                   }
                }
            }
        });
    </script>
@endpush
