@extends('layouts.app')
@section('style')
    <link href="{{url('css/custome-table.css')}}" rel="stylesheet" type="text/css">
    <link href="{{URL::asset('assets/global/plugins/bootstrap-timepicker/css/bootstrap-timepicker.min.css')}}" rel="stylesheet" type="text/css" />
@stop
@section('content')
@include('inventories.cmodal')  
    <div class="row">
        <div class="portlet light bg-inverse" style="min-height: 100%;">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>&nbsp;
                    <span class="caption-subject font-green-haze bold uppercase"> @lang('layout.Update') @lang('layout.ItemExpense') </span>
                    <!-- <span class="caption-helper">some info...</span> -->
                </div>
                <div class="tools"></div>
            </div>
            <div id="itemexpense" v-cloak class="portlet-body form" style="margin-bottom:50%;">
                <!-- BEGIN FORM-->
				{{Form::model($itemExpense,['route' => ['oilItemExpense.update',$itemExpense->id],'method' => 'PATCH','class' => 'form-horizontal','id'=>'item-expense-form'])}}
                {{ csrf_field() }}
                <div class="form-body">
                    <div class="row">
                        <input type="hidden" name="edit_sale" value="{{$edit_sale}}">
                        <div class=" col-md-9">
                            <!-- div class="row">
                                <div class="col-md-4">
                                    <label class="control-label ">@lang('layout.Type')</label>
                                    <select name="type" class="form-control" v-model="selected_type">
                                        <option value="">@lang('layout.SelectType')</option>
                                        <option value="purchase">@lang('layout.Purchases')</option>
                                        <option value="build">@lang('layout.Build')</option>
                                        <option value="inventoryTransfer">@lang('layout.InventoryTransfer')</option>
                                         <option value="transferAndLoading">@lang('layout.TransferAndLoading')</option>
                                    </select>
                                </div>
                                <div class="col-md-4">
                                    <label class="control-label ">@lang('layout.Number')</label>
                                    <input type="number" :disabled="selected_type==null || selected_type==''"
                                           name="type_number" id="number" @input="numberChange" class="form-control">
                                </div>
                                <div class="col-md-2" v-if="selected_type!=null && selected_type!=''">
                                    <br>
                                    <button type="button" @click="searchType" class="btn btn-info"><i
                                                class="fa fa-search"></i>@lang('layout.Search')</button>
                                </div>
                            </div -->
                            <div class="row">
                                <!-- div class="col-md-4">
                                    <label class="control-label ">@lang('layout.CostType')</label>
                                    <select name="cost_type" class="form-control" v-model="selected_cost_type">
										<option value="none_posting">@lang('layout.NonePosting')</option>
                                        <option value="posting">@lang('layout.Posting')</option>
                                    </select>
                                </div -->
                                <div class="col-md-4">
                                    <label class="control-label">@lang('layout.Currency')</label>
                                    <v-select label="code" @input="selectedRate" :options="currency" @keyup.native="editKey = true" @click.native="editKey = true" @input="(editKey)?set_avg_rate_by_currency():''" v-model="selected_currency"></v-select>
                                    <input type="hidden" name="currency" :value="selected_currency.code">
                                </div>
                                <div class="col-md-4">
                                    <label class="control-label">@lang('layout.Rate')</label>
                                    <input type="number" name="currency_rate" name="rate" v-model="!selected_currency?0:selected_currency.rate" :readonly="averageRate && selected_expense_type == 'writeCheck'" class="form-control" >
                                    <span v-if="differentRate && selected_expense_type == 'bill'" style="background: #efefef; font-size: 14px;" class="required">@lang('message.DifferentRateMsg')</span>
                                </div>
								<div class="col-md-4">
                                    <label class="control-label ">@lang('layout.Number')</label>
                                    <input type="number" name="number" v-model="number" class="form-control">
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.ExpenseType')</label>
                                            <select name="expense_type" v-model="selected_expense_type" class="form-control">
                                                <option value="writeCheck">@lang('layout.Writecheck')</option>
                                                <option value="bill">@lang('layout.Bill')</option>
                                                <option value="income">@lang('layout.Income')</option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12" v-if="selected_expense_type =='bill'">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Vendor')</label>
                                            <v-select label="name" :options="vendor" @search="MemberSearch" v-model="selected_vendor"></v-select>
                                            <input type="hidden" name="vendor" :value="!selected_vendor?null:selected_vendor.id" required>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12" v-if="selected_expense_type =='writeCheck'">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Account')</label>
                                            <v-select label="name" :options="approperiateBank" v-model="selected_banks" @keyup.native="editKey = true" @click.native="editKey = true" @input="(editKey)?set_avg_rate_by_bank(selected_banks):''" ></v-select>
                                            <input type="hidden" name="bank_account" :value="(this.selected_banks==null)?null:selected_banks.id">
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12" v-if="selected_expense_type =='income'">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.IncomeAccount')</label>
                                            <v-select label="name" :options="income" v-model="selected_income"></v-select>
                                            <input type="hidden" name="income_account" :value="(this.selected_income==null)?null:selected_income.id">
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.ExpenseCategory')</label>
                                            <div class="input-group">
                                                <v-select label="name" :options="expenseCategory" v-model="selected_category"></v-select>
                                                <input type="hidden" name="expense_category_id" :value="(this.selected_category==null)?null:selected_category.id">
                                                <span class="btn btn-success input-group-addon " title="@lang('button.AddNewCustomer')" @click="showcModal = true" id="show-cmodal" style="background-color:  rgb(84, 199, 211)">
                                                    <i class="fa fa-plus" style="color: white"></i>
                                                </span> 
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <div class="col-md-8">
                                            <label class="control-label">@lang('layout.Hour')</label>
                                            <div class="input-group">
                                                @if(getHourType() == 24)
                                                <input type="text" class="form-control timepicker timepicker-24" name="hour" value="{{$itemExpense->hour}}">
                                                @else
                                                <input type="text" class="form-control timepicker timepicker-no-seconds" name="hour" value="{{$itemExpense->hour}}" >
                                                @endif
                                                <span class="input-group-btn">
                                                    <button class="btn default" type="button">
                                                        <i class="fa fa-clock-o"></i>
                                                    </button>
                                                </span>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <label class="control-label">&nbsp;</label>
                                                <div class="col-md-12">
                                                    <label class="control-label">@lang('layout.HoldingCost')</label>
                                                    <label class="mt-checkbox mt-checkbox-outline">
                                                        <input type="checkbox" name="holding" v-model="holding" @checked($itemExpense->holding) /> 
                                                        <span></span>
                                                    </label>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-4 col-md-4 col-sm-6 col-xs-12">
                                    <div class="form-group"  style="margin-bottom: 0px;">
                                        <div class="col-md-8">
                                            <label class="control-label">@lang('layout.Date')</label>
                                            <input type="text" name="date" class="form-control date" value="{{$itemExpense->date}}" autocomplete="off" @if(getDateRequired() == 'true') v-validate='"required"' data-vv-as="@lang('layout.Date')" @endif>
                                            <span class="required">@{{ errors.first('date') }}</span>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <label class="control-label">&nbsp;</label>
                                                <div class="col-md-12">
                                                <label class="control-label">@lang('layout.StorageRent')</label>
                                                    <label class="mt-checkbox mt-checkbox-outline">
                                                        <input type="checkbox" name="storage_rent" @checked($itemExpense->storage_rent) />
                                                        <span></span>
                                                    </label>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-3 col-md-3 col-sm-6 col-xs-12">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Description')</label>
                                            <textarea name="description" class="form-control" rows="1">{{$itemExpense->description}}</textarea>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-1 col-md-1 col-sm-1 col-xs-12">
                                    <div class="form-group">
                                        <label class=" control-label">@lang('layout.EditDescription')</label>
                                        <div>
                                            <label class="mt-checkbox mt-checkbox-outline">
                                                <input type="checkbox" name="edit_des" value="yes" >
                                                <span></span>
                                            </label>
                                        </div>
                                    </div>
                                </div>

                            </div>

                        </div>

                        <!-- bgin pay -->
                        <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">

                            <!-- begin total -->
                            <div class="dashboard-stat2 ">
                                <table class="dashboard-tabel" width="100%">
                                    <tr>
                                        <td>
                                            <small>@lang('layout.Total'):</small>
                                        </td>
                                        <td class="text-right">
                                    <span class="text-right" data-counter="counterup"
                                          data-value="7800">@{{ (Total-payeds).toFixed(precision())}}</span>
                                            <small class="font-green-sharp">@{{selected_currency.symbol}}</small>
                                        </td>
                                    </tr>

                                    <tr>
                                        <td>
                                            <small>@lang('layout.Payment'):</small>
                                        </td>
                                        <td class="text-right">
                                            <small class="font-green-sharp">
                                        <span class="text-right" data-counter="counterup"
                                              data-value="7800">@{{ payeds.toFixed(precision())}}</span>
                                                <small class="font-green-sharp">@{{selected_currency.symbol}}</small>
                                            </small>
                                        </td>
                                    </tr>


                                    <tr>
                                        <td>
                                            <small>@lang('layout.Sub-Total'):</small>
                                        </td>
                                        <td class="text-right">
                                    <span class="text-right" data-counter="counterup"
                                          data-value="7800">@{{ (Total).toFixed(precision())}}</span>
                                            <small class="font-green-sharp">@{{selected_currency.symbol}}</small>
                                        </td>
                                    </tr>
                                
                                </table>

                            </div>

                            <!-- end total -->
                        </div>
                        <!-- end pay -->
                    </div>
                    <br>
                    <!-- begin items -->
                    <div class="row" v-if="inventories.length>0" style="overflow-x: scroll;">
                        <table id="table_content" class="table table-bordered table-advance">
                            <thead>
                            <tr>
                                <th>#</th>
                                <th style="min-width: 120px" >@lang('layout.Type') </th>
                                <th style="min-width: 150px" >@lang('layout.Number') </th>
                                <th style="min-width: 120px" >@lang('layout.VehicleName') </th>
                                <th style="min-width: 120px" >@lang('layout.ItemName') </th>
                                <th style="min-width: 120px" >@lang('layout.SiteName') </th>
                                <th>@lang('layout.Quantity') </th>
                                <th style="min-width: 120px" >@lang('layout.ConfirmQuantity') </th>
                                <th v-show="holding" style="min-width: 120px">@lang('layout.FromDate') </th>
                                <th v-show="holding" style="min-width: 120px">@lang('layout.ToDate') </th>
                                <th v-show="holding" style="min-width: 100px">@lang('layout.RemoveDays') </th>
                                <th>@lang('layout.Measure') </th>
                                <th>@lang('layout.PurchaseCost') </th>

                                <th style="min-width: 100px">@lang('layout.Category') </th>
                                <th style="min-width: 100px"  v-for="cat in itemExpenseCategory">
                                    @{{ cat.name }}
                                </th>
                            <!-- <th style="min-width: 100px">@lang('layout.TotalExpense')</th> -->
                                <th style="min-width: 100px">@lang('layout.PerUnitExpense') </th>
                                <th style="min-width: 100px">@lang('layout.Total') </th>
                                <th></th>

                            </tr>
                            </thead>
                            <tbody>
                            <tr v-for="(item,index) in inventories">
                                <td>@{{index+1}}</td>
                                <td>
									<input type="hidden" name="purch_id[]" :value="(!item.item)?null:item.item.purchase_id">
									<input type="hidden" name="stock_id[]" :value="(!item.item)?null:item.item.stock_id">
									<input type="hidden" name="quantity[]" :value="(!item.item)?null:item.item.qty">
									<input type="hidden" name="inventory_id[]" :value="(!item.item)?null:item.item.inventory_id">
									<input type="hidden" name="load_id[]" :value="(!item.item)?null:item.item.load_id">
									<input type="hidden" name="transfer_and_loading_id[]" :value="(!item.item)?null:item.item.id">
									
                                    <select name="type[]" class="form-control" v-model="item.selected_type" @click="carChange(index), addNew('inventory',index)" >
										<option value="">@lang('layout.SelectType')</option>
                                        <option value="purchase">@lang('layout.Purchases')</option>
                                        <option value="transferAndLoading">@lang('layout.TransferAndLoading')</option>
                                        <option value="discharge">@lang('layout.Discharge')</option>
                                    </select>
                                </td>
								<td>
								<div class="input-group">
									<input type="number"  name="type_number[]" v-model="item.number" class="form-control input-style" @input="searchVehicle(index)" >
								</div>
                                </td>
								<td>
                                    <v-select label="name" v-model="item.item"  :options="item.temp_vehicle"
                                    @keyup.native="editKey = true, setIndex(index)" @click.native="editKey = true, setIndex(index), addNew('inventory',index)"  @input="(editKey)?setQuantity(index):''" @search="onItemSearchVehicle" ></v-select>
                                    {{-- <input type="hidden" :name="'vehicle_id['+index+']'" :value="(!item.vehicle)?null:item.vehicle.id"> --}}
                                </td>
                                <td>@{{(!item.item)?null:item.item.items}}</td>
                                <td>@{{(!item.item)?null:item.item.site}}</td>
                                <td>@{{(!item.item)?null:item.item.qty}}</td>
                                <td>
                                    <input type="number" name="quantity_in[]" step="any" v-model="(!item.item)?null:item.quantity" oninput = "autowidths(event)" class="form-control chan_length" >
                                </td>
                                <td v-show="holding">
                                    <date_picker :name="'from_date['+index+']'" v-model="(!item.item)?null:item.from_date" placeholder="@lang('layout.FromDate')" ></date_picker>
                                </td>
                                <td v-show="holding">
                                    <date_picker :name="'to_date['+index+']'" v-model="(!item.item)?null:item.to_date" placeholder="@lang('layout.ToDate')" ></date_picker>
                                </td>
                                <td v-show="holding">
                                    <input type="number" :name="'remove_days['+index+']'" v-model="(!item.item)?null:item.remove_days" placeholder="@lang('layout.RemoveDays')" >
                                </td>
                                <td>@{{(!item.item)?null:item.item.measure}}</td>
                                <td>@{{myRound((!item.item)?null:item.item.cost)}}</td>
                                
                                <td>
                                    <select name="category[]" v-model="(!item.item)?null:item.category" class="form-control">
                                        <option value="total">@lang('layout.Total')</option>
                                        <option value="perUnit">@lang('layout.PerUnit')</option>
                                    </select>
                                </td>
                                <template v-if="item.itemExpenseCategory">

                                    <td v-for="(cat,indexes) in item.itemExpenseCategory">
                                        <input v-if="item.item" type="number" class="form-control" v-model="(!cat)?null:item.itemExpenseCategory[indexes].amount"
                                                :name="'item_expense_category_id['+item.item.stock_id+']['+cat.item_expense_category_id+']'" >

                                    </td>
                                </template>
                               

                                <td>@{{myRound(itemExpenseCogs((!item.item)?null:item,item.item,item.itemExpenseCategory))}}</td>
                                <td>@{{myRound(itemExpenseTotalItems((!item.item)?null:item,item.item,item.itemExpenseCategory))}}</td>
								<td>
									<span v-if="inventories.length > 1" v-on:click="deleteItem('inventory',index)"><i class="paddint-both glyphicon glyphicon-trash"></i></span>

								</td>
                            </tr>
                            </tbody>
                        </table>
					<br/>
					<br/>
					<br/>
                    </div>
                    <!-- end items -->

                    <div v-show="selected_expense_type=='bill'">
                        <hr>
                        <!-- begin payments -->
                        <table id="table_content" class="table table-striped table-bordered table-advance table-hover">
                            <thead>
                            <tr @click="(payments.length < 1)?addNew('payment', 1000):''" >
                                <th class="text-center" style="min-width: 8px;"> #</th>
                                <th class="text-center" style="min-width: 160px;">@lang('layout.SelectBank')</th>
                                <th class="text-center" style="min-width: 100px;"> @lang('layout.Amount')</th>
                                <th class="text-center" style="min-width: 120px;"> @lang('layout.Rate')</th>
                                <th class="text-center" style="min-width: 80px;">@lang('layout.Currency')</th>
                                <th class="text-center" style="min-width: 80px;"> @lang('layout.Amount')</th>
                                <th class="text-center" style="min-width: 120px;">@lang('layout.Total')</th>
                                <th></th>

                            </tr>
                            </thead>
                            <tbody>
                            <tr v-for="(payment,index) in payments">
                                <td>@{{index+1}}</td>
                                <td class="highlight">
                                    <v-select label="name" v-model="payment.item" :options="(payment.items)"
                                              @click.native="addNew('payment',index)"
                                              @input="checkExistingPayment(index)">

                                    </v-select>
                                    <input type="hidden" name="payment_id[]"
                                           :value="(payment.item==null)?null:payment.item.id">
                                </td>

                                <td>
                                 
                                      <span v-if="payment.item !=null">
                                         @{{myRound(Number((payment.item==null)?null:payment.item.balance)-Number((payment.item==null)?null:payment.amount))}}
                                      </span>
                                </td>
                                <td>
                                    <input v-bind:disabled="(payment.item==null)?false:(payment.item.code =='{{getHomeCurrency()["code"]}}')"
                                           type="number" v-model.number="(payment.item==null)?null:payment.item.rate "
                                           class="form-control"
                                           placeholder="@lang('layout.Rate')" required/>
                                    <input v-if="payment.item !=null" type="hidden" name="payment_rate[]"
                                           v-bind:value="payment.item.rate">
                                </td>
                                <td>
                                    <input type="text" name="payment_currency[]" class="form-control"
                                           v-model="(payment.item==null)?null:payment.item.code"
                                           placeholder="@lang('layout.Currency')" required disabled/>

                                    <input v-if="payment.item !==null" type="hidden" name="payment_currency[]"
                                           v-bind:value="payment.item.code"/>
                                </td>
                                <td>
                                    <div class="input-group">
                                        <input type="number" class="form-control"
                                               v-model.number="(payment.item==null)?null:payment.amount "
                                               placeholder="@lang('layout.PayAmount')" required/>

                                        <input v-if="payment.item !=null" type="hidden" name="payment_amount[]"
                                               v-bind:value="payment.amount">

                                        <span class="input-group-addon">@{{(payment.item==null)?null:payment.item.code}}</span>
                                    </div>
                                </td> 
                                <td>
                                    <div class="input-group">
                                        @if(systemConfig()[30] == 1)
                                        <input type="number" class="form-control"
                                            :value="!payment.item?null:(((payment.amount / payment.item.static_rate * payment.item.rate) * selected_currency.static_rate)/selected_currency.rate).toFixed(precision())"
                                            placeholder="@lang('layout.Total')" style="min-width: 100px" required/>
                                        @else 
                                            <input type="number" class="form-control"
                                                :value="!payment.item?null:(payment.amount*selected_currency.rate/payment.item.rate).toFixed(precision())"
                                                placeholder="@lang('layout.Total')" style="min-width: 100px" required/>
                                        @endif
                                        <span class="input-group-addon">@{{selected_currency.symbol}}</span>
                                    </div>
                                </td>
                                <td>
                                    <span v-on:click="deleteItem('payment',index)"><i
                                                class="paddint-both glyphicon glyphicon-trash"></i></span>
                                </td>
                            </tr>
                            </tbody>
                        </table>
                        <!-- end payments -->

                    </div>
                    <div class="col-md-4 col-md-offset-4 text-center">
                        <br>
                        <button type="button" class="btn green" v-if="!isError"
                        @click="handleSubmit($event)">@lang('layout.Update')</button>
                        <a href="{{route('oilItemExpense.index')}}" class="btn default"><i
                                    class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                    </div>
                </div>


                {!! Form::close() !!}

                <!--Begin Modal -->
                {!! Form::open(array('method'=>'POST','class'=>'form-horizontal')) !!}
                    {{ csrf_field() }}                                        
                    <cmodal :show="showcModal" @close="showcModal = false">
                        <h3 slot='cheader'>@lang('layout.CreateNewExpenseCategory')</h3>
                        <div slot="cbody">
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <label>@lang("layout.Name") <span class="required"> * </span></label>
                                            <input type="text" class="form-control" name="name" v-model="className">
                                        </div>
                                    </div>
                                </div>

                                 <div class="row">
                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <label>@lang("layout.Description")</label>
                                            <textarea class="form-control" name="description" v-model="description">
                                            </textarea>
                                        </div>
                                    </div>
                                </div>
                        </div>
                        <div slot="cfooter">
                            <button type="button" class="modal-default-button btn btn-success" @click="addExpenseCategory">
                                @lang('layout.Submit')
                            </button>
                        </div>
                    </cmodal>
                    {!! Form::close() !!}
                    <!--End Modal-->

            </div>

            <!-- END FORM-->
        </div>
    </div>

@endsection
@push('scripts')
<script src="{{URL::asset('assets/global/plugins/bootstrap-timepicker/js/bootstrap-timepicker.min.js')}}" type="text/javascript"></script>
<script src="{{URL::asset('assets/pages/scripts/components-date-time-pickers.min.js')}}" type="text/javascript"></script>
    <script type="text/javascript">
        Vue.use(VueInputAutowidth);
        Vue.component('v-select', VueSelect.VueSelect);

        var Modal = Vue.component('cmodal',
            {
                template:'#cmodal-template',
                props: ['show'],
            });


            @if(App::getLocale())
            Vue.use(VeeValidate, {
                locale: '{{App::getLocale()}}',
            });
            @else
            Vue.use(VeeValidate, {
                locale: 'en',
            });
            @endif

        var currency = {!! $currency !!};
        var selectedCurrency = {!! $selectedCurrency !!};
        var banks = {!! $banks !!};
        var income = {!! $income !!};
        var expenseCategory = {!! $expenseCategory !!};
        var category = {!! $category !!};
        var itemExpense = {!! $itemExpense !!};
        var selected_banks1 = {!! $selected_banks !!};
        var selectedVendor = {!! $selectedVendor !!};
        var itemExpenseItems = {!! $itemExpenseItems !!};
        var vm = new Vue({
            el: '#itemexpense',
            data: {
                selected_type: 'purchase',
                selected_cost_type: 'posting',
                editKey: false,
                holding: false,
                inventories: [],
                typeInfo: null,
                averageRate: false,
                differentRate: false,
                selected_expense_type: 'writeCheck',
                currency: currency,
                selected_currency: selectedCurrency,
                banks: banks,
                income: income,
                vendor: [],
                selected_vendor: selectedVendor,
                itemExpenseItems: itemExpenseItems,
                selected_banks: null,
                selected_income: {!! $selected_income !!},
                number: itemExpense.number,
                itemExpense: itemExpense,
                selected_banks1: selected_banks1,
                rate: 0,
                payments: [],
                expenseCategory: expenseCategory,
                selected_category: null,

                showcModal: false,
                errorMessage: '',
                fieldErrors: [],
                className: null,
                description: null,
                vehicle:[],
                itemExpenseCategory:category


            },
            computed: {
                isError: function () {
                    var isError = false;
                    //var flag=false;
                    // for (var i = 0; i < this.inventories.length; i++)
                    // {

                    //    if (this.inventories[i].item)
                    //    {
                    //      flag=true;
                    //      if(((this.inventories[i]['item']['rate'] <=0) ))
                    //      {
                    //        rate=this.inventories[i]['item']['rate'];
                    //        new_rate=this.inventories[i]['item']['new_rate'];
                    //        if(rate <=0 && new_rate <=0)
                    //        {
                    //             isError = true;
                    //        }

                    //      }
                    //    }
                    // }
                    // if (this.selected_vendor == null) {
                    //     isError = true;
                    // }
                    return isError;


                },
                Total: function () {
                    var sum = 0;
                    for (var i = 0; i < this.inventories.length; i++) {

						if (this.inventories[i] && this.inventories[i] != null) {

						if (this.inventories[i].item != null) {
							
							var rate = (this.selected_currency) ? this.selected_currency.rate : 1;
                            @if(systemConfig()[30] == 1)
							var cost = this.inventories[i].item.cost * this.selected_currency.static_rate / rate;
                            @else 
							var cost = this.inventories[i].item.cost * rate;
                            @endif

                            sum+=Number(vm.itemExpenseTotalItems(this.inventories[i],this.inventories[i].item,this.inventories[i].itemExpenseCategory));

						}
                           
                        }
						
                    }
                    return sum;

                },


                selectedRate() {
                    this.rate = (this.selected_currency) ? this.selected_currency.rate : 0;
                },

                subtotal: function () {
					// console.log(this.inventories);
                    var sum = 0;
                    for (var i = 0; i < this.inventories.length; i++) {
                        if (this.inventories[i] && this.inventories[i] != null) {
                        var expenses = 0;
						if (this.inventories[i].itemExpenseCategory != null) {
							for(var z=0;z<this.inventories[i].itemExpenseCategory.length;z++)
							{
								if (this.inventories[i].itemExpenseCategory[z].amount != null) {
									expenses += Number.parseFloat(this.inventories[i].itemExpenseCategory[z].amount);
								}
							}
						}
							
						if (this.inventories[i].item != null) {
							
							var rate = (this.selected_currency) ? this.selected_currency.rate : 1;
                            @if(systemConfig()[30] == 1)
							var cost = this.inventories[i].item.cost * this.selected_currency.static_rate / rate;
                            @else 
							var cost = this.inventories[i].item.cost * rate;
                            @endif
							if (this.inventories[i].category == 'total') {
								//expenses = expenses / this.inventories[i].item.qty;
							}
							// total = cost + expenses;
								sum += expenses;
						}

                    //  var sum = 0;
                    // for (var i = 0; i < this.inventories.length; i++) {
                        
                    //     if (this.inventories[i].item !=null && this.inventories[i].itemExpenseCategory) {

                    //         let itemExpenseCategoryArray=this.inventories[i].itemExpenseCategory;

                           
                    //             sum+=Number(itemExpenseTotalItem(this.inventories[i].item,itemExpenseCategoryArray));

                           
                        }

                    }
                    
                    return sum;
                },
                payeds: function () {
                    this.differentRate = false;
                    var sum = 0;
                    for (var i = 0; i < this.payments.length; i++) {

                        if (this.payments[i].item != null && this.payments[i].item) {
                            if (this.payments[i].item != null && this.payments[i]['item']['rate'] > 0) {
                                
                                // @if(systemConfig()[30] == 1)
                                // sum += ((this.payments[i]['amount'] / this.payments[i]['static_rate'] * this.payments[i]['item']['rate']) * this.selected_currency.static_rate / this.selected_currency.rate);
                                // @else 
                                // sum += (this.payments[i]['amount'] * this.selected_currency.rate / this.payments[i]['item']['rate']);
                                // @endif

                                @if(systemConfig()[30] == 1)
                                sum += ((this.payments[i]['item']['amount'] / this.payments[i]['item']['static_rate'] * this.payments[i]['item']['rate']) * this.selected_currency.static_rate / this.selected_currency.rate);
                                @else 
                                sum += (this.payments[i]['item']['amount'] * this.selected_currency.rate / this.payments[i]['item']['rate']);
                                @endif

                                if (this.selected_currency.code == this.payments[i]['item']['code'] && this.payments[i]['amount']) {
                                    if (this.selected_currency.rate != this.payments[i]['item']['rate']) {
                                    this.differentRate = true;
                                    }
                                }
                            }
                        }
                    }
                    return sum;
                },
                // filter the banks according to selected currency
                approperiateBank: function () {
                    this.selected_banks=null;
                    var bankCopy = this.banks.slice();
                    var tempBank = bankCopy.filter((account) => {
                        return (new RegExp(this.selected_currency.code.toLowerCase())).test(account.code.toLowerCase())
                    });
                    if (tempBank.length > 0) {
                        this.selected_banks = tempBank[0];
                    }
                    return tempBank;
                },
            },
			mounted: function () {
                if (this.itemExpense) {
                    this.itemExpenseNumber = this.itemExpense.type_number;
                    this.selected_expense_type = this.itemExpense.expense_type

                    if (this.selected_expense_type == 'writeCheck') {
                        for (var j = 0; j < this.banks.length; j++) {
                            if (this.banks[j].id == this.itemExpense.account_id) {
                                this.selected_banks = this.banks[j];
                            }
                        }

                    }
                    else {

                        for (var t = 0; t < this.selected_banks1.length; t++) {
                            var foundFlag = false;
                            var tempBank = null;
                            for (var y = 0; y < this.banks.length; y++) {
                                if (this.selected_banks1[t].Account_id == this.banks[y].id) {
                                    foundFlag = true;
                                    tempBank = this.banks[y];
                                    tempBank.amount = this.selected_banks1[t].Amount;
                                    if (this.selected_currency.code == tempBank.code) {
                                        tempBank.rate = this.selected_currency.rate;
                                    } else {
                                        tempBank.rate = this.selected_banks1[t].Rate;
                                    }
                                }
                            }
                            if (foundFlag) {

                                this.payments.push({item: tempBank, items: this.banks, amount: tempBank.amount});
                            }
                        }
                        for (var w = 1; w > this.selected_banks.length; w--) {
                            this.payments.push({item: null, amount: null, items: banks});
                        }
                    }

                    this.selected_type = this.itemExpense.type;
                    this.selected_cost_type = this.itemExpense.cost_type;
                    this.selected_category = _.find(this.expenseCategory, (e) => e.id == this.itemExpense.expense_category_id);

                    if (this.itemExpense.holding) {
                        this.holding = true;
                    }

                    if (this.itemExpenseItems) {
                        var items = this.itemExpenseItems;
						// console.log(3434,items);
                        
                        for (var i = 0; i < items.length; i++) {
                            this.inventories.push({item:items[i].item, itemExpenseCategory:items[i].itemExpenseCategory, temp_vehicle:[], quantity:items[i].item.quantity, vehicle:items[i], selected_type:items[i].info.type, number:items[i].info.type_number, category:items[i].info.category, from_date:items[i].info.from_date, to_date:items[i].info.to_date, remove_days:items[i].info.remove_days});
                        }

                    }
					this.inventories.push({item:null, itemExpenseCategory:{!! $category !!}, vehicle:null, temp_vehicle:[], quantity:0, selected_type:'', number:null, category:'total', from_date:null, to_date:null, remove_days:null});
                }
            },
            methods: {

                handleSubmit(e) {
                    this.$validator.validate().then(valid => {
                        if (valid) {
                            // alert(e.target);
                        
                                regForm(e.target);
                        }
                    });
                },


                    //Function to add MemberCLass
                addExpenseCategory:function(){
                    axios.post("{{route('expenseCategory.store')}}",{
                        name:vm.className,
                        description:vm.description
                    })
                    .then(function(response){
                        
                        // location.reload();

                          var data = {id: response.data.id,name: response.data.name};
                        // vu.categories = response.data;
                        axios.get("{{route('expenseCategory.create')}}").then(function (response) {
                            
                            vm.className = null;
                             vm.description = null;
                            vm.expenseCategory     = response.data;
                        });


                    });
                    vm.showcModal = false;
                },

                numberChange() {
                    this.inventories = [];
                },

                set_avg_rate(avg_rate) {
                    setTimeout(() => {
                        this.averageRate = true;
                        this.selected_currency.rate = avg_rate;
                    }, 300);
                },

                set_avg_rate_by_bank(bank) {
                    this.averageRate = false;
                    @if(getAverageRate() =="true")
                    if (bank) {
                        if (bank.avg_rate && this.selected_expense_type =='writeCheck') {
                            this.set_avg_rate(bank.avg_rate);
                        }
                    }
                    @endif
                },

                set_avg_rate_by_currency() {
                    this.averageRate = false;
                    @if(getAverageRate() =="true")
                    setTimeout(() => {
                        if (this.selected_banks) {
                            if (this.selected_banks.avg_rate && this.selected_expense_type =='writeCheck') {
                                this.set_avg_rate(this.selected_banks.avg_rate);
                            }
                        }
                    }, 200);
                    @endif
                },

                MemberSearch: _.debounce((search, loading) => {
                    loading(true);
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'SearchMember', 
                            keyword: search,
                            type: 'Vendor'
                        }
                    })
                    .then(function(response) {
                        if (response.data.length > 0) {
                            // console.log(response.data);
                            vm.vendor = [];
                            vm.vendor = response.data;
                        }
                        loading(false);
                    })
                    .catch(function(error) {
                        loading(false);
                        console.log(error);
                    })
                }, getDebounceTime()),
				
				carChange(index) {
                    //     if (vm.inventories[index].selected_type != null) {
					// 		console.log('rrrnn', vm.inventories[index].selected_type);
							
					// 		var selected_type = vm.inventories[index].selected_type;
							
					//    axios.get("{{route('callOilItemExpense.search')}}",{
					// 	params:{
					// 	  method_name:'selectRefNumber',
					// 	  type:selected_type,
					// 	}
					//    })
					//    .then(function (response)
					//    {
					// 	 vm.vehicleManagement=[];
					// 	 if(response.data != null)
					// 	 {
					// 		 vm.inventories[index].number = response.data.number;
					// 		console.log('test 22',response.data.number);
					// 	 }
					//    })
					//    .catch(function (error)
					//    {
					// 	  console.log(error);
					//    });
							
                    //     }
                },
					
				searchVehicle(index) {
                    if (vm.inventories[index].number != null && vm.inventories[index].selected_type != null) {
                        vm.inventories[index].temp_vehicle = [];
                        var selected_type = vm.inventories[index].selected_type;
                        var number = vm.inventories[index].number;
                        
                        axios.get("{{route('callOilItemExpense.search')}}",{
                        params:{
                            method_name:'selectVehicle',
                            type:selected_type,
                            number:number,
                        }
                        })
                        .then(function (response)
                        {
                            if(response.data.vehicle.length > 0)
                            {
                                vm.inventories[index].temp_vehicle = response.data.vehicle;
                            }
                        })
                        .catch(function (error)
                        {
                            console.log(error);
                        });
                    }
                },

                onItemSearchVehicle: _.debounce((search, loading) => {
                    loading(true);
                    var index = vm.selected_index;
                    if (vm.inventories[index].number != null && vm.inventories[index].selected_type != null) {
                        var selected_type = vm.inventories[index].selected_type;
                        var number = vm.inventories[index].number;

                        axios.get("{{route('callOilItemExpense.search')}}",{
                            params:{
                            method_name:'selectVehicle',
                            type:selected_type,
                            number:number,
                            keyword: search
                            }
                        })
                        .then(function (response)
                        {
                            if(response.data.vehicle.length > 0)
                            {
                                vm.inventories[index].temp_vehicle = [];
                                vm.inventories[index].temp_vehicle = response.data.vehicle;
                            }
                            loading(false);
                        })
                        .catch(function (error)
                        {
                            loading(false);
                            console.log(error);
                        });
                        
                    }
                }, getDebounceTime()),

                setIndex(index) {
                    vm.selected_index = index;
                },

                setQuantity(index) {
                    if (vm.inventories[index]) {
                        if (vm.inventories[index].item) {
                            vm.inventories[index].quantity = vm.inventories[index].item.qty
                        }
                    }
                },
				
                getTotal(item = null) {
                    var total = 0;
                    if (item != null) {
                        var expenses = 0;
                    if (item.itemExpenseCategory != null) {
						for(var i=0;i<item.itemExpenseCategory.length;i++)
						{
							if (item.itemExpenseCategory[i].amount != null) {
								expenses += Number.parseFloat(item.itemExpenseCategory[i].amount);
							}
						}
					}
                        // var materialCost = Number(item.materialCost);
                        // var transportCost = Number(item.transportCost);
                        // var customeCost = Number(item.customeCost);
                        // var laborCost = Number(item.laborCost);
                        // var subContractorCost = Number(item.subContractorCost);
                        // var manufacturingCost = Number(item.manufacturingCost);
                        // var otherCost = Number(item.otherCost);
						
					if (item.item != null) {
						
                        var rate = (this.selected_currency) ? this.selected_currency.rate : 1;
                        @if(systemConfig()[30] == 1)
                        var cost = item.item.cost * this.selected_currency.static_rate / rate;
                        @else 
                        var cost = item.item.cost * rate;
                        @endif
                        if (item.category == 'total') {
                            expenses = expenses / item.item.qty;
                        }
                        else {

                        }
                        total = cost + expenses;
                    }
                    }
                    return total;
                },
				
			itemExpenseTotalItems(items=null,item=null,itemExpenseCategory=[])
            {
                let amount=0;
                if(item !=null && itemExpenseCategory.length>0)
                {
                    var category=items.category;  

                    for(var i=0;i<itemExpenseCategory.length;i++)
                    {
                        amount+=Number(itemExpenseCategory[i].amount);   
                    }
                    if(category=='total')
                    {
                        amount=amount;
                    }
                    else
                    {
                        amount=amount*items.quantity;
                    }
                }
                return Number.parseFloat(amount).toFixed(precision());
            },
            itemExpenseCogs(items=null,item=null,itemExpenseCategory=[])
            {
                let amount=0;
                if(item !=null && itemExpenseCategory.length>0)
                {
                    var category=items.category;  

                    for(var i=0;i<itemExpenseCategory.length;i++)
                    {
                        amount+=Number(itemExpenseCategory[i].amount);   
                    }
                    if(category=='total')
                    {
                        // amount=amount/item.qty;
                        amount=amount/items.quantity
                    }
                    else
                    {
                        amount=amount;
                    }
                }
                return Number.parseFloat(amount).toFixed(precision());
            },
			
                //getTotalExpense
                getTotalExpense(item = null) {
                    var total = 0;
					if (item != null) {
                        var expenses = 0;
                    if (item.itemExpenseCategory != null) {
						for(var i=0;i<item.itemExpenseCategory.length;i++)
						{
							if (item.itemExpenseCategory[i].amount != null) {
								expenses += item.itemExpenseCategory[i].amount;
							}
						}
					}
					if (item.item != null) {
                        var rate = (this.selected_currency) ? this.selected_currency.rate : 1;
                        @if(systemConfig()[30] == 1)
                        var cost = item.item.cost * this.selected_currency.static_rate / rate;
                        @else 
                        var cost = item.item.cost * rate;
                        @endif
                        if (item.category == 'total') {
                            expenses = expenses;
                        }
                        else {

                        }
                        total = expenses;
                    }
                    }
                    return total;
                },

                // search stock based on type purchase/build/opening
                searchType() {
                    var id = document.getElementById('number').value;
                    this.inventories = [];
                    this.typeInfo = null;
                    if (id && this.selected_type) {
                        axios.get("{{route('callMethod.search')}}", {
                            params: {
                                method_name: 'itemExpenseSearch',
                                type: this.selected_type,
                                number: id,
                            }
                        })
                            .then(function (response) {
                                // console.log('123', response.data);

                                if (response.data.length > 0) {

                                    if (response.data[0]) {
                                        vm.typeInfo = response.data[0].typeInfo;
                                        var myDataArray=response.data[0].myData;
                                        for(var i=0;i<myDataArray.length;i++)
                                        {
                                           
                                            vm.inventories.push({item:myDataArray[i].items, temp_vehicle:[], quantity:0, itemExpenseCategory:myDataArray[i].itemExpenseCategory});
                                            vm.itemExpenseCategory=myDataArray[i].itemExpenseCategory;

                                        }


                                    }

                                }
                                else {
                                    var id = response.data.id;
                                    if (id) {
                                        var url = "{{url('itemExpense')}}/" + id + '/edit';

                                        window.location.href = url;
                                    }
                                }
                            })
                            .catch(function (error) {
                                console.log(error);
                            });
                    }

                },
                // end search type


                // in here you can check and decide to allow duplicate bank for payment or not
                checkExistingPayment(index = null, name = '') {
                    var bank_temp = this.banks.slice();
                    var bank_temp1 = [];
                    for (var i = 0; i < this.payments.length; i++) {
                        if (this.payments[i].item != null) {
                            var fined = bank_temp.findIndex((item) => item.name == this.payments[i].item.name);
                            if (fined != -1) {
                                var o = bank_temp.splice(bank_temp.findIndex((item) => item.name == this.payments[i].item.name), 1);
                            }
                        }
                    }
                    if (this.payments[index]) {
                        this.payments[index].items = bank_temp.filter((item) => {
                            return (new RegExp(name.toLowerCase())).test(item.name.toLowerCase())
                        });
                        //this.payments[index].items =bank_temp;
                    }


                },


                // generic function for adding item to list
                addNew(type = null, index) {
                    this.temp_items = [];
                    if (type != null) {
                        if (type == 'inventory') {
                            if (this.inventories[index + 1] == undefined) {
                                this.temp_items = [];
                                this.inventories.push({item:null, itemExpenseCategory:{!! $category !!}, vehicle:null, temp_vehicle:[], quantity:0, selected_type:'', number:null, category:'total'});
                            }
                        }
                        if (type == 'payment') {
                            if (this.payments[index + 1] == undefined) {
                                this.checkExistingPayment(index, '');
                                this.payments.push({
                                    items: this.banks,
                                    item: null,
                                    amount: null,
                                });
                            }
                        }
                    }

                },

                // delete item from list
                deleteItem(type = null, index) {
                    if (type != null) {
                        console.log(type);
                        if (type == 'inventory') {
                            this.inventories.splice(index, 1);
                        }
                        if (type == 'payment') {
                            this.payments.splice(index, 1);
                        }
                    }

                },


            }
        });

    </script>
@endpush
 