@extends('layouts.app')
@section('content')
    <div class="portlet">
        <div class="portlet-title" id="backbtn">
            <div class="caption">
                <i class=""></i>@lang('layout.OfferShow')
            </div>
            <div class="tools">
                <a href="javascript:;" class="collapse" data-original-title="" title=""> </a>
                <a href="#portlet-config" data-toggle="modal" class="config" data-original-title="" title=""> </a>
                {{--<a href="javascript:;" class="reload" data-original-title="" title=""> </a>--}}
                {{--<a href="javascript:;" class="remove" data-original-title="" title=""> </a>--}}
            </div>
        </div>
        <div class="portlet-body">
            <div class="table-scrollable">
                <table class="table table-striped table-bordered table-advance table-hover">
                    <thead>
                        <tr>
                            <th>
                                <i class="fa  fa-bars"></i> @lang('layout.Date')
                            </th>
                            <th>
                                <i class="fa fa-code"></i> @lang('layout.Number')
                            </th>
                            <th>
                                <i class="fa fa-code"></i> @lang('layout.Code')
                            </th>
                            <th>
                                <i class="fa fa-file-excel-o"></i> @lang('layout.Title')
                            </th>
                            <th>
                                <i class="fa fa-file-excel-o"></i> @lang('layout.OfferCategory')
                            </th>
                            <th>
                                <i class="fa fa-file-excel-o"></i> @lang('layout.OfferClass')
                            </th>
                            <th>
                                <i class="fa fa-file-excel-o"></i> @lang('layout.Status')
                            </th>
                            <th>
                                <i class="fa fa-user"></i> @lang('layout.RequestorName')
                            </th>
                            <th>
                                <i class="fa fa-photo"></i> @lang('layout.Photo')
                            </th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td>  {{convertDate($offer->date)}} </td>
                            <td>  {{$offer->number}}  </td>
                            <td>  {{$offer->code}} </td>
                            <td>  {{$offer->title}} </td>
                            <td>  {{$offer->name}} </td>
                            <td>  {{$offer->offerClassName}} </td>
                            <td>  {{$offer->status}} </td>
                            <td>  {{$offer->requestorName}} </td>
                            <td>  <img src="{!!url('/uploads/'.$offer->photo)!!}" style="width: 50px;height: 50px; border-radius: 50%" alt="">  </td>
                        </tr>
                        <tr>
                            <td colspan="3">
                                <table>
                                    <tr>
                                        <td><span>@lang('layout.Label')</span> &nbsp;: &nbsp;</td>
                                        <td><span>{{$offer->labels}}</span></td>
                                    </tr>
                                </table>
                            </td>
                            <td colspan="3">
                                <table>
                                    <tr>
                                        <td><span><i class="fa fa-text-width"></i> @lang('layout.Description')</span>:</td>
                                        <td><span>{{$offer->description}}</span></td>
                                    </tr>
                                </table>
                            </td>

                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    <div class="row" >
        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>
                    <span class="caption-subject bold uppercase">@lang('layout.Approveres')</span>
                </div>
                <div class="actions">
                </div>
            </div>
            <div class="portlet-body" id="itemsshow">
                <table class="table table-striped table-bordered table-hover" id="orderMemo">
                    <thead>
                        <tr>
                            <th>#</th>
                            {{-- <th>@lang('layout.Type')</th> --}}
                            <th>@lang('layout.User')</th>
                            <th>@lang('layout.PositionName')</th>
                            <th>@lang('layout.Signature')</th>
                            <th>@lang('layout.Date')</th>
                            <th>@lang('layout.Description')</th>
                            {{-- <th>@lang('layout.Action')</th> --}}
                        </tr>
                    </thead>
                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>
    <div class="row" id="app">
        {!! Form::open(array('route' => 'offer.storeMemo','method'=>'POST','class'=>'form-horizontal')) !!}
            {{ csrf_field() }}
            
            @if($selectedPosition)
            <div class="col-md-12" style="padding: 0px;" >
                <h3>@lang('menu.Position')</h3>
                <div class="col-md-4" >
                    <label class="control-label">@lang('menu.Position')</label>
                    <v-select class="vue-select2" v-model="selected_position" label="name" :options="{{$position}}">
                    </v-select>
                    <input type="hidden" name="position_id" v-model.number="(!selected_position)?null:selected_position.id">
                    <input type="hidden" name="offer_id" value="{{$offer->id}}">
                </div>
                <div class="col-md-8">
                    <label class="control-label">@lang('layout.Description')</label>
                    {!! Form::textarea('memo_description', null, array('placeholder' => __('layout.Description'),'class' => 'form-control','rows' => 1, 'cols' => 30)) !!}
                </div>
            </div>
            <div class="col-md-12" >
                <input type="hidden" value="memo" name="memo_type">
                <br/>
                <div class="portlet-body">
                    {{-- <table class="table table-striped table-bordered table-hover">
                        <tbody>
                            <tr>
                                <td class="highlight">
                                    <div class="form-control">
                                        <label class="mt-checkbox mt-checkbox-outline"  style="color: blue;">
                                            <input type="radio" value="memo" name="memo_type"><span></span> @lang('layout.Memo')
                                        </label>
                                    </div>
                                </td>
                                @if($selectedPosition->accept_form == 'yes')
                                <td class="highlight">
                                    <div class="form-control">
                                        <label class="mt-checkbox mt-checkbox-outline"  style="color: green;">
                                            <input type="radio" value="accupt" name="memo_type"><span></span> @lang('layout.Accept')
                                        </label>
                                    </div>
                                </td>
                                @endif
                                @if($selectedPosition->cancel_form == 'yes')
                                <td class="highlight">
                                    <div class="form-control">
                                        <label class="mt-checkbox mt-checkbox-outline" style="color: red;">
                                            <input type="radio" value="cancel" name="memo_type"><span></span> @lang('layout.Cancel') @lang('layout.Request')
                                        </label>
                                    </div>
                                </td>
                                @endif
                            </tr>
                        </tbody>
                    </table> --}}
                </div>
            </div>
            <div class="col-xs-12 col-sm-10 col-md-11 text-center">
                <br/>
                <button type="button" class="btn green" onclick="regForm(this)">@lang('layout.Submit')</button>
            </div>
            @endif
        {!! Form::close() !!}
        </div>

@endsection
@push('scripts')

    <script>
        $(document).ready(function () {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
            // $('#offer_details').DataTable({
            //     ajax: '{{route("offer.show",$offer->id)}}',
            //     scrollCollapse: true,
            //     responsive:'{{responsiveDataTable()}}',
            //     pagingType:'{{paginationType()}}',
            //     serverSide: true,
            //     paging: true,
            //     columns: [
            //         {data: 'date', name: 'date'},
            //         {data: 'description', name: 'description', orderable: false, searchable: false},
            //     ]
            // });
        
            $('#orderMemo').DataTable({  
                scrollCollapse: true,
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                serverSide: true,
                paging: true,
                retrieve: true,
                ajax:{
                    url: '{{route("offer.show",$offer->id)}}',
                    data:{type:'orderMemo'}
                    }, 
                columns: [ 
                    { data: 'id',   name: 'id' },
                    // { data: 'type',   name: 'type' },
                    { data: 'user',  name: 'user' },
                    { data: 'position_name', name: 'position_name' },
                    { data: 'signature', name: 'signature' },
                    { data: 'date',      name: 'date' },
                    { data: 'description',   name: 'description' },
                    // { data: 'action',   name: 'action' },
                ]
            });  
        });

        Vue.component('v-select', VueSelect.VueSelect);
    
        var selectedPosition =  {!! json_encode($selectedPosition) !!}; 
        let vu = new Vue({
            el: '#app',
            data: {
                selectedPosition: selectedPosition,
                selected_position: null
            },
            computed: {
            },
            methods: {
            }
        });

    </script>


@endpush
