@extends('layouts.factor-master')

@section('content')



    <h3 class="table-caption" style="text-align: center;">@lang('layout.NoteReport')</h3>
    <table class="main-table">
        @if($info && $info !=[])
            <tr>
                <td>
                    <span>@lang('layout.Date')</span>:
                    <span>{{convertDate($info->date)}}</span>
                </td>
                <td>
                    <span>@lang('layout.Description')</span>:
                    <span>{{$info->description}}</span>
                </td>
                <td>
                    <span>@lang('layout.Name')</span>:
                    <span>{{$info->name}}</span>
                </td>
                <td>
                    <span>@lang('layout.Number')</span>:
                    <span>{{$info->number}}</span>
                </td>

            </tr>

        @endif
        <tr>
            @if($from_date)
                <td>
                    <span>@lang('layout.FromDate')</span>:
                    <BDO DIR="LTR">{{convertDate($from_date)}}</BDO>
                </td>
            @endif
            @if($to_date)
                <td>
                    <span>@lang('layout.ToDate')</span>:
                    <BDO DIR="LTR">{{convertDate($to_date)}}</BDO>
                </td>
            @endif
        </tr>
    </table>

    <br>
    <table class="main-table">
        <thead>
        <tr class="bg">
            <td class="center" >
                <div> @lang('layout.Record') </div>
            </td>
            <td class="center" >
                <div> @lang('layout.Number')</div>
            </td>
            <td class="center" >
                <div> @lang('layout.Name')</div>
            </td>
            <td class="center" >
                <div> @lang('layout.Date')</div>
            </td>
            <td class="center" >
                <div> @lang('layout.Description')</div>
            </td>

        </tr>
        </thead>
        <?php
        $count = 0;
        ?>
        @foreach($data AS $record)
            <tr>
                <td class="center">{{++$count}}</td>
                <td class="center">{{$record->number}}</td>
                <td class="center">{{$record->name}}</td>
                <td class="center">{{convertDate($record->date)}}</td>
                <td class="center">{{$record->description}}</td>


            </tr>
        @endforeach
    </table>

 <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->

@endsection