@extends('layouts.app')
{{-- <link href="{{url('css/custome-table.css')}}" rel="stylesheet" type="text/css"> --}}
@section('style')
    {{-- <link href="{{url('css/custome-table.css')}}" rel="stylesheet" type="text/css"> --}}
    <link rel="stylesheet" type="text/css" href="{{URL::asset('multiple-select/css/jquery.multiselect.css')}}">
    <link href="{{url('/assets/bootstrap-fileinput/bootstrap-fileinput.css')}}" rel="stylesheet" type="text/css"/>
    <link rel="stylesheet" type="text/css" href="{{URL::asset('multiple-select/css/jquery.multiselect.css')}}">
    <link href="{{url('/assets/bootstrap-fileinput/bootstrap-fileinput.css')}}" rel="stylesheet" type="text/css"/>
    <link href="{{url('/assets/bootstrap-fileinput/profile-rtl.min.css')}}" rel="stylesheet" type="text/css"/>
    <link href="{{ url('/assets/global/plugins/bootstrap-wysihtml5/bootstrap-wysihtml5.css') }}" rel="stylesheet" type="text/css"/>
    <link href="{{ url('/assets/global/plugins/bootstrap-markdown/css/bootstrap-markdown.min.css') }}" rel="stylesheet" type="text/css"/>
    <link href="{{ url('/assets/global/plugins/bootstrap-summernote/summernote.css') }}" rel="stylesheet" type="text/css"/>
    <style>
        .multipleClass .v-select .selected-tag{
            height: 26px !important;
            margin: 4px 1px 0 3px !important;
        }
        .multipleClass .v-select .selected-tag > button >span{
            display: none !important;
        }
    </style>
@endsection
@section('content')
    <div id="print-modal">
        <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show" :value-type="'allOfferReport'" @closed="closeModal">
            <div slot=body>
                <div class="row">
                    <div class="tabbable tabbable-tabdrop">
                        <ul class="nav nav-tabs">
                            <li class="active">
                                <a href="#tab1" data-toggle="tab" id="tab_main">@lang('menu.Report')</a>
                            </li>
                            @permission(['customreport-list'])
                            <li class="">
                                <a href="#tab2" data-toggle="tab" id="tab_custome">@lang('layout.CustomReportM')</a>
                            </li>
                            @endpermission
                        </ul>
                        <div class="tab-content">
                            <div class="tab-pane active" id="tab1">
                                <div class="portlet light bordered">
                                    <div class="row">
                                        <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12">
                                            <div class="form-group">
                                                <label class="control-label"> @lang('layout.Type')</label>
                                                <select name="report_type" class="form-control">
                                                    <option value="">@lang('layout.SelectType')</option>
                                                    {{-- <option value="overviewDetails">@lang('layout.Overview')</option> --}}
                                                    <option value="trailDetails">@lang('layout.TrialDetails')</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12">
                                            <div class="form-group">
                                                <label class="control-label">@lang('layout.OfferCategory')</label>
                                                <v-select label="name" v-model="selectedofferCategories" :options="offerCategories">
                                                </v-select>
                                                <input type="hidden" name="category_id" v-model.number="(!selectedofferCategories)?null:selectedofferCategories.id">
                                            </div>
                                        </div>
                                        <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12">
                                            <div class="form-group">
                                                <label class="control-label">@lang('layout.OfferClass')</label>
                                                <v-select label="name" v-model="selectedofferClass" :options="offerClasses">
                                                </v-select>
                                                <input type="hidden" name="offerClass" v-model.number="(!selectedofferClass)?null:selectedofferClass.id">
                                            </div>
                                        </div>
                                        <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12">
                                            <div class="form-group">
                                                <label class="control-label">@lang('layout.RequestorName')</label>
                                                <input type="text" name="requestorName" class="form-control">
                                            </div>
                                        </div>
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label class="control-label"> @lang('layout.Date')</label>
                                                <div class="input-group">
                                                    <input class="form-control date" id="range-from-example" name="from_date" autocomplete="off">
                                                    <span class="input-group-addon"> @lang('layout.To') </span>
                                                    <input class="form-control date" id="range-to-example" name="to_date" autocomplete="off">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="tab-pane" id="tab2"> 
                                <div class="portlet light bordered">
                                    <div class="row">
                                        <form  id="saveCustomeReport" role="form" action="{{route('customeReport.storeCustomeReport')}}" method="post" >
                                            @csrf
                                            <input type="hidden" name="part_name" value="offers_index">
                                            <div class="col-md-12 col-sm-12 col-xs-12">
                                                <div class="mt-checkbox-inline col-md-2" style="padding: 0px;margin-bottom: 15px !important;" v-for="(row,itemIndex) in customReportData">
                                                    <div class="form-group">
                                                        <table class="table table-striped table-bordered table-advance table-hover">
                                                            <tr>
                                                                <td style="text-align: center;">@{{ row.Name }}</td>
                                                            </tr>
                                                            <tr>
                                                                <td style="text-align: center;">
                                                                    <input type="hidden" :name="'column_name['+itemIndex+']'" class="form-control" v-model="row.column_name">
                                                                    <label class="switch">
                                                                        <input type="checkbox" :name="'column_status['+itemIndex+']'" 
                                                                        :checked="row.checkedColumn" >
                                                                        <span class="slider round"></span>
                                                                    </label>
                                                                    <select :name="'column_percentage['+itemIndex+']'" v-model="row.column_percentage" class="form-control" style="width: 90%;">
                                                                        <option value="">@lang('layout.Select')</option>
                                                                        <option value="2">2 %</option>
                                                                        <option value="6">6 %</option>
                                                                        <option value="10">10 %</option>
                                                                        <option value="15">15 %</option>
                                                                        <option value="20">20 %</option>
                                                                        <option value="25">25 %</option>
                                                                        <option value="30">30 %</option>
                                                                        <option value="40">40 %</option>
                                                                        <option value="50">50 %</option>
                                                                        <option value="60">60 %</option>
                                                                    </select>
                                                                </td>
                                                            </tr>
                                                        </table>
                                                    </div>  
                                                </div>
                                            </div>
                                            <div class="margin-top-10">
                                                <button type="button" onclick="saveCustomeReport(this)" class="btn blue"> <i class="fa fa-save"></i> </button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </report-modal>
    </div>
    <!-- BEGIN TAB PORTLET-->
    <div class="row">
        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>&nbsp;
                    <span class="caption-subject bold uppercase">  @lang('layout.OfferList') &nbsp; &nbsp; &nbsp; </span>
                </div>
                <div class="tools"></div>
                <div class="pull-right">
                    <span onclick="getRecord();" class="btn blue">
                        <i class="fa fa-refresh"></i>
                    </span>
                    @permission('Offer-export')
                    <span id="anchore-modal">
                        <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                            <i class="fa fa-print"></i>
                        </a>
                    </span>
                    @endpermission
                    @permission('OfferCategory-show')
                    <a href="{{route('offersCategories.index')}}">
                        <button class="btn btn-success">
                            <i class="fa fa-reorder"></i> @lang('layout.OfferCategory')
                        </button>
                    </a>
                    @endpermission
                    @permission('OfferClass-list')
                    <a href="{{route('offersClasses.index')}}">
                        <button class="btn btn-success">
                            <i class="fa fa-reorder"></i> @lang('layout.OfferClass')
                        </button>
                    </a>
                    @endpermission
                    {{-- @permission('note-create')
                    <a href="{{route('offer.create')}}">
                        <!-- <button id="sample_editable_1_new" class="btn green btn-sm btn-outline"> -->
                        <button id="sample_editable_1_new" class="btn btn-success">
                            <i class="fa fa-plus"></i> @lang('layout.AddNew')
                        </button>
                    </a>
                    @endpermission --}}
                    @permission(['Offer-create'])
                    <span id="create-modal">
                        <a href="#" @click.prevent="showModal" class="btn  btn-success">
                        <i class="fa fa-plus"></i> @lang('layout.AddNew')
                        </a>
                    </span>
                    @endpermission
                </div>
                <template v-cloak id="company_all">
                    <company @company="setCompany"></company>
                </template>
            </div>
            <div class="portlet-body">
                <!--Begin Form-->
                {!! Form::open(array('route' => 'offer.store','method'=>'POST','class'=>'form-horizontal','id'=>'offer-submit','files'=> true)) !!}
                    {{ csrf_field() }}
                    <div class="well well-lg" id="app" v-show="show_create"  >
                        <div class="form-body" v-cloak >
                            <div class="row">
                                <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12" style="box-shadow: 0px 0px 3px rgba(172, 171, 171, 0.877);border-radius: 8px; margin-bottom: 10px; padding: 15px 0px;">
                                    <div class="row" style="padding: 0px 10px;">
                                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                            <label class="control-label ">@lang('layout.Title')</label>
                                            {{Form::text('title',null,['class' => 'form-control','autocomplete'=>'off'])}}
                                        </div>
                                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                            <label class="control-label ">@lang('layout.Number')</label>
                                            {{Form::number('number',$number,['class' => 'form-control','v-model'=>'number'])}}
                                        </div>
                                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                            <label class="control-label ">@lang('layout.Code')</label>
                                            {{Form::text('code',null,['class' => 'form-control'])}}
                                        </div>
                                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                            <label class="control-label ">@lang('layout.Date')</label>
                                            {{Form::text('date',null,['class' => 'form-control date','autocomplete'=>'off'])}}
                                        </div>
                                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                            <label class="control-label ">@lang('layout.Label')</label>
                                            {{Form::text('labels',null,['class' => 'form-control','autocomplete'=>'off'])}}
                                        </div>
                                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                            {{-- <label class="control-label ">@lang('layout.OfferCategory')</label>
                                            {{Form::text('labels',null,['class' => 'form-control','autocomplete'=>'off'])}} --}}
                                            <label class="control-label">@lang('layout.OfferCategory')</label>
                                            <v-select label="name" v-model="offerCategories" :options="{{json_encode($offerCategories)}}">
                                            </v-select>
                                            <input type="hidden" name="category_id" v-model.number="(!offerCategories)?null:offerCategories.id">
                                        </div>
                                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                            {{-- <label class="control-label ">@lang('layout.OfferCategory')</label>
                                            {{Form::text('labels',null,['class' => 'form-control','autocomplete'=>'off'])}} --}}
                                            <label class="control-label">@lang('layout.OfferClass')</label>
                                            <v-select label="name" v-model="offerClasses" :options="{{json_encode($offerClasses)}}">
                                            </v-select>
                                            <input type="hidden" name="offerClass" v-model.number="(!offerClasses)?null:offerClasses.id">
                                        </div>
                                        <div class="col-md-4 col-md-4 col-sm-12 col-xs-12">
                                            <label class="control-label ">@lang('layout.RequestorName')</label>
                                            {{Form::text('requestorName',null,['class' => 'form-control'])}}
                                        </div>
                                        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12" style="padding: 0px !important; margin: 0px !important;">
                                            <div class="col-md-6 col-md-6 col-sm-12 col-xs-12">
                                                <label class="control-label ">@lang('layout.Description')</label>
                                                {{Form::textarea('description',null,['class' => 'form-control','rows' => '5','id'=>'description_editor'])}}
                                                </textarea>
                                            </div>
                                            <div class="col-md-6 col-md-6 col-sm-12 col-xs-12" style="padding: 0px 0px;">
                                                <label class="control-label ">@lang('layout.Photo')</label><br>
                                                {{-- {{Form::textarea('description',null,['class' => 'form-control','rows' => '4'])}} --}}
                                                <div class="fileinput fileinput-new" data-provides="fileinput" style="width: 100%;"> 
                                                    <div class="fileinput-new thumbnail" style="width: 100%; height: 106px;">
                                                        <img src="#" alt=""/>
                                                    </div>
                                                    <div class="fileinput-preview fileinput-exists thumbnail" style="max-width: 100%; max-height: 106px;"></div>
                                                    <div style="width: 100%;">
                                                        <span class="btn default btn-file">
                                                            <span class="fileinput-new">@lang('layout.SelectImage')</span>
                                                            <span class="fileinput-exists">@lang('layout.Change')</span>
                                                            {{-- <input type="file" name="photo"> --}}
                                                            {!! Form::file('photo', []) !!}
                                                        </span>
                                                        <a href="javascript:;" class="btn default fileinput-exists"
                                                        data-dismiss="fileinput">@lang('layout.Remove')</a>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12" style="box-shadow: 0px 0px 3px rgba(172, 171, 171, 0.877);border-radius: 8px; margin-bottom: 10px; padding: 15px 0px;">
                                    <div class="row" style="padding: 0px 10px;">
                                        <h3>@lang('layout.SendToSelfDepartment')</h3>
                                        <div class="multipleClass col-md-4">
                                            <label class="control-label">@lang('menu.Position')</label>
                                            <v-select class="vue-select2" v-model="selected_position" label="name" :options="{{$position}}" :multiple="true">
                                            </v-select>
                                            <input type="hidden" name="position_id" :value="position_id.length > 0 ? position_id:null">
                                        </div>
                                        {{-- <div class="multipleClass" style="display: flex; justify-content: space-between">
                                            <label style="width: 20%;">@lang('menu.Position') </label>
                                            <div style="display: flex; flex-direction: column; width: 70%;">
                                                <v-select class="vue-select2" style="width: 100%" v-model="selected_position" label="name" :options="position" :multiple="true">
                                                </v-select>
                                                <input type="hidden" name="position_id" :value="position_id.length > 0 ? position_id:null">
                                            </div>
                                        </div> --}}
                                    </div>
                                </div>
                            </div>
                            {{-- <a  @click="printjs" class="btn  btn-success">
                                <i class="fa fa-print"></i> @lang('layout.Print')
                            </a> --}}
                            {{-- <div class="row" >
                                <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                                    <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                        <label class="control-label ">@lang('layout.Title')</label>
                                        {{Form::text('title',null,['class' => 'form-control','autocomplete'=>'off'])}}
                                    </div>
                                    <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                        <label class="control-label ">@lang('layout.Number')</label>
                                        {{Form::number('number',$number,['class' => 'form-control','v-model'=>'number'])}}
                                    </div>
                                    <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                        <label class="control-label ">@lang('layout.Code')</label>
                                        {{Form::text('code',null,['class' => 'form-control'])}}
                                    </div>
                                    <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                        <label class="control-label ">@lang('layout.Date')</label>
                                        {{Form::text('date',null,['class' => 'form-control date','autocomplete'=>'off'])}}
                                    </div>
                                    <div class="col-md-8">
                                        <label class="control-label ">@lang('layout.Description')</label>
                                        {{Form::textarea('description',null,['class' => 'form-control','rows' => '2'])}}
                                    </div> 
                                    <div class="col-md-12" style="padding: 0px;">
                                        <h3>@lang('layout.SendToSelfDepartment')</h3>
                                        <div class="col-md-4">
                                            <label class="control-label">@lang('menu.Position')</label>
                                            <v-select class="vue-select2" v-model="selected_position" label="name" :options="{{$position}}">
                                            </v-select>
                                            <input type="hidden" name="position_id" v-model.number="(!selected_position)?null:selected_position.id">
                                        </div>
                                    </div>
                                </div>
                            </div> --}}
                            <div class="row">
                                <div class="col-md-12 text-center">
                                    <br>
                                    <button  type="button" @click="handleSubmit($event)" :disabled="disabled" class="btn green">@lang('layout.Submit')</button>
                                    <button  type="button" class="btn blue" :disabled="disabled" @click="saveAndNew($event)">@lang('layout.SaveAndNew')</button>
                                    <a @click="show_create = false, clearData()" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                                    <hr />
                                </div>
                            </div>
                        </div>
                    </div>
                {!! Form::close() !!}
                <!--End Form-->
                <table class="table table-striped table-bordered table-hover" id="offerList">
                    <thead>
                        <tr>
                            <th>@lang('layout.Number')</th>
                            <th>@lang('layout.Date')</th>
                            <th>@lang('layout.Title')</th>
                            <th>@lang('layout.RequestorName')</th>
                            <th>@lang('layout.OfferCategory')</th>
                            <th>@lang('layout.OfferClass')</th>
                            <th>@lang('layout.Description')</th>
                            <th>@lang('layout.Label')</th>
                            <th>@lang('layout.Code')</th>
                            <th>@lang('layout.User')</th>
                            <th>@lang('layout.Status')</th>
                            <th>@lang('layout.Actions')</th>
                        </tr>
                    </thead>
                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>
    <!-- END TAB PORTLET-->
    <iframe id="payframe" style="display: none;"></iframe>
    <!-- END CONTENT BODY -->
@stop
@include('print.modal')
@include('groupCompanyFilter.select')
@push('scripts')
    {{-- <script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.5.1/jspdf.umd.min.js"></script>
    <script src="https://unpkg.com/jspdf-autotable@3.8.2/dist/jspdf.plugin.autotable.js"></script> --}}
    <script src="{{ url('/js/jspdf.umd.min.js') }}" type="text/javascript"></script>
    <script src="{{ url('/js/jspdf.plugin.autotable.js') }}" type="text/javascript"></script>
    <script src="{{URL::asset('multiple-select/js/jquery.multiselect.js')}}"></script>
    <script>
        $(document).ready(function () {         
            $('#description_editor').summernote({
                 toolbar: [
                    ['style', ['bold', 'italic', 'underline', 'clear']],
                    ['fontsize', ['fontsize']],
                    ['color', ['color']]
                  ],
                  shortcuts: false
            });                               
        });

        var cust_rep = {!!customeReportNewData('offers_index')!!};
        var position = {!!json_encode($position)!!};
        var offerCategories = {!!$offerCategories!!};
        var offerClasses = {!!$offerClasses!!};
        // Default export is a4 paper, portrait, using millimeters for units
        Vue.component('v-select', VueSelect.VueSelect); 
        @if(Session('sale_id') && getFactorPrint()== "automatic")
        factorPrint("{{Session('offer_id')}}", "{{Session('whatsapp')}}")
        @endif
        @if(Session('sale_id') && Session('category') == "Restaurant")
        factorPrint("{{Session('offer_id')}}", "{{Session('whatsapp')}}")
        @endif
        Vue.component('v-select', VueSelect.VueSelect);
        var Modal = Vue.component('cmodal',
        {
            template:'#cmodal-template',
            props: ['show'],
        });
            Vue.component('modal', {
            template: '#vendor-template'
        })
        Vue.component('modal', {
            template: '#modal-template'
        })
        Vue.component('amodal', {
        template: '#amodal-template',
        props: ['show']
        });
        //GRN Print
        // grnPrint("{{Session('sale_id')}}")
        Vue.component('v-select', VueSelect.VueSelect)
        function factorPrint(id,sendWhatsapp = null,type = null) {
            if (sendWhatsapp == null || sendWhatsapp == '') {
                sendWhatsapp = 'not';
            }
            if (type == null || type == '') {
                type = 1;
            }
            var a = document.createElement('a');
            a.href = "{{url('printoffer')}}/" + id + "/" + sendWhatsapp + "/" + type;
            a.target = "_blank";
            document.body.appendChild(a);
            a.click();
            document.body.removeChild(a);
        }  
        let data_table = 0;
        // document.getElementById('show_table').style.display = 'none';
        $(document).ready(function () {
            getRecord();
        });
        function getRecord() {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
            if (data_table != 0) {
                data_table.destroy();
            }
            data_table =$('#offerList').DataTable({
                ajax: '{{route("offer.index")}}',
                pageLength: '{{getPageRows()}}',
                order: [["{{orderByColumn()=='number'?0:1}}", "{{getRowOrder()}}"]],
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                scrollCollapse: true,
                paging: true,
                serverSide: true,
                columns: [
                    {data: 'number', name: 'number'},
                    {data: 'Date', name: 'Date'},
                    {data: 'title', name: 'title'},
                    {data: 'requestorName', name: 'requestorName'},
                    {data: 'name', name: 'name'},
                    {data: 'offerClassName', name: 'offerClassName'},
                    {data: 'description', name: 'description'},
                    {data: 'labels', name: 'labels'},
                    {data: 'code', name: 'code'},
                    {data: 'user', name: 'user'},
                    {data: 'status', name: 'status'},
                    {data: 'actions', name: 'actions', orderable: false, searchable: false},
                ]
            });
        }
        var vm = new Vue({
            el: '#print-modal',
            data: {
                is_show: false,
                pdfRoute: '{!!route("export.PDFAll") !!}',
                excelRoute: '{!! route("export.ExcelAll") !!}',
                selectedofferCategories: null,
                selectedofferClass: null,
                offerCategories: offerCategories,
                offerClasses: offerClasses,
                customReportData:[
                    {Name: '@lang("layout.Number")', column_name: 'number',checkedColumn:(cust_rep.number)?'checked':'',checkedColumn:(cust_rep.number)?'checked':'',column_percentage:(cust_rep.number___percent)?cust_rep.number___percent:''},
                    {Name: '@lang("layout.Date")', column_name: 'date',checkedColumn:(cust_rep.date)?'checked':'',checkedColumn:(cust_rep.date)?'checked':'',column_percentage:(cust_rep.date___percent)?cust_rep.date___percent:''},
                    {Name: '@lang("layout.Title")', column_name: 'title',checkedColumn:(cust_rep.title)?'checked':'',checkedColumn:(cust_rep.title)?'checked':'',column_percentage:(cust_rep.title___percent)?cust_rep.title___percent:''},
                    {Name: '@lang("layout.OfferCategory")', column_name: 'offerCategory',checkedColumn:(cust_rep.offerCategory)?'checked':'',checkedColumn:(cust_rep.offerCategory)?'checked':'',column_percentage:(cust_rep.offerCategory___percent)?cust_rep.offerCategory___percent:''},
                    {Name: '@lang("layout.Description")', column_name: 'description',checkedColumn:(cust_rep.description)?'checked':'',checkedColumn:(cust_rep.description)?'checked':'',column_percentage:(cust_rep.description___percent)?cust_rep.description___percent:''},
                    {Name: '@lang("layout.Label")', column_name: 'label',checkedColumn:(cust_rep.label)?'checked':'',checkedColumn:(cust_rep.label)?'checked':'',column_percentage:(cust_rep.label___percent)?cust_rep.label___percent:''},
                    {Name: '@lang("layout.Status")', column_name: 'status',checkedColumn:(cust_rep.status)?'checked':'',checkedColumn:(cust_rep.status)?'checked':'',column_percentage:(cust_rep.status___percent)?cust_rep.status___percent:''},
                    {Name: '@lang("layout.Code")', column_name: 'code',checkedColumn:(cust_rep.code)?'checked':'',checkedColumn:(cust_rep.code)?'checked':'',column_percentage:(cust_rep.code___percent)?cust_rep.code___percent:''},
                    {Name: '@lang("layout.User")', column_name: 'user',checkedColumn:(cust_rep.user)?'checked':'',checkedColumn:(cust_rep.user)?'checked':'',column_percentage:(cust_rep.user___percent)?cust_rep.user___percent:''},
                    {Name: '@lang("layout.RequestorName")', column_name: 'requestorName',checkedColumn:(cust_rep.requestorName)?'checked':'',checkedColumn:(cust_rep.requestorName)?'checked':'',column_percentage:(cust_rep.requestorName___percent)?cust_rep.requestorName___percent:''},
                    {Name: '@lang("layout.OfferClass")', column_name: 'offerClass',checkedColumn:(cust_rep.offerClass)?'checked':'',checkedColumn:(cust_rep.offerClass)?'checked':'',column_percentage:(cust_rep.offerClass___percent)?cust_rep.offerClass___percent:''},
                ],
                cust_rep:cust_rep
            },
            methods: {
                closeModal: function () {
                    this.is_show = !this.is_show
                },
            }
        });
        new Vue({
            el: '#anchore-modal',
            methods: {
                showModal: function () {
                    console.log('trr')
                    vm.$data.is_show = true;
                }
            }
        });
        new Vue({
            el: '#company_all',
            methods: {
                setCompany: function (event) {
                    if (typeof data_table == 'object'){
                        data_table.clear();
                        data_table.ajax.reload();
                    }
                }
            }
        });
        new Vue({
            el: '#create-modal',
            methods: {
                showModal: function() {
                    console.log('trr')
                    v.$data.show_create = true;
                }
            }
        });
        // /for new modal
        let v = new Vue({
            el: '#app',
            data: {
                note:
                [
                    {expense_description: null, expense_info_date: null},
                ],
                show_create: false,
                disabled: false,
                number: "{{$number}}",
                old_number: "{{$number}}",
                selected_position: null,
                position_id: [],
                position: position,
                offerCategories: offerCategories,
                offerClasses: offerClasses,
                selectedofferCategories: null,
                selectedofferClass: null,
                offerCategories: null,
                offerClasses: null,
            },
            watch: {
                selected_position: function(newVal, oldVal) {
                    let x = [];
                    newVal.forEach(function(e) {
                        x.push(e.id);
                    });
                    this.position_id = x;
                }
            },
            methods: {
                addNew(index) {
                    if (this.note[index + 1] == undefined) {
                        this.note.push({expense_description: null, expense_info_date: null});
                    } 
                },
                deleteItem(index) {
                    this.note.splice(index, 1);
                },
                handleSubmit(e) {
                    v.submitForm1();
                },
                submitForm1() {
                    v.disabled = true;
                    swal({
                        title: "@lang('layout.AreYouSure?')",
                        buttons: ["@lang('layout.Cancel')", "@lang('layout.Submit')"],
                        text: "",
                        icon: "info",
                        dangerMode: true,
                    }).then((willDelete) => {
                        if (willDelete) {
                            document.getElementById("offer-submit").submit()
                        } else {
                            v.disabled = false;
                        }
                    });
                },
                saveAndNew() {
                    v.disabled = true;
                    var url = "{{route('offer.store')}}";
                    form_id = 'offer-submit';
                    var data = $('#' + form_id).serialize();
                    toggleBlock(true);
                    axios.post(url, data)
                    .then(function(response) {
                        toggleBlock(0);
                        if (response.data.result == 1) {
                            // $('#' + form_id).trigger('reset');
                            toastr.success('', response.data.message);
                            v.number = Number(v.old_number) + 1;
                            v.old_number = Number(v.old_number) + 1;
                            // v.clearData();

                            // getRecord();
                            location.reload();
                        } else {
                            var message = "{{__('message.Warning')}}";
                            //$('#error-sound')[0].play();
                            toastr.warning('', message);
                            v.disabled = false;
                        }
                        v.disabled = false;
                    })
                    .catch(function(error) {
                        toggleBlock(0);
                        console.log(error);
                        var message = "{{__('message.Warning')}}";
                        v.disabled = false;
                        //$('#error-sound')[0].play();
                        toastr.warning('', message);
                    });
                }
            }
        })
        $('#job_title').multiselect({
            placeholder: "@lang('layout.SelectJobTitle')",
        });
    </script>
    <script src="{{url('/assets/bootstrap-fileinput/bootstrap-fileinput.js')}}" type="text/javascript"></script>
    <script src="{{url('/assets/bootstrap-fileinput/jquery.sparkline.min.js')}}" type="text/javascript"></script>
    <script src="{{url('/assets/bootstrap-fileinput/app.min.js')}}" type="text/javascript"></script>
    <script src="{{url('/assets/bootstrap-fileinput/profile.min.js')}}" type="text/javascript"></script>
    <script src="{{ url('/assets/global/plugins/bootstrap-wysihtml5/wysihtml5-0.3.0.js') }}" type="text/javascript"></script>
    <script src="{{ url('/assets/global/plugins/bootstrap-wysihtml5/bootstrap-wysihtml5.js') }}" type="text/javascript"></script>
    <script src="{{ url('/assets/global/plugins/bootstrap-markdown/lib/markdown.js') }}" type="text/javascript"></script>
    <script src="{{ url('/assets/global/plugins/bootstrap-markdown/js/bootstrap-markdown.js') }}" type="text/javascript"></script>
    <script src="{{ url('/assets/global/plugins/bootstrap-summernote/summernote.js') }}" type="text/javascript"></script>
    <script src="{{ url('/assets/pages/scripts/components-editors.js') }}" type="text/javascript"></script>
@endpush