@extends('layouts.app')
@section('content')
    @include('sales.modal')
    <!-- END PAGE HEADER-->


    <!-- BEGIN TAB PORTLET-->

    <div class="row">

        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>&nbsp;
                    <span class="caption-subject bold uppercase" >@lang('layout.NoteList')</span>
                </div>
                <div class="tools">
                    
                 </div>
                <div class="pull-right">
				
                </div>
            </div>
            <div class="row">
                    <?php foreach ($note as $no): ?> 
                <div class="col-md-6 col-sm-12">
                    <div class="portlet green-seagreen box">
                        <div class="portlet-title">
                            <div class="caption">
                                <i class="icon-note" ></i>&nbsp; <span style="color: white;font-size: 20px">{{$no['name']}}</span>
                            </div>
                      
                        </div>

                        <div class="portlet-body">
                            <div class="row static-info">
                                <div class="col-md-12 value">

                                    <table class="table">
                                        <thead>
                                            <tr class="active">
                                                <td>@lang('layout.Number')</td>
                                                <td>@lang('layout.Date')</td>
                                                <td>@lang('layout.Description')</td>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr class="active">
                                                <td>{{$no['number']}}</td>
                                                <td>{{convertDate($no['date'])}}</td>
                                                <td>{{$no['description']}}</td>
                                            </tr>
                                        </tbody>
                                    </table>
                                    <br>

                                
                                     
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                    <?php endforeach ?>
        


            </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>
</div>




    <!-- END CONTENT BODY -->


@stop

@push('scripts')

<script>

	    Vue.component('v-select', VueSelect.VueSelect);
    var Modal=Vue.component('modal', {
        template: '#modal-template',
        methods: {
            ok: function() {
                this.$emit('ok')
            }
        }
    });
    // start app
    new Vue({
        el: '#app',
        data: {
            showModal: false,
        },
        methods:{
            ok:function(){
                // alert('you clicked me');
                this.showModal = !this.showModal;
            },
            close:function(e)
            {
                this.showModal = !this.showModal;
            },
            editExample : function(){
                    //Your other code that launches the modal
                    this.showModal= true;
                this.$nextTick(function(){
                    $(document).ready(function(){
                    $(".date").persianDatepicker(modelDate());
                    });
                })
            }
        },
    });
    $('#print_pdf_all').on('click',function(e){
        $('#show-modal').click();
        e.preventDefault();
    });
	
	 
	</script>

@endpush
