@extends('layouts.app')
@section('style')
    {{-- <link href="{{url('css/custome-table.css')}}" rel="stylesheet" type="text/css"> --}}
    <link href="{{url('css/custome-table.css')}}" rel="stylesheet" type="text/css">
    <link rel="stylesheet" type="text/css" href="{{URL::asset('multiple-select/css/jquery.multiselect.css')}}">
    <link href="{{url('/assets/bootstrap-fileinput/bootstrap-fileinput.css')}}" rel="stylesheet" type="text/css"/>
    
    <link rel="stylesheet" type="text/css" href="{{URL::asset('multiple-select/css/jquery.multiselect.css')}}">
    <link href="{{url('/assets/bootstrap-fileinput/bootstrap-fileinput.css')}}" rel="stylesheet" type="text/css"/>
    <link href="{{url('/assets/bootstrap-fileinput/profile-rtl.min.css')}}" rel="stylesheet" type="text/css"/>
    <link href="{{ url('/assets/global/plugins/bootstrap-wysihtml5/bootstrap-wysihtml5.css') }}" rel="stylesheet" type="text/css"/>
    <link href="{{ url('/assets/global/plugins/bootstrap-markdown/css/bootstrap-markdown.min.css') }}" rel="stylesheet" type="text/css"/>
    <link href="{{ url('/assets/global/plugins/bootstrap-summernote/summernote.css') }}" rel="stylesheet" type="text/css"/>
    <style>
        .multipleClass .v-select .selected-tag{
            height: 26px !important;
            margin: 4px 1px 0 3px !important;
        }
        .multipleClass .v-select .selected-tag > button >span{
            display: none !important;
        }
    </style>
@endsection
@section('content')
    <div class="row">
        <div class="portlet light bg-inverse" style="min-height: 100%;">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>&nbsp;
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.OfferEdit') </span>
                    <!-- <span class="caption-helper">some info...</span> -->
                </div>
                <div class="tools"></div>
            </div>
            <div id="app" class="portlet-body form" style="margin-bottom:50%;">
                <!-- BEGIN FORM-->
                {!! Form::model($offer, ['method' => 'PATCH','class'=>'form-horizontal','files'=> true,'route' => ['offer.update',$offer->id]]) !!}
                {{ csrf_field() }}
                <div class="form-body">
                    <div class="row" style="padding: 10px 20px;">
                        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12" style="box-shadow: 0px 0px 3px rgba(172, 171, 171, 0.877);border-radius: 8px; margin-bottom: 10px; padding: 15px 0px;">
                            <div class="row" style="padding: 0px 10px;">
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <label class="control-label ">@lang('layout.Title')</label>
                                    {{Form::text('title',null,['class' => 'form-control','placeholder' => __('layout.Title')])}}
                                </div>
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <label class="control-label ">@lang('layout.Number')</label>
                                    {{Form::number('number',null,['class' => 'form-control','placeholder' => __('layout.Number')])}}
                                </div>
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <label class="control-label ">@lang('layout.Code')</label>
                                    {{Form::text('code',null,['class' => 'form-control'])}}
                                </div>
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <label class="control-label ">@lang('layout.Date')</label>
                                    {{Form::text('date',null,['class' => 'form-control date','placeholder' => __('layout.Date')])}}
                                </div>
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <label class="control-label ">@lang('layout.Label')</label>
                                    {{Form::text('labels',null,['class' => 'form-control','placeholder' => __('layout.Label')])}}
                                </div>
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <label class="control-label ">@lang('layout.OfferCategory')</label>
                                    {{-- {{Form::text('labels',null,['class' => 'form-control','placeholder' => __('layout.Label')])}} --}}
                                    <v-select label="name" v-model="selected_offerCategories" :options="offerCategories">
                                    </v-select>
                                    <input type="hidden" name="category_id"  v-model.number="(!selected_offerCategories)?null:selected_offerCategories.id"> 
                                </div>

                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <label class="control-label ">@lang('layout.OfferCategory')</label>
                                    {{-- {{Form::text('labels',null,['class' => 'form-control','placeholder' => __('layout.Label')])}} --}}
                                    <v-select label="name" v-model="selected_offerClass" :options="offerClasses">
                                    </v-select>
                                    <input type="hidden" name="offerClass"  v-model.number="(!selected_offerClass)?null:selected_offerClass.id"> 
                                </div>

                                <div class="col-md-4 col-md-4 col-sm-12 col-xs-12">
                                    <label class="control-label ">@lang('layout.RequestorName')</label>
                                    {{Form::text('requestorName',null,['class' => 'form-control','placeholder' => __('layout.RequestorName')])}}
                                </div>
                                <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12" style="padding: 0px !important; margin: 0px !important;">
                                    <div class="col-md-6 col-md-6 col-sm-12 col-xs-12">
                                        <label class="control-label ">@lang('layout.Description')</label>
                                        {{Form::textarea('description',null,['class' => 'form-control','rows' => '5','placeholder' => __('layout.Description'),'id'=>'description_editor'])}}
                                    </div>
                                    <div class="col-md-6 col-md-6 col-sm-12 col-xs-12">
                                        <label class="control-label ">@lang('layout.Photo')</label>
                                        {{-- {{Form::textarea('description',null,['class' => 'form-control','rows' => '5','placeholder' => __('layout.Description')])}} --}}
                                        <?php
                                            $photo = null;
                                            if($offer && $offer->photo!=null)
                                            {
                                                $photo =  $offer->photo;
                                            }
                                        ?>
                                        <div class="fileinput fileinput-new" data-provides="fileinput" style="width: 100%;"> 
                                            <div class="fileinput-new thumbnail" style="width: 100%; height: 106px;">
                                                <img src="{!!url('/uploads/'.$photo)!!}" alt=""/>
                                            </div>
                                            <div class="fileinput-preview fileinput-exists thumbnail" style="max-width: 100%; max-height: 106px;"></div>
                                            <div style="width: 100%;">
                                                <span class="btn default btn-file">
                                                    <span class="fileinput-new">@lang('layout.SelectImage')</span>
                                                    <span class="fileinput-exists">@lang('layout.Change')</span>
                                                    <!-- <input type="file" name="photo">  -->
                                                    {!! Form::file('photo', []) !!}
                                                </span>
                                                {!! Form::hidden('photo1', (!$offer)?null:$offer->photo) !!}
                                                <a href="javascript:;" class="btn default fileinput-exists" data-dismiss="fileinput">@lang('layout.Remove')</a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>  
                        </div>
                        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12" style="box-shadow: 0px 0px 3px rgba(172, 171, 171, 0.877);border-radius: 8px; margin-bottom: 10px; padding: 15px 0px;">
                            <div class="row" style="padding: 0px 10px;">
                                <h3>@lang('layout.SendToSelfDepartment')</h3>
                                <div class="multipleClass col-md-4">
                                    <label class="control-label">@lang('menu.Position')</label>
                                    <v-select class="vue-select2" v-model="selected_position1" label="name" :options="{{$position}}" :multiple="true">
                                    </v-select>
                                    {{-- <input type="hidden" name="position_id" v-model.number="(!selected_position1)?null:selected_position1.id"> --}}
                                    <input type="hidden" name="position_id" :value="position_id.length > 0 ? position_id:null">
                                </div>


                                {{-- <h3>@lang('layout.SendToSelfDepartment')</h3>
                                <div class="multipleClass col-md-4">
                                    <label class="control-label">@lang('menu.Position')</label>
                                    <v-select class="vue-select2" v-model="selected_position" label="name" :options="{{$position}}" :multiple="true">
                                    </v-select>
                                    <input type="hidden" name="position_id" :value="position_id.length > 0 ? position_id:null">
                                </div> --}}
                            </div>
                        </div>
                    </div>
                    {{-- <div class="row">
                        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                            <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                <div class="col-md-12">
                                    <label class="control-label ">@lang('layout.Title')</label>
                                    {{Form::text('title',null,['class' => 'form-control','placeholder' => __('layout.Title')])}}
                                </div>
                            </div>
                            <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                <div class="col-md-12">
                                    <label class="control-label ">@lang('layout.Number')</label>
                                    {{Form::number('number',null,['class' => 'form-control','placeholder' => __('layout.Number')])}}
                                </div>
                            </div>
                            <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                <label class="control-label ">@lang('layout.Code')</label>
                                {{Form::text('code',null,['class' => 'form-control'])}}
                            </div>
                            <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                <div class="col-md-12">
                                    <label class="control-label ">@lang('layout.Date')</label>
                                    {{Form::text('date',null,['class' => 'form-control date','placeholder' => __('layout.Date')])}}
                                </div>
                            </div>
                            <div class="col-md-12">
                                <div class="col-md-12">
                                    <label class="control-label ">@lang('layout.Description')</label>
                                    {{Form::textarea('description',null,['class' => 'form-control','rows' => '2','placeholder' => __('layout.Description')])}}
                                </div>
                            </div>
                        </div>
                    </div> --}}
                    {{-- <div class="col-md-12" style="padding: 0px;">
                        <h3>@lang('layout.SendToSelfDepartment')</h3>
                        <div class="col-md-4">
                            <label class="control-label">@lang('menu.Position')</label>
                            <v-select class="vue-select2" v-model="selected_position" label="name" :options="{{$position}}">
                            </v-select>
                            <input type="hidden" name="position_id" v-model.number="(!selected_position)?null:selected_position.id">
                        </div>
                    </div> --}}
                </div>
                <div class="col-md-12 text-center">
                    <button type="button" class="btn green" onclick="regForm(this)">@lang('layout.Submit')</button>
                    <a href="{{route('offer.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                </div>
                {!! Form::close() !!}
            </div>
            <!-- END FORM-->
        </div>
    </div>

@endsection
@push('scripts')
<script src="{{URL::asset('multiple-select/js/jquery.multiselect.js')}}"></script>
    <script type="text/javascript">

        $(document).ready(function () {         
            $('#description_editor').summernote({
                 toolbar: [
                    ['style', ['bold', 'italic', 'underline', 'clear']],
                    ['fontsize', ['fontsize']],
                    ['color', ['color']]
                  ],
                  shortcuts: false
            });                               
        });

        Vue.component('v-select', VueSelect.VueSelect);

            var offerCategories = {!! $offerCategories !!};
            var offerClasses = {!! $offerClasses !!};
            var offer = {!! $offer !!};
            let v = new Vue({
            el: '#app',
            data: {
                note: [],
                noteDetails: [],
                selected_position: {!! $selectedMemo !!},
                selected_position1: {!! $selectedMemo1 !!},
                position_id: [],
                offerCategories:offerCategories,
                offerClasses:offerClasses,
                selected_offerCategories: null,
                selected_offerClass: null,
            },
            watch: {
                selected_position1: function(newVal, oldVal) {
                    let x = [];
                    newVal.forEach(function(e) {
                        x.push(e.id);
                    });
                    this.position_id = x;
                }
            },
            methods: {
                addNew(index) {
                    if (this.note[index + 1] == undefined) {
                        this.note.push({expense_description: null, expense_info_date: null});
                    }
                },
                deleteItem(index) {
                    this.note.splice(index, 1);
                },
            },
            mounted: function () {
                for (var i = 0; i < this.noteDetails.length; i++) {
                    this.note.push({
                        expense_description: this.noteDetails[i].description,
                        expense_info_date: this.noteDetails[i].date
                    });
                }
                for (var m = 4; m > this.noteDetails.length; m--) {
                    this.note.push({
                        expense_description: null,
                        expense_info_date: null,
                    });
                }
                if (this.selected_position1) {
                    let x = [];
                    this.selected_position1.forEach(function(e) {
                        x.push(e.id);
                    });
                    this.position_id = x;
                }

                if (offer.category_id && offerCategories) {
                    this.selected_offerCategories = _.find(offerCategories, (s) => s.id == offer.category_id);
                }

                if (offer.offerClass && offerClasses) {
                    this.selected_offerClass = _.find(offerClasses, (s) => s.id == offer.offerClass);
                }
            },
        })
    </script>
    <script src="{{url('/assets/bootstrap-fileinput/bootstrap-fileinput.js')}}" type="text/javascript"></script>
    <script src="{{url('/assets/bootstrap-fileinput/jquery.sparkline.min.js')}}" type="text/javascript"></script>
    <script src="{{url('/assets/bootstrap-fileinput/app.min.js')}}" type="text/javascript"></script>
    <script src="{{url('/assets/bootstrap-fileinput/profile.min.js')}}" type="text/javascript"></script>
    <script src="{{ url('/assets/global/plugins/bootstrap-wysihtml5/wysihtml5-0.3.0.js') }}" type="text/javascript"></script>
    <script src="{{ url('/assets/global/plugins/bootstrap-wysihtml5/bootstrap-wysihtml5.js') }}" type="text/javascript"></script>
    <script src="{{ url('/assets/global/plugins/bootstrap-markdown/lib/markdown.js') }}" type="text/javascript"></script>
    <script src="{{ url('/assets/global/plugins/bootstrap-markdown/js/bootstrap-markdown.js') }}" type="text/javascript"></script>
    <script src="{{ url('/assets/global/plugins/bootstrap-summernote/summernote.js') }}" type="text/javascript"></script>
    <script src="{{ url('/assets/pages/scripts/components-editors.js') }}" type="text/javascript"></script>

@endpush
 