@extends('layouts.app')
<link href="{{url('css/custome-table.css')}}" rel="stylesheet" type="text/css">
@section('style')
<style>
    /* * {
    margin: 0;
    padding: 0;
    box-sizing: border-box;
    }
    ::selection {
    background: none;
    }
    body {
    background-color: #3fa9fc;
    }
    #calc {
    display: flex;
    align-items: center;
    justify-content: center;
    height: 100vh;
    width: 100vw;
    }
    .calculator {
    display: grid;
    grid-template-rows: repeat(7, minmax(60px, auto));
    grid-template-columns: repeat(4, 60px);
    grid-gap: 12px;
    padding: 35px;
    font-family: "Poppins";
    font-weight: 300;
    font-size: 18px;
    background-color: #ffffff;
    border-radius: 10px;
    box-shadow: 0px 3px 80px -30px rgba(13, 81, 134, 1);
    }
    .btn,
    .zero {
    display: flex;
    align-items: center;
    justify-content: center;
    cursor: pointer;
    text-align: center;
    text-decoration: none;
    outline: none;
    color: #484848;
    background-color: #f4faff;
    border-radius: 5px;
    }
    .display,
    .answer {
    grid-column: 1 / 5;
    display: flex;
    align-items: center;
    }
    .display {
    color: #a3a3a3;
    border-bottom: 1px solid #e1e1e1;
    margin-bottom: 15px;
    overflow: hidden;
    text-overflow: clip;
    font-size: 30px;
    }
    .answer {
    font-weight: 500;
    color: #146080;
    font-size: 55px;
    height: 65px;
    }
    .zero {
    grid-column: 1 / 3;
    }
    .operator {
    background-color: #d9efff;
    color: #3fa9fc;
    } */
</style>
@endsection
@section('content')
    <div class="row">
        <div class="portlet light bg-inverse" style="min-height: 100%;">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i> &nbsp;
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.CreateNewNote') </span>
                    <!-- <span class="caption-helper">some info...</span> -->
                </div>
                <div class="tools"> </div>
            </div>
            <div id="app" class="portlet-body form" style="margin-bottom:50%;">
                {!! Form::open(array('route' => 'note.store','method'=>'POST','class'=>'form-horizontal')) !!}
                {{ csrf_field() }}
                <div class="form-body">
                    <div class="row">
                        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                            <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                <div class="col-md-12">
                                    <label class="control-label ">@lang('layout.Name')</label>
                                    {{Form::text('name',null,['class' => 'form-control','placeholder' => __('layout.Name')])}}
                                </div>
                            </div>
                            <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                <div class="col-md-12">
                                    <label class="control-label ">@lang('layout.Number')</label>
                                    {{Form::number('number',$number,['class' => 'form-control','placeholder' => __('layout.Number')])}}
                                </div>
                            </div>
                            <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                <div class="col-md-12">
                                    <label class="control-label ">@lang('layout.Date')</label>
                                    {{Form::text('date',null,['class' => 'form-control date','placeholder' => __('layout.Date')])}}
                                </div>
                            </div>
                            <div class="col-md-6">
                                <label class="control-label ">@lang('layout.Description')</label>
                                {{Form::textarea('description',null,['class' => 'form-control','rows' => '2','placeholder' => __('layout.Description')])}}
                            </div> 
                            <div class="col-md-3">
                                <br>
                                <br>
                                <button class="btn btn-info " data-toggle="collapse" data-parent="#accordion1" href="#accordion1_3">
                                    <i class="fa fa-info-circle" style="font-size: 20px;"></i> @lang('layout.Details')
                                </button>
                            </div>
                            <br>
                            <div id="accordion1_3" class="panel-collapse collapse">
                                <div style="">
                                    <table id="table_content" class="table table-bordered">
                                        <thead>
                                            <tr>
                                                <th>#</th>
                                                <th style="min-width: 300px">@lang('layout.Description') </th>
                                                <th>@lang('layout.Date') </th>
                                                <th></th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr v-for="(item,index) in note">
                                                <td>@{{index+1}}</td>
                                                <td class="highlight">
                                                    <input type="text" @keyup="addNew(index)" v-on:click="addNew(index)" name="expense_description[]" class="form-control">
                                                </td>
                                                <td class="highlight">
                                                    <date_picker :name="'expense_info_date['+index+']'" placeholder="@lang('layout.Date')" ></date_picker>
                                                </td>
                                                <td>
                                                    <span v-on:click="deleteItem('index')"><i class="paddint-both glyphicon glyphicon-trash"></i></span>
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-4 col-md-offset-4 text-center">
                    <br>
                    <button type="button" class="btn green" onclick="regForm(this)">@lang('layout.Submit')</button>
                    <a href="{{route('note.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                </div>
                {!! Form::close() !!}
            </div>
            {{-- <div id="calc">
                  <div class="calculator">
                    <div class="answer">@{{ answer }}</div>
                    <div class="display">@{{ logList + current }}</div>
                    <div @click="clear" id="clear" class="btn operator">C</div>
                    <div @click="sign" id="sign" class="btn operator">+/-</div>
                    <div @click="percent" id="percent" class="btn operator">
                      %
                    </div>
                    <div @click="divide" id="divide" class="btn operator">
                      /
                    </div>
                    <div @click="append('7')" id="n7" class="btn">7</div>
                    <div @click="append('8')" id="n8" class="btn">8</div>
                    <div @click="append('9')" id="n9" class="btn">9</div>
                    <div @click="times" id="times" class="btn operator">*</div>
                    <div @click="append('4')" id="n4" class="btn">4</div>
                    <div @click="append('5')" id="n5" class="btn">5</div>
                    <div @click="append('6')" id="n6" class="btn">6</div>
                    <div @click="minus" id="minus" class="btn operator">-</div>
                    <div @click="append('1')" id="n1" class="btn">1</div>
                    <div @click="append('2')" id="n2" class="btn">2</div>
                    <div @click="append('3')" id="n3" class="btn">3</div>
                    <div @click="plus" id="plus" class="btn operator">+</div>
                    <div @click="append('0')" id="n0" class="zero">0</div>
                    <div @click="dot" id="dot" class="btn">.</div>
                    <div @click="equal" id="equal" class="btn operator">=</div>
                  </div>
              </div> --}}



            <!-- END FORM-->
        </div>
    </div>
@endsection
@push('scripts')
    <script type="text/javascript">
        Vue.component('v-select', VueSelect.VueSelect);
        let v = new Vue({
            el: '#app',
            data: {
                note:
                    [
                        {expense_description: null, expense_info_date: null},
                        {expense_description: null, expense_info_date: null},
                        {expense_description: null, expense_info_date: null},

                    ]
            },
            methods: {
                addNew(index) {
                    if (this.note[index + 1] == undefined) {
                        this.note.push({expense_description: null, expense_info_date: null});
                    }
                },
                deleteItem(index) {
                    this.note.splice(index, 1);
                },
            }
        })
      //   new Vue({
      //   el: "#calc",
      //   data() {
      //     return {
      //       logList: "",
      //       current: "",
      //       answer: "",
      //       operatorClicked: true
      //     };
      //   },
      //   methods: {
      //     append(number) {
      //       if (this.operatorClicked) {
      //         this.current = "";
      //         this.operatorClicked = false;
      //       }
      //       this.animateNumber(`n${number}`);
      //       this.current = `${this.current}${number}`;
      //     },
      //     addtoLog(operator) {
      //       if (this.operatorClicked == false) {
      //         this.logList += `${this.current} ${operator} `;
      //         this.current = "";
      //         this.operatorClicked = true;
      //       }
      //     },
      //     animateNumber(number) {
      //       <!-- let tl = anime.timeline({ -->
      //         <!-- targets: `#${number}`, -->
      //         <!-- duration: 250, -->
      //         <!-- easing: "easeInOutCubic" -->
      //       <!-- }); -->
      //       <!-- tl.add({ backgroundColor: "#c1e3ff" }); -->
      //       <!-- tl.add({ backgroundColor: "#f4faff" }); -->
      //     },
      //     animateOperator(operator) {
      //       <!-- let tl = anime.timeline({ -->
      //         <!-- targets: `#${operator}`, -->
      //         <!-- duration: 250, -->
      //         <!-- easing: "easeInOutCubic" -->
      //       <!-- }); -->
      //       <!-- tl.add({ backgroundColor: "#a6daff" }); -->
      //       <!-- tl.add({ backgroundColor: "#d9efff" }); -->
      //     },
      //     clear() {
      //       this.animateOperator("clear");
      //       this.current = "";
      //       this.answer = "";
      //       this.logList = "";
      //       this.operatorClicked = false;
      //     },
      //     sign() {
      //       this.animateOperator("sign");
      //       if (this.current != "") {
      //         this.current =
      //           this.current.charAt(0) === "-"
      //             ? this.current.slice(1)
      //             : `-${this.current}`;
      //       }
      //     },
      //     percent() {
      //       this.animateOperator("percent");
      //       if (this.current != "") {
      //         this.current = `${parseFloat(this.current) / 100}`;
      //       }
      //     },
      //     dot() {
      //       this.animateNumber("dot");
      //       if (this.current.indexOf(".") === -1) {
      //         this.append(".");
      //       }
      //     },
      //     divide() {
      //       this.animateOperator("divide");
      //       this.addtoLog("/");
      //     },
      //     times() {
      //       this.animateOperator("times");
      //       this.addtoLog("*");
      //     },
      //     minus() {
      //       this.animateOperator("minus");
      //       this.addtoLog("-");
      //     },
      //     plus() {
      //       this.animateOperator("plus");
      //       this.addtoLog("+");
      //     },
      //     equal() {
      //       this.animateOperator("equal");
      //       if (this.operatorClicked == false) {
      //         this.answer = eval(this.logList + this.current);
      //       } else {
      //         this.answer = "WHAT?!!";
      //       }
      //     }
      //   }
      // });
    </script>
@endpush