@extends('layouts.app')

@section('content')

    <div class="portlet">
        <div class="portlet-title" id="backbtn">
            <div class="caption">
                <i class=""></i>@lang('menu.Note')
            </div>
            <div class="tools">
                <a href="javascript:;" class="collapse" data-original-title="" title=""> </a>
                <a href="#portlet-config" data-toggle="modal" class="config" data-original-title="" title=""> </a>
                {{--<a href="javascript:;" class="reload" data-original-title="" title=""> </a>--}}
                {{--<a href="javascript:;" class="remove" data-original-title="" title=""> </a>--}}
            </div>
        </div>
        <div class="portlet-body">
            <div class="table-scrollable">
                <table class="table table-striped table-bordered table-advance table-hover">
                    <thead>
                    <tr>
                        <th>
                            <i class="fa  fa-bars"></i> @lang('layout.Date')
                        </th>

                        <th>
                            <i class="fa fa-code"></i> @lang('layout.Number')
                        </th>
                        <th>
                            <i class="fa fa-file-excel-o"></i> @lang('layout.Name')
                        </th>
                    </tr>
                    </thead>
                    <tbody>
                    <tr>
                        <td>  {{convertDate($note->date)}} </td>
                        <td> {{$note->number}}  </td>
                        <td>  {{$note->name}} </td>

                    </tr>
                    <tr>
                        <td colspan="3">
                            <table>
                                <tr>
                                    <td><span><i class="fa fa-text-width"></i> @lang('layout.Description')</span>:</td>
                                    <td><span>{{$note->description}}</span></td>
                                </tr>
                            </table>
                        </td>

                    </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            <!-- BEGIN EXAMPLE TABLE PORTLET-->
            <div class="portlet light bordered">
                <div class="portlet-title">
                    <div class="caption font-dark">
                        <i class="icon-settings font-dark"></i>
                        <span class="caption-subject bold uppercase">@lang('layout.Details') </span>
                    </div>
                    <div class="tools"></div>

                </div>
                <div class="portlet-body">
                    <table class="table table-striped table-bordered table-hover" id="note_details">
                        <thead>
                            <tr>

                                <th>@lang('layout.Date')</th>
                                <th>@lang('layout.Description')</th>
                            </tr>
                        </thead>
                    </table>
                </div>
            </div>
            <!-- END EXAMPLE TABLE PORTLET-->
        </div>
    </div>
@endsection
@push('scripts')

    <script>
        $(document).ready(function () {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
            $('#note_details').DataTable({
                ajax: '{{route("note.show",$note->id)}}',
                scrollCollapse: true,
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                serverSide: true,
                paging: true,
                columns: [
                    {data: 'date', name: 'date'},
                    {data: 'description', name: 'description', orderable: false, searchable: false},
                ]

            });
        });
    </script>


@endpush
