@extends('layouts.app')
{{-- <link href="{{url('css/custome-table.css')}}" rel="stylesheet" type="text/css"> --}}

@section('content')


    <div id="print-modal">
        <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show"
                      :value-type="'allNoteReport'"
                      @closed="closeModal">

            <div slot=body>
                <div class="row">
                    <div class="form-group">
                        <label class="control-label"> @lang('layout.Number')</label>
                        <input class="form-control" type="number" name="note_number">
                    </div>
                </div>

                <div class="row">
                    <div class="form-group">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="control-label"> @lang('layout.Date')</label>
                                <div class="input-group">
                                    <input class="form-control date" id="range-from-example" name="from_date"
                                           autocomplete="off">

                                    <span class="input-group-addon"> @lang('layout.To') </span>
                                    <input class="form-control date" id="range-to-example" name="to_date"
                                           autocomplete="off">

                                </div>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </report-modal>
    </div>


    <!-- BEGIN TAB PORTLET-->
    <div class="row">
        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>&nbsp;
                    <span class="caption-subject bold uppercase">  @lang('menu.Note') &nbsp; &nbsp; &nbsp; </span>
                </div>
                <div class="tools"></div>
                <div class="pull-right">

                  <!--   <a href="{{route('note.graphicalshow')}}">
                        <button class="btn btn-success">@lang('layout.GraphicalPresintation')</button>
                    </a> -->
                    <span onclick="getRecord();" class="btn blue">
                        <i class="fa fa-refresh"></i>
                    </span>
                    @permission('note-export')
                    <span id="anchore-modal">
                     <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                        <i class="fa fa-print"></i>
                     </a>
                 </span>
                    @endpermission


                    {{-- @permission('note-create')
                    <a href="{{route('note.create')}}">
                        <!-- <button id="sample_editable_1_new" class="btn green btn-sm btn-outline"> -->
                        <button id="sample_editable_1_new" class="btn btn-success">
                            <i class="fa fa-plus"></i> @lang('layout.AddNew')
                        </button>
                    </a>
                    @endpermission --}}

                    @permission(['note-create'])
                    <span id="create-modal">
                        <a href="#" @click.prevent="showModal" class="btn  btn-success">
                        <i class="fa fa-plus"></i> @lang('layout.AddNew')
                        </a>
                    </span>
                    @endpermission

                </div>
                <template v-cloak id="company_all">
                    <company @company="setCompany"></company>
                </template>


            </div>
            <div class="portlet-body">

                <!--Begin Form-->
                {!! Form::open(array('route' => 'note.store','method'=>'POST','class'=>'form-horizontal','id'=>'note-submit')) !!}
                {{ csrf_field() }}

                <div class="well well-lg" id="app" v-show="show_create"  >
                    <div class="form-body" v-cloak >

                        
                            {{-- <a  @click="printjs" class="btn  btn-success">
                                <i class="fa fa-print"></i> @lang('layout.Print')
                            </a> --}}

                            <div class="row" >
                                <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                                    <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                        <div class="col-md-12">
                                            <label class="control-label ">@lang('layout.Title')</label>
                                            {{Form::text('name',null,['class' => 'form-control','autocomplete'=>'off'])}}
                                        </div>
                                    </div>
    
    
                                    <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                        <div class="col-md-12">
                                            <label class="control-label ">@lang('layout.Number')</label>
                                            {{Form::number('number',$number,['class' => 'form-control','v-model'=>'number'])}}
                                        </div>
                                    </div>
    
    
                                    <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                        <div class="col-md-12">
                                            <label class="control-label ">@lang('layout.Date')</label>
                                            {{Form::text('date',null,['class' => 'form-control date','autocomplete'=>'off'])}}
                                        </div>
                                    </div>
    
    
                                    <div class="col-md-6">
                                        <label class="control-label ">@lang('layout.Description')</label>
                                        {{Form::textarea('description',null,['class' => 'form-control','rows' => '2'])}}
                                    </div> 
                                    
                                    <div class="col-md-3">
                                    <br>
                                    <br>
                                    <button class="btn btn-info" data-toggle="collapse" data-parent="#accordion1" href="#accordion1_3">
                                        <i class="fa fa-info-circle" style="font-size: 20px;"></i> @lang('layout.Details')</button>
                                    </div>
                                </div>
                            </div>
                                    <div id="accordion1_3" class="panel-collapse collapse" style="margin-top: 20px">
    
                                        <div style="">
                                            <table id="table_content" class="table table-bordered">
                                                <thead>
                                                <tr style="background-color: rgb(84, 199, 211);color:white">
                                                    <th>#</th>
                                                    <th style="min-width: 300px">@lang('layout.Description') </th>
    
                                                    <th>@lang('layout.Date') </th>
                                                    <th></th>
    
                                                </tr>
                                                </thead>
                                                <tbody>
                                                <tr v-for="(item,index) in note">
                                                    <td>@{{index+1}}</td>
                                                    <td class="highlight">
                                                        <input type="text" @keyup="addNew(index)" v-on:click="addNew(index)"
                                                            name="expense_description[]" class="form-control" autocomplete="off">
                                                    </td>
    
                                                    <td class="highlight">
    
                                                        <date_picker :name="'expense_info_date['+index+']'" ></date_picker>
                                                    </td>
                                                    <td>
                                                        <span v-on:click="deleteItem('index')"><i
                                                                    class="paddint-both glyphicon glyphicon-trash"></i></span>
                                                    </td>
    
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                            <div class="row">
                                <div class="col-md-12 text-center">
                                    <br>
                                    <button  type="button" @click="handleSubmit($event)" :disabled="disabled" class="btn green">@lang('layout.Submit')</button>
                                    <button  type="button" class="btn blue" :disabled="disabled" @click="saveAndNew($event)">@lang('layout.SaveAndNew')</button>
                                    <a @click="show_create = false, clearData()" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                                    <hr />
                                </div>
                            </div>
                    </div>
                </div>

                
                {!! Form::close() !!}

                <!--End Form-->
                
                <table class="table table-striped table-bordered table-hover" id="noteList">
                    <thead>
                    <tr>
                        <th>@lang('layout.Number')</th>
                        <th>@lang('layout.Date')</th>
                        <th>@lang('layout.Name')</th>
                        <th>@lang('layout.Description')</th>
                        <th>@lang('layout.User')</th>
                        <th>@lang('layout.Actions')</th>
                    </tr>
                    </thead>
                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>


    <!-- END TAB PORTLET-->
    <iframe id="payframe" style="display: none;"></iframe>
    <!-- END CONTENT BODY -->
@stop
@include('print.modal')
@include('groupCompanyFilter.select')
@push('scripts')
{{-- <script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.5.1/jspdf.umd.min.js"></script>
<script src="https://unpkg.com/jspdf-autotable@3.8.2/dist/jspdf.plugin.autotable.js"></script> --}}

<script src="{{ url('/js/jspdf.umd.min.js') }}" type="text/javascript"></script>
<script src="{{ url('/js/jspdf.plugin.autotable.js') }}" type="text/javascript"></script>

    <script>

// Default export is a4 paper, portrait, using millimeters for units

         Vue.component('v-select', VueSelect.VueSelect);

        let data_table = 0;
        // document.getElementById('show_table').style.display = 'none';
        $(document).ready(function () {
            getRecord();
        });
        function getRecord() {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
            if (data_table != 0) {
                data_table.destroy();
            }
            data_table =$('#noteList').DataTable({
                ajax: '{{route("note.index")}}',
                pageLength: '{{getPageRows()}}',
                order: [["{{orderByColumn()=='number'?0:1}}", "{{getRowOrder()}}"]],
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                scrollCollapse: true,
                paging: true,
                serverSide: true,
                columns: [
                    {data: 'number', name: 'number'},
                    {data: 'Date', name: 'Date'},
                    {data: 'name', name: 'name'},
                    {data: 'description', name: 'description'},
                    {data: 'user', name: 'user'},
                    {data: 'actions', name: 'actions', orderable: false, searchable: false},

                ]
            });
        }


        var vm = new Vue({
            el: '#print-modal',
            data: {
                is_show: false,
                pdfRoute: '{!!route("export.PDFAll") !!}',
                excelRoute: '{!! route("export.ExcelAll") !!}',

            },
            methods: {
                closeModal: function () {
                    this.is_show = !this.is_show
                },
            }
        });


        new Vue({
            el: '#anchore-modal',
            methods: {
                showModal: function () {
                    console.log('trr')
                    vm.$data.is_show = true;

                }
            }
        });

        new Vue({
            el: '#company_all',
            methods: {
                setCompany: function (event) {
                    if (typeof data_table == 'object'){
                        data_table.clear();
                        data_table.ajax.reload();
                    }
                }
            }
        });

    new Vue({
        el: '#create-modal',
        methods: {
            showModal: function() {
                console.log('trr')
                v.$data.show_create = true;

            }
        }
    });
    // /for new modal

    let v = new Vue({
            el: '#app',
            data: {
                note:
                    [
                        {expense_description: null, expense_info_date: null},

                    ],
                    show_create: false,
                    disabled: false,
                    number: "{{$number}}",
                    old_number: "{{$number}}"
            },
            methods: {
                addNew(index) {
                    if (this.note[index + 1] == undefined) {
                        this.note.push({expense_description: null, expense_info_date: null});
                    } 
                },
                // printjs(){
                //     const { jsPDF } = jspdf
                //     const {autoTable} ='jspdf-autotable'
                //     const doc = new jsPDF({
                //         orientation: 'p',
                //         unit: 'mm',
                //         format: 'a4',
                //         // encryption: {
                //         //     userPassword: "user",
                //         //     ownerPassword: "saeed",
                //         //     userPermissions: ["print", "modify", "copy", "annot-forms"]
                //         // }
                //     });
                //     // for(var i=0; i<=100;i++){

                //     //     doc.text("Hello world!", 10, 10);
                //     // }
                //     // doc.save("a4.pdf");

                //     // var body = [
                //     //         ['SL.No', 'Product Name', 'Price', 'Model'],
                //     //         [1, 'I-phone', 75000, '2021'],
                //     //         [2, 'Realme', 25000, '2022'],
                //     //         [3, 'Oneplus', 30000, '2021'],
                //     //         ]
                //     // var y = 10;
                //     // doc.setLineWidth(2);
                //     // doc.text(200, y = y + 30, "Product detailed report");
                //     // doc.autoTable({
                //     //     head:[['name','age','country']],
                //     //     body: [['saeed',28,'afg'],['saeed',28,'afg']]
                //     // })
                //     // doc.save('auto_table_with_javascript_data');


                //     // var body = [
                //     //         ['SL.No', 'Product Name', 'Price', 'Model'],
                //     //         [1, 'I-phone', 75000, '2021'],
                //     //         [2, 'Realme', 25000, '2022'],
                //     //         [3, 'Oneplus', 30000, '2021'],
                //     //         ]


                //     // var body = this.note_all;
                //     // var y = 10;
                //     // doc.setLineWidth(2);
                //     // doc.text("Hello world!", 10, 10);
                //     // doc.autoTable({
                //     //     body: body,
                //     //     startY: 70,
                //     //     theme: 'grid',
                //     //             })
                //     // doc.save('auto_table_with_javascript_data');

                //     axios.get("{{route('note.create')}}")
                //     .then(function (response) {

                //         var fontPath = "{{url('Farsi_font/'.getFont().'.ttf')}}";
                //         var logoPath = "{{url('uploads/logo.png')}}";
                        
                //         console.log('daaaaaaaaaaa',response,fontPath,logoPath);
                //         var body = response.data.note_all;
                //         var company_name = response.data.company_name;
                //         var company_phone = response.data.company_phone;
                //         var y = 10;
                //         doc.addFileToVFS("CustomeFont.ttf", fontPath);
                //         doc.addFont(fontPath, 'CustomeFont', 'normal');
                //         doc.setFont('CustomeFont');
                //         doc.setLineWidth(2);
                //         // doc.text("Test Company this is a header", 10, y=y+10);
                //         doc.autoPrint({variant: 'non-conform'});
                //         doc.setTextColor(40);
                //         doc.setDirection = "rtl";
                //         // doc.setLanguage("en-US");

                //         // const pageCount = doc.internal.getNumberOfPages();
                //         // for (let i = 1; i <= pageCount; i++) {
                //         //     doc.setPage(i);
                //         //     doc.text('Page ' + String(i)+ ' of ' + String(pageCount),100,285,null,null,"right");
                //         // }

                //         if (logoPath) {
                //             doc.addImage(logoPath, "png", 10, 15, 10, 10);
                //         }
                //         doc.setFontSize(25);
                //         doc.setTextColor(255,0,0)

                //         doc.text(company_name, 10 + 60, 22)

                //         doc.setFontSize(12);
                //         doc.setTextColor(255,0,0)

                //         doc.text(company_phone, 10 + 170, 22)
                        
                //         doc.setLineWidth(0.2);
                //         doc.line(10, y+18, 200, y+18);


                //         doc.autoTable({
                //             body: body,
                //             // html: '#noteList',
                //             startY: 30,
                //             // head:[['Date','Number','Amount','Currency']],
                //             columns: [
                //                 { dataKey: 'id', header: '@lang("layout.ID")' },
                //                 { dataKey: 'name', header: '@lang("layout.Name")' },
                //                 { dataKey: 'fatherName', header: '@lang("layout.FatherName")' },
                //                 { dataKey: 'description', header: '@lang("layout.Description")' },
                //                 // { dataKey: 'description', header: '@lang("layout.Description")' }
                //             ],
                //             foot:[['','','Amount','Currency','']],
                //             theme: 'grid',
                //             // theme: 'striped',
                //             tableLineWidth:0.5,
                //             // tableLineColor:[200,80,120],
                //             tableLineColor: [231, 76, 60],
                //             headStyles: {
                //                 fillColor: [241, 196, 15],
                //                 fontSize: 15,
                //             },
                //             footStyles: {
                //                 fillColor: [241, 196, 15],
                //                 fontSize: 15,
                //             },
                //             styles:{
                //                 font:'CustomeFont',
                //                 fontSize:12,
                //                 cellPadding:1,
                //                 lineWidth:0.2,
                //                 lineColor:[200,80,120],
                //                 float: "rtl",

                //             },
                //             columnStyles:{
                //                 0: {
                //                     halign: 'left',
                //                     valign:'middle',
                //                     tableWidth: 100,
                //                     fillColor:[232,252,245],
                //                     cellWidth:'auto'
                //                 },
                //                 1: {
                //                     halign: 'center',
                //                     valign:'middle',
                //                     tableWidth: 100,
                //                     fillColor:[232,252,245],
                //                     cellWidth:'auto'
                //                 },
                //                 2: {
                //                     halign: 'left',
                //                     valign:'middle',
                //                     tableWidth: 100,
                //                     fillColor:[232,252,245],
                //                     cellWidth:'auto'
                //                 },
                //                 3: {
                //                     halign: 'right',
                //                     valign:'middle',
                //                     tableWidth: 100,
                //                     fillColor:[232,252,245],
                //                     cellWidth:'auto'
                //                 },
                //                 // 4: {
                //                 //     halign: 'center',
                //                 //     valign:'middle',
                //                 //     tableWidth: 100,
                //                 //     fillColor:[232,252,245],
                //                 //     cellWidth:'auto'
                //                 // }
                //             },
                //             didDrawPage: function(data) {
                //                 console.log(data);

                //                 var currentdate = new Date(); 
                //                 var datetime =   currentdate.getDate() + "/"
                //                                 + (currentdate.getMonth()+1)  + "/" 
                //                                 + currentdate.getFullYear() + " ----- "  
                //                                 + currentdate.getHours() + ":"  
                //                                 + currentdate.getMinutes() + ":" 
                //                                 + currentdate.getSeconds();
                //                 // const currentPage = data.pageNumber;
                //                 // const pageNumber = `Page ${currentPage} - ${datetime}`;
                //                 // doc.setFontSize(10);
                //                 // doc.text(pageNumber,100,285);

                //                 // const pageCount = doc.internal.getNumberOfPages();
                //                 // for (let i = 1; i <= pageCount; i++) {
                //                 //     doc.setFontSize(10);
                //                 //     doc.setPage(i);
                //                 //     doc.text('Page ' + String(i)+ ' of ' + String(pageCount),100,285,null,null,"right");
                //                 // }

                //                 doc.setFontSize(20);
                //                 doc.setTextColor(255,0,0)
                //                 // doc.text("CHACO Company  - َشرکت حسابدار خبره", 10, 10);
                //                 // doc.addImage(logoPath, "png", 10, 10, 10, 10);


                //                 // if (logoPath) {
                //                 //     doc.addImage(logoPath, "png", data.settings.margin.left, 15, 10, 10);
                //                 // }
                //                 // doc.text('Report', data.settings.margin.left + 80, 22)
                //                 // doc.text('Phone', data.settings.margin.left + 120, 22)


                //                 // doc.line(3, 70, margins.width + 43,70);
                //                 // doc.setLineWidth(0.2);
                //                 // doc.line(10, y+18, 200, y+18);

                               
                                
                                
                //                 //create image data using base64
                //                 // var imgData = 'data:image/jpeg;base64,'+ Base64.encode('Koala.jpeg');
                //                 // doc.addImage(imgData, 'JPEG', 10, 10, 200, 200);


                //                 // doc.setLineWidth(1);
                //                 // doc.line(10, y, 200, y);
                //             }
                //         })

                //         //Second Table
                //         doc.autoTable({
                //             columns: [
                //                 { dataKey: 'id', header: '@lang("layout.ID")' },
                //                 { dataKey: 'name', header: '@lang("layout.Name")' },
                //                 { dataKey: 'fatherName', header: '@lang("layout.FatherName")' },
                //                 { dataKey: 'description', header: '@lang("layout.Description")' }
                //             ],
                //             body: body,
                //             // startY: 240,
                //             // showHead: 'firstPage',
                //             styles:{
                //                 font:'CustomeFont',
                //                 fontSize:12,
                //                 // cellPadding:1,
                //                 // lineWidth:0.2,
                //                 // lineColor:[200,80,120]

                //             },
                //             // margin: { left: 107 },
                //             didDrawPage: function(data) {
                //                 console.log(data);

                //                 var currentdate = new Date(); 
                //                 var datetime =   currentdate.getDate() + "/"
                //                                 + (currentdate.getMonth()+1)  + "/" 
                //                                 + currentdate.getFullYear() + " ----- "  
                //                                 + currentdate.getHours() + ":"  
                //                                 + currentdate.getMinutes() + ":" 
                //                                 + currentdate.getSeconds();

                //                 // const currentPage = data.pageNumber;
                //                 // const pageNumber = `Page ${currentPage} - ${datetime}`;
                                
                //                 // doc.text(pageNumber,100,285);

                //                 doc.setFontSize(20);
                //                 doc.setTextColor(255,0,0)
                //                 // doc.text("CHACO Company  - َشرکت حسابدار خبره", 10, 10);
                //                 // doc.line(3, 70, margins.width + 43,70);

                               
                //             }
                //         })


                //         //Page Number
                //         const pageCount = doc.internal.getNumberOfPages();
                //         for (let i = 1; i <= pageCount; i++) {
                //             doc.setPage(i);
                //             doc.setFontSize(10);
                //             doc.setTextColor(255,0,0)
                //             doc.text('Page ' + String(i)+ ' of ' + String(pageCount),100,285,null,null,"right");
                //         }

                        


                //         doc.save('auto_table_with_javascript_data');

						
                //     })
                //     .catch(function (error) {
                //     });




                // },

                deleteItem(index) {
                    this.note.splice(index, 1);
                },
                handleSubmit(e) {
                        v.submitForm1();
                },
                submitForm1() {
                    v.disabled = true;
                    swal({
                        title: "@lang('layout.AreYouSure?')",
                        buttons: ["@lang('layout.Cancel')", "@lang('layout.Submit')"],
                        text: "",
                        icon: "info",
                        dangerMode: true,
                    }).then((willDelete) => {
                        if (willDelete) {
                            document.getElementById("note-submit").submit()
                        } else {
                            v.disabled = false;
                        }
                    });
                },
                saveAndNew() {
                            v.disabled = true;
                            var url = "{{route('note.store')}}";
                            form_id = 'note-submit';
                            var data = $('#' + form_id).serialize();
                            toggleBlock(true);
                            axios.post(url, data)
                                .then(function(response) {
                                    toggleBlock(0);
                                    if (response.data.result == 1) {
                                        // $('#' + form_id).trigger('reset');
                                        toastr.success('', response.data.message);
                                        v.number = Number(v.old_number) + 1;
                                        v.old_number = Number(v.old_number) + 1;
                                        // v.clearData();

                                        // getRecord();
                                        location.reload();
                                    } else {
                                        var message = "{{__('message.Warning')}}";
                                        //$('#error-sound')[0].play();
                                        toastr.warning('', message);
                                        v.disabled = false;
                                    }
                                    v.disabled = false;
                                })
                                .catch(function(error) {
                                    toggleBlock(0);
                                    console.log(error);
                                    var message = "{{__('message.Warning')}}";
                                    v.disabled = false;
                                    //$('#error-sound')[0].play();
                                    toastr.warning('', message);
                                });
            }

            }
        })


    </script>
@endpush