@extends('layouts.app')
<link href="{{url('css/custome-table.css')}}" rel="stylesheet" type="text/css">

@section('content')
    <div class="row">

        <div class="portlet light bg-inverse" style="min-height: 100%;">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>&nbsp;
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.EditNote') </span>
                    <!-- <span class="caption-helper">some info...</span> -->
                </div>
                <div class="tools">
                    
                </div>
            </div>
            <div id="app" class="portlet-body form" style="margin-bottom:50%;">
                <!-- BEGIN FORM-->
                {!! Form::model($note, ['method' => 'PATCH','class'=>'form-horizontal','route' => ['note.update',$note->id]]) !!}
                {{ csrf_field() }}
                <div class="form-body">
                    <div class="row">
                        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                            <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                <div class="col-md-12">
                                    <label class="control-label ">@lang('layout.Name')</label>
                                    {{Form::text('name',null,['class' => 'form-control','placeholder' => __('layout.Name')])}}
                                </div>
                            </div>


                            <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                <div class="col-md-12">
                                    <label class="control-label ">@lang('layout.Number')</label>
                                    {{Form::number('number',null,['class' => 'form-control','placeholder' => __('layout.Number')])}}
                                </div>
                            </div>


                            <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                <div class="col-md-12">
                                    <label class="control-label ">@lang('layout.Date')</label>
                                    {{Form::text('date',null,['class' => 'form-control date','placeholder' => __('layout.Date')])}}
                                </div>
                            </div>


                            <div class="col-md-12">
                                <div class="col-md-12">
                                    <label class="control-label ">@lang('layout.Description')</label>
                                    {{Form::textarea('description',null,['class' => 'form-control','rows' => '2','placeholder' => __('layout.Description')])}}
                                </div>
                            </div>
                        </div>
                    </div>

                    <div style="margin-top: 20px !important">
                        <table id="table_content" class="table table-bordered">
                            <thead>
                            <tr>
                                <th colspan="4">@lang('layout.Details')</th>
                            </tr>
                            <tr>
                                <th>#</th>
                                <th style="min-width: 300px">@lang('layout.Description') </th>

                                <th>@lang('layout.Date') </th>
                                <th></th>

                            </tr>
                            </thead>
                            <tbody>
                            <tr v-for="(item,index) in note">
                                <td>@{{index+1}}</td>
                                <td class="highlight">
                                    <input type="text" @keyup="addNew(index)" v-on:click="addNew(index)" v-model="(!item)?null:item.expense_description" name="expense_description[]" class="form-control">
                                </td>
                                <td class="highlight">
                                    <date_picker :name="'expense_info_date['+index+']'" v-model="(!item)?null:item.expense_info_date" placeholder="@lang('layout.Date')" ></date_picker>
                                </td>
                                <td>
                                    <span v-on:click="deleteItem('index')">
                                        <i class="paddint-both glyphicon glyphicon-trash"></i>
                                    </span>
                                </td>
                            </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
                <div class="col-md-4 col-md-offset-4 text-center">
                    <br>
                    <button type="button" class="btn green" onclick="regForm(this)">@lang('layout.Submit')</button>
                    <a href="{{route('note.index')}}" class="btn default"><i
                                class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                </div>
                {!! Form::close() !!}

            </div>

            <!-- END FORM-->
        </div>
    </div>

@endsection
@push('scripts')
    <script type="text/javascript">
        Vue.component('v-select', VueSelect.VueSelect);
        let noteDetails = {!! $noteDetails !!}

            let
        v = new Vue({
            el: '#app',
            data: {
                note: [],
                noteDetails: noteDetails
            },
            mounted: function () {
                for (var i = 0; i < this.noteDetails.length; i++) {
                    this.note.push({
                        expense_description: this.noteDetails[i].description,
                        expense_info_date: this.noteDetails[i].date
                    });
                }
                for (var m = 4; m > this.noteDetails.length; m--) {
                    this.note.push({
                        expense_description: null,
                        expense_info_date: null,
                    });
                }
            },
            methods: {
                addNew(index) {
                    if (this.note[index + 1] == undefined) {
                        this.note.push({expense_description: null, expense_info_date: null});
                    }

                },

                deleteItem(index) {
                    this.note.splice(index, 1);
                },
            }
        })
    </script>

@endpush
 