@extends('layouts.app')
@section('style')
<style type="text/css">
   table.td{
        border-top:0px;
    }
    .header{
    
    }
   
</style>
@stop
@section('content')
 
      <div class="">
            <!-- BEGIN EXAMPLE TABLE PORTLET-->
            <div class="portlet light bordered sale">
                <div class="portlet-title">
                    <div class="caption font-dark">
                        <i class="icon-settings font-dark"></i>
                        <span class="caption-subject bold uppercase">@lang('layout.NGOProjectShow')</span>
                    </div>
                   
                    <div class="tools"></div>
                    <div class="btn-group pull-right">
                        {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}}
                           <input type="hidden" name="type" value="ngo_project_Details"/>
                           <input type="hidden" name="id" value="{{$nGOProject->id}}"/> 
                           <button type="submit" class="btn btn-success" style="margin-right: 4px;"> <i class="fa fa-file-pdf-o"></i> @lang('layout.Report') </button>
                        {{Form::close()}}  
                    </div>
                </div>
                <div class="portlet-body">
                    <div class="row">
                       <div class="col-md-12">
                           <table class="table">
                           <thead>
                                <tr>
                                    <th>@lang('layout.Code')</th>
                                    <th>@lang('layout.Name')</th>
                                    <th>@lang('layout.ReferenceNumber')</th>
                                    <th>@lang('layout.Amount')</th>
                                    <th>@lang('layout.Currency')</th>
                                    <th>@lang('layout.Category')</th>
                                    <th>@lang('layout.Location')</th>
                                    <th>@lang('layout.Description') </th>
                                    <th>@lang('layout.Date') </th>
                                    <th>@lang('layout.StartDate') </th>
                                    <th>@lang('layout.EndDate') </th>
                                    <th>@lang('layout.Percent') </th>
                                </tr>
                              </thead>
                            <tbody> 
                                <tr>  
                                    <td class=""> {{ $nGOProject->code}}  </td>
                                    <td class=""> {{ $nGOProject->name}}  </td>
                                    <td class=""> {{ $nGOProject->ref_no}}  </td>
                                    <td class=""> {{ $nGOProject->amount}}</td>
                                    <td class=""> {{ $nGOProject->currency}}</td>
                                    <td class=""> {{ $nGOProject->category}}</td>
                                    <td class=""> {{ $nGOProject->location}}</td>
                                    <td class=""> {{ $nGOProject->description}}</td>
                                    <td class=""> {{ $nGOProject->date}}</td>
                                    <td class=""> {{ $nGOProject->start_date}}</td>
                                    <td class=""> {{ $nGOProject->end_date}}</td>
                                    <td class=""> {{ $nGOProject->percent}} %</td>
                                </tr>
                            </tbody>
                            </table>
                       </div> 
                    </div>
                    <div class="row" >

                    <div class="tabbable tabbable-tabdrop">

                        <ul class="nav nav-tabs">
                            <li class="active">
                                <a href="#tab1" data-toggle="tab" id="">@lang('layout.Donator')</a>
                            </li>
                            <li class="">
                                <a href="#tab2" data-toggle="tab" id="">@lang('layout.Attachments')</a>
                            </li>
                        </ul>
                        <div class="tab-content">
                            <div class="tab-pane active" id="tab1">
                                <div class="row">
                                    <div class="col-md-12">
                                        <!-- BEGIN EXAMPLE TABLE PORTLET-->
                                        <div class="portlet light bordered">
                                            <div class="title">
                                                <div class="caption font-dark">
                                                    <i class="icon-settings font-dark"></i>
                                                    <span class="caption-subject bold uppercase">@lang('layout.Donator')</span>
                                                </div>
                                                <div class="actions">
                                                </div>
                                            </div>
                                            <div class="portlet-body" id="itemsshow">
                                                <table class="table table-striped table-bordered table-hover" id="donator">
                                                    <thead>
                                                        <tr>
                                                            <th>@lang('layout.Name')</th>
                                                            <th>@lang('layout.Description')</th>
                                                        </tr>
                                                    </thead>
                                                </table>
                                            </div>
                                        </div>
                                        <!-- END EXAMPLE TABLE PORTLET-->
                                    </div>
                                </div>
                            </div>
                            <div class="tab-pane" id="tab2">
                                <div class="portlet light bordered">
                                    <div class="title">
                                        <div class="caption font-dark">
                                            <i class="icon-settings font-dark"></i>
                                            <span class="caption-subject bold uppercase">@lang('layout.Attachments')</span>
                                        </div>
                                    </div>
                                    <div class="portlet-body">
                                        <div class="portlet light bordered">
                                            <div class="portlet-body">

                                                <form role="form" action="{{route('attachment.store')}}" method="post"
                                                    enctype="multipart/form-data">

                                                    @csrf
                                                    <input type="hidden" name="redirect_route" value="nGOProject.show">
                                                    <input type="hidden" name="foreign_data_id" value="{{$nGOProject->id}}">
                                                    <input type="hidden" name="path" value="uploads/NGOProject">
                                                    <input type="hidden" name="table_name" value="ngo_projects">

                                                    <div class="row">
                                                        <div class="col-md-4">
                                                            <div class="form-group">
                                                                <label class="control-label">@lang('layout.AttachmentTitle')</label>
                                                                <input type="text" name="title" class="form-control">
                                                            </div>
                                                        </div>
                                                        <div class="col-md-4">
                                                            <div class="form-group">
                                                                <label class="control-label">@lang('layout.Description')</label>
                                                                <textarea name="description" class="form-control"></textarea>
                                                            </div>
                                                        </div>
                                                        <div class="col-md-7">
                                                            <div class="form-group">
                                                                <div class="fileinput fileinput-new" data-provides="fileinput">
                                                                    <div class="fileinput-new thumbnail"
                                                                        style="width: 200px; height: 150px;">
                                                                        <img src="" alt=""></div>
                                                                    <div class="fileinput-preview fileinput-exists thumbnail"
                                                                        style="max-width: 200px; max-height: 150px; line-height: 10px;"></div>
                                                                    <div>
                                                                                <span class="btn default btn-file">
                                                                                    <span class="fileinput-new">@lang('layout.SelectFile')</span>
                                                                                    <span class="fileinput-exists">@lang('layout.Change')</span>
                                                                                    <input type="hidden" value="" name=""><input
                                                                                            type="file" name="photo"> </span>

                                                                        <a href="javascript:;" class="btn default fileinput-exists"
                                                                        data-dismiss="fileinput"> @lang('layout.Remove') </a>
                                                                    </div>

                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="margiv-top-10">
                                                        <button type="button" onclick="regForm(this)"
                                                                class="btn green"> @lang('layout.Submit') </button>
                                                        <a href="{{route('dailyExpense.index')}}"
                                                        class="btn default">@lang('layout.Cancel')</a>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                        <table class="table table-striped table-bordered table-hover" id="attachment">
                                            <thead>
                                            <tr>
                                                <th>@lang('layout.AttachmentTitle')</th>
                                                <th>@lang('layout.Description')</th>
                                                <th>@lang('layout.Action')</th>
                                            </tr>
                                            </thead>
                                        </table>
                                    </div>
                                </div>
                            </div>        
                        </div>
                    </div>
                    </div>
                </div>
            </div>
            <!-- END EXAMPLE TABLE PORTLET-->
    </div>
@endsection
@push('scripts') 
<script>

    $(document).ready(function(){
    $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
        $('#donator').DataTable({  
            scrollCollapse: true,
            responsive:'{{responsiveDataTable()}}',
            pagingType:'{{paginationType()}}',
            serverSide: true,
            paging: true,
            retrieve: true,
            ajax:{
                url: '{{route("nGOProject.show",$nGOProject->id)}}',
                data:{type:'donator'}
                }, 
            columns: [ 
                { data: 'name'   ,      name: 'name' },
                { data: 'description',  name: 'description' },
            ]
        });

        $('#attachment').DataTable({
            ajax: {
                url: '{{route("nGOProject.show",$nGOProject->id)}}',
                data: {type: 'attachment'}
            },
            pageLength:'{{getPageRows()}}',
            responsive:'{{responsiveDataTable()}}',
            pagingType:'{{paginationType()}}',

            scrollCollapse: true,
            serverSide: true,
            paging: true,
            columns: [

                {data: 'title', name: 'attachments.title'},
                {data: 'description', name: 'attachments.description'},
                {data: 'actions', name: 'actions', orderable: false, searchable: false},
            ]
        });   
    });

</script>
@endpush