@extends('layouts.factor-master')

@section('content')
<?php
$report = customeReport('contract', 'index');
?>

<h3 class="table-caption" style="text-align: center;">@lang('layout.NGOProjectReport')</h3>
<table class="main-table">
    <thead>
        <tr class="bg">
            <th>@lang('layout.Code')</th>
            <th>@lang('layout.Name')</th>
            <th>@lang('layout.ReferenceNumber')</th>
            <th>@lang('layout.Amount')</th>
            <th>@lang('layout.Currency')</th>
            <th>@lang('layout.Category')</th>
            <th>@lang('layout.Date') </th>
            <th>@lang('layout.StartDate') </th>
            <th>@lang('layout.EndDate') </th>
            <th>@lang('layout.Percent') </th>
        </tr>
    </thead>
    <tbody>
        <tr>
            <td class=""> {{ $data->code}} </td>
            <td class=""> {{ $data->name}} </td>
            <td class=""> {{ $data->ref_no}} </td>
            <td class=""> {{ $data->amount}}</td>
            <td class=""> {{ $data->currency}}</td>
            <td class=""> {{ $data->category}}</td>
            <td class=""> {{ $data->date}}</td>
            <td class=""> {{ $data->start_date}}</td>
            <td class=""> {{ $data->end_date}}</td>
            <td class=""> {{ $data->percent}} %</td>
        </tr>
    </tbody>
</table>
<table class="main-table">
    <thead>
        <tr class="bg">
            <th>@lang('layout.Location')</th>
            <th>@lang('layout.Description') </th>
        </tr>
    </thead>
    <tbody>
        <tr>
            <td class=""> {{ $data->location}}</td>
            <td class=""> {{ $data->description}}</td>
        </tr>
    </tbody>
</table>
<hr />

<h3>@lang('layout.Donator')</h3>
<table class="main-table">
    <tr class="bg">
        <th> @lang('layout.Record') </th>
        <th>@lang('layout.Name')</th>
        <th>@lang('layout.Description')</th>
    </tr>
    <?php
    $count = 0;
    ?>
    @foreach($projectDonator AS $record1)
    <tr>
        <td class="center">{{++$count}}</td>
        <td class="center">{{$record1->name}}</td>
        <td class="center">{{$record1->description}}</td>
    </tr>
    @endforeach
</table>
<hr />
<?php //dd($nProOrder); ?>
<h3>@lang('layout.Request')</h3>
<table class="main-table">
    <thead>
        <tr class="bg">
            <th>@lang('layout.Record') </th>
            <th>@lang('layout.Number')</th>
            <th>@lang('layout.ReferenceNumber')</th>
            <th>@lang('layout.Member')</th>
            <th>@lang('layout.Date') </th>
            <th>@lang('layout.Currency') </th>
            <th>@lang('layout.Rate') </th>
            <th>@lang('layout.Total')</th>
            <th>@lang('layout.Category')</th>
            <th>@lang('layout.Priority')</th>
            <th>@lang('layout.Type')</th>
            <th>@lang('layout.Driver')</th>
            <th>@lang('layout.VehicleName')</th>
            <th>@lang('layout.DateRequired') </th>
            <th>@lang('layout.User') </th>
            <th>@lang('layout.Description') </th>
        </tr>
    </thead>
    <?php
    $count = 0;
    ?>
    @foreach($nProOrder AS $record2)
    <tr>
        <td class="center">{{++$count}}</td>
        <td class=""> {{ $record2->number}} </td>
        <td class=""> {{ $record2->ref_no}} </td>
        <td class=""> {{ $record2->member}} </td>
        <td class=""> {{ convertDate($record2->date) }}</td>
        <td class=""> {{ $record2->currency}}</td>
        <td class=""> {{ $record2->currency_rate}}</td>
        <td class=""> {{ myRound($record2->price)}}</td>
        <td class=""> {{ $record2->category}}</td>
        <td class=""> {{ __('type.'.$record2->priority)}}</td>
        <td class=""> {{ __('layout.'.$record2->type)}}</td>
        <td class=""> {{ $record2->driver_name }}</td>
        <td class=""> {{ $record2->vehicle_name}} -- {{ $record2->palet_number}}</td>
        <td class=""> {{ convertDate($record2->requir_date) }}</td>
        <td class=""> {{ $record2->user}}</td>
        <td class=""> {{ $record2->description}}</td>
    </tr>
    @endforeach
</table>
<hr />

<h3>@lang('layout.ReceiveAndPayment')</h3>
<table class="main-table">
    <thead>
        <tr class="bg">
            <th>@lang('layout.Record') </th>
            <th>@lang('layout.Number')</th>
            <th>@lang('layout.ReferenceNumber')</th>
            <th>@lang('layout.Member')</th>
            <th>@lang('layout.Date') </th>
            <th>@lang('layout.Currency') </th>
            <th>@lang('layout.Rate') </th>
            <th>@lang('layout.Total')</th>
            <th>@lang('layout.Category')</th>
            <th>@lang('layout.Priority')</th>
            <th>@lang('layout.DateRequired') </th>
            <th>@lang('layout.User') </th>
            <th>@lang('layout.Description') </th>

            <th>@lang('layout.RequestNO')</th>
            <th>@lang('layout.ExpenseType')</th>
            <th>@lang('layout.PaymentType')</th>
            <th>@lang('layout.ExpenseAccount')</th>
            <th>@lang('layout.BankAccount')</th>
            <th>@lang('layout.Vendor')</th>
            <th>@lang('layout.Type')</th>
            <th>@lang('layout.Driver')</th>
            <th>@lang('layout.VehicleName')</th>
            <th>@lang('layout.PaletNumber')</th>
        </tr>
    </thead>
    <?php
    $total_base_amount = 0;
    $count = 0;
    $currencies = [];
    ?>
    @foreach($nProOrderRP AS $record3)
    <?php
    if ($record3->rate >0) {
        $total_base_amount += ((($record3->expense_type == 'Receive')?(-1 * $record3->price):$record3->price) / $record3->rate);
    }
    if (array_key_exists($record3->unit, $currencies)) {
        $currencies[$record3->unit] = $currencies[$record3->unit] + (($record3->expense_type == 'Receive')?(-1 * $record3->price):$record3->price);
    } else {
        $currencies[$record3->unit] = (($record3->expense_type == 'Receive')?(-1 * $record3->price):$record3->price);
    }
    ?> 
    <tr>
        <td class=""> {{ ++$count}} </td>
        <td class=""> {{ $record3->number}} </td>
        <td class=""> {{ $record3->ref_no}} </td>
        <td class=""> {{ $record3->member}} </td>
        <td class=""> {{ convertDate($record3->date) }}</td>
        <td class=""> {{ $record3->unit}}</td>
        <td class=""> {{ $record3->rate}}</td>
        <td class=""> {{ (($record3->expense_type == 'Receive')?myRound(-1 * $record3->price):myRound($record3->price))}}</td>
        <td class=""> {{ $record3->category}}</td>
        <td class=""> {{ __('type.'.$record3->priority)}}</td>
        <td class=""> {{ convertDate($record3->requir_date) }}</td>
        <td class=""> {{ $record3->user}}</td>
        <td class=""> {{ $record3->description}}</td>

        <td class=""> {{$record3->pro_order_num}}</td>
        <td class=""> {{__('layout.'.ucfirst($record3->expense_type))}} </td>
        <td class=""> {{__('layout.'.ucfirst($record3->pay_type))}}</td>
        <td class=""> {{$record3->expense}}</td>
        <td class=""> {{$record3->bankAccount}}</td>
        <td class=""> {{$record3->vendor}}</td>
        <td class=""> {{ __('layout.'.$record3->type)}}</td>
        <td class=""> {{ $record3->driver_name}} </td>
        <td class=""> {{ $record3->vehicle_name}} </td>
        <td class=""> {{ $record3->palet_number}} </td>
    </tr>
    @endforeach
    <tr class="bg">
        <td colspan="9">
            <div class="center">@lang('layout.Currency')</div>
        </td>
    </tr>
    <tr>
        <td>
            <div class="center"> @lang('layout.Record')  </div>
        </td>
        <td colspan="4">
            <div class="center"> @lang('layout.Category') </div>
        </td>
        <td colspan="4">
            <div class="center"> @lang('layout.Amount') </div>
        </td>
    </tr>
    <?php
    $count = 0;
    foreach ($currencies as $key1 => $curr) {
    ?>
        <tr>
            <td>
                <div class="center">{{++$count}}</div>
            </td>
            <td colspan="4">
                <div class="center">{{$key1}}</div>
            </td>
            <td colspan="4">
                <div class="center">{{myRound($curr)}}</div>
            </td>
        </tr>
    <?php
    }
    ?>
</table>
<hr />

<h3>@lang('layout.PayrollList')</h3>
<table class="main-table">
    <thead>
        <tr class="bg">

            <td>
                <div class="center"> @lang('layout.Record') </div>
            </td>
            <th>@lang('layout.Name')</th>
            <th>@lang('layout.BasicSalary')</th>
            <th>@lang('layout.Tax')</th>
            <th>@lang('layout.WorkedDay')</th>
            <th>@lang('layout.AbsentDays')</th>
            <th>@lang('layout.NetPayable')</th>
            <th>@lang('layout.Currency')</th>
            <th>@lang('layout.Account')</th>
            <th>@lang('layout.ExpenseAccount')</th>
            <th>@lang('layout.FromDate')</th>
            <th>@lang('layout.ToDate')</th>
            <th>@lang('layout.Date')</th>
            <th>@lang('layout.Description')</th>
        </tr>
    </thead>
    <?php
    $count = 0;
    $totalp = 0;
    $currencies = [];
    ?>
    @foreach($paySalaryExpense AS $record)
    <tr>
        <?php
        if ($record3->rate > 0) {
            $total_base_amount += (($record->Net_Payable-$record->tax_amount) / $record->rate);
            $totalp += (($record->Net_Payable-$record->tax_amount) / $record->rate);
        }
        if (array_key_exists($record->Curreny, $currencies)) {
            $currencies[$record->Curreny] = $currencies[$record->Curreny] + ($record->Net_Payable-$record->tax_amount);
        } else {
            $currencies[$record->Curreny] = ($record->Net_Payable-$record->tax_amount);
        }
        ?>
        <td class="center">{{++$count}}</td>
        <td class="center">{{$record->Employee}}</td>
        <td class="center">{{$record->BasicSalary}}</td>
        <td class="center">{{$record->tax_amount}}</td>
        <td class="center">{{$record->Worked_Days}}</td>
        <td class="center">{{$record->absent_day}}</td>
        <td class="center">{{myRound($record->Net_Payable-$record->tax_amount)}}</td>
        <td class="center">{{$record->Curreny}}</td>
        <td class="center">{{$record->account}}</td>
        <td class="center">{{$record->exAccount}}</td>
        <td class="center">{{convertDate($record->From_Date)}}</td>
        <td class="center">{{convertDate($record->To_Date)}}</td>
        <td class="center">{{convertDate($record->Date)}}</td>
        <td class="center">{{$record->description}}</td>
    </tr>

    @endforeach
</table>
<table class="main-table">
    <tr class="bg">
        <td colspan="3">
            <div class="center">@lang('layout.PerCurrency')</div>
        </td>
    </tr>
    <tr>
        <td>
            <div class="center">  @lang('layout.Record') </div>
        </td>
        <td>
            <div class="center"> @lang('layout.Currency') </div>
        </td>
        <td>
            <div class="center"> @lang('layout.Amount') </div>
        </td>
    </tr>
    <?php
    $count = 0;
    foreach ($currencies as $key => $currency) {
    ?>
        <tr>
            <td>
                <div class="center">{{++$count}}</div>
            </td>
            <td>
                <div class="center">{{$key}}</div>
            </td>
            <td>
                <div class="center">{{round($currency,2)}}</div>
            </td>

        </tr>
    <?php
    }
    ?>
    <tr>
        <td colspan="2">
            <div class="center">@lang('layout.HomeCurrencyTotal')</div>
        </td>
        <td>
            <div class="center">{{myRound($totalp)}} {{getHomeCurrency()[getCurrencyType()]}}</div>
        </td>

    </tr>

</table>
<hr />

<h3>@lang('layout.Total')</h3>
<table class="main-table">
    <tr class="bg">
        <td>
            <div class="center">@lang('layout.HomeCurrencyTotal')</div>
        </td>
        <td>
            <div class="center">{{myRound($total_base_amount)}} {{getHomeCurrency()[getCurrencyType()]}}</div>
        </td>
    </tr>
</table>



@endsection