@extends('layouts.app')
@section('style')
<style type="text/css">
    body, html{
        height: 100%;
    }
    .background{
        position: relative;
        width: 100%;
        height: 100vh;
        background-image: url('{{asset('menu_img/SaleImages/Capture6.PNG')}}');
        background-size: cover;
        background-position: center;
        background-repeat: no-repeat;
        overflow-y: auto;
    }
    .overlay{
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100vh;
        background-color: rgba(0, 0, 0, 0.651);
        display: flex;
        justify-content: center;
        align-items: flex-start;
        padding-top: 20px;
    }
    .cards{
        display: flex;
        flex-wrap: wrap;
        justify-content: center;
        width: 100%;
        max-width: 1600px;
        padding: 10px;
        box-sizing: border-box;
        gap: 10px;
    }
    .allCards{ 
        width: 19%;
        /* height: 80px; */
        min-height: 90px;
        background-color: white;
        border-radius: 10px;
        box-shadow: 0 4px 8px rgba(235, 232, 232, 0.877);
        transition: .5s;
    }
    .allMainCard{ 
        width: 19%;
        /* height: 80px; */
        min-height: 100px;
        border-radius: 10px;
        transition: .5s;
    }
    .allMainCard:hover{
        text-decoration: none;
    }
    .allCards:hover{
        background-color: rgba(255, 255, 255, 0.787);
        transition: .5s;
    }
    .allCards:hover a{
        text-decoration: none;
    }
    @media(max-width: 1024px){
        .allCards{
            width: 22%;
        }
        .allMainCard{
            width: 22%;
        }
    }
    @media(max-width: 768px){
        .allCards{
            width: 45%;
        }
        .allMainCard{
            width: 45%;
        }
    }
    @media(max-width: 480px){
        .allCards{
            width: 90%;
        }
        .allMainCard{
            width: 90%;
        }
    }
    .caret{
        transition: transform 0.3s ease;
    }
    .caret.open{
        transform: rotate(90deg);
    }
</style>
@stop
@section('content')
<div class="background">
    <div class="overlay">
        <div class="cards">
            <div class="mainHeader" style="display: flex; justify-content: space-between;width: 100%;flex-wrap: wrap;">
                <h3 style="color: white;">@lang('layout.NGOProject')</h3>
                <div>
                    <div class="btn-group">
                        @if(systemConfig()[19] == 1)
                        @permission('NGOProject-list')
                        <a href="{{route('nGOProject.create')}}" type="button" class="btn topBtn" style="background-color: #50818d;color: white;">@lang('layout.AddNew')</a>
                        <button type="button" class="btn topBtn dropdown-toggle btn-success" data-toggle="dropdown" id="dropdownButton">
                            <span class="caret"></span>
                        </button>
                        @endpermission
                        @endif
                        <ul class="dropdown-menu dropdown-menu-right" role="menu">
                            @if(systemConfig()[19] == 1)
                            @permission('NGOProject-list')
                            <li>
                                <a href="{{route('nGOProject.create')}}">@lang('layout.NGOProject')</a>
                            </li>
                            @endpermission
                            @endif
                            @if(systemConfig()[19] == 1)
                            @permission('NProOrder-list')
                            <li>
                                <a href="{{route('nProOrder.create')}}">@lang('layout.Request')</a>
                            </li>
                            @endpermission
                            @endif
                            @if(systemConfig()[19] == 1)
                            @permission('NProOrderQuotation-list')
                            <li>
                                <a href="{{route('nProOrderQuotation.create')}}">@lang('layout.Quotation')</a>
                            </li>
                            @endpermission
                            @endif
                            @if(systemConfig()[19] == 1)
                            @permission('OrderReceiveAndPayment-list')
                            <li>
                                <a href="{{route('nProOrdReceiveAndPay.create')}}">@lang('layout.ReceiveAndPayment')</a>
                            </li>
                            @endpermission
                            @endif
                            @if(systemConfig()[19] == 1)
                            @permission('NGOProCategory-list')
                            <li>
                                <a href="{{route('nProCategory.index')}}">@lang('layout.ProjectCategory')</a>
                            </li>
                            @endpermission
                            @endif
                            @if(systemConfig()[19] == 1)
                            @permission('NGOProCategory-list')
                            <li>
                                <a href="{{route('nProOrderCategory.index')}}">@lang('layout.OrderCategory')</a>
                            </li>
                            @endpermission
                            @endif
                        </ul>
                    </div>
                    <a href="#" class="btn btn-danger">@lang('layout.Back') <i class="fa fa-reply"></i></a>
                </div>
            </div>
            <div class="cards">
                @if(systemConfig()[19] == 1)
                @permission('NGOProject-list')
                <div class="allCards">
                    <div style="display: flex;justify-content: space-between;flex-wrap: wrap;padding: 0px !important;">
                        <div style="padding: 0px 10px;">
                            <div style="padding: 0px !important; margin: 0px !important;">
                                <a href="{{route('nGOProject.index')}}" class="titleBtn"><p style="padding:5px 0px !important; margin: 0px !important;font-weight: bold;">@lang('layout.NGOProject')</p></a>
                            </div>
                            <div style="padding: 0px !important; margin: 0px !important;">
                                <p style="padding: 0px !important; margin: 0px !important;">@if($nGOProject){{$nGOProject}} @else @endif</p>
                            </div>
                        </div>
                        <div>
                            <a href="{{route('nGOProject.index')}}"><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: #7ccc04;" class="fa fa-edit"></i></a>
                        </div>
                    </div>
                </div>
                @endpermission
                @endif
                @if(systemConfig()[19] == 1)
                @permission('NProOrder-list')
                <div class="allCards">
                    <div style="display: flex;justify-content: space-between;flex-wrap: wrap;padding: 0px !important;">
                        <div style="padding: 0px 10px;">
                            <div style="padding: 0px !important; margin: 0px !important;">
                                <a href="{{route('nProOrder.index')}}" class="titleBtn"><p style="padding:5px 0px !important; margin: 0px !important;font-weight: bold;">@lang('layout.Request')</p></a>
                            </div>
                            <div style="padding: 0px !important; margin: 0px !important;">
                                <p style="padding: 0px !important; margin: 0px !important;">@if($nProOrder) {{$nProOrder}} @else @endif</p>
                            </div>
                        </div>
                        <div>
                            <a href="{{route('nProOrder.index')}}"><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: #b6babf;" class="fa fa-edit"></i></a>
                        </div>
                    </div>
                </div>
                @endpermission
                @endif
                @if(systemConfig()[19] == 1)
                @permission('NProOrderQuotation-list')
                <div class="allCards">
                    <div style="display: flex;justify-content: space-between;flex-wrap: wrap;padding: 0px !important;">
                        <div style="padding: 0px 10px;">
                            <div style="padding: 0px !important; margin: 0px !important;">
                                <a href="{{route('nProOrderQuotation.index')}}" class="titleBtn"><p style="padding:5px 0px !important; margin: 0px !important;font-weight: bold;">@lang('layout.Quotation')</p></a>
                            </div>
                            <div style="padding: 0px !important; margin: 0px !important;">
                                <p style="padding: 0px !important; margin: 0px !important;">@if($Quotation){{$Quotation}} @else @endif</p>
                            </div>
                        </div>
                        <div>
                            <a href="{{route('nProOrderQuotation.index')}}"><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: #fb8001;" class="fa fa-bold"></i></a>
                        </div>
                    </div>
                </div>
                @endpermission
                @endif
                @if(systemConfig()[19] == 1)
                @permission('OrderReceiveAndPayment-list')
                <div class="allCards">
                    <div style="display: flex;justify-content: space-between;flex-wrap: wrap;padding: 0px !important;">
                        <div style="padding: 0px 10px;">
                            <div style="padding: 0px !important; margin: 0px !important;">
                                <a href="{{route('nProOrdReceiveAndPay.index')}}" class="titleBtn"><p style="padding:5px 0px !important; margin: 0px !important;font-weight: bold;">@lang('layout.ReceiveAndPayment')</p></a>
                            </div>
                            <div style="padding: 0px !important; margin: 0px !important;">
                                <p style="padding: 0px !important; margin: 0px !important;">@if($orderReceiveAndPay) {{$orderReceiveAndPay}} @else @endif</p>
                            </div>
                        </div>
                        <div>
                            <a href="{{route('nProOrdReceiveAndPay.index')}}"><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: #0175c0;" class="fa fa-money"></i></a>
                        </div>
                    </div>
                </div>
                @endpermission
                @endif
                @if(systemConfig()[19] == 1)
                @permission('NGOProCategory-list')
                <div class="allCards">
                    <div style="display: flex;justify-content: space-between;flex-wrap: wrap;padding: 0px !important;">
                        <div style="padding: 0px 10px;">
                            <div style="padding: 0px !important; margin: 0px !important;">
                                <a href="{{route('nProCategory.index')}}" class="titleBtn"><p style="padding:5px 0px !important; margin: 0px !important;font-weight: bold;">@lang('layout.ProjectCategory')</p></a>
                            </div>
                            <div style="padding: 0px !important; margin: 0px !important;">
                                <p style="padding: 0px !important; margin: 0px !important;">@if($nProCategories) {{$nProCategories}} @else @endif</p>
                            </div>
                        </div>
                        <div>
                            <a href="{{route('nProCategory.index')}}"><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: #259ce0;" class="fa fa-industry"></i></a>
                        </div>
                    </div>
                </div>
                @endpermission
                @endif
                @if(systemConfig()[19] == 1)
                @permission('NGOProCategory-list')
                <div class="allCards">
                    <div style="display: flex;justify-content: space-between;flex-wrap: wrap;padding: 0px !important;">
                        <div style="padding: 0px 10px;">
                            <div style="padding: 0px !important; margin: 0px !important;">
                                <a href="{{route('nProOrderCategory.index')}}" class="titleBtn"><p style="padding:5px 0px !important; margin: 0px !important;font-weight: bold;">@lang('layout.OrderCategory')</p></a>
                            </div>
                            <div style="padding: 0px !important; margin: 0px !important;">
                                <p style="padding: 0px !important; margin: 0px !important;">@if($nProOrderCategories) {{$nProOrderCategories}} @else @endif</p>
                            </div>
                        </div>
                        <div>
                            <a href="{{route('nProOrderCategory.index')}}"><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: #1fa7f2;" class="fa fa-industry"></i></a>
                        </div>
                    </div>
                </div>
                @endpermission
                @endif
            </div>
        </div>
    </div>
</div>
@endsection
@push('scripts')
<script>
    const dropdownButton = document.getElementById('dropdownButton');
    const caret = dropdownButton.querySelector('.caret');
    dropdownButton.addEventListener('click', ()=>{
        caret.classList.toggle('open');
    });
    function toggleContent(){
        var content = document.querySelector('.content');
        var icon = document.getElementById('icon');
        if(content.classList.contains('collapsed')){
            content.classList.remove('collapsed');
            content.classList.add('expanded');
            icon.classList.remove('fa-chevron-down');
            icon.classList.add('fa-chevron-up');
        }else{
            content.classList.remove('expanded');
            content.classList.add('collapsed');
            icon.classList.remove('fa-chevron-up');
            icon.classList.add('fa-chevron-down');
        }
    }
</script>
<script type="text/javascript">
    new Vue({
        el: "#system_setting",
        data: {
            settings: settingAll,
            measures: measures,
            sites: sites,
            enable_notify: false
        },
        mounted() {
        },
        methods: {
        }
    });
</script>
@endpush