@extends('layouts.app')
@section('content')
@include('layouts.modal')
    <div id="print-modal">
        <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute"
                      v-if="is_show" :value-type="'ngo_Project_report'" @closed="closeModal">
            <div slot="body">
                <!----------------------------------------------
                ----Begin Report Body And Custome Report-------
                ----------------------------------------------->
                <div class="row" v-cloak>
                         <div class="tabbable tabbable-tabdrop">
                            <ul class="nav nav-tabs">
                                
                                <li class="active">
                                    <a href="#tab1" data-toggle="tab" id="tab_main">@lang('menu.Report')</a>
                                </li>
                               @if(systemConfig()[2] != 0 )
                                        @permission(['customreport-list'])
                                <li class="">
                                    <a href="#tab2" data-toggle="tab" id="tab_custome">@lang('layout.CustomReportM')</a>
                                </li>
                                @endpermission
                                @endif
                            </ul>
                            <div class="tab-content">
                                 <div class="tab-pane active" id="tab1"> 
                                    <div class="portlet light bordered">
                                        <div class="row">
                                            <div class="form-group">
                                                <div class="col-md-6">
                                                    <label class="control-label ">@lang('layout.SelectProject') </label>
                                                    <v-select class="vue-select2" v-model="selectedproject" label="name"
                                                              @search="onProjectSearch" :options="projectList">
                                                    </v-select>
                                                    <input type="hidden" name="project_id"
                                                           v-model.number="(!selectedproject)?null:selectedproject.id">
                                                </div>
                                                <div class="col-md-6">
                                                    <label class="control-label">@lang('layout.Status')</label>
                                                    <select name="status" class="form-control">
                                                        <option value="">@lang('layout.Select')</option>
                                                        <option value="on">@lang('layout.Active')</option>
                                                        <option value="pending">@lang('layout.Pending')</option>
                                                        <option value="off">@lang('layout.InActive')</option>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-md-12 form-group">
                                                <div class="col-md-4">
                                                    <label class="control-label ">@lang('layout.Date')</label>
                                                        <select name="period" v-model="period" @input="getDates()" class="form-control">
                                                        <option value="CustomDates">@lang('type.CustomDates')</option>
                                                        <option value="Today">@lang('type.Today')</option>
                                                        <option value="Yesterday">@lang('type.Yesterday')</option>
                                                        <option value="ThisWeek">@lang('type.ThisWeek')</option>
                                                        <option value="LastWeek">@lang('type.LastWeek')</option>
                                                        <option value="WeekToDate">@lang('type.WeekToDate')</option>
                                                        <option value="ThisMonth">@lang('type.ThisMonth')</option>
                                                        <option value="MonthToDate">@lang('type.MonthToDate')</option>
                                                        <option value="ThisQuarter">@lang('type.ThisQuarter')</option>
                                                        <option value="QuarterToDate">@lang('type.QuarterToDate')</option>
                                                        <option value="ThisYear">@lang('type.ThisYear')</option>
                                                        <option value="YearToDate">@lang('type.YearToDate')</option>
                                                    </select>
                                                </div>
                                                <div class="col-md-8" v-show="period == 'CustomDates'">
                                                    <div class="form-group">
                                                        <label class="control-label"> @lang('layout.Date')</label>
                                                        <div class="input-group">
                                                            <input class="form-control date" id="range-from-example" v-model="from_date" name="from_date" autocomplete="off">
                                                            <span class="input-group-addon"> @lang('layout.To') </span>
                                                            <input class="form-control date" id="range-to-example" v-model="to_date" name="to_date" autocomplete="off">
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div> 

                                <div class="tab-pane" id="tab2"> 
                                   <div class="portlet light bordered">
                                        <div class="portlet-body">

                                            <form  id="saveCustomeReport" role="form" action="{{route('customeReport.storeCustomeReport')}}" method="post" >
                                                @csrf
                                                <input type="hidden" name="part_name" value="ngo_project_index">


                                                <div class="col-md-12 col-sm-12 col-xs-12">

                                                    <div class="mt-checkbox-inline col-md-2" v-for="(row,itemIndex) in customReportData">

                                                        <div class="form-group">
                                                             <label> @{{ row.Name }}</label>

                                                              <input type="hidden" :name="'column_name['+itemIndex+']'" class="form-control" v-model="row.column_name">


                                                             <label class="switch">
                                                                    <input type="checkbox" :name="'column_status['+itemIndex+']'" 
                                                                    :checked="row.checkedColumn" >
                                                                  <span class="slider round"></span>
                                                            </label>

                                                            <select :name="'column_percentage['+itemIndex+']'" v-model="row.column_percentage" class="form-control" style="width: 90%;">
                                                                <option value="">@lang('layout.Select')</option>
                                                                <option value="2">2 %</option>
                                                                <option value="6">6 %</option>
                                                                <option value="10">10 %</option>
                                                                <option value="15">15 %</option>
                                                                <option value="20">20 %</option>
                                                                <option value="25">25 %</option>
                                                                <option value="30">30 %</option>
                                                                <option value="40">40 %</option>
                                                                <option value="50">50 %</option>
                                                                <option value="60">60 %</option>
                                                            </select>

                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="margiv-top-10">
                                                    <!-- <button type="button" onclick="regForm(this)" class="btn green"> <i class="fa fa-save"></i> </button> -->

                                                    <button type="button" onclick="saveCustomeReport(this)" class="btn blue"> <i class="fa fa-save"></i> </button>
                                                </div>
                                        </form>
                                        </div>
                                </div>
                        </div>
                        </div>
                    </div>
                </div>
                <!----------------------------------------------
                ----Begin Report Body And Custome Report-------
                ----------------------------------------------->

            </div>
        </report-modal>
    </div>


<!-- END PAGE HEADER-->

<!-- BEGIN TAB PORTLET--> 
<div class="row"> 
    <div class="portlet light bordered">
        <div class="portlet-title">
            <div class="caption font-dark">
                <i class="icon-settings font-dark"></i>&nbsp;
                <span class="caption-subject bold uppercase">@lang('layout.NGOProjectList') </span>
            </div>
             <div class="btn-group pull-right">
                    @permission('NGOProject-export')
                        <span id="anchore-modal">
                            <a  @click.prevent="showModal" id="" class="btn  btn-success">
                            <i class="fa fa-print"></i>
                            </a>
                        </span>
                    @endpermission
                    <a href="{{route('nGOProject.create')}}">
                        <button class="btn btn-success">
                            <i class="fa fa-plus"></i> @lang('layout.AddNew')
                    </button></a>
                    <div id="nGOProject" v-cloak>
                        
                         <!-- <button class="btn btn-success" id="show-modal" @click="showModal =true">@lang('layout.AddNew')</button>

                         <modal v-if="showModal" @close="showModal = false">
                            <div slot="header">
                                <div class="col-md-12 col-sm-12 col-xs-12">
                                    <h3>
                                        @lang('layout.projectCategoryCreate')
                                    </h3>
                                </div>
                                <div class="col-md-4">
                                    <div v-if="fieldErrors.length > 0">
                                        <p class="text-danger" fieldErrors>
                                            <spna v-text="fieldErrors"></spna>
                                        </p>
                                    </div>
                                </div>
                            </div>
                            <div slot="body">
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <label>@lang("layout.Name") <span class="required"> * </span></label>
                                            <input type="text" class="form-control" name="name" v-model="className">
                                        </div>
                                    </div>

                                </div>
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <label>@lang("layout.Description") <span class="required"> * </span></label>
                                            <textarea class="form-control" name="description" v-model="description">
                                                
                                            </textarea>
                                        </div>

                                    </div>
                                    
                                </div>
                            </div>


                            <div slot="footer">
                                <button type=button class="btn btn-success" @click="addClass" >
                                    @lang('layout.OK')
                                </button>
                                <button type=button class="btn btn-danger"
                                       @click="showModal =false" >
                                    @lang('layout.Cancel')
                                </button>
                            </div>
                        </modal> -->
                        
                    </div>

            </div>
        </div>
        <div class="portlet-body">

            <template v-cloak id="company_ll">
                <company @company="setCompany"></company>
            </template>

            <table class="table table-striped table-bordered table-hover" cellspacing="1" id="nGOProjects" width="100%">
                <thead>
                <tr> 
                    <th>@lang('layout.Code')</th>
                    <th>@lang('layout.Name')</th>
                    <th>@lang('layout.ReferenceNumber')</th>
                    <th>@lang('layout.Category')</th>
                    <th>@lang('layout.Amount')</th>
                    <th>@lang('layout.Currency')</th>
                    <th>@lang('layout.Location')</th>
                    <th>@lang('layout.Description') </th>
                    <th>@lang('layout.Date') </th>
                    <th>@lang('layout.EndDate') </th>
                    <th>@lang('layout.Status') </th>
                    <th>@lang('layout.Percent') </th>
                    <th>@lang('layout.Action') </th>
                </tr>
                </thead> 
            </table>
        </div>
    </div>
</div> 
@stop
@include('print.modal')
@include('groupCompanyFilter.select')
@push('scripts')
<script>
    var cust_rep = {!!customeReportNewData('ngo_project_index')!!};
    Vue.component("v-select", VueSelect.VueSelect);

    let data_table;
     $(document).ready(function() { 
        $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
        data_table = $('#nGOProjects').DataTable( {
            ajax: '{{route("nGOProject.index")}}',
            pageLength:'{{getPageRows()}}',
            responsive:'{{responsiveDataTable()}}',
            pagingType:'{{paginationType()}}',
            serverSide: true,
            paging:         true,
            columns: [
            { data: 'code', name: 'code' },
            { data: 'name', name: 'name' },
            { data: 'ref_no', name: 'ref_no' },
            { data: 'category', name: 'category' },
            { data: 'amount', name: 'amount' },
            { data: 'currency', name: 'currency' },
            { data: 'location', name: 'location' },
            { data: 'description', name: 'description' },
            { data: 'date', name: 'date' },
            { data: 'end_date', name: 'end_date' },
            { data: 'status', name: 'status' },
            { data: 'percent', name: 'percent', orderable: false, searchable: false },
            { data: 'action', name: 'action', orderable: false, searchable:false },
            ] 
    }); 
    });
        Vue.component('modal',{
            template: '#modal-template'
        });

     let vu = new Vue({
        el: '#nGOProject',
        data:{
            showModal:false,
            fieldErrors:[],
            className: null,
            description: null,
        },
        methods:{
            addClass(){
             
                // var myData = {name: this.className,description:this.description};

                axios.post("{{route('nGOProject.store')}}",{
                    name:this.className,
                    description:this.description
                })
                .then(function(response){
                    vu.showModal = false;
                    vu.className = null;
                    vu.description = null;
                    $('#nGOProjects').DataTable().ajax.reload();
                })
            }
        }
     });

     new Vue({
         el: '#company_ll',
         methods: {
             setCompany: function (event) {
                 if (typeof data_table == 'object'){
                     data_table.clear();
                     data_table.ajax.reload();
                 }
             }
         }
     });

             //Begin Export Modal

    var vm = new Vue({

        el: '#print-modal',
        data: {
            period: 'CustomDates',
            from_date: null,
            to_date: null,
            is_show: false,
            pdfRoute: '{!!route('export.PDFAll') !!}',
            excelRoute: '{!! route('export.ExcelAll') !!}',
            selectedproject: null,
            projectList: [],
            customReportData:
            [      
            {Name: '@lang("layout.Code")', column_name: 'code',checkedColumn:(cust_rep.code)?'checked':'',column_percentage:(cust_rep.code___percent)?cust_rep.code___percent:''},
            {Name: '@lang("layout.ProjectName")', column_name: 'name',checkedColumn:(cust_rep.name)?'checked':'',column_percentage:(cust_rep.name___percent)?cust_rep.name___percent:''},
            {Name: '@lang("layout.Description")', column_name: 'description',checkedColumn:(cust_rep.description)?'checked':'',column_percentage:(cust_rep.description___percent)?cust_rep.description___percent:''},
            {Name: '@lang("layout.StartDate")', column_name: 'start_date',checkedColumn:(cust_rep.start_date)?'checked':'',column_percentage:(cust_rep.start_date___percent)?cust_rep.start_date___percent:''},
            {Name: '@lang("layout.EndDate")', column_name: 'end_date',checkedColumn:(cust_rep.end_date)?'checked':'',column_percentage:(cust_rep.end_date___percent)?cust_rep.end_date___percent:''},
            {Name: '@lang("layout.Date")', column_name: 'date',checkedColumn:(cust_rep.date)?'checked':'',column_percentage:(cust_rep.date___percent)?cust_rep.date___percent:''},
            {Name: '@lang("layout.Location")', column_name: 'location',checkedColumn:(cust_rep.location)?'checked':'',column_percentage:(cust_rep.location___percent)?cust_rep.location___percent:''},
            {Name: '@lang("layout.ReferenceNumber")', column_name: 'ref_no',checkedColumn:(cust_rep.ref_no)?'checked':'',column_percentage:(cust_rep.ref_no___percent)?cust_rep.ref_no___percent:''},
            {Name: '@lang("layout.Category")', column_name: 'category',checkedColumn:(cust_rep.category)?'checked':'',column_percentage:(cust_rep.category___percent)?cust_rep.category___percent:''},
            {Name: '@lang("layout.Donator")', column_name: 'donator',checkedColumn:(cust_rep.donator)?'checked':'',column_percentage:(cust_rep.donator___percent)?cust_rep.donator___percent:''},
            ],
            cust_rep:cust_rep
        },
        methods: {
            closeModal: function () {
                this.is_show = !this.is_show;
            },
            onProjectSearch(search, loading) {
                loading(true);
                this.searchProject(search, loading, this);
            },

            //ajax call to get items
            searchProject(search, loading, vm) {
                axios.get("{{route('callMethod.search')}}", {
                    params: {
                        method_name: 'anyTable',
                        'search_column': 'name',
                        'table_name': 'ngo_projects',
                        keyword: search,
                    }
                })
                    .then(function (response) {
                        this.projectList = [];
                        if (response.data.length > 0) {
                            vm.projectList = response.data;
                            console.log('data', vm.projectList);
                        }
                        loading(false);
                    })
                    .catch(function (error) {
                        console.log(error);
                    })
            },
            //ajax call to get dates
            getDates() {
                setTimeout((function () {
                vm.getDate(vm.period);
                    // console.log(12);
                }), 2e2);
            },
            getDate(period) {
                if (period) {
                // console.log(3232, period);
                if (period != 'CustomDates') {
                    axios.get("{{route('callMethod.search')}}", {
                    params: {
                        method_name: 'getDatesByPeriod',
                        period: period,
                    }
                    })
                    .then(function(response) {
                    vm.from_date = null;
                    vm.to_date = null;
                    if (response.data) {
                        vm.from_date = response.data.start;
                        vm.to_date = response.data.end;
                        // console.log('data', response.data);
                    }
                    })
                    .catch(function(error) {
                    vm.period = 'CustomDates';
                    vm.from_date = null;
                    vm.to_date = null;
                    })
                } else {
                    vm.from_date = null;
                    vm.to_date = null;
                }
                }
            },
        }
    });

    var anchor = new Vue({
        el: '#anchore-modal',
        methods: {
            showModal: function () {
                // console.log('trr')
                vm.$data.is_show = true;
            }
        }
    });

</script>

@endpush
