@extends('layouts.app')
@section('style')
    <link href="{{url('css/custome-table.css')}}" rel="stylesheet">
@stop
@section('content')
    <div class="row">

        <div class="portlet light bg-inverse">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>&nbsp;
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.NGOProjectCreate') </span>
                    <!-- <span class="caption-helper">some info...</span> -->
                </div>
            </div>
            <div class="portlet-body form" style="margin-bottom: 50%;" id="app" >
                <!-- BEGIN FORM-->
                {!! Form::open(array('route' => 'nGOProject.store','method'=>'POST','class'=>'form-horizontal')) !!}
                {{ csrf_field() }} 
                    <div class="form-body">
                        <div class="row"> 
                        <div class="col-md-12"> 
                            <div class="col-md-4">
                                <label class="control-label ">@lang('layout.ProjectName')</label>
                                {{Form::text('name',null,['class' => 'form-control','placeholder' => __('layout.ProjectName')])}}
                            </div>
                            <div class="col-md-8" style="padding: 0px !important;">
                                <div class="col-md-4">
                                    <label class="control-label">@lang('layout.ProjectCode')</label>
                                    <input type="text" name="code" value="{{$code}}" class="form-control">
                                </div>
                                <div class="col-md-4">
                                    <label class="control-label">@lang('layout.ReferenceNumber')</label>
                                    <input type="text" name="ref_no" class="form-control">
                                </div>
                                <div class="col-md-4">
                                    <label class="control-label">@lang('layout.Date')</label>
                                    <input type="text" class="form-control date" name="date" autocomplete="off">
                                </div>
                            </div>
                            <div class="col-md-4">
                                <label class="control-label">@lang('layout.Location')</label>
                                <input type="text" name="location" class="form-control"
                                        placeholder="@lang('layout.Location')">
                            </div>
                            <div class="col-md-8" style="padding: 0px !important;">
                                <div class="col-md-4">
                                    <label class="control-label">@lang('layout.Category')</label>
                                    <v-select class="vue-select2" v-model="selectedCategory" label="name" :options="{{$projectCategory}}">
                                    </v-select>
                                    <input type="hidden" name="category_id" v-model.number="(!selectedCategory)?null:selectedCategory.id">
                                </div>
                                <div class="col-md-4">
                                    <label class="control-label">@lang('layout.StartDate')</label>
                                    <input type="text" class="form-control date" autocomplete="off"
                                            name="start_date">
                                </div>
                                <div class="col-md-4">
                                    <label class="control-label">@lang('layout.EndDate')</label>
                                    <input type="text" class="form-control date" name="end_date">
                                </div>
                            </div>
                            <div class="col-md-12" style="padding: 0px !important;">
                                <div class="col-md-4 col-sm-12">
                                    <label class="control-label">@lang('layout.Currency')</label>
                                    <v-select label="code" :options="currency" v-model="selected_currency"></v-select>
                                    <input type="hidden" name="currency" :value="selected_currency.code">
                                </div>

                                <div class="col-md-3 col-sm-12">
                                    <label class="control-label">@lang('layout.Rate')</label>
                                    <input type="number" name="rate" v-model="!selected_currency?0:selected_currency.rate" class="form-control" >
                                </div>
                                <div class="col-md-5 col-sm-12">
                                    <label class="control-label">@lang('layout.Amount')</label>
                                    {{Form::number('amount',null,['class' => 'form-control'])}}
                                </div>
                            </div>
                                <div class="col-md-12" style="padding: 0px !important;">
                                    <div class="col-md-4">
                                        <label class="control-label">@lang('layout.Status')</label>
                                        <select name="status" class="form-control">
                                            <option value="on">@lang('layout.Active')</option>
                                            <option value="pending">@lang('layout.Pending')</option>
                                            <option value="off">@lang('layout.InActive')</option>
                                        </select>
                                    </div>
                                    <div class="col-md-6">
                                        <label class="control-label">@lang('layout.Description')</label>
                                        {!! Form::textarea('description', null, array('placeholder' => __('layout.Description'),'class' => 'form-control','rows' => 2, 'cols' => 30)) !!}
                                    </div>
                                </div>
                        </div> 
                        
                        <div class="col-md-12">    
                            <!-- begin donator -->
                            <table id="table_content" class="table table-striped table-bordered table-advance table-hover">
                                <thead>
                                <tr>
                                    <th class="text-center" style="min-width: 8px;"> #</th>
                                    <th class="text-center" style="min-width: 160px;">@lang('layout.Donator')</th>
                                    <th class="text-center" style="min-width: 160px;">@lang('layout.Description')</th>
                                    <th></th>

                                </tr>
                                </thead>
                                <tbody>
                                <tr v-for="(record,index) in donatorData">
                                    <td>@{{index+1}}</td>
                                    <td class="highlight">
                                        <v-select label="name" v-model="record.selected" :options="(record.donator_list)"
                                                @click.native="addNew('donator',index)"
                                                placeholder="@lang('layout.Select')">

                                        </v-select>
                                        <input type="hidden" name="donator_id[]"
                                            :value="(record.selected==null)?null:record.selected.id">
                                    </td>

                                    <td>
                                        <input class="form-control" type="text" name="don_description[]"
                                            v-model.number="record.description" placeholder="@lang('layout.Description')">
                                    </td>

                                    <td>
                                        <span v-on:click="deleteItem('donator',index)"><i
                                                    class="paddint-both glyphicon glyphicon-trash"></i></span>
                                    </td>
                                </tr>
                                </tbody>
                            </table>
                            <!-- end donator -->
                        </div>  
                        </div>  
                    </div>
                    <div class="col-xs-12 col-sm-10 col-md-11 text-center">
                        <button type="button" class="btn green" onclick="regForm(this)"> @lang('layout.Submit') </button>
                        <button href="{{url('nGOProject.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel') </button>
                    </div>  
                {!! Form::close() !!}
            </div>                  
            <!-- END FORM-->
        </div>
    </div> 
@endsection
 
@push('scripts')
<script>

    Vue.component('v-select', VueSelect.VueSelect);
    var donator = {!! $shareholder !!};
    var currency = {!! $currency!!}
    var homeCurrency = {!! $homeCurrency !!};

    let vu = new Vue({
    el: '#app',
    data:{
        currency: currency,
        selected_currency: homeCurrency,
        selectedCategory: null,
        donator: donator,
        donatorData: [
            {description: null, donator_list: donator, selected: null},
            {description: null, donator_list: donator, selected: null},
        ],
    },
    methods:{
        addClass(){
            
        },

        // generic function for adding item to list
        addNew(type = null, index) {
            if (type != null) {
                if (type == 'donator') {
                    if (this.donatorData[index + 1] == undefined) {
                        this.donatorData.push({description: null, donator_list: this.donator, selected: null});
                    }
                }
            }

        },

        // delete item from list
        deleteItem(type = null, index) {
            if (type != null) {
                if (type == 'donator') {
                    this.donatorData.splice(index, 1);
                }
            }

        },
    }
    });


</script>

@endpush