@extends('layouts.factor-master')

@section('content')

    <?php
    $report = customeReportNew('ngo_project_index');

    $_code = !in_array('code', $report);
    $_name = !in_array('name', $report);
    $_description = !in_array('description', $report);
    $_start_date = !in_array('start_date', $report);
    $_end_date = !in_array('end_date', $report);
    $_location = !in_array('location', $report);
    $_date = !in_array('date', $report);
    $_ref_no = !in_array('ref_no', $report);
    $_category = !in_array('category', $report);
    $_donator = !in_array('donator', $report);
    $_description = !in_array('description', $report);


    $report_percent = customeReportNewPercent('ngo_project_index');
    $_code_percent= (array_key_exists('code___percent', $report_percent))?$report_percent['code___percent']:null;
    $_name_percent= (array_key_exists('name___percent', $report_percent))?$report_percent['name___percent']:null;
    $_description_percent= (array_key_exists('description___percent', $report_percent))?$report_percent['description___percent']:null;
    $_start_date_percent= (array_key_exists('start_date___percent', $report_percent))?$report_percent['start_date___percent']:null;
    $_end_date_percent= (array_key_exists('end_date___percent', $report_percent))?$report_percent['end_date___percent']:null;
    $_date_percent= (array_key_exists('date___percent', $report_percent))?$report_percent['date___percent']:null;
    $_ref_no_percent= (array_key_exists('ref_no___percent', $report_percent))?$report_percent['ref_no___percent']:null;
    $_category_percent= (array_key_exists('category___percent', $report_percent))?$report_percent['category___percent']:null;
    $_donator_percent= (array_key_exists('donator___percent', $report_percent))?$report_percent['donator___percent']:null;
    $_location_percent= (array_key_exists('location___percent', $report_percent))?$report_percent['location___percent']:null;



    ?>

<h3 class="table-caption" style="text-align: center;">@lang('layout.NGOProjectReport')</h3>
<table class="main-table">

<thead>
<tr class="bg" >
   @if($_code)<td class="center"  @if($_code_percent) width="{{$_code_percent}}%" @endif><div > @lang('layout.Code') </div></td>@endif
   @if($_ref_no)<td class="center"  @if($_ref_no_percent) width="{{$_ref_no_percent}}%" @endif><div > @lang('layout.ReferenceNumber')</div></td>@endif
   @if($_date)<td class="center"  @if($_date_percent) width="{{$_date_percent}}%" @endif><div > @lang('layout.Date')</div></td>@endif 
   @if($_description)<td class="center"  @if($_description_percent) width="{{$_description_percent}}%" @endif><div > @lang('layout.Description')</div></td>@endif
   @if($_name)<td class="center"  @if($_name_percent) width="{{$_name_percent}}%" @endif><div > @lang('layout.ProjectName')</div></td>@endif
   <td class="center" ><div > @lang('layout.Amount')</div></td>
   <td class="center" ><div > @lang('layout.Currency')</div></td>
   @if($_start_date)<td class="center"  @if($_start_date_percent) width="{{$_start_date_percent}}%" @endif><div > @lang('layout.StartDate')</div></td>@endif
   @if($_end_date)<td class="center"  @if($_end_date_percent) width="{{$_end_date_percent}}%" @endif><div > @lang('layout.EndDate')</div></td>@endif
   @if($_location)<td class="center"  @if($_location_percent) width="{{$_location_percent}}%" @endif><div > @lang('layout.Location')</div></td>@endif
   @if($_category)<td class="center"  @if($_category_percent) width="{{$_category_percent}}%" @endif><div > @lang('layout.Category')</div></td>@endif 
   <td class="center" ><div > @lang('layout.Percent')</div></td> 
   <td class="center" ><div > @lang('layout.Status')</div></td> 
   <td class="center" ><div > @lang('layout.User')</div></td> 
   @if($_donator)<td  class="center" @if($_donator_percent) width="{{$_donator_percent}}%" @endif><div > @lang('layout.Donator')</div></td>@endif 
   
</tr>
</thead>
<?php
$count = 0;

?>

@foreach($data AS $record)
<tr>

@if($_code)<td class="center">{{$record['code']}}</td>@endif
@if($_ref_no)<td class="center">{{$record['ref_no']}}</td>@endif
@if($_date)<td class="center">{{convertDate($record['date'])}}</td>@endif
@if($_description)<td style="@if($_description_percent) text-align: justify @endif">{{$record['description']}}</td>@endif
@if($_name)<td style="text-align: justify">{{$record['name']}}</td>@endif
<td class="center">{{$record['amount']}}</td>
<td class="center">{{$record['currency']}}</td>
@if($_start_date)<td class="center">{{convertDate($record['start_date'])}}</td>@endif
@if($_end_date)<td class="center">{{convertDate($record['end_date'])}}</td>@endif
@if($_location)<td class="center">{{$record['location']}}</td>@endif
@if($_category)<td class="center"> {{$record['category']}}</td>@endif
<td class="center"> {{$record['percent']}} %</td>
<td class="center">
    @if($record['status'] == "on")
        <div style="color:green"> @lang("layout.Active") </div>
    @elseif($record['status'] == "pending")
        <div style="color:blue"> @lang("layout.Pending") </div>
    @else
        <div> @lang("layout.InActive") </div>
    @endif
</td>
<td > {{$record['user']}}</td>
@if($_donator)<td class="center">
  <table class="main-table">
      <tr>
       <td style="font-weight: bold;"><div class="center"> @lang('layout.Name') </div></td>
       <td style="font-weight: bold;"><div class="center"> @lang('layout.Description') </div></td>
      </tr>
      <?php
      $count=0;
      if (count($record['donators']) > 0) {
     
      foreach($record['donators'] As $don )
      {
        ?>
        <tr>
          <td><div class="center">{{$don['name']}}</div></td>
          <td><div class="center">{{$don['description']}}</div></td>
        </tr>
        <?php
      }
      }
      ?>
  </table>

</td>@endif

</tr>
@endforeach

</table>

 <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->
@endsection

