@extends('layouts.factor-master')

@section('content')
<?php
$report = customeReport('contract', 'index');
?>

<h3 class="table-caption" style="text-align: center;">@lang('layout.ReceiveAndPaymentReport')</h3>
<table class="main-table">
    <thead>
        <tr class="bg">
            <th>@lang('layout.Number')</th>
            <th>@lang('layout.ReferenceNumber')</th>
            <th>@lang('layout.Member')</th>
            <th>@lang('layout.Project')</th>
            <th>@lang('layout.Date') </th>
            <th>@lang('layout.Currency') </th>
            <th>@lang('layout.Rate') </th>
            <th>@lang('layout.Total')</th>
            <th>@lang('layout.Category')</th>
            <th>@lang('layout.Priority')</th>
            <th>@lang('layout.DateRequired') </th>
            <th>@lang('layout.User') </th>
            <th>@lang('layout.Description') </th>
        </tr>
    </thead>
    <tbody>
        <tr>
            <td class="hidden-xs"> {{ $data->number}}  </td>
            <td class="hidden-xs"> {{ $data->ref_no}}  </td>
            <td class="hidden-xs"> {{ $data->member}}  </td>
            <td class="hidden-xs"> {{ $data->project}}</td>
            <td class="hidden-xs"> {{ $data->date}}</td>
            <td class="hidden-xs"> {{ $data->currency}}</td>
            <td class="hidden-xs"> {{ $data->currency_rate}}</td>
            <td class="hidden-xs"> {{ myRound($data->price)}}</td>
            <td class="hidden-xs"> {{ $data->category}}</td>
            <td class="hidden-xs"> {{ __('type.'.$data->priority)}}</td>
            <td class="hidden-xs"> {{ $data->requir_date}}</td>
            <td class="hidden-xs"> {{ $data->user}}</td>
            <td class="hidden-xs"> {{ $data->description}}</td>
        </tr>
    </tbody>
    <thead>
        <tr>
            <th></th>
            <th>@lang('layout.Type')</th>
            @if($data->type == 'VehicleExpenses')
            <th>@lang('layout.Driver')</th>
            <th>@lang('layout.VehicleName')</th>
            <th>@lang('layout.PaletNumber')</th>
            @endif
        </tr>
        </thead>
    <tbody> 
        <tr>  
            <td class="hidden-xs"></td>
            <td class="hidden-xs"> {{ __('layout.'.$data->type)}}</td>
            @if($data->type == 'VehicleExpenses')
            <td class="hidden-xs"> {{ $data->driver_name}}  </td>
            <td class="hidden-xs"> {{ $data->vehicle_name}}  </td>
            <td class="hidden-xs"> {{ $data->palet_number}}  </td>
            @endif
        </tr>
    </tbody>
</table>
<hr />

<h3>@lang('layout.Request')</h3>
<table class="main-table">
    <tr class="bg">
        <th> @lang('layout.Record') </th>
        <th>@lang('layout.Name')</th>
        <th>@lang('layout.Description')</th>
        <th>@lang('layout.Quantity')</th>
        <th>@lang('layout.Measure')</th>
        <th>@lang('layout.Price')</th>
        <th>@lang('layout.Total')</th>
    </tr>
    <?php
    $count = 0;
    ?>
    @foreach($proOrderDetail AS $record1)
    <tr>
        <td class="center">{{++$count}}</td>
        <td class="center">{{$record1->name}}</td>
        <td class="center">{{$record1->description}}</td>
        <td class="center">{{$record1->quantity}}</td>
        <td class="center">{{$record1->measure_name}}</td>
        <td class="center">{{myRound($record1->price)}}</td>
        <td class="center">{{myRound($record1->price * $record1->quantity)}}</td>
    </tr>
    @endforeach
</table>
<hr />

<h3>@lang('layout.Approveres')</h3>
<table class="main-table">
    <thead>
        <tr class="bg">
            <th> @lang('layout.Record') </th>
            <th>@lang('layout.Type')</th>
            <th>@lang('layout.User')</th>
            <th>@lang('layout.PositionName')</th>
            <th>@lang('layout.Signature')</th>
            <th>@lang('layout.Date')</th>
            <th>@lang('layout.Description')</th>
        </tr>
    </thead>
    <?php
    $count = 0;
    ?>
    @foreach($proOrderMemo AS $record2)
    <tr>
        <td class="center">{{++$count}}</td>
        <td class="hidden-xs"> {{ __('type.'.$record2->type)}}</td>
        <td class="hidden-xs"> {{ $record2->user}}</td>
        <td class="hidden-xs"> {{ $record2->position_name }}</td>
        <td class="hidden-xs">
            <center>
            @if($record2->signature)
            <a href="{!! asset('uploads/' . $record2->signature) !!} " target='_blank'>
                <img src="{!! asset('uploads/' . $record2->signature) !!}" class='img-responsive' style='max-width:120px; max-height:100px;'>
            </a>
            @endif 
            </center>   
        </td>
        <td class="hidden-xs"> {{ convertDate($record2->date) }}</td>
        <td class="hidden-xs"> {{ $record2->description}}</td>
    </tr>
    @endforeach
</table>


@endsection