@extends('layouts.app')
@section('style')
<link href="{{url('css/custome-table.css')}}" rel="stylesheet">
@stop
@section('content')
<div class="row">

    <div class="portlet light bg-inverse">
        <div class="portlet-title">
            <div class="caption">
                <i class="icon-equalizer font-green-haze"></i>&nbsp;
                <span class="caption-subject font-green-haze bold uppercase">@lang('layout.ReceiveAndPaymentCreate') </span>
                <!-- <span class="caption-helper">some info...</span> -->
            </div>
        </div>
        <div class="portlet-body form" style="margin-bottom: 50%;" id="app">
            <!-- BEGIN FORM-->
            {!! Form::model($nProOrder,['method' => 'PATCH','route' => ['nProOrdReceiveAndPay.storeFromOrder',$nProOrder->id],'class'=>'form-horizontal']) !!}
            {{ csrf_field() }}
            <div class="form-body">
                <div class="row">
                    <div class="col-md-10">
                        <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                            <div class="form-group">
                                <div class="col-md-12 ">
                                    <label class="control-label">@lang('layout.ExpenseType') </label>
                                    {{Form::select('pay_type',['writeCheck' => __('layout.Writecheck'),'bill' => __('layout.Bill')],'Accounts Receivable',[ 'v-model'=>'expenseType','class'=>'form-control select_style',"v-validate"=>"'required'","data-vv-as"=>__('layout.ExpenseType')])}}
                                    <span class="required">@{{errors.first('type')}}</span>
                                </div>

                            </div>
                        </div>
                        <div class="col-md-2">
                            <label class="control-label">@lang('layout.Number')</label>
                            <input type="text" name="number" value="{{$number}}" class="form-control">
                        </div>
                        <div class="col-md-4">
                            <label class="control-label">@lang('layout.Project')</label>
                            <v-select class="vue-select2" v-model="selectedProject" label="name" :options="{{$projects}}">
                            </v-select>
                            <input type="hidden" name="project_id" v-model.number="(!selectedProject)?null:selectedProject.id">
                        </div>
                        <div class="col-md-4">
                            <label class="control-label">@lang('layout.RequestorName')</label>
                            <v-select class="vue-select2" v-model="selectedEmployee" label="name" :options="{{$employee}}">
                            </v-select>
                            <input type="hidden" name="employee_id" v-model.number="(!selectedEmployee)?null:selectedEmployee.id">
                        </div>
                        <div class="col-md-12" style="padding: 0px;">
                            <div class="col-md-4">
                                <label class="control-label">@lang('layout.Currency')</label>
                                <v-select label="code" :options="setRates" v-model="selectedCurrency">
                                </v-select>
                                <input type="hidden" name="currency" :value="selectedCurrency.code" />
                            </div>
                            <div class="col-md-2">
                                <label class="control-label">@lang('layout.Rate')</label>
                                <div class="input-group">
                                    <input v-model="selectedCurrency.exchange_rate" class="form-control" type="number" min="0" step="any">
                                    <span class="input-group-addon">@{{selectedCurrency.symbol}}</span>
                                </div>
                                <input type="hidden" name="currency_rate" :value="selectedCurrency.exchange_rate">
                            </div>
                            <div v-if="expenseType == 'writeCheck'" class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                                <div class="form-group">
                                    
                                    <div class="col-md-12">
                                        <label class="control-label">@lang('layout.Amount') </label>
                                        <span class="form-control" >@{{((!selectedBank)?0:selectedBank.balance-subtotal)}}</span>
                                    </div>
                                </div>
                            </div>
                            <div v-if="expenseType == 'writeCheck'" class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                <div class="form-group">

                                    <div class="col-md-12">
                                        <label class="control-label">@lang('layout.Account') </label>
                                        <select class="form-control select_style" name="bank_account" v-model="defaultAccount"
                                                v-on:change="test(defaultAccount)">
                                            <option v-for="Account in accountUpdate" :value="Account.id">@{{
                                                Account.name }}
                                            </option>
                                        </select>

                                    </div>
                                </div>
                            </div>
                            <div v-if="expenseType == 'bill'" class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                <div class="form-group">
                                    <div class="col-md-12">
                                        <label class="control-label">@lang('layout.Vendor')</label>
                                        <v-select label="name" v-model="customer" :options="customerList">
                                        </v-select>
                                        <input type="hidden" name="vendor" :value="(customer)?customer.id:null"
                                                v-validate="'required'" data-vv-as="@lang('layout.Vendor')">
                                        <span class="required">@{{errors.first('vendor')}}</span>

                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-12" style="padding: 0px;">
                            <div class="col-md-3">
                                <label class="control-label">@lang('layout.Date')</label>
                                <input type="text" class="form-control date" value="{{$nProOrder->date}}" autocomplete="off" name="date">
                            </div>
                            <div class="col-md-3">
                                <label class="control-label">@lang('layout.DateRequired')</label>
                                <input type="text" class="form-control date" name="requir_date" value="{{$nProOrder->requir_date}}" autocomplete="off">
                            </div>
                            <div class="col-md-3">
                                <label class="control-label">@lang('layout.ReferenceNumber')</label>
                                <input type="text" name="ref_no" value="{{$nProOrder->ref_no}}" class="form-control">
                            </div>
                            @if(systemConfig()[20] == 1)
                            <div class="col-md-3">
                                <label class="control-label">@lang('layout.ContractName')</label>
                                <v-select class="vue-select2" placeholder="@lang('layout.Select')" v-model="selectedContract" label="company_name" :options="{{$contract}}">
                                </v-select>
                                <input type="hidden" name="contract_id" v-model.number="(!selectedContract)?null:selectedContract.id" />
                            </div>
                            @endif
                        </div>
                        
                        <div class="col-md-4">
                            <label class="control-label">@lang('layout.Expense')</label>
                            <v-select label="name" :options="expenses" v-model="selected_expense_account" ></v-select>
                            <input type="hidden" name="expense_id" v-bind:value="(!selected_expense_account)?null:selected_expense_account.id" v-validate="'required'" data-vv-as="@lang('layout.Expense')" />
                            <span class="required">@{{errors.first('expense_id')}}</span>
                        </div>
                        <div class="col-md-4">
                            <label class="control-label">@lang('layout.Priority')</label>
                            <select name="priority" v-model="priority" class="form-control">
                                <option value="High">@lang('type.High')</option>
                                <option value="Medium">@lang('type.Medium')</option>
                                <option value="Low">@lang('type.Low')</option>
                            </select>
                        </div>

                        <div class="col-md-4">
                            <label class="control-label">@lang('layout.Description')</label>
                            {!! Form::textarea('description', null, array('placeholder' => __('layout.Description'),'class' => 'form-control','rows' => 1, 'cols' => 30)) !!}
                        </div>
                        <div class="col-md-12" style="padding: 0px;" >
                            <div class="col-md-4">
                                <label class="control-label">@lang('layout.Type')</label>
                                <select name="type" v-model="type" class="form-control">
                                    <option value="Simple">@lang('layout.Simple')</option>
                                    <option value="VehicleExpenses">@lang('layout.VehicleExpenses')</option>
                                </select>
                            </div>
                            <div class="col-md-4" v-show="type == 'VehicleExpenses'" >
                                <label class="control-label">@lang('layout.Transporter_name')</label>
                                <v-select class="vue-select2" v-model="selectedDriver" label="name" :options="{{$allDrivers}}">
                                </v-select>
                                <input type="hidden" name="driver_id" v-model.number="(!selectedDriver)?null:selectedDriver.id">
                            </div>
                            <div class="col-md-4" v-show="type == 'VehicleExpenses'" >
                                <label class="control-label">@lang('layout.VehicleName')</label>
                                <v-select class="vue-select2" v-model="selectedVehicle" label="name" :options="{{$vehicle}}">
                                </v-select>
                                <input type="hidden" name="vehicle_id" v-model.number="(!selectedVehicle)?null:selectedVehicle.id">
                            </div>
                        </div>

                    </div>

                    <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                        <!-- begin total -->
                        <div class="dashboard-stat2" style="padding-bottom: 30px !important;">

                            <table class="dashboard-tabel table-bordered" width="100%">

                                <tbody>
                                    <span>
                                        <tr>
                                            <td class="highlight">
                                                @lang('layout.Total')
                                            </td>
                                            <td>
                                                @{{subtotal}}
                                            </td>
                                        </tr>
                                    </span>
                                </tbody>
                            </table>
                        </div>
                    </div>

                    <div class="col-md-12">
                        <div v-if="items.length >0 " class="row">
                            <li class="list-group-item bg-green bg-font-green"> @lang('layout.Request') </li>
                            <div class="table-responsive333">
                                <table id="table_content" class="table table-bordered table-advance table-hover">
                                    <thead>
                                        <tr>
                                            <th class="text-center" style="min-width: 6px;">#</th>
                                            <th class="text-center" style="min-width: 100px;">@lang('layout.Description')</th>
                                            <th class="text-center" style="min-width: 50px;"> @lang('layout.Quantity')</th>
                                            <th class="text-center" style="min-width: 50px;"> @lang('layout.Measure')</th>
                                            <th class="text-center" style="min-width: 40px;"> @lang('layout.Price')</th>
                                            <th class="text-center" style="min-width: 60px;"> @lang('layout.Total')</th>
                                            <th style="min-width: 20px;"></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr v-for="(rows,index) in items" class="even">
                                            <td class=""> @{{index+1}} </span>
                                            </td>
                                            <td class="highlight">
                                                <input type="text" name="name[]" v-model.number="(!rows)?null:rows.description" class="form-control" @click="addNew('item',index)" autocomplete="off" >
                                            </td>
                                            <td>
                                                <input type="number" placeholder="@lang('layout.Quantity')" name="quantity[]" v-model.number="(!rows)?null:rows.quantity" class="form-control">
                                            </td>
                                            <td>
                                                <select name="um_id[]" v-model.number="(!rows)?null:rows.um_id" class="form-control">
                                                    <option value="null">@lang('layout.Select')</option>
                                                    <option v-for="measure in measureList" :value="measure.measure_id">
                                                        @{{measure.measure_name}}
                                                    </option>
                                                </select>
                                            </td>
                                            <td>
                                                <div class="input-group input_style">
                                                    <input type="number" name="price[]" class="form-control" placeholder="@lang('layout.Price')" v-model.number="(!rows)?null:rows.price">
                                                    <span class="input-group-addon">
                                                        <b>@{{selectedCurrency.symbol}}</b>
                                                    </span>
                                                </div>
                                            </td>
                                            <td>
                                                <div class="input-group input_style">
                                                    <input type="" class="form-control inner_input" placeholder="@lang('layout.Total')" :value="(!rows)?null:rows.quantity * (rows.price)" disabled>
                                                    <span class="input-group-addon">
                                                        <b>@{{selectedCurrency.symbol}}</b>
                                                    </span>
                                                </div>
                                            </td>
                                            <td>
                                                <span v-on:click="deleteItem('item',index)"><i class="paddint-both glyphicon glyphicon-trash"></i></span>
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-12">
                        <div v-if="fixedAssetData.length >0 " class="row">
                            <li class="list-group-item bg-green bg-font-green"> @lang('layout.Request') @lang('layout.FixedAsset') </li>
                            <div class="table-responsive333">
                                <!-- begin fixedAsset -->
                                <table id="table_content" class="table table-striped table-bordered table-advance table-hover">
                                    <thead>
                                        <tr>
                                            <th class="text-center" style="min-width: 8px;">#</th>
                                            <th class="text-center" style="min-width: 160px;">@lang('layout.FixedAsset')</th>
                                            <th class="text-center" style="min-width: 160px;">@lang('layout.Description')</th>
                                            <th></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr v-for="(record,index) in fixedAssetData">
                                            <td>@{{index+1}}</td>
                                            <td class="highlight">
                                                <v-select label="name" v-model="record.selected" :options="(record.fixedAsset_list)" @click.native="addNew('fixedAsset',index)" @input="checkExistingService(index)" placeholder="@lang('layout.Select')">

                                                </v-select>
                                                <input type="hidden" name="fixedAsset_id[]" :value="(record.selected==null)?null:record.selected.id">
                                            </td>

                                            <td>
                                                <input class="form-control" type="text" name="fixedAsset_description[]" v-model.number="record.description" placeholder="@lang('layout.Description')">
                                            </td>

                                            <td>
                                                <span v-on:click="deleteItem('fixedAsset',index)"><i class="paddint-both glyphicon glyphicon-trash"></i></span>
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                                <!-- end fixedAsset -->
                            </div>
                        </div>
                    </div>

                    <div class="col-md-12">
                        <div class="row">
                            <li class="list-group-item bg-green bg-font-green"> @lang('layout.Request') @lang('layout.Procurement') </li>
                            <div v-if="inventories.length>0" >
                                <table id="table_content" class="table table-bordered table-advance">
                                    <thead>
                                        <tr>
                                            <th class="text-center" style="min-width: 8px;"> # </th>
                                            <th class="text-center" style="min-width: 160px;">@lang('layout.ItemName')</th>
                                            <th class="text-center" style="min-width: 120px;">@lang('layout.SiteName') </th>
                                            <th class="text-center" style="min-width: 80px;"> @lang('layout.Quantity')</th>
                                            <th class="text-center" style="min-width: 60px;"> @lang('layout.OnHand')</th>
                                            <th class="text-center" style="min-width: 120px;"> @lang('layout.Measure')</th>
                                            <th class="text-center" style="min-width: 120px;"> @lang('layout.Description')</th>
                                            <th class="text-center" style="min-width: 40px;">@lang('layout.Total')</th>
                                            <th style="min-width: 20px;"></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr v-for="(item,index) in inventories">
                                            <td>@{{index+1}}</td>
                                            <td class="highlight">
                                                <v-select label="name" v-model="item.item" :options="temp_items" @search="onItemSearch"  @Click.native="addNew('inventory',index)" ></v-select>
                                                <input type="hidden" name="inventory_id[]" :value="(!item.item)?null:item.item.id">
                                            </td>
                                            <td class="highlight">
                                                <select v-model="(item.item==null)?null:item.item.site" class="form-control">
                                                    <option value="null">@lang('layout.Select')</option>
                                                    <span v-if="(item.item != null)">
                                                        <option v-for="site in (item.item==null)?null:item.item.site_list" :value="site">
                                                            @{{site.site_name}}
                                                        </option>
                                                    </span>
                                                </select>

                                                <input type="hidden" name="inventory_site[]" :value="(item.item==null)?null:((item.item.site==null)?null:item.item.site.site_id)">
                                            </td>
                                            <td>
                                                <input type="number" name="inventory_quantity[]" v-model.number="(item.item==null)?null:item.item.quantity" @click="addNew('inventory',index)" class="form-control input-style input-number" placeholder="@lang('layout.Quantity')">
                                            </td>

                                            <td>
                                                @{{myRound((item.item==null)?null:saleItemQuantity(item.item,item.item.quantity))}}
                                            </td>
                                            <td class="highlight">
                                                <select v-model="(item.item == null)?null:item.item.measure" class="form-control" @change="measureChange(index)">
                                                    <option value="null">@lang('layout.Select')</option>
                                                    <span v-if="(item.item ==null)?false:true">
                                                        <option v-for="measure in (item.item==null)?null:item.item.measure_list" :value="measure">
                                                            @{{measure.measure_name}}
                                                        </option>
                                                    </span>
                                                </select>
                                                <input type="hidden" name="inventory_measure[]" :value="(item.item==null)?null:item.item.measure.measure_id">
                                            </td>
                                            <td>
                                            <input class="form-control" type="text" name="inventory_description[]" v-model.number="(item.item==null)?null:item.item.description"  placeholder="@lang('layout.Description')">
                                            </td>
                                            <td>
                                                <div class="input-group">
                                                    <input type="hidden" name="inventory_cost[]" placeholder="@lang('layout.Cost')" :value="(item.item==null)?null:(item.item.new_rate)" ref="in" @input="setNewRate('inventory',index)" class="form-control">
                                                    @{{(item.item==null)?null:myRound((item.item.new_rate)*((item.item==null)?null:item.item.quantity))}}
                                                </div>
                                            </td>
                                            <td>
                                                <span v-on:click="deleteItem('inventory',index)"><i class="paddint-both glyphicon glyphicon-trash"></i></span>
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>

                    <span v-if="expenseType == 'bill'">
                        <div v-if="payments.length >0  " class="row col-md-12">
                        <!-- begin Receive -->
                        <table id="table_content" class="table table-striped table-bordered table-advance table-hover">
                            <thead>
                                <tr>
                                    <th class="text-center" style="min-width: 8px;"> #</th>
                                    <th class="text-center" style="min-width: 160px;">@lang('layout.SelectBank')</th>
                                    <th class="text-center" style="min-width: 100px;"> @lang('layout.Amount')</th>
                                    <th class="text-center" style="min-width: 120px;"> @lang('layout.Rate')</th>
                                    <th class="text-center" style="min-width: 80px;">@lang('layout.Currency')</th>
                                    <th class="text-center" style="min-width: 80px;"> @lang('layout.Amount')</th>
                                    <th class="text-center" style="min-width: 120px;">@lang('layout.Total')</th>

                                    <th class="text-center" style="min-width: 120px;">@lang('layout.Description')</th>

                                    <th></th>

                                </tr>
                            </thead>
                            <tbody>
                                <tr v-for="(payment,index) in payments">
                                    <td>@{{index+1}}</td>

                                    <td class="highlight">
                                        <v-select label="name" v-model="payment.item" :options="(payment.items)" @click.native="addNew('payment',index)" @input="checkExistingPayment(index)">

                                        </v-select>
                                        <input type="hidden" v-if="payment.item !=null" name="payment_id[]" :value="(payment.item==null)?null:payment.item.id">
                                    </td>

                                    <td>

                                        <span v-if="payment.item !=null">
                                            @{{myRound(Number((payment.item==null)?null:payment.item.balance)-Number((payment.item==null)?null:payment.item.amount))}}
                                        </span>
                                    </td>
                                    <td>
                                        <input v-bind:disabled="(payment.item==null)?false:(payment.item.code =='{{getHomeCurrency()["code"]}}')" type="number" v-model.number="(payment.item==null)?null:payment.item.rate " class="form-control" placeholder="@lang('layout.Rate')" />
                                        <input v-if="payment.item !=null" type="hidden" name="payment_rate[]" v-bind:value="payment.item.rate">
                                    </td>
                                    <td>
                                        <input type="text" name="payment_currency[]" class="form-control" v-model="(payment.item==null)?null:payment.item.code" placeholder="@lang('layout.Currency')" disabled reqiured />

                                        <input v-if="payment.item !==null" type="hidden" name="payment_currency[]" v-bind:value="payment.item.code" />
                                    </td>

                                    <td>
                                        <div class="input-group">
                                            <input type="number" class="form-control" v-model.number="(payment.item==null)?null:payment.item.amount " placeholder="@lang('layout.PayAmount')" />

                                            <input v-if="payment.item !=null" type="hidden" name="payment_amount[]" v-bind:value="payment.item.amount">

                                            <span class="input-group-addon">@{{(payment.item==null)?null:payment.item.code}}</span>
                                        </div>
                                    </td>
                                    <td>
                                        @{{ (payment.item==null)?null:totalPayment(payment.item,selectedCurrency.rate,selectedCurrency.hq_rate).result }}
                                        @{{selectedCurrency.symbol}}
                                    </td>

                                    <td>
                                        <textarea class="form-control" name="payment_description[]" rows="2" placeholder="@lang('layout.Description')">@{{(payment.item==null)?null:payment.item.description}}</textarea>
                                    </td>


                                    <td>
                                        <span v-on:click="deleteItem('payment',index)">
                                            <i class="paddint-both glyphicon glyphicon-trash"></i>
                                        </span>
                                    </td>
                                </tr>
                            </tbody>

                        </table>
                        <!-- end Receive -->
                    </div>
                    </span>

                </div>
            </div>
            <div class="col-xs-12 col-sm-10 col-md-11 text-center">
                <button type="button" class="btn green" @click="handleSubmit($event)" > @lang('layout.Submit') </button>
                <button href="{{url('nProOrder.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel') </button>
            </div>
            {!! Form::close() !!}
        </div>
        <!-- END FORM-->
    </div>
</div>
@endsection

@push('scripts')
<script>

    @if(App::getLocale())
    Vue.use(VeeValidate, {
        locale: '{{App::getLocale()}}',
    });
    @else
    Vue.use(VeeValidate, {
        locale: 'en',
    });
    @endif

    Vue.use(VeeValidate);

    Vue.component('v-select', VueSelect.VueSelect);
    var currency ={!! $currency !!};
    let homeCurrency = {!! $homeCurrency !!};
    let ratesFetched = {!! $rates !!};
    var measureList = {!!$measureList!!}; 
    var category = {!!$category!!}; 
    var projects = {!!$projects!!}; 
    var employee = {!!$employee!!}; 
    var proOrderDetails = {!!$proOrderDetails!!}; 
    var proOrderDetailAsset = {!!$proOrderDetailAsset!!}; 
    var proOrderDetailInventory = {!!$proOrderDetailInventory!!}; 
    var allDrivers = {!!$allDrivers!!}; 
    var vehicle = {!!$vehicle!!}; 
    var position = {!!$position!!}; 
    var CustomerAll ={!! $customer !!}
    var AllAccounts = {!! $all_accounts!!};
    var Banks ={!! $banks!!}
    var Account = {!! $allBank !!};
    let bankes = {!! $bankes !!};
    let expense = {!! $expense !!};
    var fixedAsset = {!!$fixedAsset!!}; 

    let vu = new Vue({
        el: '#app',
        data: {
            selectedCategory: null,
            selectedProject: null,
            selectedEmployee: null,
            selectedDriver: null,
            selectedVehicle: null,
            selected_position: null,
            memo_description: null,
            selectedContract: null,
            type: '{{$nProOrder->type}}',
            priority: '{{$nProOrder->priority}}',
            items: [],
            currency: currency,
            selectedCurrency: homeCurrency,
            measureList: measureList,
            category: category,
            proOrderDetails: proOrderDetails,
            expenseType: 'writeCheck',
            selected_expense_account:null,
            expenses: expense,
            payments: [{items: bankes, item: null}],
            customer: null,
            customerList: CustomerAll,
            account: {},
            bankes: bankes,
            selectedBank: null,
            defuilt_banks: null,
            defaultValue: 0,
            defaultAmount: 0,
            defaultAccount: 0,
            amount: null,
            proOrderDetailAsset: proOrderDetailAsset,
            proOrderDetailInventory: proOrderDetailInventory,
            fixedAsset: fixedAsset,
            fixedAssetData: [],
            inventories:[],
            temp_items:[],
        },
        computed: {
            setRates() {

                let rates = [];
                this.currency.forEach((b) => {
                    ratesFetched.forEach((a) => {

                        if (a.currency_id == b.id) {
                            rates.push({
                                name: a.name,
                                code: a.code,
                                symbol: a.symbol,
                                rate: a.rate != null ? Number.parseFloat(a.rate) : 1,
                                exchange_rate: a.rate != null ? Number.parseFloat(a.rate) : 1,
                                hq_rate: a.hq_rate != null ? Number.parseFloat(a.hq_rate) : 1,
                                currency: b.id,
                                id: b.id
                            });
                        }
                    })
                });

                this.currency.forEach((a) => {
                    let found = false;
                    rates.forEach((b) => {
                        if (a.id == b.id) {
                            found = true;
                            return;
                        }
                    });

                    if (!found) {
                        rates.push({
                            name: a.name,
                            code: a.code,
                            symbol: a.symbol,
                            rate: 1,
                            exchange_rate: 1,
                            hq_rate: 1,
                            currency: a.id,
                            id: a.id
                        })
                    }
                });

                return rates;
            },
            subtotal: function() {
                var sum = 0;
                for (var i = 0; i < this.items.length; i++) {
                    if (this.items[i]['quantity'] > 0 && this.items[i]['price'] > 0) {
                        sum += (Number.parseFloat(this.items[i]['quantity']) * Number.parseFloat(this.items[i]['price']));
                    }
                }
                return myRound(sum);
            },
            accountUpdate() {
                var b = _.clone(Banks);

                var test = b.filter((account) => {
                    return (new RegExp(this.selectedCurrency.code.toLowerCase())).test(account.code.toLowerCase())
                });

                if (test[0]) {
                    this.defaultValue = test[0].id;
                }
                // console.log(4444,this.defaultValue, test);
                this.selectedBank = null;
                for (var x in this.bankes) {
                    for (z in this.bankes[x]) {
                        if (this.bankes[x][z] == this.defaultValue && z == 'id') {
                            if (this.bankes[x].balance!=undefined) {
                                this.selectedBank = this.bankes[x];
                                this.defaultAccount = this.defaultValue;
                                break;
                            }
                        }
                    }

                }
                return test;
            },
        },
        mounted: function () {

            // begin service
            for (var r = 0; r < this.proOrderDetails.length; r++) {
                this.items.push({quantity: this.proOrderDetails[r].quantity, description: this.proOrderDetails[r].description, price: this.proOrderDetails[r].price, um_id: this.proOrderDetails[r].um_id})
            }
                // this.items.push({quantity: null, description: null, price: null, um_id: null});
            // end service

            if ("{{$nProOrder->category_id}}") {
                this.selectedCategory=_.find(this.category,(v)=>v.id=="{{$nProOrder->category_id}}");
            }
            if ("{{$nProOrder->ngo_project_id}}") {
                this.selectedProject=_.find(projects,(v)=>v.id=="{{$nProOrder->ngo_project_id}}");
            }
            if ("{{$nProOrder->member_id}}") {
                this.selectedEmployee=_.find(employee,(v)=>v.id=="{{$nProOrder->member_id}}");
            }
            if ("{{$nProOrder->driver_id}}") {
                this.selectedDriver=_.find(allDrivers,(v)=>v.id=="{{$nProOrder->driver_id}}");
            }
            if ("{{$nProOrder->vehicle_id}}") {
                this.selectedVehicle=_.find(vehicle,(v)=>v.id=="{{$nProOrder->vehicle_id}}");
            }
            @if($selectedPosition)
                this.selected_position=_.find(position,(v)=>v.id== {{$selectedPosition->position_id}});
                this.memo_description = '{{$selectedPosition->description}}'
                // console.log(4333333, this.selected_position);
            @endif

            for(var i=0;i<this.proOrderDetailInventory.length;i++)
            {
                this.inventories.push({item:this.proOrderDetailInventory[i]});
            }
            
            // this.inventories.push({item:null});
            
            for (var r = 0; r < this.proOrderDetailAsset.length; r++) {
                var selected = _.find(this.fixedAsset, (v) => v.id == this.proOrderDetailAsset[r].inventory_id);
                this.fixedAssetData.push({
                    description: this.proOrderDetailAsset[r].description,
                    fixedAsset_list: fixedAsset,
                    selected: selected
                })
            }
            // this.fixedAssetData.push({
            //         description: null,
            //         fixedAsset_list: fixedAsset,
            //         selected: null
            // });

        },
        methods: {
            handleSubmit(e) {
                this.$validator.validate().then(valid => {
                    if (valid) {
						// alert(e.target);
                        regForm(e.target);
                    }
                });
            },
            checkExistingService(index = null, id = '') {
                var fixedAsset_temp = this.fixedAsset.slice();
                for (var i = 0; i < this.fixedAssetData.length; i++) {
                    if (this.fixedAssetData[i].selected != null) {
                        var fined = fixedAsset_temp.findIndex((item) => item.name == this.fixedAssetData[i].selected.name);
                        if (fined != -1) {
                            var o = fixedAsset_temp.splice(fixedAsset_temp.findIndex((item) => item.name == this.fixedAssetData[i].selected.name), 1);
                        }
                    }
                }

                this.fixedAssetData[index].fixedAsset_list = fixedAsset_temp.filter((item) => {
                    return (new RegExp(name.toLowerCase())).test(item.name.toLowerCase())
                });

            },

            //ajax call to get items
            onItemSearch:_.debounce((search,loading)=>{
                loading(true);
                axios.get("{{route('callMethod.search')}}",{
                    params:{
                    method_name:'itemSearchProcurment',
                    keyword:search,
                    }
                })
                .then(function (response)
                {
                    vu.temp_items=[];
                    if(response.data.length>0)
                    {
                    console.log('ddddd',response.data)
                        vu.temp_items=response.data;
                    }
                    loading(false);
                })
                .catch(function (error)
                {
                    console.log(error);
                });
            },getDebounceTime()),

            // set new price
            setNewRate(type=null,index)
            {
                if(type=='inventory')
                { 
                    if(this.inventories[index].item)
                    {
                        this.inventories[index].item.new_rate = this.$refs.in[index].value;
                    }
                }
                
            },

            measureChange(index)
            {
                if(this.inventories[index].item !=null){
                    var item=this.inventories[index].item;
                    var temp=((item.rate*item.measure.measure_unit/item.measure_unit));
                    result=Number.parseFloat(temp).toFixed(precision());
                    this.inventories[index].item.new_rate =result;
                }
            },

            // generic function for adding item to list
            addNew(type = null, index) {
                if (type != null) {
                    if (type == 'item') {
                        // if (this.items[index + 1] == undefined) {
                        //     this.items.push({
                        //         quantity: null,
                        //         description: null,
                        //         price: null,
                        //         um_id: null
                        //     });
                        // }
                    }
                    if (type == 'fixedAsset') {
                        // if (this.fixedAssetData[index + 1] == undefined) {
                        //     this.checkExistingService(index, '');
                        //     this.fixedAssetData.push({
                        //         description: null,
                        //         fixedAsset_list: this.fixedAsset,
                        //         selected: null
                        //     });
                        // }
                    }
                    if(type=='inventory')
                    {
                        // if(this.inventories[index+1]==undefined)
                        // {
                        // this.temp_items=[];
                        // this.inventories.push({item:null});
                        // }
                    }
                    if (type == 'payment') {
                        if (this.payments[index + 1] == undefined) {
                            this.checkExistingPayment(index, '');
                            this.payments.push({
                                items: bankes,
                                item: null,
                            });
                        }
                    }
                }

            },

            // delete item from list
            deleteItem(type = null, index) {
                if (type != null) {
                    if (type == 'item') {
                        this.items.splice(index, 1);
                    }
                    if (type == 'fixedAsset') {
                        this.fixedAssetData.splice(index, 1);
                    }
                    if(type=='inventory')
                    {
                        this.inventories.splice(index, 1);
                    }
                    if (type == 'payment') {
                        this.payments.splice(index, 1);
                    }
                }

            },

            test(defaultAccount) {
                this.selectedBank = null;
                for (var x in this.bankes) {
                    for (z in this.bankes[x]) {
                        if (this.bankes[x][z] == defaultAccount && z == 'id') {
                            if (this.bankes[x].balance!=undefined) {
                            this.selectedBank = this.bankes[x];
                            break;
                        }
                        }
                    }
                }
            },

            
            // in here you can check and decide to allow duplicate bank for payment or not
            checkExistingPayment(index = null, name = '') {
                // var bank_temp = bankes.slice();
                // console.log(bank_temp);
                // this.payments[index].items = bank_temp.filter((item) => {
                //     return (new RegExp(name.toLowerCase())).test(item.name.toLowerCase())
                // });
                //this.payments[index].items =bank_temp;
            },

        }
    });
</script>

@endpush