@extends('layouts.factor-master')

@section('content')

    <?php
    $report = customeReportNew('n_pro_order_receive_and_pay_index');

    $_number = !in_array('number', $report);
    $_name = !in_array('name', $report);
    $_member = !in_array('member', $report);
    $_description = !in_array('description', $report);
    $_currency = !in_array('currency', $report);
    $_rate = !in_array('rate', $report);
    $_requir_date = !in_array('requir_date', $report);
    $_date = !in_array('date', $report);
    $_ref_no = !in_array('ref_no', $report);
    $_requestNO = !in_array('ref_no', $report);
    $_expenseType = !in_array('expenseType', $report);
    $_total = !in_array('total', $report);
    $_paymentType = !in_array('paymentType', $report);
    $_priority = !in_array('priority', $report);
    $_driver = !in_array('driver', $report);
    $_vehicleName = !in_array('vehicleName', $report);
    $_contract = !in_array('contract', $report);




    $report_percent = customeReportNewPercent('n_pro_order_receive_and_pay_index');
    $_number_percent= (array_key_exists('number___percent', $report_percent))?$report_percent['number___percent']:null;
    $_name_percent= (array_key_exists('name___percent', $report_percent))?$report_percent['name___percent']:null;
    $_member_percent= (array_key_exists('member___percent', $report_percent))?$report_percent['member___percent']:null;
    $_description_percent= (array_key_exists('description___percent', $report_percent))?$report_percent['description___percent']:null;
    $_currency_percent= (array_key_exists('currency___percent', $report_percent))?$report_percent['currency___percent']:null;
    $_rate_percent= (array_key_exists('rate___percent', $report_percent))?$report_percent['rate___percent']:null;
    $_ref_no_percent= (array_key_exists('ref_no___percent', $report_percent))?$report_percent['ref_no___percent']:null;
    $_total_percent= (array_key_exists('total___percent', $report_percent))?$report_percent['total___percent']:null;
    $_requestNO_percent= (array_key_exists('requestNO___percent', $report_percent))?$report_percent['requestNO___percent']:null;
    $_date_percent= (array_key_exists('date___percent', $report_percent))?$report_percent['date___percent']:null;
    $_requir_date_percent= (array_key_exists('requir_date___percent', $report_percent))?$report_percent['requir_date___percent']:null;
    $_ref_no_percent= (array_key_exists('ref_no___percent', $report_percent))?$report_percent['ref_no___percent']:null;
    $_expenseType_percent= (array_key_exists('expenseType___percent', $report_percent))?$report_percent['expenseType___percent']:null;
    $_paymentType_percent= (array_key_exists('paymentType___percent', $report_percent))?$report_percent['paymentType___percent']:null;
    $_vehicleName_percent= (array_key_exists('vehicleName___percent', $report_percent))?$report_percent['vehicleName___percent']:null;
    $_priority_percent= (array_key_exists('priority___percent', $report_percent))?$report_percent['priority___percent']:null;
    $_driver_percent= (array_key_exists('driver___percent', $report_percent))?$report_percent['driver___percent']:null;
    $_contract_percent= (array_key_exists('contract___percent', $report_percent))?$report_percent['contract___percent']:null;

    

    ?>

<h3 class="table-caption" style="text-align: center;">@lang('layout.ReceiveAndPaymentReport')</h3>
<table class="main-table">

<thead>
<tr class="bg" >
    <td  class="center" ><div > @lang('layout.Record') </div></td>
    @if($_number)<td  class="center"  @if($_number_percent) width="{{$_number_percent}}%" @endif><div > @lang('layout.Number') </div></td>@endif
    @if($_ref_no)<td  class="center"  @if($_ref_no_percent) width="{{$_ref_no_percent}}%" @endif><div > @lang('layout.ReferenceNumber')</div></td>@endif
    @if($_date)<td  class="center"  @if($_date_percent) width="{{$_date_percent}}%" @endif><div > @lang('layout.Date')</div></td>@endif 
    @if($_description)<td  class="center"  @if($_description_percent) width="{{$_description_percent}}%" @endif><div > @lang('layout.Description')</div></td>@endif
    @if($_requestNO)<td  class="center"  @if($_requestNO_percent) width="{{$_requestNO_percent}}%" @endif><div > @lang('layout.RequestNO')</div></td>@endif
    @if($_member)<td  class="center"  @if($_member_percent) width="{{$_member_percent}}%" @endif><div > @lang('layout.Member')</div></td>@endif
    @if($_name)<td  class="center"  @if($_name_percent) width="{{$_name_percent}}%" @endif><div > @lang('layout.Project')</div></td>@endif
    @if(systemConfig()[20] == 1)
    @if($_contract)<td  class="center"  @if($_contract_percent) width="{{$_contract_percent}}%" @endif><div > @lang('layout.Contract')</div></td>@endif
    @endif
    @if($_name)<td  class="center"  @if($_name_percent) width="{{$_name_percent}}%" @endif><div > @lang('layout.Project')</div></td>@endif
    @if($_currency)<td  class="center"  @if($_currency_percent) width="{{$_currency_percent}}%" @endif><div > @lang('layout.Currency')</div></td>@endif
    @if($_rate)<td  class="center"  @if($_rate_percent) width="{{$_rate_percent}}%" @endif><div > @lang('layout.Rate')</div></td>@endif
    @if($_total)<td  class="center"  @if($_total_percent) width="{{$_total_percent}}%" @endif><div > @lang('layout.Total')</div></td>@endif 
    @if($_expenseType)<td  class="center"  @if($_expenseType_percent) width="{{$_expenseType_percent}}%" @endif><div > @lang('layout.ExpenseType')</div></td>@endif 
    @if($_paymentType)<td  class="center"  @if($_paymentType_percent) width="{{$_paymentType_percent}}%" @endif><div > @lang('layout.PaymentType')</div></td>@endif 
    @if($_priority)<td  class="center"  @if($_priority_percent) width="{{$_priority_percent}}%" @endif><div > @lang('layout.Priority')</div></td>@endif 
    <th class="center">@lang('layout.Type')</th>
    @if($_driver)<th  class="center"  @if($_driver_percent) width="{{$_driver_percent}}%" @endif>@lang('layout.Driver')</th>@endif
    @if($_vehicleName)<th  class="center"  @if($_vehicleName_percent) width="{{$_vehicleName_percent}}%" @endif>@lang('layout.VehicleName')</th>@endif
    @if($_requir_date)<td  class="center"  @if($_requir_date_percent) width="{{$_requir_date_percent}}%" @endif><div > @lang('layout.DateRequired')</div></td>@endif 
    <td  class="center" ><div > @lang('layout.Status')</div></td> 
    <td  class="center" ><div > @lang('layout.User')</div></td> 
</tr>
</thead>
<?php
$count = 0;
?>

@foreach($data AS $record)
<tr>

<td class="center">{{++$count}}</td>
@if($_number)<td class="center">{{$record['number']}}</td>@endif
@if($_ref_no)<td class="center">{{$record['ref_no']}}</td>@endif
@if($_date)<td class="center">{{convertDate($record['date'])}}</td>@endif
@if($_description)<td style="@if($_description_percent) text-align: justify @endif">{{$record['description']}}</td>@endif
@if($_requestNO)<td class="center">{{$record['pro_order_num']}}</td>@endif
@if($_member)<td style="text-align: justify">{{$record['member']}}</td>@endif
@if($_name)<td style="text-align: justify">{{$record['project']}}</td>@endif
@if(systemConfig()[20] == 1)
@if($_contract)<td style="text-align: justify">{{$record['Contract']}}</td>@endif
@endif
@if($_currency)<td class="center"> {{$record['currency']}}</td>@endif
@if($_rate)<td class="center">{{$record['rate']}}</td>@endif
@if($_total)<td class="center"> {{myRound($record['price'])}}</td>@endif
@if($_expenseType)<td class="center"> {{__('layout.'.ucfirst($record['expense_type']))}}</td>@endif
@if($_paymentType)<td class="center"> {{__('layout.'.ucfirst($record['pay_type']))}}</td>@endif
@if($_priority)<td class="center"> {{__('type.'.$record['priority'])}}</td>@endif
<td class="hidden-xs"> {{ __('layout.'.$record['type'])}}</td>
@if($_driver)<td class="hidden-xs"style="text-align: justify">{{ $record['driver_name']}}</td>@endif
@if($_vehicleName)<td class="hidden-xs">{{ $record['vehicle_name']}} -- {{ $record['palet_number']}}</td>@endif
@if($_requir_date)<td class="center">{{convertDate($record['requir_date'])}}</td>@endif
<td class="center"> {{ __('layout.'.$record['status'])}}</td>
<td style="text-align: justify"> {{$record['user']}}</td>
</tr>
@endforeach

</table>

 <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->
@endsection

