@extends('layouts.app')
@section('style')
<style type="text/css">
   table.td{
        border-top:0px;
    }
    .header{
    
    }
   
</style>
@stop
@section('content')
 
      <div class="">
            <!-- BEGIN EXAMPLE TABLE PORTLET-->
            <div class="portlet light bordered sale">
                <div class="portlet-title">
                    <div class="caption font-dark">
                        <i class="icon-settings font-dark"></i>
                        <span class="caption-subject bold uppercase">@lang('layout.RequestShow')</span>
                    </div>
                   
                    <div class="tools"></div>
                </div>
                <div class="portlet-body">
                    <div class="row">
                       <div class="col-md-12">
                           <table class="table">
                           <thead>
                                <tr>
                                    <th>@lang('layout.Number')</th>
                                    <th>@lang('layout.ReferenceNumber')</th>
                                    <th>@lang('layout.Member')</th>
                                    <th>@lang('layout.Project')</th>
                                    <th>@lang('layout.Date') </th>
                                    <th>@lang('layout.Currency') </th>
                                    <th>@lang('layout.Rate') </th>
                                    <th>@lang('layout.Total')</th>
                                    <th>@lang('layout.User') </th>
                                    <th>@lang('layout.NumberQutationRequest') </th>
                                    <th>@lang('layout.Vendor') </th>
                                    <th>@lang('layout.Address') </th>
                                    <th>@lang('layout.Description') </th>
                                </tr>
                              </thead>
                            <tbody> 
                                <tr>  
                                    <td class="hidden-xs"> {{ $quotation->number}}  </td>
                                    <td class="hidden-xs"> {{ $quotation->ref_no}}  </td>
                                    <td class="hidden-xs"> {{ $quotation->member}}  </td>
                                    <td class="hidden-xs"> {{ $quotation->project}}</td>
                                    <td class="hidden-xs"> {{ $quotation->date}}</td>
                                    <td class="hidden-xs"> {{ $quotation->currency}}</td>
                                    <td class="hidden-xs"> {{ $quotation->currency_rate}}</td>
                                    <td class="hidden-xs"> {{ $quotation->price}}</td>
                                    <td class="hidden-xs"> {{ $quotation->user}}</td>
                                    <td class="hidden-xs"> {{ $quotation->n_pro_number}}</td>
                                    <td class="hidden-xs"> {{ $quotation->Vendor}}</td>
                                    <td class="hidden-xs"> {{ $quotation->address}}</td>
                                    <td class="hidden-xs"> {{ $quotation->description}}</td>
                                </tr>
                            </tbody>
                            </table>
                       </div> 
                    </div>
                    <div class="" >
                        <div class="tabbable tabbable-tabdrop">
                            <ul class="nav nav-tabs">
                                <li class="active">
                                    <a href="#tab1" data-toggle="tab" id="">@lang('layout.Request')</a>
                                </li>
                                <li class="">
                                    <a href="#tab2" data-toggle="tab" id="">@lang('layout.Attachments')</a>
                                </li>
                            </ul>
                            <div class="tab-content">
                                <div class="tab-pane active" id="tab1">
                                    <div class="row">
                                        <div class="col-md-12">
                                            <!-- BEGIN EXAMPLE TABLE PORTLET-->
                                            <div class="portlet light bordered">
                                                <div class="title">
                                                    <div class="caption font-dark">
                                                        <i class="icon-settings font-dark"></i>
                                                        <span class="caption-subject bold uppercase">@lang('layout.Request')</span>
                                                    </div>
                                                    <div class="actions">
                                                    </div>
                                                </div>
                                                <div class="portlet-body" id="itemsshow">
                                                    <table class="table table-striped table-bordered table-hover" id="orderDetail">
                                                        <thead>
                                                            <tr>
                                                                <th>@lang('layout.Description')</th>
                                                                <th>@lang('layout.Quantity')</th>
                                                                <th>@lang('layout.Measure')</th>
                                                                <th>@lang('layout.Price')</th>
                                                                <th>@lang('layout.Total')</th>
                                                            </tr>
                                                        </thead>
                                                    </table>
                                                </div>
                                            </div>
                                            <!-- END EXAMPLE TABLE PORTLET-->
                                        </div>
                                    </div>
                                </div>
                                <div class="tab-pane" id="tab2">
                                    <div class="portlet light bordered">
                                        <div class="title">
                                            <div class="caption font-dark">
                                                <i class="icon-settings font-dark"></i>
                                                <span class="caption-subject bold uppercase">@lang('layout.Attachments')</span>
                                            </div>
                                        </div>
                                        <div class="portlet-body">
                                            <div class="portlet light bordered">
                                                <div class="portlet-body">

                                                    <form role="form" action="{{route('attachment.store')}}" method="post"
                                                        enctype="multipart/form-data">

                                                        @csrf
                                                        <input type="hidden" name="redirect_route" value="nProOrderQuotation.show">
                                                        <input type="hidden" name="foreign_data_id" value="{{$quotation->id}}">
                                                        <input type="hidden" name="path" value="uploads/NGOProject">
                                                        <input type="hidden" name="table_name" value="n_pro_order_quotations">

                                                        <div class="row">
                                                            <div class="col-md-4">
                                                                <div class="form-group">
                                                                    <label class="control-label">@lang('layout.AttachmentTitle')</label>
                                                                    <input type="text" name="title" class="form-control">
                                                                </div>
                                                            </div>
                                                            <div class="col-md-4">
                                                                <div class="form-group">
                                                                    <label class="control-label">@lang('layout.Description')</label>
                                                                    <textarea name="description" class="form-control"></textarea>
                                                                </div>
                                                            </div>
                                                            <div class="col-md-7">
                                                                <div class="form-group">
                                                                    <div class="fileinput fileinput-new" data-provides="fileinput">
                                                                        <div class="fileinput-new thumbnail"
                                                                            style="width: 200px; height: 150px;">
                                                                            <img src="" alt=""></div>
                                                                        <div class="fileinput-preview fileinput-exists thumbnail"
                                                                            style="max-width: 200px; max-height: 150px; line-height: 10px;"></div>
                                                                        <div>
                                                                                    <span class="btn default btn-file">
                                                                                        <span class="fileinput-new">@lang('layout.SelectFile')</span>
                                                                                        <span class="fileinput-exists">@lang('layout.Change')</span>
                                                                                        <input type="hidden" value="" name=""><input
                                                                                                type="file" name="photo"> </span>

                                                                            <a href="javascript:;" class="btn default fileinput-exists"
                                                                            data-dismiss="fileinput"> @lang('layout.Remove') </a>
                                                                        </div>

                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>

                                                        <div class="margiv-top-10">
                                                            <button type="button" onclick="regForm(this)"
                                                                    class="btn green"> @lang('layout.Submit') </button>
                                                            <a href="{{route('dailyExpense.index')}}"
                                                            class="btn default">@lang('layout.Cancel')</a>
                                                        </div>
                                                    </form>
                                                </div>
                                            </div>
                                            <table class="table table-striped table-bordered table-hover" id="attachment">
                                                <thead>
                                                <tr>
                                                    <th>@lang('layout.AttachmentTitle')</th>
                                                    <th>@lang('layout.Description')</th>
                                                    <th>@lang('layout.Action')</th>
                                                </tr>
                                                </thead>
                                            </table>
                                        </div>
                                    </div>
                                </div>        
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- END EXAMPLE TABLE PORTLET-->
    </div>
@endsection
@push('scripts') 
<script>

    $(document).ready(function(){
    $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
        $('#orderDetail').DataTable({  
            scrollCollapse: true,
            responsive:'{{responsiveDataTable()}}',
            pagingType:'{{paginationType()}}',
            serverSide: true,
            paging: true,
            retrieve: true,
            ajax:{
                url: '{{route("nProOrderQuotation.show",$quotation->id)}}',
                data:{type:'orderDetail'}
                }, 
            columns: [ 
                { data: 'description',   name: 'description' },
                { data: 'quantity'   ,   name: 'quantity' },
                { data: 'measure_name',  name: 'measure_name' },
                { data: 'price'   ,      name: 'price' },
                { data: 'total'   ,      name: 'total' },
            ]
        }); 

        $('#attachment').DataTable({
            ajax: {
                url: '{{route("nProOrderQuotation.show",$quotation->id)}}',
                data: {type: 'attachment'}
            },
            pageLength:'{{getPageRows()}}',
            responsive:'{{responsiveDataTable()}}',
            pagingType:'{{paginationType()}}',

            scrollCollapse: true,
            serverSide: true,
            paging: true,
            columns: [

                {data: 'title', name: 'attachments.title'},
                {data: 'description', name: 'attachments.description'},
                {data: 'actions', name: 'actions', orderable: false, searchable: false},
            ]
        });  

    });

</script>
@endpush