@extends('layouts.factor-master')


@section('content')

    <h3 class="table-caption" style="text-align: center;">@lang('layout.Quotation')</h3>
    <table class="main-table">

        <tr>
            <th>@lang('layout.Number')</th>
            <th>@lang('layout.Date')</th>
            <th>@lang('layout.User')</th>
        </tr>
        <tr>
            <td align="center">{{$quotation->number}}</td>
            <td align="center">{{convertDate($quotation->date)}}</td>
            <td align="center">{{$quotation->user}}</td>
        </tr>

    </table>

    <br>

    <table class="main-table">
        <thead>
        <tr>
            <th>#</th>
            <th>@lang('layout.Description')</th>
            <th> @lang('layout.Quantity')</th>
            <th> @lang('layout.Measure')</th>
            <th> @lang('layout.Price')</th>
            <th> @lang('layout.Total')</th>

        </tr>
        </thead>
        <tbody>
        @php $count = 0; @endphp
        @foreach($quotationDetail as $key )
            <tr>
                <td>
                    {{++$count}}
                </td>
                <td>
                    {{$key->description}}
                </td>
                <td>
                    {{$key->quantity}}
                </td>
                <td>
                    {{$key->measure_name}}
                </td>
                <td>
                    {{$key->price}}
                </td>
                <td>
                    {{simpleRound($key->price * $key->quantity)}}
                </td>
            </tr>
        @endforeach

        </tbody>
    </table>
    <br>

    <table class="main-table">
        <thead>
        <tr>
            <th width="70%"> @lang('layout.Description') </th>
            <th>@lang('layout.Total')</th>
        </tr>
        </thead>
        <tbody>
        <tr>
            <td width="70%">{{$quotation->description}}</td>
            <td style="width: 30%;">{{$quotation->price}} {{$quotation->currency}}</td>
        </tr>
        </tbody>
    </table>
    <table class="main-table" style="margin-top: 20px;">
        <thead>
        <tr>
            <th style="width: 20%"> @lang('layout.NumberQutationRequest') </th>
            <th>@lang('layout.Vendor')</th> 
            <th>@lang('layout.Address')</th> 
        </tr>
        </thead>
        <tbody>
        <tr>
            <td style="text-align: center;">{{$quotation->n_pro_number}}</td>
            <td style="text-align: center;">{{$quotation->Vendor}}</td>
            <td style="text-align: center;">{{$quotation->address}}</td>
        </tr>
        </tbody>
    </table>


@endsection
