@extends('layouts.app')
@section('style')
<link href="{{url('css/custome-table.css')}}" rel="stylesheet">
@stop
@section('content')
<div class="row">

    <div class="portlet light bg-inverse">
        <div class="portlet-title">
            <div class="caption">
                <i class="icon-equalizer font-green-haze"></i>&nbsp;
                <span class="caption-subject font-green-haze bold uppercase">@lang('layout.RequestEdit') </span>
                <!-- <span class="caption-helper">some info...</span> -->
            </div>
        </div>
        <div class="portlet-body form" style="margin-bottom: 50%;" id="app">
            <!-- BEGIN FORM-->
            {!! Form::model($Quotation,['method' => 'PATCH','route' => ['nProOrderQuotation.update',$Quotation->id],'class'=>'form-horizontal']) !!}
            {{ csrf_field() }}
            <div class="form-body">
                <div class="">
                    <div class="row">
                        <div class="col-md-10">
                            <div class="col-md-4">
                                <label class="control-label">@lang('layout.Project')</label>
                                <v-select class="vue-select2" v-model="selectedProject" label="name" :options="{{$projects}}"  >
                                </v-select>
                                <input type="hidden" name="project_id" v-model.number="(!selectedProject)?null:selectedProject.id">
                            </div>
                            <div class="col-md-4">
                                <label class="control-label">@lang('layout.RequestorName')</label>
                                <v-select class="vue-select2" v-model="selectedEmployee" label="name" :options="{{$employee}}"  >
                                </v-select>
                                <input type="hidden" name="employee_id" v-model.number="(!selectedEmployee)?null:selectedEmployee.id">
                            </div>
                            <div class="col-md-4">
                                <label class="control-label">@lang('layout.NumberQutationRequest')</label>
                                <v-select class="vue-select2" v-model="selectedNProOrder" label="number" :options="nProOrder">
                                </v-select>
                                <input type="hidden" name="n_pro_order_id" v-model.number="(!selectedNProOrder)?null:selectedNProOrder.id">
                            
                            </div>
                            
                            <div class="col-md-12">
                                <div class="col-md-4">
                                    <label class="control-label">@lang('layout.Number')</label>
                                    <input type="text" name="number" value="{{$Quotation->number}}" class="form-control">
                                </div>
                            </div>
                            <div class="col-md-12" style="padding: 0px !important;" >
                                <div class="col-md-4" style="height: 10px;">
                                    <label class="control-label">@lang('layout.Currency')</label>
                                    <v-select label="code" :options="setRates" v-model="selected_currency">
                                    </v-select>
                                    <input type="hidden" name="currency" :value="selected_currency.code" />
                                </div>
                                <div class="col-md-4">
                                    <label class="control-label">@lang('layout.Rate')</label>
                                    <div class="input-group">
                                        <input v-model="selected_currency.exchange_rate" class="form-control" type="number" min="0" step="any">
                                        <span class="input-group-addon">@{{selected_currency.symbol}}</span>
                                    </div>
                                    <input type="hidden" name="currency_rate" :value="selected_currency.exchange_rate">
                                </div>
                                <div class="col-md-4">
                                    <label class="control-label">@lang('layout.ReferenceNumber')</label>
                                    <input type="text" name="ref_no" value="{{$Quotation->ref_no}}" class="form-control">
                                </div>
                            </div>

                            <div class="col-md-12" style="padding: 0px;" > 
                                <div class="col-md-4">
                                    <label class="control-label">@lang('layout.Vendor')</label>
                                    <v-select label="name" @input="memberChange()" :options="vendor" @search="MemberSearch"  v-model="selected_vendor"></v-select>
                                    <input type="hidden" name="vendor_id" :value="!selected_vendor?null:selected_vendor.id" required>
                                </div>
                                <div class="col-md-4">
                                    <label class="control-label">@lang('layout.Address')</label>
                                    <textarea name="address" id="" cols="30" rows="1" class="form-control">{{$Quotation->address}}</textarea>
                                </div>
                                <div class="col-md-4">
                                    <label class="control-label">@lang('layout.Date')</label>
                                    <input type="text" class="form-control date" value="{{$Quotation->date}}" autocomplete="off" name="date">
                                </div>
                            </div>

                           
                            <div class="col-md-12" style="margin-bottom: 20px;">
                                <label class="control-label">@lang('layout.Description')</label>
                                {!! Form::textarea('description', null, array('placeholder' => __('layout.Description'),'class' => 'form-control','rows' => 1, 'cols' => 30)) !!}
                            </div>
                        </div>

                        <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                            <!-- begin total -->
                            <div class="dashboard-stat2" style="padding-bottom: 30px !important;">

                                <table class="dashboard-tabel table-bordered" width="100%">

                                    <tbody>
                                        <span>
                                            <tr>
                                                <td class="highlight">
                                                    @lang('layout.Total')
                                                </td>
                                                <td>
                                                    @{{total_amount}}
                                                </td>
                                            </tr>
                                        </span>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-12">
                        <div v-if="items.length >0 " class="row">
                            <li class="list-group-item" style="background: rgb(80, 129, 141) !important; color: white;"> @lang('layout.Request') </li>
                            <div class="table-responsive333">
                                <table id="table_content" class="table table-bordered table-advance table-hover">
                                    <thead>
                                        <tr>
                                            <th class="text-center" style="min-width: 6px;">#</th>
                                            <th class="text-center" style="min-width: 100px;">@lang('layout.Description')</th>
                                            <th class="text-center" style="min-width: 50px;"> @lang('layout.Quantity')</th>
                                            <th class="text-center" style="min-width: 50px;"> @lang('layout.Measure')</th>
                                            <th class="text-center" style="min-width: 40px;"> @lang('layout.Price')</th>
                                            <th class="text-center" style="min-width: 60px;"> @lang('layout.Total')</th>
                                            <th style="min-width: 20px;"></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr v-for="(rows,index) in items" class="even">
                                            <td class=""> @{{index+1}} </span>
                                            </td>
                                            <td class="highlight">
                                                <input type="text" name="name[]" v-model.number="(!rows)?null:rows.description" class="form-control" @click="addNew('item',index)" autocomplete="off" >
                                            </td>
                                            <td>
                                                <input type="number" placeholder="@lang('layout.Quantity')" name="quantity[]" v-model.number="(!rows)?null:rows.quantity" class="form-control">
                                            </td>
                                            <td>
                                                <select name="um_id[]" v-model.number="(!rows)?null:rows.um_id" class="form-control">
                                                    <option value="null">@lang('layout.Select')</option>
                                                    <option v-for="measure in measureList" :value="measure.measure_id">
                                                        @{{measure.measure_name}}
                                                    </option>
                                                </select>
                                            </td>
                                            <td>
                                                <div class="input-group input_style">
                                                    <input type="number" name="price[]" class="form-control" placeholder="@lang('layout.Price')" v-model.number="(!rows)?null:rows.price">
                                                    <span class="input-group-addon">
                                                        <b>@{{selected_currency.symbol}}</b>
                                                    </span>
                                                </div>
                                            </td>
                                            <td>
                                                <div class="input-group input_style">
                                                    <input type="" class="form-control inner_input" placeholder="@lang('layout.Total')" :value="(!rows)?null:rows.quantity * (rows.price)" disabled>
                                                    <span class="input-group-addon">
                                                        <b>@{{selected_currency.symbol}}</b>
                                                    </span>
                                                </div>
                                            </td>
                                            <td>
                                                <span v-on:click="deleteItem('item',index)"><i class="paddint-both glyphicon glyphicon-trash"></i></span>
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-xs-12 col-sm-10 col-md-11 text-center">
                <button type="button" class="btn green" onclick="regForm(this)"> @lang('layout.Submit') </button>
                <button href="{{url('nProOrderQuotation.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel') </button>
            </div>
            {!! Form::close() !!}
        </div>
        <!-- END FORM-->
    </div>
</div>
@endsection

@push('scripts')
<script>
    Vue.component('v-select', VueSelect.VueSelect);
    var currency ={!! $currency !!};
    let homeCurrency = {!! $homeCurrency !!};
    let ratesFetched = {!! $rates !!};
    var measureList = {!!$measureList!!}; 
    var category = {!!$category!!}; 
    var projects = {!!$projects!!}; 
    var employee = {!!$employee!!}; 
    var QuotationDetail = {!!$QuotationDetail!!}; 
    var nProOrder = {!!$nProOrder!!}; 
    var selectedVendor ={!! $selectedVendor !!};
    
    let vu = new Vue({
        el: '#app',
        data: {
            selectedNProOrder: null,
            nProOrder: nProOrder,
            selectedCategory: null,
            selectedProject: null,
            selectedEmployee: null,
            selectedDriver: null,
            selectedVehicle: null,
            selected_position: null,
            memo_description: null,
            items: [],
            currency: currency,
            selected_currency: homeCurrency,
            measureList: measureList,
            category: category,
            QuotationDetail: QuotationDetail,
            vendor: [],
            selected_vendor: selectedVendor
        },
        computed: {
            setRates() {

                let rates = [];
                this.currency.forEach((b) => {
                    ratesFetched.forEach((a) => {

                        if (a.currency_id == b.id) {
                            rates.push({
                                name: a.name,
                                code: a.code,
                                symbol: a.symbol,
                                rate: a.rate != null ? Number.parseFloat(a.rate) : 1,
                                exchange_rate: a.rate != null ? Number.parseFloat(a.rate) : 1,
                                hq_rate: a.hq_rate != null ? Number.parseFloat(a.hq_rate) : 1,
                                currency: b.id,
                                id: b.id
                            });
                        }
                    })
                });

                this.currency.forEach((a) => {
                    let found = false;
                    rates.forEach((b) => {
                        if (a.id == b.id) {
                            found = true;
                            return;
                        }
                    });

                    if (!found) {
                        rates.push({
                            name: a.name,
                            code: a.code,
                            symbol: a.symbol,
                            rate: 1,
                            exchange_rate: 1,
                            hq_rate: 1,
                            currency: a.id,
                            id: a.id
                        })
                    }
                });

                return rates;
            },
            total_amount: function() {
                var sum = 0;
                for (var i = 0; i < this.items.length; i++) {
                    if (this.items[i]['quantity'] > 0 && this.items[i]['price'] > 0) {
                        sum += (Number.parseFloat(this.items[i]['quantity']) * Number.parseFloat(this.items[i]['price']));
                    }
                }
                return myRound(sum);
            },
        },
        mounted: function () {

            // begin service
            for (var r = 0; r < this.QuotationDetail.length; r++) {
                this.items.push({quantity: this.QuotationDetail[r].quantity, description: this.QuotationDetail[r].description, price: this.QuotationDetail[r].price, um_id: this.QuotationDetail[r].um_id})
            }
                this.items.push({quantity: null, description: null, price: null, um_id: null});
            // end service

            if ("{{$Quotation->ngo_project_id}}") {
                this.selectedProject=_.find(projects,(v)=>v.id=="{{$Quotation->ngo_project_id}}");
            }
            if ("{{$Quotation->member_id}}") {
                this.selectedEmployee=_.find(employee,(v)=>v.id=="{{$Quotation->member_id}}");
            }


            if ("{{$Quotation->pro_order_id}}") {
                this.selectedNProOrder=_.find(nProOrder,(v)=>v.id=="{{$Quotation->pro_order_id}}");
            }
     
        },
        methods: {

            MemberSearch: _.debounce((search, loading) => {
                        loading(true);
                        let class_id = (vu.selected_class != undefined) ? vu.selected_class.id : null; 
                        axios.get("{{route('callMethod.search')}}", {
                            params: {
                                method_name: 'SearchMember', 
                                keyword: search,
                                class_id: class_id,
                                type: 'Vendor'
                            }
                        })
                        .then(function(response) {
                            if (response.data.length > 0) {
                                // console.log(response.data);
                                vu.vendor = [];
                                vu.vendor = response.data;
                            }
                            loading(false);
                        })
                        .catch(function(error) {
                            loading(false);
                            console.log(error);
                        })
                    }, getDebounceTime()),




            addClass() {

            },

            // generic function for adding item to list
            addNew(type = null, index) {
                if (type != null) {
                    if (type == 'item') {
                        if (this.items[index + 1] == undefined) {
                            this.items.push({quantity: null, description: null, price: null, um_id: null});
                        }
                    }
                }

            },

            // delete item from list
            deleteItem(type = null, index) {
                if (type != null) {
                    if (type == 'item') {
                        this.items.splice(index, 1);
                    }
                }

            },
        }
    });
</script>

@endpush