@extends('layouts.factor-master')


@section('content')

    <h3 class="table-caption" style="text-align: center;">@lang('layout.Request')</h3>
    <table class="main-table">
        <tr>
            <td align="center">@lang('layout.Number')</td>
            <td align="center" >{{$data->number}}</td>
        </tr>
        <tr>
            <td align="center">@lang('layout.User')</td>
            <td align="center" >{{$data->user}}</td>
        </tr>
    </table>
    <table style="width: 100%; margin-top: 10px; margin-left: 0px; margin-right: 0px; padding-right: 0px; padding-left: 0px;" >
        <tr>
            <td style="text-align: left; width:40%; margin-left: 0px; margin-right: 0px; padding-right: 0px; padding-left: 0px;" >
                <table class="main-table">
                    <tr>
                        <td align="right"><b>@lang('layout.RequestorName')</b></td>
                        <td align="right"><b>{{ $data->member}}</b></td>
                    </tr>
                    <tr>
                        <td align="right"><b>@lang('layout.Date')</b></td>
                        <td align="right"><b>{{$data->date}}</b></td>
                    </tr>
                    <tr>
                        <td align="right"><b>@lang('layout.DateRequired')</b></td>
                        <td align="right"><b>{{$data->requir_date}}</b></td>
                    </tr>
                    <tr>
                        <td align="right"><b>@lang('layout.Priority')</b></td>
                        <td align="right"><b> {{ __('type.'.$data->priority)}} </b></td>
                    </tr>
                </table>
            </td>
            <td width="20%" style=" margin-left: 0px; margin-right: 0px; padding-right: 0px; padding-left: 0px;"></td>
            <td style="text-align: left; width:40%; margin-left: 0px; margin-right: 0px; padding-right: 0px; padding-left: 0px;" >
                <table class="main-table">
                    <tr>
                        <td align="right"><b>@lang('layout.ProjectCode')</b></td>
                        <td align="right"><b> {{ $data->code}} </b></td>
                    </tr>
                    <tr>
                        <td align="right"><b>@lang('layout.ProjectName')</b></td>
                        <td align="right"><b>{{ $data->project}}</b></td>
                    </tr>
                    <tr>
                        <td align="right"><b>@lang('layout.ReferenceNumber')</b></td>
                        <td align="right"><b>{{$data->ref_no}}</b></td>
                    </tr>
                    <tr>
                        <td align="right"><b></b></td>
                        <td align="right"><b></b></td>
                    </tr>
                </table>
            </td>
        </tr>
    </table>

    <table class="main-table" style="margin-top: 20px;">
        <thead>
        <tr style="margin-top: 20px; background-color: #c3c3c3;">
            <th>#</th>
            <th>@lang('layout.Name')</th>
            <th>@lang('layout.Description')</th>
            <th> @lang('layout.Quantity')</th>
            <th> @lang('layout.Measure')</th>
            <th> @lang('layout.Price')</th>
            <th> @lang('layout.Total')</th>

        </tr>
        </thead>
        <tbody>
        @php $count = 0; @endphp
        @foreach($proOrderDetail as $key )
            <tr>
                <td>
                    {{++$count}}
                </td>
                <td>
                    {{$key->name}}
                </td>
                <td>
                    {{$key->description}}
                </td>
                <td>
                    {{$key->quantity}}
                </td>
                <td>
                    {{$key->measure_name}}
                </td>
                <td>
                    {{$key->price}}
                </td>
                <td>
                    {{simpleRound($key->price * $key->quantity)}}
                </td>
            </tr>
        @endforeach

        </tbody>
    </table>

    <table class="main-table" style="margin-top: 10px;">
        <thead>
        <tr>
            <th width="70%"> @lang('layout.Description') </th>
            <th>@lang('layout.Total')</th>
        </tr>
        </thead>
        <tbody>
        <tr>
            <td width="70%">{{$data->description}}</td>
            <td style="width: 30%;">{{ myRound($data->price)}} {{$data->currency}}</td>
        </tr>
        </tbody>
    </table>

    <table style="border: 0px; margin-top: 1px; width:100%;" cellpadding="1px" >
        <tr>
            <th colspan="5" style="text-decoration: underline; padding-bottom: 10px;" > @lang('layout.Approveres') </th>
        </tr>
        @foreach($proOrderMemo as $key )
            <tr style="margin-top: 1px; margin-bottom: 1px;">
                <td class="hidden-xs" style="width: 32%; text-decoration: underline;"> {{ $key->position_name }}: {{ $key->user}}</td>
                <td class="hidden-xs" style="width: 13%;" > @lang('layout.Signature'):</td>
                <td class="hidden-xs" style="width: 30%;" > 
                    @if($key->signature)
                    <center><img src="{!! asset('uploads/' . $key->signature) !!}" class='img-responsive' style='max-width:120px; max-height:100px;'></center>
                    @endif 
                </td>
                <td class="hidden-xs" style="width: 25%;" > @lang('layout.Date'): {{ convertDate($key->date) }}</td>
            </tr>
        @endforeach
    </table>


@endsection
