@extends('layouts.app')
@section('style')
<link href="{{url('css/custome-table.css')}}" rel="stylesheet">
@stop
@section('content')
<div class="row">

    <div class="portlet light bg-inverse">
        <div class="portlet-title">
            <div class="caption">
                <i class="icon-equalizer font-green-haze"></i>&nbsp;
                <span class="caption-subject font-green-haze bold uppercase">@lang('layout.RequestCreate') </span>
                <!-- <span class="caption-helper">some info...</span> -->
            </div>
        </div>
        <div class="portlet-body form" style="margin-bottom: 50%;" id="app">
            <!-- BEGIN FORM-->
            {!! Form::open(array('route' => 'nProOrder.store','method'=>'POST','class'=>'form-horizontal')) !!}
            {{ csrf_field() }}
            <div class="form-body">
                <div class="">
                <div class="row">
                    <div class="col-md-10 ">
                        <div class="col-md-4">
                            <label class="control-label">@lang('layout.Project')</label>
                            <v-select class="vue-select2" v-model="selectedProject" label="name" :options="{{$projects}}">
                            </v-select>
                            <input type="hidden" name="project_id" v-model.number="(!selectedProject)?null:selectedProject.id">
                        </div>
                        <div class="col-md-4">
                            <label class="control-label">@lang('layout.RequestorName')</label>
                            <v-select class="vue-select2" v-model="selectedEmployee" label="name" :options="{{$employee}}">
                            </v-select>
                            <input type="hidden" name="employee_id" v-model.number="(!selectedEmployee)?null:selectedEmployee.id">
                        </div>
                        <div class="col-md-4">
                            <label class="control-label">@lang('layout.Number')</label>
                            <input type="text" name="number" value="{{$code}}" class="form-control">
                        </div>
                        <div class="col-md-8" style="padding: 0px !important;">
                            <div class="col-md-6">
                                <label class="control-label">@lang('layout.Date')</label>
                                <input type="text" class="form-control date" autocomplete="off" name="date">
                            </div>
                            <div class="col-md-6">
                                <label class="control-label">@lang('layout.DateRequired')</label>
                                <input type="text" class="form-control date" name="requir_date" autocomplete="off">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <label class="control-label">@lang('layout.ReferenceNumber')</label>
                            <input type="text" name="ref_no" class="form-control">
                        </div>
                        <div class="col-md-4" style="height: 10px;">
                            <label class="control-label">@lang('layout.Currency')</label>
                            <v-select label="code" :options="setRates" v-model="selected_currency">
                            </v-select>
                            <input type="hidden" name="currency" :value="selected_currency.code" />
                        </div>
                        <div class="col-md-4">
                            <label class="control-label">@lang('layout.Rate')</label>
                            <div class="input-group">
                                <input v-model="selected_currency.exchange_rate" class="form-control" type="number" min="0" step="any">
                                <span class="input-group-addon">@{{selected_currency.symbol}}</span>
                            </div>
                            <input type="hidden" name="currency_rate" :value="selected_currency.exchange_rate">
                        </div>
                        <div class="col-md-4">
                            <label class="control-label">@lang('layout.Category')</label>
                            <v-select class="vue-select2" v-model="selectedCategory" label="name" :options="{{$category}}">
                            </v-select>
                            <input type="hidden" name="category_id" v-model.number="(!selectedCategory)?null:selectedCategory.id">
                        </div>
                        <div class="col-md-4">
                            <label class="control-label">@lang('layout.Priority')</label>
                            <select name="priority" class="form-control">
                                <option value="High">@lang('type.High')</option>
                                <option value="Medium">@lang('type.Medium')</option>
                                <option value="Low">@lang('type.Low')</option>
                            </select>
                        </div>
                        <div class="col-md-8">
                            <label class="control-label">@lang('layout.Description')</label>
                            {!! Form::textarea('description', null, array('placeholder' => __('layout.Description'),'class' => 'form-control','rows' => 1, 'cols' => 30)) !!}
                        </div>
                        <div class="col-md-12" style="padding: 0px;">
                            <div class="col-md-4">
                                <label class="control-label">@lang('layout.Type')</label>
                                <select name="type" v-model="type" class="form-control">
                                    <option value="Simple">@lang('layout.Simple')</option>
                                    <option value="VehicleExpenses">@lang('layout.VehicleExpenses')</option>
                                </select>
                            </div>
                            <div class="col-md-4" v-show="type == 'VehicleExpenses'">
                                <label class="control-label">@lang('layout.Transporter_name')</label>
                                <v-select class="vue-select2" v-model="selectedDriver" label="name" :options="{{$allDrivers}}">
                                </v-select>
                                <input type="hidden" name="driver_id" v-model.number="(!selectedDriver)?null:selectedDriver.id">
                            </div>
                            <div class="col-md-4" v-show="type == 'VehicleExpenses'">
                                <label class="control-label">@lang('layout.VehicleName')</label>
                                <v-select class="vue-select2" v-model="selectedVehicle" label="name" :options="{{$vehicle}}">
                                </v-select>
                                <input type="hidden" name="vehicle_id" v-model.number="(!selectedVehicle)?null:selectedVehicle.id">
                            </div>
                        </div>
                        <div class="col-md-12" style="padding: 0px;">
                            <h3>@lang('layout.SendToSelfDepartment')</h3>
                            <div class="col-md-4">
                                <label class="control-label">@lang('menu.Position')</label>
                                <v-select class="vue-select2" v-model="selected_position" label="name" :options="{{$position}}">
                                </v-select>
                                <input type="hidden" name="position_id" v-model.number="(!selected_position)?null:selected_position.id">
                            </div>
                            <div class="col-md-8">
                                <label class="control-label">@lang('layout.Description')</label>
                                {!! Form::textarea('memo_description', null, array('placeholder' => __('layout.Description'),'class' => 'form-control','rows' => 1, 'cols' => 30)) !!}
                            </div>
                        </div>

                    </div>

                    <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                        <!-- begin total -->
                        <div class="dashboard-stat2" style="padding-bottom: 30px !important;">

                            <table class="dashboard-tabel table-bordered" width="100%">

                                <tbody>
                                    <span>
                                        <tr>
                                            <td class="highlight">
                                                @lang('layout.Total')
                                            </td>
                                            <td>
                                                @{{total_amount}}
                                            </td>
                                        </tr>
                                    </span>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

                    <div class="col-md-12">
                        <div v-if="items.length >0 " class="row">
                            <li class="list-group-item bg-green" style="background: rgb(80, 129, 141) !important;color: white;"> @lang('layout.Request') </li>
                            <div class="table-responsive333">
                                <table id="table_content" class="table table-bordered table-advance table-hover">
                                    <thead>
                                        <tr>
                                            <th class="text-center" style="min-width: 6px;">#</th>
                                            <th class="text-center" style="min-width: 100px;">@lang('layout.Description')</th>
                                            <th class="text-center" style="min-width: 50px;"> @lang('layout.Quantity')</th>
                                            <th class="text-center" style="min-width: 50px;"> @lang('layout.Measure')</th>
                                            <th class="text-center" style="min-width: 40px;"> @lang('layout.Price')</th>
                                            <th class="text-center" style="min-width: 60px;"> @lang('layout.Total')</th>
                                            <th style="min-width: 20px;"></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr v-for="(rows,index) in items" class="even">
                                            <td class=""> @{{index+1}} </span>
                                            </td>
                                            <td class="highlight">
                                                <input type="text" name="name[]" class="form-control" @click="addNew('item',index)" autocomplete="off">
                                            </td>
                                            <td>
                                                <input type="number" placeholder="@lang('layout.Quantity')" name="quantity[]" v-model.number="(!rows)?null:rows.quantity" class="form-control">
                                            </td>
                                            <td>
                                                <select name="um_id[]" class="form-control">
                                                    <option value="null">@lang('layout.Select')</option>
                                                    <option v-for="measure in measureList" :value="measure.measure_id">
                                                        @{{measure.measure_name}}
                                                    </option>
                                                </select>
                                            </td>
                                            <td>
                                                <div class="input-group input_style">
                                                    <input type="number" name="price[]" class="form-control" placeholder="@lang('layout.Price')" v-model.number="(!rows)?null:rows.price">
                                                    <span class="input-group-addon">
                                                        <b>@{{selected_currency.symbol}}</b>
                                                    </span>
                                                </div>
                                            </td>
                                            <td>
                                                <div class="input-group input_style">
                                                    <input type="" class="form-control inner_input" placeholder="@lang('layout.Total')" :value="(!rows)?null:rows.quantity * (rows.price)" disabled>
                                                    <span class="input-group-addon">
                                                        <b>@{{selected_currency.symbol}}</b>
                                                    </span>
                                                </div>
                                            </td>
                                            <td>
                                                <span v-on:click="deleteItem('item',index)"><i class="paddint-both glyphicon glyphicon-trash"></i></span>
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-12">
                        <div v-if="fixedAssetData.length >0 " class="row">
                            <li class="list-group-item" style="background-color: rgb(80, 129, 141) !important;color: white;"> @lang('layout.Request') @lang('layout.FixedAsset') </li>
                            <div class="table-responsive333">
                                <!-- begin fixedAsset -->
                                <table id="table_content" class="table table-striped table-bordered table-advance table-hover">
                                    <thead>
                                        <tr>
                                            <th class="text-center" style="min-width: 8px;">#</th>
                                            <th class="text-center" style="min-width: 160px;">@lang('layout.FixedAsset')</th>
                                            <th class="text-center" style="min-width: 160px;">@lang('layout.Description')</th>
                                            <th></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr v-for="(record,index) in fixedAssetData">
                                            <td>@{{index+1}}</td>
                                            <td class="highlight">
                                                <v-select label="name" v-model="record.selected" :options="(record.fixedAsset_list)" @click.native="addNew('fixedAsset',index)" @input="checkExistingService(index)" placeholder="@lang('layout.Select')">

                                                </v-select>
                                                <input type="hidden" name="fixedAsset_id[]" :value="(record.selected==null)?null:record.selected.id">
                                            </td>

                                            <td>
                                                <input class="form-control" type="text" name="fixedAsset_description[]" v-model.number="record.description" placeholder="@lang('layout.Description')">
                                            </td>

                                            <td>
                                                <span v-on:click="deleteItem('fixedAsset',index)"><i class="paddint-both glyphicon glyphicon-trash"></i></span>
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                                <!-- end fixedAsset -->
                            </div>
                        </div>
                    </div>

                    <div class="col-md-12">
                        <div class="row">
                            <li class="list-group-item" style="background-color: rgb(80, 129, 141) !important; color: white;"> @lang('layout.Request') @lang('layout.Procurement') </li>
                            <div v-if="inventories.length>0" >
                                <table id="table_content" class="table table-bordered table-advance">
                                    <thead>
                                        <tr>
                                            <th class="text-center" style="min-width: 8px;"> # </th>
                                            <th class="text-center" style="min-width: 160px;">@lang('layout.ItemName')</th>
                                            <th class="text-center" style="min-width: 120px;">@lang('layout.SiteName') </th>
                                            <th class="text-center" style="min-width: 80px;"> @lang('layout.Quantity')</th>
                                            <th class="text-center" style="min-width: 60px;"> @lang('layout.OnHand')</th>
                                            <th class="text-center" style="min-width: 120px;"> @lang('layout.Measure')</th>
                                            <th class="text-center" style="min-width: 120px;"> @lang('layout.Description')</th>
                                            <th class="text-center" style="min-width: 40px;">@lang('layout.Total')</th>
                                            <th style="min-width: 20px;"></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr v-for="(item,index) in inventories">
                                            <td>@{{index+1}}</td>
                                            <td class="highlight">
                                                <v-select label="name" v-model="item.item" :options="temp_items" @search="onItemSearch"></v-select>
                                                <input type="hidden" name="inventory_id[]" :value="(!item.item)?null:item.item.id">
                                            </td>
                                            <td class="highlight">
                                                <select v-model="(item.item==null)?null:item.item.site" class="form-control">
                                                    <option value="null">@lang('layout.Select')</option>
                                                    <span v-if="(item.item != null)">
                                                        <option v-for="site in (item.item==null)?null:item.item.site_list" :value="site">
                                                            @{{site.site_name}}
                                                        </option>
                                                    </span>
                                                </select>

                                                <input type="hidden" name="inventory_site[]" :value="(item.item==null)?null:((item.item.site==null)?null:item.item.site.site_id)">
                                            </td>
                                            <td>
                                                <input type="number" name="inventory_quantity[]" v-model.number="(item.item==null)?null:item.item.quantity" @click="addNew('inventory',index)" class="form-control input-style input-number" placeholder="@lang('layout.Quantity')">
                                            </td>

                                            <td>
                                                @{{myRound((item.item==null)?null:saleItemQuantity(item.item,item.item.quantity))}}
                                            </td>
                                            <td class="highlight">
                                                <select v-model="(item.item == null)?null:item.item.measure" class="form-control" @change="measureChange(index)">
                                                    <option value="null">@lang('layout.Select')</option>
                                                    <span v-if="(item.item ==null)?false:true">
                                                        <option v-for="measure in (item.item==null)?null:item.item.measure_list" :value="measure">
                                                            @{{measure.measure_name}}
                                                        </option>
                                                    </span>
                                                </select>
                                                <input type="hidden" name="inventory_measure[]" :value="(item.item==null)?null:item.item.measure.measure_id">
                                            </td>
                                            <td>
                                            <input class="form-control" type="text" name="inventory_description[]"  placeholder="@lang('layout.Description')">
                                            </td>
                                            <td>
                                                <div class="input-group">
                                                    <input type="hidden" name="inventory_cost[]" placeholder="@lang('layout.Cost')" :value="(item.item==null)?null:(item.item.new_rate)" ref="in" @input="setNewRate('inventory',index)" class="form-control">
                                                    @{{(item.item==null)?null:myRound((item.item.new_rate)*((item.item==null)?null:item.item.quantity))}}
                                                </div>
                                            </td>
                                            <td>
                                                <span v-on:click="deleteItem('inventory',index)"><i class="paddint-both glyphicon glyphicon-trash"></i></span>
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
            <div class="col-xs-12 col-sm-12 col-md-12 text-center" style="margin-top: 10px;">
                <button type="button" class="btn green" onclick="regForm(this)"> @lang('layout.Submit') </button>
                <button href="{{url('nProOrder.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel') </button>
            </div>
            {!! Form::close() !!}
        </div>
        <!-- END FORM-->
    </div>
</div>
@endsection

@push('scripts')
<script>
    Vue.component('v-select', VueSelect.VueSelect);
    var currency ={!! $currency !!};
    let homeCurrency = {!! $homeCurrency !!};
    let ratesFetched = {!! $rates !!};
    var measureList = {!!$measureList!!}; 
    var fixedAsset = {!!$fixedAsset!!}; 

    let vu = new Vue({
        el: '#app',
        data: {
            selectedCategory: null,
            selectedProject: null,
            selectedEmployee: null,
            selectedDriver: null,
            selectedVehicle: null,
            selected_position: null,
            type: 'Simple',
            items: [{
                    quantity: null,
                    description: null,
                    price: null,
                    um_id: null
                },
                {
                    quantity: null,
                    description: null,
                    price: null,
                    um_id: null
                }
            ],
            fixedAsset: fixedAsset,
            fixedAssetData: [{
                    description: null,
                    fixedAsset_list: fixedAsset,
                    selected: null
                },
                {
                    description: null,
                    fixedAsset_list: fixedAsset,
                    selected: null
                },
            ],
            inventories:[
                {item:null},
                {item:null}
            ],
            temp_items:[],
            currency: currency,
            selected_currency: homeCurrency,
            measureList: measureList,
        },
        computed: {
            setRates() {
                let rates = [];
                this.currency.forEach((b) => {
                    ratesFetched.forEach((a) => {

                        if (a.currency_id == b.id) {
                            rates.push({
                                name: a.name,
                                code: a.code,
                                symbol: a.symbol,
                                rate: a.rate != null ? Number.parseFloat(a.rate) : 1,
                                exchange_rate: a.rate != null ? Number.parseFloat(a.rate) : 1,
                                hq_rate: a.hq_rate != null ? Number.parseFloat(a.hq_rate) : 1,
                                currency: b.id,
                                id: b.id
                            });
                        }
                    })
                });

                this.currency.forEach((a) => {
                    let found = false;
                    rates.forEach((b) => {
                        if (a.id == b.id) {
                            found = true;
                            return;
                        }
                    });

                    if (!found) {
                        rates.push({
                            name: a.name,
                            code: a.code,
                            symbol: a.symbol,
                            rate: 1,
                            exchange_rate: 1,
                            hq_rate: 1,
                            currency: a.id,
                            id: a.id
                        })
                    }
                });

                return rates;
            },
            total_amount: function() {
                var sum = 0;
                for (var i = 0; i < this.items.length; i++) {
                    if (this.items[i]['quantity'] > 0 && this.items[i]['price'] > 0) {
                        sum += (Number.parseFloat(this.items[i]['quantity']) * Number.parseFloat(this.items[i]['price']));
                    }
                }
                return myRound(sum);
            },
        },
        methods: {
            checkExistingService(index = null, id = '') {
                var fixedAsset_temp = this.fixedAsset.slice();
                for (var i = 0; i < this.fixedAssetData.length; i++) {
                    if (this.fixedAssetData[i].selected != null) {
                        var fined = fixedAsset_temp.findIndex((item) => item.name == this.fixedAssetData[i].selected.name);
                        if (fined != -1) {
                            var o = fixedAsset_temp.splice(fixedAsset_temp.findIndex((item) => item.name == this.fixedAssetData[i].selected.name), 1);
                        }
                    }
                }

                this.fixedAssetData[index].fixedAsset_list = fixedAsset_temp.filter((item) => {
                    return (new RegExp(name.toLowerCase())).test(item.name.toLowerCase())
                });

            },

            //ajax call to get items
            onItemSearch:_.debounce((search,loading)=>{
                loading(true);
                axios.get("{{route('callMethod.search')}}",{
                    params:{
                    method_name:'itemSearchProcurment',
                    keyword:search,
                    }
                })
                .then(function (response)
                {
                    vu.temp_items=[];
                    if(response.data.length>0)
                    {
                    console.log('ddddd',response.data)
                        vu.temp_items=response.data;
                    }
                    loading(false);
                })
                .catch(function (error)
                {
                    console.log(error);
                });
            },getDebounceTime()),

            // set new price
            setNewRate(type=null,index)
            {
                if(type=='inventory')
                { 
                    if(this.inventories[index].item)
                    {
                        this.inventories[index].item.new_rate = this.$refs.in[index].value;
                    }
                }
                
            },

            measureChange(index)
            {
                if(this.inventories[index].item !=null){
                    var item=this.inventories[index].item;
                    var temp=((item.rate*item.measure.measure_unit/item.measure_unit));
                    result=Number.parseFloat(temp).toFixed(precision());
                    this.inventories[index].item.new_rate =result;
                }
            },

            // generic function for adding item to list
            addNew(type = null, index) {
                if (type != null) {
                    if (type == 'item') {
                        if (this.items[index + 1] == undefined) {
                            this.items.push({
                                quantity: null,
                                description: null,
                                price: null,
                                um_id: null
                            });
                        }
                    }
                    if (type == 'fixedAsset') {
                        if (this.fixedAssetData[index + 1] == undefined) {
                            this.checkExistingService(index, '');
                            this.fixedAssetData.push({
                                description: null,
                                fixedAsset_list: this.fixedAsset,
                                selected: null
                            });
                        }
                    }
                    if(type=='inventory')
                    {
                        if(this.inventories[index+1]==undefined)
                        {
                        this.temp_items=[];
                        this.inventories.push({item:null});
                        }
                    }
                }

            },

            // delete item from list
            deleteItem(type = null, index) {
                if (type != null) {
                    if (type == 'item') {
                        this.items.splice(index, 1);
                    }
                    if (type == 'fixedAsset') {
                        this.fixedAssetData.splice(index, 1);
                    }
                    if(type=='inventory')
                    {
                        this.inventories.splice(index, 1);
                    }
                }

            },
        }
    });
</script>

@endpush