
@push('scripts')
    <script>
        Vue.component('form-modal', {
            props: {
                route: {
                    type: String,
                    required: true
                },
                method:{
                    type: String,
                    required: true
                },
                modalId:{
                    type: String,
                    required: true
                }


            },
            template: `

                              <div class="modal fade" :id="modalId" tabindex="-1" role="dialog">
                    <div class="modal-dialog modal-lg" role="document">
                        <div class="modal-content">
                            <div class="modal-header">
                                <button type="button" data-dismiss="modal" class="close">
                                    <span aria-hidden="true"> &times;</span>
                                </button>

                                <slot name="header"></slot>

                            </div>

                            <div class="modal-body">
                                <form :action="route" class="form" id="form-home" :method="method">
                                    {!! csrf_field() !!}
                                <div class="row">
                                    <slot name="body">

                                    </slot>
                                </div>
                            </form>
                        </div>

                        <div class="modal-footer">
                            <button type="button" class="btn btn-success" data-dismiss="modal" @click="submit">
                                <i class="fa fa-send"></i> @lang('layout.Submit')
                                </button>
                            </div>
                        </div>
                    </div>
                </div>

                `,
            methods: {
                submit() {
                    $("form#form-home").submit();
                }
            }
        });
    </script>
@endpush