@extends('layouts.app')
@section('content')

@include('layouts.modal')


    <div id="print-modal">
        <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute"
                      v-if="is_show" :value-type="'chit_chat_list'" @closed="closeModal">
            <div slot="body">
                <!----------------------------------------------
                ----Begin Report Body And Custome Report-------
                ----------------------------------------------->
                <div class="row" v-cloak>
                         <div class="tabbable tabbable-tabdrop">

                            <ul class="nav nav-tabs">
                                
                                <li class="active">
                                    <a href="#tab1" data-toggle="tab" id="tab_main">@lang('menu.Report')</a>
                                </li>
                               @if(systemConfig()[2] != 0 )
                                        @permission(['customreport-list'])
                                <li class="">
                                    <a href="#tab2" data-toggle="tab" id="tab_custome">@lang('layout.CustomReportM')</a>
                                </li>
                                @endpermission
                                @endif
                            </ul>
                            <div class="tab-content">
                                 <div class="tab-pane active" id="tab1"> 
                                    <div class="portlet light bordered">
                                        <div class="row">
                                            <div class="form-group">
                                                <div class="col-md-6">
                                                    <label class="control-label ">@lang('layout.Member') </label>
                                                    <v-select class="vue-select2" v-model="selecteduser" label="name" :options="{{ $users }}">
                                                    </v-select>
                                                    <input type="hidden" name="user_id" v-model.number="(!selecteduser)?null:selecteduser.id">
                                                </div>
                                                <div class="col-md-6">
                                                    <label class="control-label">@lang('layout.Status')</label>
                                                    <select name="status" class="form-control">
                                                        <option value="">@lang('layout.Select')</option>
                                                        <option value="NotRead">@lang('layout.NotRead')</option>
                                                        <option value="Readed">@lang('layout.Readed')</option>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="form-group">
                                                <div class="col-md-12">
                                                    <div class="form-group">
                                                        <label class="control-label"> @lang('layout.Date')</label>
                                                        <div slot="date">
                                                            <div class="input-group">
                                                                <input class="form-control date" id="range-from-example" autocomplete="off" name="from_date">
                                                                <span class="input-group-addon"> @lang('layout.To') </span>
                                                                <input class="form-control date" id="range-to-example" autocomplete="off" name="to_date">
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div> 

                                <div class="tab-pane" id="tab2"> 
                                   <div class="portlet light bordered">
                                        <div class="portlet-body">

                                            <form  id="saveCustomeReport" role="form" action="{{route('customeReport.storeCustomeReport')}}" method="post" >
                                                @csrf
                                                <input type="hidden" name="part_name" value="messaging_index">


                                                <div class="col-md-12 col-sm-12 col-xs-12">

                                                    <div class="mt-checkbox-inline col-md-2" v-for="(row,itemIndex) in customReportData">

                                                        <div class="form-group">
                                                             <label> @{{ row.Name }}</label>

                                                              <input type="hidden" :name="'column_name['+itemIndex+']'" class="form-control" v-model="row.column_name">

                                                             <label class="switch">
                                                                    <input type="checkbox" :name="'column_status['+itemIndex+']'" 
                                                                    :checked="row.checkedColumn" >
                                                                  <span class="slider round"></span>
                                                            </label>
                                                            <select :name="'column_percentage['+itemIndex+']'" v-model="row.column_percentage" class="form-control" style="width: 90%;">
                                                                <option value="">@lang('layout.Select')</option>
                                                                <option value="2">2 %</option>
                                                                <option value="6">6 %</option>
                                                                <option value="10">10 %</option>
                                                                <option value="15">15 %</option>
                                                                <option value="20">20 %</option>
                                                                <option value="25">25 %</option>
                                                                <option value="30">30 %</option>
                                                                <option value="40">40 %</option>
                                                                <option value="50">50 %</option>
                                                                <option value="60">60 %</option>
                                                            </select>

                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="margiv-top-10">
                                                    <!-- <button type="button" onclick="regForm(this)" class="btn green"> <i class="fa fa-save"></i> </button> -->

                                                    <button type="button" onclick="saveCustomeReport(this)" class="btn blue"> <i class="fa fa-save"></i> </button>
                                                </div>
                                        </form>
                                        </div>
                                </div>
                        </div>
                        </div>
                    </div>
                </div>
                <!----------------------------------------------
                ----Begin Report Body And Custome Report-------
                ----------------------------------------------->

            </div>
        </report-modal>
    </div>



<!-- END PAGE HEADER-->

<!-- BEGIN TAB PORTLET--> 
<div class="row"> 
    <div class="portlet light bordered">
        <div class="portlet-title">
            <div class="caption font-dark">
                <i class="icon-settings font-dark"></i>&nbsp;
                <span class="caption-subject bold uppercase">@lang('layout.ChitChatList') </span>
            </div>
             <div class="btn-group pull-right">
                    <!-- <a href="{{route('nProOrder.index_on')}}">
						<button class="btn btn-success">
                            <i class="fa"></i> @lang('layout.ActiveList')
                            
                            <span class="badge badge-default" style="color: #ffffff; background-color: #f90000; font-size: 15px !important;"> 21 </span>
                            
                        </button>
                    </a> -->
                    @permission('ToDo-export')
                        <span id="anchore-modal">
                            <a  @click.prevent="showModal" id="" class="btn  btn-success">
                            <i class="fa fa-print"></i>
                            </a>
                        </span>
                    @endpermission
                    @permission('ToDo-create')
                    <!-- <a href="{{route('messaging.create')}}">
                        <button class="btn btn-success">
                            <i class="fa fa-plus"></i> @lang('layout.AddNew')
                    </button></a> -->
                    @endpermission
                    <div id="nProOrder" v-cloak>
                        
                        <!-- <button class="btn btn-success" id="show-modal" @click="showModal =true">@lang('layout.AddNew')</button> -->

                         <modal v-if="showModal" @close="showModal = false">
                            <div slot="header">
                                <div class="col-md-12 col-sm-12 col-xs-12">
                                    <h3>
                                        @lang('layout.projectCategoryCreate')
                                    </h3>
                                </div>
                                <div class="col-md-4">
                                    <div v-if="fieldErrors.length > 0">
                                        <p class="text-danger" fieldErrors>
                                            <spna v-text="fieldErrors"></spna>
                                        </p>
                                    </div>
                                </div>
                            </div>
                            <div slot="body">
                                <div class="row">
                                    <div class="col-md-12">
                                        <label class="control-label">@lang('layout.Status')</label>
                                        <select name="status" class="form-control" v-model="status" >
                                            <option value="Active">@lang('layout.Active')</option>
                                            <option value="Deactive">@lang('layout.Deactive')</option>
                                            <option value="OnProgress">@lang('layout.OnProgress')</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="row">
                                    <input type="hidden" name="toDoList_id" v-model="todo_id">
                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <label>@lang("layout.Description") <span class="required"> * </span></label>
                                            <textarea class="form-control" name="description" v-model="description"></textarea>
                                        </div>

                                    </div>
                                </div>
                            </div>


                            <div slot="footer">
                                <button type=button class="btn btn-success" @click="addClass" >
                                    @lang('layout.OK')
                                </button>
                                <button type=button class="btn btn-danger"
                                       @click="showModal =false" >
                                    @lang('layout.Cancel')
                                </button>
                            </div>
                        </modal>
                        
                    </div>

            </div>
        </div>
        <div class="portlet-body">

            <template v-cloak id="company_ll">
                <company @company="setCompany"></company>
            </template>

            <table class="table table-striped table-bordered table-hover" cellspacing="1" id="messaging" width="100%">
                <thead>
                <tr> 
                    <th>#</th>
                    <th>@lang('layout.Sender')</th>
                    <th>@lang('layout.Reciever')</th>
                    <th>@lang('layout.Date') </th>
                    <th>@lang('layout.Status') </th>
                    <th>@lang('layout.Message') </th>
                    <th>@lang('layout.Action') </th>
                </tr>
                </thead> 
            </table>
        </div>
    </div>
</div> 
@stop
@include('print.modal')
@include('groupCompanyFilter.select')
@push('scripts')
<script>
    var cust_rep = {!!customeReportNewData('messaging_index')!!};
    Vue.component("v-select", VueSelect.VueSelect);

    function createFeedback(id, status) {
        // var a = document.createElement('a');
        // a.href = "{{url('printTransferBillQuotation')}}/" + id;
        // a.target = "_blank";
        // document.body.appendChild(a);
        // a.click();
        // document.body.removeChild(a);
        vu.showModal = true;
        vu.todo_id = id;
        vu.status = status;
    }

    let data_table;
     $(document).ready(function() { 
        $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
        data_table = $('#messaging').DataTable( {
            ajax: '{{route("messaging.index")}}',
            pageLength:'{{getPageRows()}}',
            responsive:'{{responsiveDataTable()}}',
            pagingType:'{{paginationType()}}',
            order: [
                ["{{orderByColumn()=='number'?0:1}}", "{{getRowOrder()}}"]
            ],
            serverSide: true,
            paging:         true,
            columns: [
            { data: 'id', name: 'id' },
            { data: 'in_user_name', name: 'in_user_name' },
            { data: 'out_user_name', name: 'out_user_name' },
            { data: 'date', name: 'date' },
            { data: 'status', name: 'status' },
            { data: 'massage', name: 'massage' },
            { data: 'action', name: 'action', searchable: false, orderable: false },
            ] 
    }); 
    });
        Vue.component('modal',{
            template: '#modal-template'
        });

     let vu = new Vue({
        el: '#nProOrder',
        data:{
            showModal:false,
            fieldErrors:[],
            status: null,
            description: null,
            todo_id: null,
        },
        methods:{
            addClass(){
             
                // var myData = {name: this.status,description:this.description};

                axios.post("{{route('toDoList.storeFeedback')}}",{
                    toDoList_id:this.todo_id,
                    status:this.status,
                    description:this.description
                })
                .then(function(response){
                    vu.showModal = false;
                    vu.todo_id = null;
                    vu.status = null;
                    vu.description = null;
                    $('#toDoList').DataTable().ajax.reload();
                })
            }
        }
     });

     new Vue({
         el: '#company_ll',
         methods: {
             setCompany: function (event) {
                 if (typeof data_table == 'object'){
                     data_table.clear();
                     data_table.ajax.reload();
                 }
             }
         }
     });

             //Begin Export Modal

    var vm = new Vue({

        el: '#print-modal',
        data: {
            is_show: false,
            pdfRoute: '{!!route('export.PDFAll') !!}',
            excelRoute: '{!! route('export.ExcelAll') !!}',
            selectedRequest: null,
            requestList: [],
            selecteduser: null,
            projectList: [],
            customReportData:
            [      
            {Name: '@lang("layout.Sender")', column_name: 'sender',checkedColumn:(cust_rep.sender)?'checked':'',column_percentage:(cust_rep.sender___percent)?cust_rep.sender___percent:''},
            {Name: '@lang("layout.Message")', column_name: 'message',checkedColumn:(cust_rep.message)?'checked':'',column_percentage:(cust_rep.message___percent)?cust_rep.message___percent:''},
            {Name: '@lang("layout.Reciever")', column_name: 'reciever',checkedColumn:(cust_rep.reciever)?'checked':'',column_percentage:(cust_rep.reciever___percent)?cust_rep.reciever___percent:''},
            {Name: '@lang("layout.Date")', column_name: 'date',checkedColumn:(cust_rep.date)?'checked':'',column_percentage:(cust_rep.date___percent)?cust_rep.date___percent:''},
            {Name: '@lang("layout.Status")', column_name: 'status',checkedColumn:(cust_rep.status)?'checked':'',column_percentage:(cust_rep.status___percent)?cust_rep.status___percent:''},
            ],
            cust_rep:cust_rep
        },
        methods: {
            closeModal: function () {
                this.is_show = !this.is_show;
            },
            onProjectSearch(search, loading) {
                loading(true);
                this.searchProject(search, loading, this);
            },

            //ajax call to get items
            searchProject(search, loading, vm) {
                axios.get("{{route('callMethod.search')}}", {
                    params: {
                        method_name: 'anyTable',
                        'search_column': 'name',
                        'table_name': 'ngo_projects',
                        keyword: search,
                    }
                })
                    .then(function (response) {
                        this.projectList = [];
                        if (response.data.length > 0) {
                            vm.projectList = response.data;
                            console.log('data', vm.projectList);
                        }
                        loading(false);
                    })
                    .catch(function (error) {
                        console.log(error);
                    })
            },

            onRequestSearch(search, loading) {
                loading(true);
                this.requestSearch(search, loading, this);
            },

            //ajax call to get items
            requestSearch(search, loading, vm) {
                axios.get("{{route('callMethod.search')}}", {
                    params: {
                        method_name: 'anyTable',
                        'search_column': 'number',
                        'table_name': 'n_pro_orders',
                        keyword: search,
                    }
                })
                    .then(function (response) {
                        this.requestList = [];
                        if (response.data.length > 0) {
                            vm.requestList = response.data;
                            console.log('data', vm.requestList);
                        }
                        loading(false);
                    })
                    .catch(function (error) {
                        console.log(error);
                    })
            },
        }
    });

    var anchor = new Vue({
        el: '#anchore-modal',
        methods: {
            showModal: function () {
                // console.log('trr')
                vm.$data.is_show = true;
            }
        }
    });

</script>

@endpush
