@extends('layouts.app')
@section('style')
<link href="{{url('css/custome-table.css')}}" rel="stylesheet">
@stop
@section('content')
<div class="row">

    <div class="portlet light bg-inverse">
        <div class="portlet-title">
            <div class="caption">
                <i class="icon-equalizer font-green-haze"></i>&nbsp;
                <span class="caption-subject font-green-haze bold uppercase">@lang('layout.ToDoEdit') </span>
                <!-- <span class="caption-helper">some info...</span> -->
            </div>
        </div>
        <div class="portlet-body form" style="margin-bottom: 50%;" id="app">
            <!-- BEGIN FORM-->
            {!! Form::model($toDoList,['method' => 'PATCH','route' => ['toDoList.update',$toDoList->id],'class'=>'form-horizontal']) !!}
            {{ csrf_field() }}
            <div class="form-body">
                <div class="row">
                    <div class="col-md-12">
                        <div class="col-md-6">
                            <label class="control-label">@lang('layout.Priority')</label>
                            <select name="priority" v-model="priority" class="form-control">
                                <option value="High">@lang('type.High')</option>
                                <option value="Medium">@lang('type.Medium')</option>
                                <option value="Low">@lang('type.Low')</option>
                            </select>
                        </div>
                        <div class="col-md-6">
                            <label class="control-label">@lang('layout.Number')</label>
                            <input type="text" name="number" value="{{$toDoList->number}}" class="form-control">
                        </div>
                        <div class="col-md-6">
                            <label class="control-label">@lang('layout.Member')</label>
                            <v-select class="vue-select2" v-model="selectedUser" label="name" :options="{{$user}}">
                            </v-select>
                            <input type="hidden" name="user_id" v-model.number="(!selectedUser)?null:selectedUser.id">
                        </div>
                        <div class="col-md-6">
                            <label class="control-label">@lang('layout.Status')</label>
                            <select name="status" v-model="status" class="form-control">
                                <option value="Active">@lang('layout.Active')</option>
                                <option value="Deactive">@lang('layout.Deactive')</option>
                                <option value="OnProgress">@lang('layout.OnProgress')</option>
                            </select>
                        </div>
                        <div class="col-md-12" style="padding: 0px;" >
                            <div class="col-md-6">
                                <label class="control-label">@lang('layout.DueDate')</label>
                                <input type="text" class="form-control date" value="{{$toDoList->date}}" autocomplete="off" name="date">
                            </div>
                            <div class="col-md-6">
                                <label class="control-label">@lang('layout.Time')</label>
                                <div class="input-group">
                                    <input type="time" class="form-control" name="time" value="{{$toDoList->time}}" >
                                    <span class="input-group-btn">
                                        <button class="btn default" type="button">
                                            <i class="fa fa-clock-o"></i>
                                        </button>
                                    </span>
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-md-12">
                            <label class="control-label">@lang('layout.Details')</label>
                            {!! Form::textarea('description', null, array('placeholder' => __('layout.Details'),'class' => 'form-control','rows' => 3, 'cols' => 30)) !!}
                        </div>
                        <div class="col-md-12" style="padding: 0px;" >
                        </div>

                    </div>
                </div>
            </div>
            <div class="col-xs-12 col-sm-10 col-md-11 text-center">
                <button type="button" class="btn green" onclick="regForm(this)"> @lang('layout.Update') </button>
                <button href="{{url('toDoList.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel') </button>
            </div>
            {!! Form::close() !!}
        </div>
        <!-- END FORM-->
    </div>
</div>
@endsection

@push('scripts')
<script>
    Vue.component('v-select', VueSelect.VueSelect);
    var user = {!!$user!!}; 

    let vu = new Vue({
        el: '#app',
        data: {
            user: user,
            selectedUser: null,
            status: '{{$toDoList->status}}',
            priority: '{{$toDoList->priority}}',
            type: 'Simple',
            items: [],
        },
        computed: {
            
        },
        mounted: function () {
            
            if ("{{$toDoList->member_id}}") {
                this.selectedUser=_.find(user,(v)=>v.id=="{{$toDoList->member_id}}");
            }

        },
        methods: {
            addClass() {

            },

            // generic function for adding item to list
            addNew(type = null, index) {
                if (type != null) {
                    if (type == 'item') {
                        if (this.items[index + 1] == undefined) {
                            this.items.push({quantity: null, description: null, price: null, um_id: null});
                        }
                    }
                }

            },

            // delete item from list
            deleteItem(type = null, index) {
                if (type != null) {
                    if (type == 'item') {
                        this.items.splice(index, 1);
                    }
                }

            },
        }
    });
</script>

@endpush