@extends('layouts.app')
@section('style')
@if(session()->get("system_direction") == "ltr")
    <link rel="stylesheet" href="{{asset('assets/rtl/css/mainStyle.css')}}">
@endif
@if(session()->get("system_direction") == "rtl")
    <link rel="stylesheet" href="{{asset('assets/rtl/css/mainStyleRtl.css')}}">
@endif
@endsection
@section('content')
<div class="mainContents">
    <div class="rightContent">
        <div class="firstRightContent">
            <div>
                <h4><a href="{{route('vendor.index')}}" style="color: white;"> @lang('layout.Vendor') </a></h4>
            </div>
            <div class="firstMainContent">
                <div class="innerMainContents">
                    <div class="leftSubInner">
                        <a href="{{route('purchaseOrder.index')}}" style="text-align: center;">
                            <img src="{{asset('menu_img/transaction-history.png')}}" alt="ok">
                            <h5 style="text-align: center;">@lang('layout.PurchaseOrder')</h5>
                        </a>
                    </div>
                    {{-- <div class="box"></div> --}}
                    <div class="leftSubInner">
                        {{-- <a href="" style="text-align: center;">
                            <img src="{{asset('menu_img/asset.png')}}" alt="ok">
                            <h4 style="text-align: center;">Receive <br> <br> <br> <br> <br> Inventory</h4>
                        </a> --}}
                    </div>
                    <div class="box1"></div>
                    <div class="leftSubInner">
                        <a href="{{route('bill.index')}}" style="text-align: center;">
                            <img src="{{asset('menu_img/calendar.png')}}" alt="ok">
                            <h5 style="text-align: center;">@lang('layout.Enterbill')</h5>
                        </a>
                    </div>
                    <div class="box3"></div>
                    <div class="leftSubInner">
                        <a href="{{route('taxation.index')}}" style="text-align: center;">
                            <img src="{{asset('menu_img/contract.png')}}" alt="ok">
                            <h5 style="text-align: center;">@lang('layout.SaleTaxation')</h5>
                        </a>
                    </div>
                </div>
                <div class="firstInnerMainContents">
                    <div class="leftSubInner">
                        <a href="{{route('bill.index')}}" style="text-align: center;">
                            <img src="{{asset('menu_img/expenses.png')}}" alt="ok">
                            <h5 style="text-align: center;">@lang('layout.Enterbill')</h5>
                        </a>
                    </div>
                    <div class="box2"></div>
                    <div class="box6"></div>
                    <div class="leftSubInner" style="display: flex;align-items: flex-end;">
                        <a href="{{route('payByFactor.index')}}" style="text-align: end;">
                            <img src="{{asset('menu_img/growth.png')}}" alt="ok" style="margin-left: 25%;">
                            <h5 style="text-align: end;">@lang('layout.PayBills')</h5>
                        </a>
                    </div>
                </div>
            </div>
        </div>
        <div class="secondRightContent">
            <div>
                <h4><a href="{{route('customer.index')}}" style="color: white;"> @lang('layout.Customer') </a></h4>
            </div>
            <div class="secondMainContent">
                <div class="secondMainContent">
                    <div class="secondSubInner">
                        <a href="{{route('salesOrder.index')}}" style="text-align: center;">
                            <img src="{{asset('menu_img/transaction-history.png')}}" alt="ok">
                            <h5 style="text-align: center;">@lang('layout.SaleOrder')</h5>
                        </a>
                    </div>
                    <div class="box4"></div>
                    <div class="box7"></div>
                    <div class="secondSubInner" style="align-items: flex-end;">
                        {{-- <a href="" style="text-align: center;">
                            <img src="{{asset('menu_img/asset.png')}}" alt="ok">
                            <h4 style="text-align: center;">Accept <br> <br> <br> <br> <br> Credit Cards</h4>
                        </a> --}}
                    </div>
                    <div class="secondSubInner">
                        <!-- <img src="../calendar.png" alt="ok">
                        <h3>Enter Bills <br> Against Inventory</h3> -->
                    </div>
                    <div class="secondSubInner">
                        <a href="{{route('sale.index')}}" style="text-align: center;">
                            <img src="{{asset('menu_img/contract.png')}}" alt="ok">
                            <h5 style="text-align: center;">@lang('layout.SalesRecept')</h5>
                        </a>
                    </div>
                    <div class="box11"></div>
                </div>
            </div>
            <div class="secondMainContent" style="margin-top: 30px;">
                <div class="secondMainContent">
                    <div class="secondSubInner">
                        <a href="{{route('estimate.index')}}" style="text-align: center;">
                            <img src="{{asset('menu_img/transaction-history.png')}}" alt="ok">
                            <h5 style="text-align: center;">@lang('layout.Estimates')</h5>
                        </a>
                    </div>
                    <div class="box5"></div>
                    <div class="box8"></div>
                    <div class="secondSubInner" style="align-items: flex-start;">
                        <a href="{{route('invoice.index')}}" style="text-align: {{(session()->get("system_direction") == "rtl")?'center':'center'}};">
                            <img src="{{asset('menu_img/asset.png')}}" alt="ok" style="">
                            <h5 style="text-align: {{(session()->get("system_direction") == "rtl")?'center':'center'}};">@lang('layout.Invoice')</h5>
                        </a>
                    </div>
                    <div class="box9"></div>
                    <div class="secondSubInner">
                        <a href="{{route('receive.index')}}" style="text-align: center;">
                            <img src="{{asset('menu_img/contract.png')}}" alt="ok">
                            <h5 style="text-align: center;">@lang('layout.Recevies')</h5>
                        </a>
                    </div>
                    <div class="box10"></div>
                    <div class="secondSubInner">
                        <!-- <img src="../contract.png" alt="ok">
                        <h3>Manage Sales <br> Task</h3> -->
                    </div>
                </div>
            </div>
            <div class="secondMainContent" style="margin-top: 30px;">
                <div class="secondMainContent">
                    <div class="secondSubInner">
                        <!-- <img src="../transaction-history.png" alt="ok">
                        <h3>Sales <br> order</h3> -->
                    </div>
                    <div class="secondSubInner" style="align-items: center;">
                        {{-- <a href="" style="text-align: center;">
                            <img src="{{asset('menu_img/asset.png')}}" alt="ok">
                            <h4 style="text-align: center;">Statement <br> <br> <br> <br> <br> Charges</h4>
                        </a> --}}
                    </div>
                    {{-- <div class="box12"></div> --}}
                    <div class="secondSubInner" style="align-items: flex-start;">
                        <a href="{{route('customer.index')}}" style="text-align: center;">
                            <img src="{{asset('menu_img/contract.png')}}" alt="ok">
                            <h5 style="text-align: center;">@lang('layout.Statements')</h5>
                        </a>
                    </div>
                    <div class="box13"></div>
                    <div class="secondSubInner" style="align-items: flex-end;">
                        <a href="{{route('refund.index')}}" style="text-align: center;">
                            <img src="{{asset('menu_img/contract.png')}}" alt="ok">
                            <h5 style="text-align: center;">@lang('layout.Refund')</h5>
                        </a>
                    </div>
                </div>
            </div>
        </div>
        <div class="thirdRightContent">
            <div>
                <h4><a href="{{route('employee.index')}}" style="color: white;"> @lang('layout.Employee') </a></h4>
            </div>
            <div class="firstMainContent">
                <div class="firstInnerMainContents">
                    <div class="leftSubInner" style="display: flex;align-items: flex-end;">
                        <a href="{{route('salaryDetails.index')}}" style="text-align: center;">
                            <img src="{{asset('menu_img/growth.png')}}" alt="ok">
                            <h5 style="text-align: center;">@lang('layout.SalaryDetails')</h5>
                        </a>
                    </div>
                    <div class="box15"></div>
                    <div class="leftSubInner" style="display: flex;align-items: flex-end;">
                        <a href="{{route('payroll.index')}}" style="text-align: center;">
                            <img src="{{asset('menu_img/standards.png')}}" alt="ok">
                            <h5 style="text-align: center;">@lang('layout.Payroll')</h5>
                        </a>
                    </div>
                    <div class="box16"></div>
                    <div class="leftSubInner" style="display: flex;align-items: flex-end;">
                        <a href="{{route('paySalary.index')}}" style="text-align: center;">
                            <img src="{{asset('menu_img/money.png')}}" alt="ok">
                            <h5 style="text-align: center;">@lang('layout.PaySalary')</h5>
                        </a>
                    </div>
                    <div class="leftSubInner">
                        {{-- <a href="" style="text-align: center;">
                            <img src="{{asset('menu_img/expenses.png')}}" alt="ok">
                            <h4 style="text-align: center;">Enter <br> <br> <br> <br> <br> Times</h4>
                        </a> --}}
                    </div>
                    {{-- <div class="box14"></div> --}}
                    <div class="leftSubInner" style="display: flex;align-items: flex-end; justify-content: center;">
                        <div style=" text-align: end; cursor: pointer;" class="Alldropdown">
                            <img src="{{asset('menu_img/hrm.png')}}" style="width: 20%; text-align: center;" alt="ok">
                            <button class="dropdownBtn" onclick="toggleDropdownBtn(event)"><i class="fa fa-caret-down"></i></button>
                            <div class="dropdown-content" id="dropdownMenu">
                                <a href="{{route('attendanceSheet.index')}}">@lang('layout.Attendance')</a>
                                <a href="{{route('attendanceType.index')}}">@lang('Menu.AttendanceSheetType')</a>
                                <a href="{{route('shift.index')}}">@lang('layout.Shift')</a>
                                <a href="{{route('leaveType.index')}}">@lang('layout.Leave')</a>
                                <a href="{{route('overtime.index')}}">@lang('layout.OverTimeAddition')</a>
                                <a href="{{route('overtimeType.index')}}">@lang('Menu.OvertimeType')</a>
                                <a href="{{route('overTimeRequest.index')}}">@lang('layout.OverTimeRequest')</a>
                                <a href="{{route('employeeLeaves.index')}}">@lang('layout.Employeeleaves')</a>
                            </div>
                        </div>
                        <a >
                            <h5>@lang('layout.Hr')</h5>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="leftContent">
        <div class="firstLeftContent">
            <div>
                <h4><a href="{{route('company.index')}}" style="color: white;"> @lang('layout.Company') </a></h4>
            </div>
            <div class="innerContents">
                <div class="subInner" style="margin-bottom: 20px;">
                    <a href="{{route('account.index')}}" style="text-align: center;">
                        <img src="{{asset('menu_img/growth.png')}}" alt="ok">
                        <h5 style="text-align: center;">@lang('menu.ChartOfAccount')</h5>
                    </a>
                </div>
                <div class="subInner">
                    <div style=" text-align: center; cursor: pointer;" class="Alldropdown">
                        <img src="{{asset('menu_img/inventory-management.png')}}" alt="ok">
                        <button class="dropdownBtn" onclick="toggleDropdownBtn(event)"><i class="fa fa-caret-down"></i></button>
                        <div class="dropdown-content" style="text-align: right" id="dropdownMenu1">
                            <a href="{{route('inventory.index')}}">@lang('layout.Inventory')</a>
                            <a href="{{route('adjustment.index')}}">@lang('menu.Adjustment')</a>
                            <a href="{{route('inventoryCategory.index')}}">@lang('layout.InventoryCategory')</a>
                            <a href="{{route('cargoSite.index')}}">@lang('layout.InventorySite')</a>
                            <a href="{{route('inventoryTransfer.index')}}">@lang('layout.InventoryTransfer')</a>
                        </div>
                    </div>
                    <a href="" style="text-align: center;">
                        <h5 style="text-align: center;">@lang('layout.Inventory')</h5>
                    </a>
                </div>
                <div class="subInner">
                    <div style=" text-align: center; cursor: pointer;" class="Alldropdown">
                        <img src="{{asset('menu_img/service.png')}}" alt="ok">
                        <button class="dropdownBtn" onclick="toggleDropdownBtn(event)"><i class="fa fa-caret-down"></i></button>
                        <div class="dropdown-content" style="text-align: right" id="dropdownMenu2">
                            <a href="{{route('inventory.index')}}">@lang('layout.Items')</a>
                            <a href="{{route('service.index')}}">@lang('layout.Service')</a>
                        </div>
                    </div>
                    <a href="" style="text-align: center;">
                        <h5 style="text-align: center;">@lang('layout.Items') & @lang('layout.Service')</h5>
                    </a>
                </div>
                <div class="subInner">
                    {{-- <a href="" style="text-align: center;">
                        <img src="{{asset('menu_img/money.png')}}" alt="ok">
                        <h4 style="text-align: center;">Order <br> <br> <br> <br> <br> Checks</h4>
                    </a> --}}
                </div>
                <div class="subInner">
                    {{-- <a href="" style="text-align: center;">
                        <img src="{{asset('menu_img/calendar.png')}}" alt="ok">
                        <h4 style="text-align: center;">Calendar</h4>
                    </a> --}}
                </div>
            </div>
        </div>
        <div class="secondLeftContent">
            <div>
                <h4><a href="{{route('account.index')}}" style="color: white;"> @lang('layout.Banking') </a></h4>
            </div>		
            <div class="leftInnerContents">
                <div class="leftSubInner" style="margin-bottom: 5px;">
                    <div style=" text-align: center; cursor: pointer;" class="Alldropdown">
                        <img src="{{asset('menu_img/report.png')}}" alt="ok">
                        <button class="dropdownBtn" onclick="toggleDropdownBtn(event)"><i class="fa fa-caret-down"></i></button>
                        <div class="dropdown-content" style="text-align: right" id="dropdownMenu3">
                            <a href="{{route('expense.index')}}">@lang('layout.WriteCheckExpense')</a>
                            <a href="{{route('purchase.index')}}">@lang('layout.Writecheck')</a>
                        </div>
                    </div>
                    <a href="" style="text-align: center;">
                        <h5 style="text-align: center;">@lang('layout.WriteChecks')</h5>
                    </a>
                </div>
                <div class="leftSubInner">
                    <a href="{{route('cheque.index')}}" style="text-align: center;">
                        <img src="{{asset('menu_img/standards.png')}}" alt="ok">
                        <h5 style="text-align: center;">@lang('menu.Cheque')</h5>
                    </a>
                </div>
                <div class="leftSubInner">
                    <a href="{{route('loan.index')}}" style="text-align: center;">
                        <img src="{{asset('menu_img/transaction-history.png')}}" alt="ok">
                        <h5 style="text-align: center;">@lang('menu.DepositAndWithdrawal')</h5>
                    </a>
                </div>
                <div class="leftSubInner">
                    {{-- <a href="" style="text-align: center;">
                        <img src="{{asset('menu_img/expenses.png')}}" alt="ok">
                        <h4 style="text-align: center;">Reconcile</h4>
                    </a> --}}
                </div>
                <div class="leftSubInner">
                    {{-- <a href="" style="text-align: center;">
                        <img src="{{asset('menu_img/contract.png')}}" alt="ok">
                        <h4 style="text-align: center;">Print <br> <br> <br> <br> <br> checks</h4>
                    </a> --}}
                </div>
            </div>
        </div>
    </div>
</div>
<script>
    function toggleDropdownBtn(event){
        event.stopPropagation();
        closeAllDropdown();
        var dropdown = event.currentTarget.nextElementSibling;
        dropdown.classList.toggle("show");
    }
    function closeAllDropdown(){
        var dropdown = document.getElementsByClassName("dropdown-content");
        for(var i=0; i<dropdown.length; i++){
            dropdown[i].classList.remove('show');
        }
    }
    window.onclick = function(event){
        if(!event.target.matches('.fa-caret-down')){
            closeAllDropdown();
        }
    }
    // function toggleDropdownBtn(event){
    //     event.stopPropagation();
    //     var dropdown = document.getElementById("dropdownMenu");
    //     if(dropdown.style.display === "block"){
    //         dropdown.style.display = "none";
    //     }
    //     else
    //     {
    //         dropdown.style.display = "block";
    //     }
    // }
    // function toggleDropdownBtn1(event){
    //     event.stopPropagation();
    //     var dropdown = document.getElementById("dropdownMenu1");
    //     if(dropdown.style.display === "block"){
    //         dropdown.style.display = "none";
    //     }
    //     else
    //     {
    //         dropdown.style.display = "block";
    //     }
    // }
    // // function toggleDropdownBtn2(event){
    // //     event.stopPropagation();
    // //     var dropdown = document.getElementById("dropdownMenu2");
    // //     if(dropdown.style.display === "block"){
    // //         dropdown.style.display = "none";
    // //     }
    // //     else
    // //     {
    // //         dropdown.style.display = "block";
    // //     }
    // // }
    // function toggleDropdownBtn2(event){
    //     event.stopPropagation();
    //     var dropdown = document.getElementById("dropdownMenu3");
    //     dropdown.classList.toggle("show");
    // }
    
    // window.onclick = function(event){
    //     if(!event.target.matches('.fa-caret-down')){
    //         var dropdown = document.getElementById("dropdownMenu3");
    //         if(dropdown.classList.contains('show')){
    //             dropdown.classList.remove('show');
    //         }
    //     }
    // }
    // // function toggleDropdownBtn3(event){
    // //     event.stopPropagation();
    // //     var dropdown = document.getElementById("dropdownMenu3");
    // //     if(dropdown.style.display === "block"){
    // //         dropdown.style.display = "none";
    // //     }
    // //     else
    // //     {
    // //         dropdown.style.display = "block";
    // //     }
    // // }
    // // function toggleDropdownBtn3(event){
    // //     event.stopPropagation();
    // //     var dropdown = document.getElementById("dropdownMenu3");
    // //     dropdown.classList.toggle("show");
    // // }

    // // window.onclick = function(event){
    // //     if(!event.target.matches('.fa-caret-down')){
    // //         var dropdown = document.getElementById("dropdownMenu3");
    // //         if(dropdown.classList.contains('show')){
    // //             dropdown.classList.remove('show');
    // //         }
    // //     }
    // // }
    // // window.onclick = function(event){
    // //     // if(!event.target.matches('.dropdownBtn')){
    // //         var dropdown = document.getElementByClassName("dropdown-content");
    // //         for(var i = 0; i<dropdown.length; i++){
    // //             var openDropdown = dropdown[i];
    // //             if(openDropdown.style.display === "block" && !event.target.closest('.dropdown')){
    // //                 openDropdown.style.display = "none";
    // //             }
    // //         }
    // //     // }
    // // }
</script>
@endsection