@extends('layouts.app')


@section('style')
@stop


@section('content')
    <div class="row">

        <div class="portlet light bg-inverse" style="min-height: 100%;">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>&nbsp;
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.GuarantorEdit') </span>
                    <!-- <span class="caption-helper">some info...</span> -->
                </div>
                <div class="tools">
                    
                </div>
            </div>

            <div class="portlet-body form" style="margin-bottom:50%;" id="app">
                <!-- BEGIN FORM-->
                {!! Form::model($memberGuarantor, ['method' => 'PATCH','class'=>'form-horizontal','files'=> true,'route' => ['memberGuarantor.update',$memberGuarantor->id]]) !!}
                {{ csrf_field() }}
                <input type="hidden" name="redirect_route" value="employee.show">
                <div class="form-body">
                    <div class="row">
                        <div class="col-md-4">
                                <label class="control-label">@lang('layout.Name')</label>
                                {!! Form::text('name', null, array('class' => 'form-control','@click'=>"addNew(index)",'autocomplete'=>'off')) !!}
                        </div> 
                        <div class="col-md-2">
                                <label class="control-label">@lang('layout.FatherName')</label>
                                {!! Form::text('father_name', null, array('class' => 'form-control','autocomplete'=>'off')) !!}
                        </div>
                        <div class="col-md-2">
                            <label class="control-label ">@lang('layout.GrandFather')</label>
                            {!! Form::text('grand_father_name', null, array('class' => 'form-control','autocomplete'=>'off')) !!}
                        </div> 
                        <div class="col-md-4">
                                <label class="control-label" >@lang('layout.Phone')</label>
                                {!! Form::text('phone', null, array('class' => 'form-control','autocomplete'=>'off')) !!}
                        </div> 
                    </div> 
                    <div class="row">
                        <div class="col-md-4">
                                <label class="control-label ">@lang('layout.Address')</label>
                                {!! Form::text('address', null, array('class' => 'form-control','autocomplete'=>'off')) !!}
                    
                        </div>
                        <div class="col-md-4">
                                <label class="control-label">@lang('layout.City')</label>
                                    {!! Form::text('city', null, array('class' => 'form-control')) !!}
                        </div>
                        <div class="col-md-4">
                            <label class="control-label  ">@lang('layout.Country')</label>
                            {!! Form::text('country', null, array('class' => 'form-control')) !!}
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-2">
                            <label class="control-label ">@lang('layout.District')</label>
                            {!! Form::text('district', null, array('class' => 'form-control','autocomplete'=>'off')) !!}
                        </div>
                        <div class="col-md-2">
                            <label class="control-label ">@lang('layout.Village')</label>
                            {!! Form::text('village', null, array('class' => 'form-control')) !!}
                        </div>
                        <div class="col-md-4">
                                <label class="control-label ">@lang('layout.CurrentLocation')</label>
                                {!! Form::text('current_location', null, array('class' => 'form-control','autocomplete'=>'off')) !!}
                        </div>
                        <div class="col-md-4">
                                <label class="control-label ">@lang('layout.MainLocation')</label>
                                {!! Form::text('main_location', null, array('class' => 'form-control','autocomplete'=>'off')) !!}
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-4">
                                <label class="control-label ">@lang('layout.JobTitle')</label>
                                {!! Form::text('job_title', null, array('class' => 'form-control','autocomplete'=>'off')) !!}
                        </div>
                        <div class="col-md-4">
                                <label class="control-label ">@lang('layout.NationalNumber')</label>
                                {!! Form::text('national_number', null, array('class' => 'form-control','autocomplete'=>'off')) !!}
                        </div>
                        <div class="col-md-4">
                                <label class="control-label ">@lang('layout.NationalVolume')</label>
                                {!! Form::text('national_volume', null, array('class' => 'form-control','autocomplete'=>'off')) !!}
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-2">
                                <label class="control-label ">@lang('layout.Page')</label>
                                {!! Form::text('national_page', null, array('class' => 'form-control','autocomplete'=>'off')) !!}
                        </div>
                        <div class="col-md-2">
                                <label class="control-label ">@lang('layout.RegistrationNumber')</label>
                                {!! Form::text('national_reg_number', null, array('class' => 'form-control','autocomplete'=>'off')) !!}
                        </div>
                        <div class="col-md-4">
                                <label class="control-label ">@lang('layout.IntroducedBy')</label>
                                {!! Form::text('introduced_by', null, array('class' => 'form-control','autocomplete'=>'off')) !!}
                        </div>

                        <div class="col-md-4">
                            <?php
                                $photo = null;
                                if($memberGuarantor && $memberGuarantor->photo!=null)
                                {
                                    $photo =  $memberGuarantor->photo;
                                }
                            ?>
                            <div class="form-group">
                                    <div class="col-md-8">
                                        <div class="fileinput fileinput-new" data-provides="fileinput" style="padding-top: 7px;"> 
                                            <div class="fileinput-new thumbnail" style="width: 100px; height: 70px;">
                                                <img src="{!!url('/uploads/'.$photo)!!}" alt=""/>
                                            </div>
                                            <div class="fileinput-preview fileinput-exists thumbnail"
                                                style="max-width: 200px; max-height: 150px;"></div>
                                            <div>
                                                    <span class="btn default btn-file">
                                                        <span class="fileinput-new">@lang('layout.SelectImage')</span>
                                                        <span class="fileinput-exists">@lang('layout.Change')</span>
                                                        <!-- <input type="file" name="photo">  -->
                                                        {!! Form::file('photo', []) !!}</span>
                                                        {!! Form::hidden('photo1', (!$memberGuarantor)?null:$memberGuarantor->photo) !!}
                                                <a href="javascript:;" class="btn default fileinput-exists"
                                                data-dismiss="fileinput">@lang('layout.Remove')</a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                    </div>

                </div>
                <div class="col-xs-12 col-sm-10 col-md-11 text-center">
                    <button type="button" class="btn green" onclick="regForm(this)">@lang('layout.Submit')</button>
                    <a href="{{url()->previous()}}" class="btn default"><i
                                class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                </div>
                {!! Form::close() !!}
            </div>

            <!-- END FORM-->
        </div>



    </div>

@endsection
@push('scripts')

    <script type="text/javascript">



        
    </script>

@endpush
 