@extends('layouts.app')
@section('style')

@stop
@section('content')


    <div class="portlet" >
        <div class="portlet-title" id="backbtn">
            <div class="caption">
                <i class=""></i>@lang('menu.MemberContact')
            </div>
        </div>
        <div class="portlet-body">
            <div class="">    
                <div class="col-md-12">
                    <!--begin: widget 1-2 -->
                    <div class="mt-widget-1">
                        <div class="mt-icon">
                            <a title="{{btnTitle('Edit')}}"  href="{{ route('memberContact.edit', ['id' => $memberContact->id]) }}">
                                <i class="fa fa-pencil"></i>
                            </a>
                        </div>
                        <div class="mt-img">
                            @if($memberContact && $memberContact->photo !=Null)
                                    
                                    <img class=" twPc-avatarImg"
                                    src="{!!url('/uploads/'.$memberContact->photo)!!}"
                                    style="width:120px; height:120px;">

                            @else
                            <img class="twPc-avatarImg" src="{{asset('uploads/avatar.png')}}"
                                    style="width:120px; height:120px;">
                            @endif
                            
                        </div>
                        <div class="mt-body">
                            <h3 class="mt-username">{{($memberContact)? $memberContact->name:'' }}</h3>
                            <p class="mt-user-title">{{ ($memberContact)? $memberContact->phone:'' }}  </p>
                            <div class="mt-stats">
                                <div class="btn-group btn-group btn-group-justified">
                                    <table class="table">
                                        <tr style="background-color: #d4d7dc;">
                                            <td>@lang('layout.Number')</td>
                                            <td>@lang('layout.LastName')</td>
                                            <td>@lang('layout.Pseudonym')</td>
                                            <td>@lang('layout.FatherName')</td>
                                            <td>@lang('layout.Gender')</td>
                                        </tr>
                                        <tr>
                                            <td > {{ ($memberContact)? $memberContact->number:'' }}  </td>
                                            <td > {{ ($memberContact)? $memberContact->last_name:'' }}  </td>
                                            <td > {{ ($memberContact)? $memberContact->pseudonym:'' }}  </td>
                                            <td > {{ ($memberContact)? $memberContact->father_name:''}}  </td>
                                            <td > {{ ($memberContact)? __('type.'.$memberContact->gender):''}}  </td>
                                        </tr> 
                                    </table>
                                    <hr>
                                    <table class="table">
                                        <tr style="background-color: #d4d7dc;">
                                            <td>@lang('layout.Phone')</td>
                                            <td>@lang('layout.Phone')2</td>
                                            <td>@lang('layout.HomePhone')</td>
                                            <td>@lang('layout.WorkPhone')</td>
                                            <td>@lang('layout.OtherPhone')</td>
                                            <td>@lang('layout.OtherPhone')2</td>
                                            <td>@lang('layout.Email')</td>
                                            <td>@lang('layout.WebSite')</td>
                                        </tr>
                                        <tr>
                                            <td > {{ ($memberContact)? $memberContact->phone:'' }}  </td>
                                            <td > {{ ($memberContact)? $memberContact->phone2:'' }}  </td>
                                            <td > {{ ($memberContact)? $memberContact->home_phone:'' }}  </td>
                                            <td > {{ ($memberContact)? $memberContact->work_phone:''}}  </td>
                                            <td > {{ ($memberContact)? $memberContact->other_phone:''}}  </td>
                                            <td > {{ ($memberContact)? $memberContact->other_phone2:''}}  </td>
                                            <td > {{ ($memberContact)? $memberContact->email:''}}  </td>
                                            <td > {{ ($memberContact)? $memberContact->website:''}}  </td>
                                        </tr> 
                                    </table>
                                    <hr>
                                    <table class="table">
                                        <thead>
                                        <tr style="background-color: #d4d7dc;">
                                            
                                            <td>@lang('layout.Country')</td>
                                            <td>@lang('layout.City')</td>
                                            <td>@lang('layout.District')</td>
                                            <td>@lang('layout.Village')</td>
                                            <td>@lang('layout.Address')</td>
                                            <td>@lang('layout.Address')2</td>
                                            <td>@lang('layout.PostCode')</td>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        <tr>
                                            <td class=""> {{ ($memberContact)? $memberContact->country:'' }}  </td>
                                            <td class=""> {{ ($memberContact)? $memberContact->city:'' }}  </td>
                                            <td class=""> {{ ($memberContact)? $memberContact->district:'' }}  </td>
                                            <td class=""> {{ ($memberContact)? $memberContact->village:'' }}  </td>
                                            <td class=""> {{ ($memberContact)? $memberContact->address1:'' }}  </td>
                                            <td class=""> {{ ($memberContact)? $memberContact->address2:'' }}  </td>
                                            <td class=""> {{ ($memberContact)? $memberContact->post_code:'' }}  </td>
                                        </tr>
                                        </tbody>
                                    </table> 
                                    <hr>
                                    <table class="table">
                                        <thead>
                                        <tr style="background-color: #d4d7dc;">
                                            
                                            <td>@lang('layout.Organization')</td>
                                            <td>@lang('layout.Reference')</td>
                                            <td>@lang('layout.SSID')</td>
                                            <td>@lang('layout.Passport')</td>
                                            <td>@lang('layout.DateOfBirth')</td>
                                            <td>@lang('layout.Date')</td>
                                            <td>@lang('layout.JobTitle')</td>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        <tr>
                                            <td class=""> {{ ($memberContact)? $memberContact->organization:'' }}  </td>
                                            <td class=""> {{ ($memberContact)? $memberContact->reference:'' }}  </td>
                                            <td class=""> {{ ($memberContact)? $memberContact->ss_id:'' }}  </td>
                                            <td class=""> {{ ($memberContact)? $memberContact->passport:'' }}  </td>
                                            <td class=""> {{ ($memberContact)? convertDate($memberContact->date_of_birth):'' }}  </td>
                                            <td class=""> {{ ($memberContact)? convertDate($memberContact->reg_date):'' }}  </td>
                                            <td class=""> {{ ($memberContact)? $memberContact->job_title:'' }}  </td>
                                        </tr>
                                        </tbody>
                                    </table>


                                </div>
                            
                            </div>
                        </div>
                    </div>
                    <!--end: widget 1-2 -->
                </div>
                
            </div>
        </div>
    </div>




    <!-- for factor begin -->

    <div id="factor-obj">

    </div>
    <iframe id="saleFrames" style="display: none;"></iframe>

    <!-- end for factor -->

@endsection
@push('scripts')

@endpush
