@extends('layouts.app')
@section('style')

<style>

.modal-container{
    width: 50% !important;
}
</style>
@endsection

@section('content')
    <!-- END PAGE HEADER-->
 

    <div id="print-modal">
        <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show"
                      :value-type="'member_contact'"
                      @closed="closeModal">

            <div slot="body">

                <!----------------------------------------------
                ----Begin Report Body  And Custome Report-------
                ----------------------------------------------->
                <div class="row" v-cloak>
                    <div class="portlet light bordered">
                        <div class="row">
                            <div class="form-group">

                                <div class="col-md-4">
                                    <label class="control-label ">@lang('layout.SelectClass')</label>
                                    <v-select class="vue-select2"
                                              v-model="selected_class"
                                              label="name"
                                              :options="member_class"
                                              @search="onClassSearch"
                                              >
                                    </v-select>
                                    <input type="hidden" name="class_id" :value="(!selected_class)?null:selected_class.id">
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="form-group">
                                <div class="col-md-4">
                                        <label class="control-label ">@lang('layout.Date')</label>
                                        <select name="period" v-model="period" @input="getDates()" class="form-control">
                                            <option value="CustomDates">@lang('type.CustomDates')</option>
                                            <option value="Today">@lang('type.Today')</option>
                                            <option value="Yesterday">@lang('type.Yesterday')</option>
                                            <option value="ThisWeek">@lang('type.ThisWeek')</option>
                                            <option value="LastWeek">@lang('type.LastWeek')</option>
                                            <option value="WeekToDate">@lang('type.WeekToDate')</option>
                                            <option value="ThisMonth">@lang('type.ThisMonth')</option>
                                            <option value="MonthToDate">@lang('type.MonthToDate')</option>
                                            <option value="ThisQuarter">@lang('type.ThisQuarter')</option>
                                            <option value="QuarterToDate">@lang('type.QuarterToDate')</option>
                                            <option value="ThisYear">@lang('type.ThisYear')</option>
                                            <option value="YearToDate">@lang('type.YearToDate')</option>
                                        </select>
                                </div>
                                <div class="col-md-8" v-show="period == 'CustomDates'">
                                    <div class="form-group">
                                        <label class="control-label"> @lang('layout.Date')</label>
                                        <div class="input-group">
                                            <input class="form-control date" id="range-from-example" v-model="from_date" name="from_date" autocomplete="off">
                                            <span class="input-group-addon"> @lang('layout.To') </span>
                                            <input class="form-control date" id="range-to-example" v-model="to_date" name="to_date" autocomplete="off">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!----------------------------------------------
                ----Begin Report Body And Custome Report-------
                ----------------------------------------------->
             

            </div>
        </report-modal>
    </div>
    <!-- BEGIN TAB PORTLET-->
    <div class="row">
        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>&nbsp;
                    <span class="caption-subject bold uppercase">@lang('menu.MemberContact')</span>
                </div>
                <div class="tools"></div>

                <div class="pull-right">
                    @permission('MemberContact-export')
                    <span id="anchore-modal">
                     <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                        <i class="fa fa-print"></i>
                     </a>
                 </span>
                    @endpermission

                    <a href="{{route('memberContactClass.index')}}">
                        <button id="sample_editable_1_new" class="btn btn-success">
                            <i class="fa fa-reorder "></i> @lang('menu.MemberContactClass')
                        </button>
                    </a>

                    @permission('MemberContact-create')
                    <a href="{{route('memberContact.create')}}">
                        <button id="sample_editable_1_new" class="btn btn-success">
                            <i class="fa fa-plus"></i> @lang('layout.AddNew')
                        </button>
                    </a>
                    @endpermission
                </div>
            </div>
            <div class="portlet-body">
                <template v-cloak id="company_ll">
                    <company @company="setCompany"></company>
                </template>
                <table class="table table-striped table-bordered table-hover" id="memberContact">
                    <thead>
                        <tr>
                            <th>@lang('layout.Number') </th>
                            <th>@lang('layout.FullName')</th> 
                            <th>@lang('layout.LastName')</th> 
                            <th>@lang('layout.FatherName')</th> 
                            <th>@lang('layout.Phone')</th>
                            <th>@lang('layout.Address')</th>
                            <th>@lang('layout.Class')</th>
                            <th>@lang('layout.User')</th>
                            <th>@lang('layout.Actions')</th>
                        </tr>
                    </thead>
                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->

       
    </div>
    <!-- END TAB PORTLET-->

    <!-- END CONTENT BODY -->
@stop
@include('groupCompanyFilter.select')
@include('print.modal')
@push('scripts')
    <script>
        var cust_rep      = {!!customeReportNewData('member_general_statement')!!};
        var member_class  = {!!json_encode($member_class)!!}

        Vue.component("v-select", VueSelect.VueSelect);

        $(document).ready(function () {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';

            $('#memberContact').DataTable({
                ajax: '{{route("memberContact.index")}}',
                pageLength:'{{getPageRows()}}',
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                fixedHeader:true,
                serverSide: true,
                paging: true,
                order: [["{{orderByColumn()=='number'?0:1}}", "{{getRowOrder()}}"]],
                buttons: [{
                    extend: 'excel',
                    text: '',
                    key: {
                        key: 'x',
                        altkey: true
                    }
                }],
                columns: [
                    {data: 'number', name: 'member_contacts.number'},
                    {data: 'name', name: 'member_contacts.name'},
                    {data: 'last_name', name: 'member_contacts.last_name'},
                    {data: 'father_name', name: 'member_contacts.father_name'},
                    {data: 'phone', name: 'member_contacts.phone'},
                    {data: 'address1', name: 'address1', orderable: false, searchable: false},
                    {data: 'class_name', name: 'member_contact_classes.name'},
                    {data: 'user', name: 'users.name'},
                    {data: 'actions', name: 'actions', orderable: false, searchable: false},

                ]
            });
        });


        var vm = new Vue({
            el: '#print-modal',
            data: {
                period: 'CustomDates',
                from_date: null,
                to_date: null,
                is_show: false,
                pdfRoute: '{!!route('memberContact.report') !!}',
                excelRoute: '{!! route('memberContact.report') !!}',

                selected_class:null,
                member_class:member_class,
                class_id:null

            },
           



            methods: {
                closeModal: function () {
                    this.is_show = !this.is_show
                },
                onClassSearch(search, loading) {
                    loading(true);
                    this.searchClass(search, loading, this);
                },
                //ajax call to get class
                searchClass(search, loading, vm) {
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'anyTable',
                            keyword: search,
                            table_name: 'member_contact_classes',

                        }
                    })
                        .then(function (response) {
                            this.member_class = [];
                            if (response.data.length > 0) {
                                vm.member_class = response.data;
                            }
                            loading(false);
                        })
                        .catch(function (error) {
                            console.log(error);
                        })
                }
            }
        });


        new Vue({
            el: '#anchore-modal',
            methods: {
                showModal: function () {
                    vm.$data.is_show = true;
                }
            }
        });

        new Vue({
            el: '#company_ll',
            methods: {
                setCompany: function (event) {
                    window.location.reload();
                }
            }
        });

    </script>
@endpush


@section('vselectStyle')
    <style type="text/css">
        .v-select .selected-tag {
            height: 26px !important;
            margin: 4px 1px 0 3px !important;
        }
        .v-select .selected-tag > button >span{
            display: none !important;
        }
    </style>
@endsection