@extends('layouts.app')
@section('style')

 <link href="{{url('/assets/bootstrap-fileinput/bootstrap-fileinput.css')}}" rel="stylesheet" type="text/css"/>

 <style>
     .select_style{
        outline:1px solid #c2cad8 !important
     }
 </style>
@stop

@section('content') 

    <div class="row"  id="app" v-cloak> 
        <div class="portlet light bg-inverse">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>&nbsp;
                    <span class="caption-subject font-green-haze bold uppercase">@lang('menu.MemberContact')</span>
                </div>
                <div class="tools">
                    
                </div>
            </div>
            <div  class="portlet-body form" >
                <!-- BEGIN FORM-->
                {!! Form::model($memberContact,['method' => 'PATCH','route' => ['memberContact.update',$memberContact->id],'class'=>'form-horizontal','files'=> true])!!} 
                 <div class="form-body" >
                    <div class="row">
                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                            <label class="control-label">@lang('layout.FullName')</label> 
                            {!! Form::text('name', null, array('class' => 'form-control','tabindex' =>'1','autocomplete'=>'off')) !!} 
                        </div>
                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                            <label class="control-label">@lang('layout.LastName')</label> 
                            {!! Form::text('last_name', null, array('class' => 'form-control','autocomplete'=>'off')) !!} 
                        </div>
                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                            <label class="control-label">@lang('layout.Pseudonym')</label> 
                            {!! Form::text('pseudonym', null, array('class' => 'form-control','autocomplete'=>'off')) !!} 
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                            <label class="control-label">@lang('layout.Number')</label> 
                            {!! Form::text('number',$memberContact->number, array('class' => 'form-control')) !!}
                        </div>
                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                            <label class="control-label">@lang('layout.FatherName')</label> 
                            {!! Form::text('father_name', null, array('class' => 'form-control','autocomplete'=>'off')) !!} 
                        </div>
                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                            <label class="control-label">@lang('layout.Memo')</label>
                            <textarea name="memo" rows="1" class="form-control">{{$memberContact->memo}}</textarea>   
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                            <label class="control-label">@lang('layout.SSID')</label> 
                            {!! Form::text('ss_id',null, array('class' => 'form-control')) !!}
                        </div>
                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                            <label class="control-label">@lang('layout.Passport')</label> 
                            {!! Form::text('passport', null, array('class' => 'form-control','autocomplete'=>'off')) !!} 
                        </div>
                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                            <label class="control-label">@lang('layout.Organization')</label> 
                            <textarea name="organization" rows="1" class="form-control">{{$memberContact->organization}}</textarea>  
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                            <label class="control-label">@lang('layout.Date')</label>
                            <input type="text" id="reg_date" name="reg_date"  class="form-control date" autocomplete="off" value="{{convertDate($memberContact->reg_date)}}">
                        </div>

                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                <label class="control-label">@lang('layout.DateOfBirth')</label>
                                <input type="text" id="date_of_birth" name="date_of_birth"  class="form-control date" autocomplete="off" value="{{convertDate($memberContact->date_of_birth)}}">
                        </div>
                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                            <label class="control-label">@lang('layout.Reference')</label> 
                            <textarea name="reference" rows="1" class="form-control">{{$memberContact->reference}}</textarea>   
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12" id="memberClassDiv">
                            <label class="control-label">@lang('layout.Class')</label>
                            {!! Form::select('class', $class,$memberContact->member_contact_class_id, array('class' => 'form-control select_style')) !!}
                        </div>
                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                            <label class="control-label">@lang('layout.JobTitle')</label>
                            {!! Form::text('job_title', null, array('class' => 'form-control','autocomplete'=>'off')) !!}
                        </div>
                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                            <label class="control-label">@lang('layout.Gender')</label>
                            <div style="border: 1px dotted ;">
                                <label class="radio-inline">
                                    <input type="radio" name="gender" :checked="'{{$memberContact->gender}}' == 'male'" value="male"> @lang('layout.Male') </label>
                                <label class="radio-inline">
                                    <input type="radio" name="gender" :checked="'{{$memberContact->gender}}' == 'female'" value="female" >
                                    @lang('layout.Female') </label>
                            </div>
                        </div> 
                    </div>

                    <br>
                        

<!----------------------------------------------------------------------------------
------------------------------------------------------------------------------------
----------------------Begin Other INformations--------------------------------------
------------------------------------------------------------------------------------>
                        <div class="row">
                            <div class="col-md-12">
                                <!-- BEGIN TAB PORTLET-->
                                <div class="portlet light bordered">
                                    
                                    <div class="portlet-body">
                                        <div class="tabbable tabbable-tabdrop">
                                            <ul class="nav nav-pills">
                                                <li class="active">
                                                    <a href="#tab1" data-toggle="tab" aria-expanded="false"><i class="fa fa-home"></i> @lang('layout.Address')</a>
                                                </li>
                                                <li class="">
                                                    <a href="#tab2" data-toggle="tab" aria-expanded="false"><i class="fa fa-phone"></i> @lang('layout.Contacts')</a>
                                                </li>
                                                <li class="">
                                                    <a href="#tab6" data-toggle="tab" aria-expanded="false"><i class="fa fa-image"></i> @lang('layout.Photo')</a>
                                                </li> 
                                            </ul>
                                            <div class="tab-content">
                                                <div class="tab-pane active" id="tab1">
                                                        <div class="row">
                                                            <div class="col-md-3">
                                                                    <label class="control-label ">@lang('layout.Address1')</label>
                                                                    {!! Form::text('address1', null, array('class' => 'form-control','autocomplete'=>'off')) !!}
                                                            

                                                            </div>
                                                            <div class="col-md-3">
                                                                    <label class="control-label ">@lang('layout.Address2')</label>
                                                                    {!! Form::text('address2', null, array('class' => 'form-control')) !!}
                                                            </div>
                                                            <div class="col-md-6">
                                                                <label class="control-label ">@lang('layout.PostCode')</label>
                                                                        {!! Form::number('post_code', null, array('class' => 'form-control')) !!}
                                                            </div>
                                                        </div>
                                                        <div class="row">
                                                            <div class="col-md-6">
                                                                    <label class="control-label">@lang('layout.City')</label>
                                                                        {!! Form::text('city', null, array('class' => 'form-control')) !!}
                                                            </div>
                                                            <div class="col-md-6">
                                                                    <label class="control-label  ">@lang('layout.Country')</label>
                                                                    <v-select label="name" v-model="selectedCountry" :options="countries">
                                                                        </v-select>
                                                                        <input type="hidden" name="country" :value="(selectedCountry==null)?null:selectedCountry.name">
                                                            </div>
                                                        </div>
                                                        <div class="row">
                                                            <div class="col-md-6">
                                                                <label class="control-label ">@lang('layout.District')</label>
                                                                {!! Form::text('district', null, array('class' => 'form-control','autocomplete'=>'off')) !!}
                                                            </div>
                                                            <div class="col-md-6">
                                                                <label class="control-label ">@lang('layout.Village')</label>
                                                                {!! Form::text('village', null, array('class' => 'form-control')) !!}
                                                            </div>
                                                        </div>
                                                    </div>
                                                <div class="tab-pane" id="tab2">
                                                    <div class="row">
                                                        <div class="col-md-3">
                                                            <label class="control-label">@lang('layout.Phone')</label>
                                                            {!! Form::number('phone', null, array('class' => 'form-control')) !!}
                                                        </div>
                                                        <div class="col-md-3">
                                                            <label class="control-label">@lang('layout.Phone2')</label>
                                                            {!! Form::number('phone2', null, array('class' => 'form-control')) !!}
                                                        </div>
                                                        <div class="col-md-3">
                                                            <label class="control-label">@lang('layout.HomePhone')</label>
                                                            {!! Form::number('home_phone', null, array('class' => 'form-control')) !!}
                                                        </div>
                                                        <div class="col-md-3">
                                                            <label class="control-label">@lang('layout.WorkPhone')</label>
                                                            {!! Form::number('work_phone', null, array('class' => 'form-control')) !!}
                                                        </div>
                                                    </div>
                                                    <div class="row">
                                                        <div class="col-md-3">
                                                            <label class="control-label">@lang('layout.OtherPhone')</label>
                                                            {!! Form::number('other_phone', null, array('class' => 'form-control')) !!}
                                                        </div>
                                                        <div class="col-md-3">
                                                            <label class="control-label">@lang('layout.OtherPhone')2</label>
                                                            {!! Form::number('other_phone2', null, array('class' => 'form-control')) !!}
                                                        </div>
                                                        <div class="col-md-3">
                                                            <label class="control-label">@lang('layout.Email')</label>
                                                            {!! Form::text('email', null, array('class' => 'form-control','autocomplete'=>'off')) !!}
                                                        </div>
                                                        <div class="col-md-3">
                                                            <label class="control-label">@lang('layout.WebSite')</label>
                                                            {!! Form::text('website', null, array('class' => 'form-control','autocomplete'=>'off')) !!}
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="tab-pane" id="tab6">
                                                    <div class="col-md-3">
                                                        <div class="form-group">
                                                            <label class="control-label col-md-3">@lang('layout.Photo')</label>
                                                            <?php
                                                                $photo = null;
                                                                if($memberContact && $memberContact->photo!=null)
                                                                {
                                                                    $photo =  $memberContact->photo;
                                                                }
                                                            ?>
                                                            <div class="col-md-4">
                                                                <div class="form-group">
                                                                    <div class="fileinput fileinput-new" data-provides="fileinput"> 
                                                                        <div class="fileinput-new thumbnail" style="width: 200px; height: 150px;">
                                                                        <img src="{!!url('/uploads/'.$photo)!!}" alt=""/>
                                                                    </div>
                                                                        <div class="fileinput-preview fileinput-exists thumbnail"
                                                                            style="max-width: 200px; max-height: 150px;"></div>
                                                                        <div>
                                                                                <span class="btn default btn-file">
                                                                                    <span class="fileinput-new">@lang('layout.SelectImage')</span>
                                                                                    <span class="fileinput-exists">@lang('layout.Change')</span>
                                                                                    <!-- <input type="file" name="photo">  -->
                                                                                    {!! Form::file('photo', []) !!}</span>
                                                                            {!! Form::hidden('photo1', (!$memberContact)?null:$memberContact->photo) !!}
                                                                            <a href="javascript:;" class="btn default fileinput-exists"
                                                                            data-dismiss="fileinput">@lang('layout.Remove')</a>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>

                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                               
                            </div>
                        </div>

<!----------------------------------------------------------------------------------
------------------------------------------------------------------------------------
----------------------End Other INformations--------------------------------------
------------------------------------------------------------------------------------>



                </div>
                <div class="form-actions">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="row">
                                <div class="col-md-offset-3 col-md-9">
                                     <button type="button"  onclick="regForm(this)"  class="btn green" tabindex ='6'>@lang('layout.Submit')</button>
                                     
                                     <a href="{{route('memberContact.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>

                                </div>
                            </div>
                        </div>
                        <div class="col-md-6"></div>
                    </div>
                </div>
            {!! Form::close() !!}
            <!-- END FORM-->
            </div>
        </div>

    </div>


@endsection

@push('scripts')


<script>

  var memberContact={!! $memberContact !!};

  var countries = {!!$countries!!};
  var selectedCountry = {!!$selectedCountry!!};

  new Vue({
    el:'#app',
    data:{
        memberContact:memberContact,
        countries:countries,
        selectedCountry:selectedCountry
    },
    mounted:function(){   
          
    },

  });
    
</script>
@endpush