@extends('layouts.app')
@section('style')
 <link href="{{url('/assets/bootstrap-fileinput/bootstrap-fileinput.css')}}" rel="stylesheet" type="text/css"/>
 <style>

     input:invalid{
         border-color: red;
     }

 </style>
@stop

@section('content') 
@include('member_contact_classes.modal')

    <div class="row"  id="app" v-cloak> 
        <div class="portlet light bg-inverse">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>&nbsp;
                    <span class="caption-subject font-green-haze bold uppercase">@lang('menu.MemberContact')</span>
                </div>
                <div class="tools">
                    
                </div>
            </div>
            <div  class="portlet-body form" >
                <!-- BEGIN FORM-->
                {!! Form::open(array('route' => 'memberContact.store','method'=>'POST','class'=>'form-horizontal','id'=>'member-form','files'=> true)) !!}
                {{ csrf_field() }}
                 <div class="form-body" >
                    <div class="row">
                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                            <label class="control-label">@lang('layout.FullName')</label> 
                            {!! Form::text('name', null, array('class' => 'form-control','tabindex' =>'1','autocomplete'=>'off','v-validate' =>'"required"','data-vv-as' => __('layout.FullName'))) !!} 
                            <span class="required">@{{ errors.first('name') }}</span>
                        </div>
                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                            <label class="control-label">@lang('layout.LastName')</label> 
                            {!! Form::text('last_name', null, array('class' => 'form-control','autocomplete'=>'off')) !!} 
                        </div>
                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                            <label class="control-label">@lang('layout.Pseudonym')</label> 
                            {!! Form::text('pseudonym', null, array('class' => 'form-control','autocomplete'=>'off')) !!} 
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                            <label class="control-label">@lang('layout.Number')</label> 
                            {!! Form::text('number',$code, array('class' => 'form-control')) !!}
                        </div>
                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                            <label class="control-label">@lang('layout.FatherName')</label> 
                            {!! Form::text('father_name', null, array('class' => 'form-control','autocomplete'=>'off')) !!} 
                        </div>
                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                            <label class="control-label">@lang('layout.Memo')</label>
                            <textarea name="memo" rows="1" class="form-control"></textarea>   
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                            <label class="control-label">@lang('layout.SSID')</label> 
                            {!! Form::text('ss_id',null, array('class' => 'form-control')) !!}
                        </div>
                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                            <label class="control-label">@lang('layout.Passport')</label> 
                            {!! Form::text('passport', null, array('class' => 'form-control','autocomplete'=>'off')) !!} 
                        </div>
                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                            <label class="control-label">@lang('layout.Organization')</label> 
                            <textarea name="organization" rows="1" class="form-control"></textarea>  
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                            <label class="control-label">@lang('layout.Date')</label>
                            <input type="text" id="reg_date" name="reg_date"  class="form-control date" autocomplete="off">
                        </div>

                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                <label class="control-label">@lang('layout.DateOfBirth')</label>
                                <input type="text" id="date_of_birth" name="date_of_birth"  class="form-control date" autocomplete="off">
                        </div>
                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                            <label class="control-label">@lang('layout.Reference')</label> 
                            <textarea name="reference" rows="1" class="form-control"></textarea>   
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12 ">
                            <label class="control-label">@lang('layout.Class')</label>
                            <div class="input-group">
                                {{-- <select name="class" class="form-control" style="outline:1px solid #c2cad8 !important">
                                    <option  value="">@lang('layout.SelectClass')</option> 
                                    @foreach($class AS $rec)
                                        <option value="{{$rec->id}}">{{$rec->name}}</option>
                                    @endforeach
                                </select> --}}

                                <v-select label="name" v-model="selected_class" :options="contact_class">
                                </v-select>
                                <input type="hidden" name="class" :value="(selected_class==null)?null:selected_class.id">
                                
                                <span class="btn btn-success  input-group-addon"  id="show-modal" @click="showModal =true" style="background-color:  rgb(84, 199, 211)">
                                    <i class="fa fa-plus" style="color: white"></i>
                                </span>

                                

                            </div>
                        </div>
                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                            <label class="control-label">@lang('layout.JobTitle')</label>
                            {!! Form::text('job_title', null, array('class' => 'form-control','autocomplete'=>'off')) !!}
                        </div>
                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                            <label class="control-label">@lang('layout.Gender')</label>
                            <div style="border: 1px dotted ;">
                                <label class="radio-inline">
                                    <input type="radio" name="gender" checked="" value="male"> @lang('layout.Male') </label>
                                <label class="radio-inline">
                                    <input type="radio" name="gender" value="female" >
                                    @lang('layout.Female') </label>
                            </div>
                        </div> 
                    </div>

                    <br>
                        

<!----------------------------------------------------------------------------------
------------------------------------------------------------------------------------
----------------------Begin Other INformations--------------------------------------
------------------------------------------------------------------------------------>
                        <div class="row">
                            <div class="col-md-12">
                                <!-- BEGIN TAB PORTLET-->
                                <div class="portlet light bordered">
                                    
                                    <div class="portlet-body">
                                        <div class="tabbable tabbable-tabdrop">
                                            <ul class="nav nav-pills">
                                                <li class="active">
                                                    <a href="#tab1" data-toggle="tab" aria-expanded="false"><i class="fa fa-home"></i> @lang('layout.Address')</a>
                                                </li>
                                                <li class="">
                                                    <a href="#tab2" data-toggle="tab" aria-expanded="false"><i class="fa fa-phone"></i> @lang('layout.Contacts')</a>
                                                </li>
                                                <li class="">
                                                    <a href="#tab6" data-toggle="tab" aria-expanded="false"><i class="fa fa-image"></i> @lang('layout.Photo')</a>
                                                </li> 
                                            </ul>
                                            <div class="tab-content">
                                                <div class="tab-pane active" id="tab1">
                                                        <div class="row">
                                                            <div class="col-md-3">
                                                                    <label class="control-label ">@lang('layout.Address1')</label>
                                                                    {!! Form::text('address1', null, array('class' => 'form-control','autocomplete'=>'off')) !!}
                                                            

                                                            </div>
                                                            <div class="col-md-3">
                                                                    <label class="control-label ">@lang('layout.Address2')</label>
                                                                    {!! Form::text('address2', null, array('class' => 'form-control')) !!}
                                                            </div>
                                                            <div class="col-md-6">
                                                                <label class="control-label ">@lang('layout.PostCode')</label>
                                                                        {!! Form::number('post_code', null, array('class' => 'form-control')) !!}
                                                            </div>
                                                        </div>
                                                        <div class="row">
                                                            <div class="col-md-6">
                                                                    <label class="control-label">@lang('layout.City')</label>
                                                                        {!! Form::text('city', null, array('class' => 'form-control')) !!}
                                                            </div>
                                                            <div class="col-md-6">
                                                                    <label class="control-label  ">@lang('layout.Country')</label>
                                                                    <v-select label="name" v-model="selectedCountry" :options="countries">
                                                                        </v-select>
                                                                        <input type="hidden" name="country" :value="(selectedCountry==null)?null:selectedCountry.name">
                                                            </div>
                                                        </div>
                                                        <div class="row">
                                                            <div class="col-md-6">
                                                                <label class="control-label ">@lang('layout.District')</label>
                                                                {!! Form::text('district', null, array('class' => 'form-control','autocomplete'=>'off')) !!}
                                                            </div>
                                                            <div class="col-md-6">
                                                                <label class="control-label ">@lang('layout.Village')</label>
                                                                {!! Form::text('village', null, array('class' => 'form-control')) !!}
                                                            </div>
                                                        </div>
                                                    </div>
                                                <div class="tab-pane" id="tab2">
                                                    <div class="row">
                                                        <div class="col-md-3">
                                                            <label class="control-label">@lang('layout.Phone')</label>
                                                            {!! Form::number('phone', null, array('class' => 'form-control')) !!}
                                                        </div>
                                                        <div class="col-md-3">
                                                            <label class="control-label">@lang('layout.Phone2')</label>
                                                            {!! Form::number('phone2', null, array('class' => 'form-control')) !!}
                                                        </div>
                                                        <div class="col-md-3">
                                                            <label class="control-label">@lang('layout.HomePhone')</label>
                                                            {!! Form::number('home_phone', null, array('class' => 'form-control')) !!}
                                                        </div>
                                                        <div class="col-md-3">
                                                            <label class="control-label">@lang('layout.WorkPhone')</label>
                                                            {!! Form::number('work_phone', null, array('class' => 'form-control')) !!}
                                                        </div>
                                                    </div>
                                                    <div class="row">
                                                        <div class="col-md-3">
                                                            <label class="control-label">@lang('layout.OtherPhone')</label>
                                                            {!! Form::number('other_phone', null, array('class' => 'form-control')) !!}
                                                        </div>
                                                        <div class="col-md-3">
                                                            <label class="control-label">@lang('layout.OtherPhone')2</label>
                                                            {!! Form::number('other_phone2', null, array('class' => 'form-control')) !!}
                                                        </div>
                                                        <div class="col-md-3">
                                                            <label class="control-label">@lang('layout.Email')</label>
                                                            {!! Form::text('email', null, array('class' => 'form-control','autocomplete'=>'off','v-validate' =>'"email"','data-vv-as' => __('layout.Email'))) !!}
                                                            <span class="required">@{{ errors.first('email') }}</span>
                                                        </div>
                                                        <div class="col-md-3">
                                                            <label class="control-label">@lang('layout.WebSite')</label>
                                                            {!! Form::text('website', null, array('class' => 'form-control','autocomplete'=>'off')) !!}
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="tab-pane" id="tab6">
                                                    <div class="col-md-3">
                                                        <div class="form-group">
                                                            <label class="control-label col-md-3">@lang('layout.Photo')</label>
                                                         

                                                            <?php
                                                            // $logo = null;
                                                            // if($company && $company->logo!=null)
                                                            // {
                                                            //     $logo =  $company->logo;
                                                            // }
                                                        ?>
                                                        <div class="col-md-4">
                                                            <div class="form-group">
                                                                <div class="fileinput fileinput-new" data-provides="fileinput"> 
                                                                    <div class="fileinput-new thumbnail" style="width: 200px; height: 150px;">
                                                                    <img src="#" alt=""/>
                                                                </div>
                                                                    <div class="fileinput-preview fileinput-exists thumbnail"
                                                                        style="max-width: 200px; max-height: 150px;"></div>
                                                                    <div>
                                                                            <span class="btn default btn-file">
                                                                                <span class="fileinput-new">@lang('layout.SelectImage')</span>
                                                                                <span class="fileinput-exists">@lang('layout.Change')</span>
                                                                                <!-- <input type="file" name="photo">  -->
                                                                                {!! Form::file('photo', []) !!}
                                                                                
                                                                            </span>
                                                                        <a href="javascript:;" class="btn default fileinput-exists"
                                                                        data-dismiss="fileinput">@lang('layout.Remove')</a>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>

                                                        {{-- <input type="file" name="image" class="form-control" ref="imageInput" @change="handelFileChange"> --}}

                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                               
                            </div>
                        </div>

<!----------------------------------------------------------------------------------
------------------------------------------------------------------------------------
----------------------End Other INformations--------------------------------------
------------------------------------------------------------------------------------>
                    <modal v-if="showModal" @close="showModal = false">
                        <div slot="header">
                            <div class="col-md-12 col-sm-12 col-xs-12">
                                <h3>
                                    @lang('layout.CreateMemberClass')
                                </h3>
                            </div>
                            <div class="col-md-4">
                                <div v-if="fieldErrors.length > 0">
                                    <p class="text-danger" fieldErrors>
                                        <spna v-text="fieldErrors"></spna>
                                    </p>
                                </div>
                            </div>
                        </div>
                        <div slot="body">
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label>@lang("layout.Name") <span class="required"> * </span></label>
                                        <input type="text" class="form-control" name="name" v-model="className" autocomplete="off">
                                    </div>
                                </div>

                            </div>
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label>@lang("layout.Description")</label>
                                        <textarea class="form-control" name="description" v-model="description" autocomplete="off">
                                            
                                        </textarea>
                                    </div>

                                </div>
                                
                            </div>
                        </div>


                        <div slot="footer">
                            <button type=button class="btn btn-success" @click="addClass" >
                                @lang('layout.OK')
                            </button>
                            <button type=button class="btn btn-danger"
                                @click="showModal =false" >
                                @lang('layout.Cancel')
                            </button>
                        </div>
                    </modal>




                </div>
                <div class="form-actions">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="row">
                                <div class="col-md-offset-3 col-md-9">
                                     <button type="button"  @click="handleSubmit($event)"  class="btn green" tabindex ='6'>@lang('layout.Submit')</button>
									 <button type="button" class="btn blue" :disabled="disabled" @click="saveAndNew($event)">@lang('layout.SaveAndNew')</button>
                                     
                                     <a href="{{route('memberContact.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>

                                </div>
                            </div>
                        </div>
                        <div class="col-md-6"></div>
                    </div>
                </div>
            {!! Form::close() !!}
            <!-- END FORM-->
            </div>
        </div>

    </div>


@endsection
@push('scripts')
<script>

    @if(App::getLocale())
    Vue.use(VeeValidate, {
        locale: '{{App::getLocale()}}',
    });
    @else
    Vue.use(VeeValidate, {
        locale: 'en',
    });
    @endif

    Vue.component('v-select', VueSelect.VueSelect);
   


    Vue.component('modal',{
        template: '#modal-template'
    });

  var countries = {!!$countries!!};
  var contact_class = {!!$class!!};

  var vu = new Vue({
    el:'#app',
    data:{
		countries:countries,
        selectedCountry:{
            id:'Afghanistan',
            name:'Afghanistan',
            dial_code:'0093'
        },
        errorMessage: '',
        showModal:false,
        fieldErrors: [],
        className: null,
        description: null,
        disabled: false,
        contact_class:contact_class,
        selected_class:null

    },

    methods:{
        addClass(){
             axios.post("{{route('memberContactClass.store')}}",{
                 name:this.className,
                 description:this.description
             })
             .then(function(response){
                if(response)
                {
                    vu.showModal = false;
                    vu.selected_class = response.data.memberContactClass;
                    vu.className = null;
                    vu.description = null;
                }
             })
             .catch(function (error) {
                toggleBlock(0);
                console.log('dddddddddd',error);
                var message = "{{__('message.Warning')}}";
                toastr.warning('', message);
            });
         },

        handleSubmit(e) {
            this.$validator.validate().then(valid => {
                if (valid) {
                    regForm(e.target);
                }
            });
        },
    // handelFileChange(event)
    // {
    //     this.image = event.target.files[0];
    // },

	saveAndNew() {
		this.$validator.validate()
        
		.then(valid => {
			if (valid) {
                vu.disabled = true;
				var url = "{{route('memberContact.store')}}";
				form_id = 'member-form';
				var data = $('#' + form_id).serialize();
                console.log('data',data)
				toggleBlock(true);
				axios.post(url, data)
                // axios({
                //     method:"post",
                //     url:url,
                //     data: data,
                //     config:{headers: {'Contect-Type': 'multipart/form-data'}}
                // })
					.then(function (response) {
						toggleBlock(0);
						if (response.data.result == 1) {
							$('#' + form_id).trigger('reset');
							//$('#success-sound')[0].play();
							toastr.success('', response.data.message);
							location.reload();
							
						}
						else {
							var message = "{{__('message.Warning')}}";
                            vu.disabled = false;
							//$('#error-sound')[0].play();
							toastr.warning('', message);
						}
					})
					.catch(function (error) {
                        toggleBlock(0);
                        vu.disabled = false;
						console.log(error);
						var message = "{{__('message.Warning')}}";
						//$('#error-sound')[0].play();
						toastr.warning('', message);
					});

			}
		})
	},
        
    }

  });  


</script>


@endpush