@extends('layouts.app')

@section('content')
@include("layouts.Cmodal")
@include('loans.modal')
<style type="text/css">
    /* tr th {
        text-align: center;
    } */
    hr {
        border-top: 1px solid #b1adad;
    }

</style>

<div id="print-modal">
    <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show" :value-type="'allChequeReports'" @closed="closeModal">
        <div slot="body">
            <!----------------------------------------------
            ----Begin Report Body And Custome Report-------
            ----------------------------------------------->
            <div class="row" v-cloak>
                <div class="tabbable tabbable-tabdrop">

                    <ul class="nav nav-tabs">

                        <li class="active">
                            <a href="#tab1" data-toggle="tab" id="tab_main">@lang('menu.Report')</a>
                        </li>
                        @if(systemConfig()[2] != 0 )
                        @permission(['customreport-list'])
                        <li class="">
                            <a href="#tab2" data-toggle="tab" id="tab_custome">@lang('layout.CustomReportM')</a>
                        </li>
                        @endpermission
                        @endif
                    </ul>
                    <div class="tab-content">
                        <div class="tab-pane active" id="tab1">
                            <div class="portlet light bordered">
                                <div class="row">
                                    <div class="form-group">
                                        <div class="col-md-4">
                                            <label class="control-label ">@lang('layout.SelectClass')</label>
                                            <v-select class="vue-select2"
                                                      v-model="selected_class"
                                                      label="name"
                                                      :options="member_class">
                                            </v-select>
                                            <input type="hidden" name="class_id" :value="(!selected_class)?null:selected_class.id">
                                        </div>
                                        <div class="col-md-4">
                                            <label class="control-label ">@lang('layout.SelectType') </label>
                                            <select class="form-control" name="type_name" >
                                                <option value="">@lang('layout.SelectType')</option>
                                                <option value="Receive">@lang('type.Receive')</option>
                                                <option value="Send">@lang('type.Send')</option>
                                            </select>
                                        </div>

                                        <div class="col-md-3">
                                            <label class="control-label ">@lang('layout.Bank') </label>
                                            <v-select class="vue-select2"
                                                    v-model="selected_bank"
                                                    label="name"
                                                    :options="bank"
                                                    @search="searchAccount" >
                                            </v-select>
                                            <input type="hidden" name="bank_id" :value="(!selected_bank)?null:selected_bank.id">
                                        </div> 


                                        <div class="col-md-2">
                                            <label class="control-label ">@lang('layout.Status') </label>
                                            <select class="form-control" name="status" >
                                                <option value="">@lang('layout.SelectType')</option>
                                                <option value="off">@lang('layout.Implemented')</option>
                                                <option value="on">@lang('layout.NotImplemented')</option>
                                                <option value="cancel">@lang('layout.Cancel')</option>
                                            </select>
                                        </div>
                                        <div class="col-md-2">
                                            <label class="control-label ">@lang('layout.TransactionType') </label>
                                            <select class="form-control" name="transaction_type" >
                                                <option value="">@lang('layout.SelectType')</option>
                                                <option value="Local">@lang('layout.Local')</option>
                                                <option value="Foreign">@lang('layout.Foreign')</option>
                                            </select>
                                        </div>
                                        @if(systemConfig()[29] == 1)
                                        <div class="col-md-2">
                                            <label class=" control-label">@lang('layout.TransactionConfirm')</label>
                                            <div class="col-md-12 mt-checkbox">
                                                <label class="mt-checkbox mt-checkbox-outline"> 
                                                    <input type="checkbox" name="transaction_confirm" value="On">
                                                    <span></span>
                                                </label>
                                            </div>
                                        </div>
                                        @endif
                                    </div>

                                </div>
                                <div class="row">
                                    <div class="form-group">
                                        <div class="col-md-4">
                                            <label class="control-label ">@lang('layout.SelectMember') </label>
                                            <v-select class="vue-select2" v-model="selectedMember" label="name" @search="MemberSearch"  :options="member"> </v-select>
                                            <input type="hidden" name="member_id" v-model.number="(!selectedMember)?null:selectedMember.id">
                                        </div>
                                        <div class="col-md-4">
                                            <label class="control-label ">@lang('layout.ChequeNumber') </label>
                                            <input type="text" name="ref_no" class="form-control" autocomplete="off" >
                                        </div>
                                        <div class="col-md-2">
                                            <label class="control-label">@lang('layout.Currency')</label>
                                            <v-select v-model="selectedCurrency" label="code" :options="currency" > </v-select>
                                            <input type="hidden" name="currency" v-bind:value="(!selectedCurrency)?null:selectedCurrency.code">
                                        </div>
                                        @if(getFinancialClass() =='true') 
                                        @permission('financialClass-list')
                                        <div class="col-md-2">
                                            <label class="control-label"> @lang('menu.FinancialClass')</label>
                                            <select name="financial_class_id" class="form-control" >
                                                <option value="">@lang('layout.SelectClass')</option>
                                                <option value="Unclassified">Unclassified</option>
                                                <option v-for="cla in financial_classes" :value="cla.id" :key="cla.id" >@{{cla.name}}</option>
                                            </select>
                                        </div>
                                        @endpermission
                                        @endif
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="form-group">
                                        <div class="col-md-4">
                                            <label class="control-label ">@lang('layout.Date')</label>
                                                <select name="period" v-model="period" @input="getDates()" class="form-control">
                                                <option value="CustomDates">@lang('type.CustomDates')</option>
                                                <option value="Today">@lang('type.Today')</option>
                                                <option value="Yesterday">@lang('type.Yesterday')</option>
                                                <option value="ThisWeek">@lang('type.ThisWeek')</option>
                                                <option value="LastWeek">@lang('type.LastWeek')</option>
                                                <option value="WeekToDate">@lang('type.WeekToDate')</option>
                                                <option value="ThisMonth">@lang('type.ThisMonth')</option>
                                                <option value="MonthToDate">@lang('type.MonthToDate')</option>
                                                <option value="ThisQuarter">@lang('type.ThisQuarter')</option>
                                                <option value="QuarterToDate">@lang('type.QuarterToDate')</option>
                                                <option value="ThisYear">@lang('type.ThisYear')</option>
                                                <option value="YearToDate">@lang('type.YearToDate')</option>
                                            </select>
                                        </div>
                                        <div class="col-md-8" v-show="period == 'CustomDates'">
                                            <div class="form-group">
                                                <label class="control-label"> @lang('layout.Date')</label>
                                                <div class="input-group">
                                                    <input class="form-control date" id="range-from-example" v-model="from_date" name="from_date" autocomplete="off">
                                                    <span class="input-group-addon"> @lang('layout.To') </span>
                                                    <input class="form-control date" id="range-to-example" v-model="to_date" name="to_date" autocomplete="off">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="tab-pane" id="tab2">
                            <div class="portlet light bordered">
                                <div class="portlet-body">

                                    <form id="saveCustomeReport" role="form" action="{{route('customeReport.storeCustomeReport')}}" method="post">
                                        @csrf
                                        <input type="hidden" name="part_name" value="cheque_index">


                                        <div class="col-md-12 col-sm-12 col-xs-12">

                                            <div class="mt-checkbox-inline col-md-2" style="padding: 0px;" v-for="(row,itemIndex) in customReportData">

                                                <div class="form-group">
                                                    <table class="table table-striped table-bordered table-advance table-hover">
                                                        <tr>
                                                            <td style="text-align: center;">@{{ row.Name }}</td>
                                                        </tr>
                                                        <tr>
                                                            <td style="text-align: center;">
                                                                <input type="hidden" :name="'column_name['+itemIndex+']'" class="form-control" v-model="row.column_name">


                                                                <label class="switch">
                                                                    <input type="checkbox" :name="'column_status['+itemIndex+']'" :checked="row.checkedColumn">
                                                                    <span class="slider round"></span>
                                                                </label>
                                                                <select :name="'column_percentage['+itemIndex+']'" v-model="row.column_percentage" class="form-control" style="width: 90%;">
                                                                    <option value="">@lang('layout.Select')</option>
                                                                    <option value="2">2 %</option>
                                                                                <option value="6">6 %</option>
                                                                    <option value="10">10 %</option>
                                                                    <option value="15">15 %</option>
                                                                    <option value="20">20 %</option>
                                                                    <option value="25">25 %</option>
                                                                    <option value="30">30 %</option>
                                                                    <option value="40">40 %</option>
                                                                    <option value="50">50 %</option>
                                                                    <option value="60">60 %</option>
                                                                </select>
                                                            </td>
                                                        </tr>
                                                    </table>
                                                    <!-- <label> @{{ row.Name }}</label>

                                                          <input type="hidden" :name="'column_name['+itemIndex+']'" class="form-control" v-model="row.column_name">


                                                         <label class="switch">
                                                                <input type="checkbox" :name="'column_status['+itemIndex+']'" 
                                                                :checked="row.checkedColumn" >
                                                              <span class="slider round"></span>
                                                        </label> -->

                                                </div>
                                            </div>
                                        </div>
                                        <div class="margiv-top-10">
                                            <!-- <button type="button" onclick="regForm(this)" class="btn green"> <i class="fa fa-save"></i> </button> -->

                                            <button type="button" onclick="saveCustomeReport(this)" class="btn blue"> <i class="fa fa-save"></i> </button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!----------------------------------------------
            ----Begin Report Body And Custome Report-------
            ----------------------------------------------->

        </div>

    </report-modal>
</div>

<div class="row" >
    <!-- BEGIN EXAMPLE TABLE PORTLET-->
    <div class="portlet light bordered">
        <div class="portlet-title">
            <div class="caption font-dark">
                <i class="icon-settings font-dark"></i>&nbsp;
                <span class="caption-subject bold uppercase">@lang('menu.Cheque') &nbsp; &nbsp; &nbsp; </span>
            </div>
            <div class="tools"></div>
            <div class="pull-right">
                <span onclick="getRecord();" class="btn blue">
                    <i class="fa fa-refresh"></i>
                </span>
                @permission(['cheque-export'])
                <span id="anchore-modal">
                    <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                        <i class="fa fa-print"></i>
                    </a>
                </span>
                @endpermission
                <!-- <a href="{{route('cheque.create')}}">
                    <button class="btn btn-success">
                        <i class="fa fa-plus"></i> @lang('layout.AddNew')
                    </button>
                </a> -->
                @permission(['cheque-create'])
                <span id="create-modal">
                    <a href="#" @click.prevent="showModal">
                        <button class="btn btn-success">
                            <i class="fa fa-plus"></i> @lang('layout.AddNew')
                        </button>
                    </a>
                </span>
                @endpermission

            </div>
            <template v-cloak id="company_ll">
                <company @company="setCompany"></company>
            </template>
        </div>
        <div class="portlet-body" style="padding:0.5% 1%;border-radius: 8px;">
            <!-- BEGIN FORM-->
            @permission(['cheque-create'])
            {!! Form::open(array('route' => 'cheque.store','method'=>'POST','class'=>'form-horizontal','id'=>'loan-submit')) !!}
            {{ csrf_field() }}
            <div class="form-body  col-md-12" id="app" v-cloak>
                <div class="row" v-show="show_create" style="margin-bottom: 20px; border-bottom: 2px solid rgba(172, 171, 171, 0.877);padding-bottom: 20px;">
                    <div class="col-lg-6 col-md-12 col-sm-12" style="box-shadow: 0px 0px 3px rgba(172, 171, 171, 0.877);border-radius: 8px; margin-bottom: 10px;">
                        <div class="row" style="padding: 0.5% 1%;">
                            <div class="col-lg-4">
                                <div v-show="showWhat('member_class')=='yes'">
                                    <label class="control-label">@lang('layout.MemberClass') </label>
    
                                    <v-select label="name" :options="memberClass" v-model="selected_class" @input="memberClassChange()"></v-select>
                                    <input type="hidden" name="class_id" :value="!selected_class?null:selected_class.id">
                                </div>
                            </div>
                            <div class="col-lg-4">
                                <label class="control-label ">@lang('layout.BranchName') / @lang('layout.Customer')</label>
                                <div class="input-group">
                                    <v-select :class="selectMem + ' vue-select2 '" v-model="selectedMember" @input="getSummary()" label="name" :options="member" @search="MemberSearch" >
                                    </v-select>
                                    <input type="hidden" name="member_id" :value="(!selectedMember)?null:selectedMember.id" v-validate="'required'" data-vv-as="@lang('layout.Member')">
                                    <span class="required">@{{ errors.first('member_id') }}</span>

                                    <span class="btn btn-success input-group-addon " title="@lang('button.AddNewCustomer')" @click="showModal = true" style="background-color:  rgb(84, 199, 211);">
                                        <i class="fa fa-plus" style="color: white"></i>
                                    </span>
                                    @if (fingerprint() == 'true')
                                    <span class="input-group-addon">
                                        <input type="checkbox" name="finger" @click="clearFinger('finger')" v-model="finger" placeholder="@lang('layout.Fingerprint')" >
                                        <span></span>
                                    </span>
                                    @endif
                                </div>
                            </div>
                            <div class="col-lg-4">
                                <label class="control-label" for="form_control">@lang('layout.Type')</label>
                                <div class="md-radio-inline">
                                    <div class="md-radio">
                                        <input type="radio" id="radio1" name="type" v-model="chequeType" value="Receive" class="md-radiobtn">
                                        <label for="radio1">
                                            <span class="inc"></span>
                                            <span class="check"></span>
                                            <span class="box"></span> @lang('type.Receive') 
                                        </label>
                                    </div>
                                    <div class="md-radio">
                                        <input type="radio" id="radio2" name="type" v-model="chequeType" value="Send" class="md-radiobtn" checked="">
                                        <label for="radio2">
                                            <span class="inc"></span>
                                            <span class="check"></span>
                                            <span class="box"></span> @lang('type.Send') 
                                        </label>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <div class="row" style="padding: 0.5% 1%;">
                            <div class="col-lg-4">
                                <label class="control-label">@lang('layout.Number')</label>
                                <input type="number" name="number" class="form-control" v-model="number">
                            </div>
                            <div class="col-lg-4">
                                <label class="control-label">@lang('layout.ChequeNumber')</label>
                                <input type="text" name="ref_no" class="form-control">
                                <span v-if="isError ==true" class="input-has-error" style="color: red">@{{msg}}</span>
                            </div>
                            <div class="col-lg-4">
                                <div :class="currency_len">
                                    <label class="control-label">@lang('layout.Currency')</label>
                                    <v-select v-model="selectedCurrency" label="code" :options="currency" @input="setSize(selectedCurrency.code), get_exchange()"> </v-select>
                                    <input type="hidden" name="currency" v-bind:value="selectedCurrency.code" />
                                </div>
                                <div :class="rate_len" v-if="selectedCurrency.code != '{{getHomeCurrency()["code"]}}'">
                                    <label class="control-label">@lang('layout.Rate') </label>
                                    <div :class="{'has-error':selectedCurrency.rate < 0}">
                                        <!-- <div class="input-group"> -->
                                        <input v-model="selected_rate" class="form-control" type="number" step="any" min="0" @keyup="check_code(selectedCurrency.code), get_exchange()" @click="check_code(selectedCurrency.code), get_exchange()" :readonly="averageRate">
                                        <!-- <span class="input-group-addon">@{{selectedCurrency.code}}</span>
                                        </div> -->
                                        <input type="hidden" name="currency_rate" :value="selected_rate">
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-12">
                                <div class="row" style="padding: 0.5% 1%;">
                                    <div class="row" style="padding: 0.5% 1%;">
                                        <div class="col-lg-4">
                                            <label class="control-label">@lang('layout.Amount')<span v-if="amount_to_word" style="color: red;">(@{{amount_to_word}})</span></label>
                                            <vue-numeric
                                                class="form-control"
                                                v-model="amount"
                                                :max="99999999999999"
                                                :currency="selectedCurrency.code"
                                                :precision="precision()"
                                                @input="get_exchange(), getTranslateToWord()"
                                            >
                                            </vue-numeric>
                                            <input type="hidden" name="amount" class="form-control" v-model="amount" step="any" min="0" v-validate="'required'" data-vv-as="@lang('layout.Amount')">
                                            
                                            <span class="required">@{{ errors.first('amount') }}</span>
                                        </div>
                                        <div class="col-lg-4">
                                            <label class="control-label">@lang('layout.Account')</label>
                                            <select class="form-control" name="account_id" v-model="defaultAccount" v-on:change="test(defaultAccount)" required v-validate="'required'" data-vv-as="@lang('layout.Account')">
                                                <option v-for="Account in accountUpdate" :value="Account.id">@{{ Account.name }}
                                                </option>
                                            </select>
                                            <span class="required">@{{ errors.first('account_id') }}</span>
                                        </div>
                                        <div class="col-lg-4" v-if="!(sender && chequeType == 'Send')" v-show="!(reciever && chequeType == 'Receive')">
                                                <span v-if="checkLoan" v-show="false">
                                                    @{{balance = Number(selectedBank.balance)-(Number(amount)-Number(defaultAmount)) }}
                                                </span>
                                                <span v-else v-show="false">
                                                    @{{balance = Number(selectedBank.balance)+(Number(amount)-Number(defaultAmount))}}
                                                </span>
                                                <label class="control-label">@lang('layout.Balance')</label>
                                                <!-- <div class="input-group"> -->
                                                    <input class="form-control" disabled :value="balance.toFixed(precision())">
                                                    <!-- <span class="input-group-addon">@{{selectedCurrency.code}}</span>
                                                </div> -->
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-lg-4">
                                            <div :class="pcurrency_len">
                                                <label class="control-label">@lang('layout.ExchangedCurrency')</label>
                                                <v-select v-model="paymentCurrency" label="code" :options="currency1" @input="setPaymentSize(paymentCurrency.code), get_exchange()"> </v-select>
                                                <input type="hidden" name="paymentCurrency" v-bind:value="paymentCurrency.code" />
                                            </div>
                                            <div :class="prate_len" v-if="paymentCurrency.code != '{{getHomeCurrency()["code"]}}'">
                                                <label class="control-label">@lang('layout.Rate') </label>
                                                <div :class="{'has-error':paymentCurrency.exchange_rate < 0}">
                                                    <input v-model="selected_rate1" class="form-control" type="number" min="0" step="any" @input="get_exchange()" :readonly="selectedCurrency.code==paymentCurrency.code">
                                                    <input type="hidden" name="rate" :value="selected_rate1">
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-lg-4">
                                            <label class="control-label">@lang('layout.ExchangedAmount')</label>
                                            <div class="input-group" style="margin-top: .5em;">
                                                <vue-numeric
                                                    class="form-control"
                                                    v-model="exchange_amount"
                                                    :max="99999999999999"
                                                    :currency="paymentCurrency.code"
                                                    :precision="precision()"
                                                    @keyup.native="set_rate()" @click.native="set_rate()"
                                                >
                                                </vue-numeric>
                                                {{-- <input type="number" v-model="exchange_amount" @input="set_rate()" class="form-control" min="0" step="any"> --}}
                                                <input type="hidden" :value="(amount*selected_rate1/(selected_rate)).toFixed(8)">
                                                <span class="input-group-addon">
                                                    <input type="checkbox" name="gain_loss_status" v-model="gain_loss_status">
                                                    <span></span>
                                                </span>
                                            </div>
                                        </div>
                                        <div class="col-lg-4">
                                            <label class="control-label" for="form_control">@lang('layout.TransactionType')</label>
                                            <div class="md-radio-inline">
                                                <div class="md-radio" style="margin-right: 10px;">
                                                    <input type="radio" id="radio4" name="transaction_type" value="Local" class="md-radiobtn" checked="">
                                                    <label for="radio4">
                                                        <span class="inc"></span>
                                                        <span class="check"></span>
                                                        <span class="box"></span> @lang('layout.Local') </label>
                                                </div>
                                                <div class="md-radio" style="margin-right: 10px;">
                                                    <input type="radio" id="radio5" name="transaction_type" value="Foreign" class="md-radiobtn">
                                                    <label for="radio5">
                                                        <span class="inc"></span>
                                                        <span class="check"></span>
                                                        <span class="box"></span> @lang('layout.Foreign') </label>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row" style="padding:0.5% 1%;">
                                        <div class="col-lg-4">
                                            <label class="control-label">@lang('layout.Date')</label>
                                            <input type="text" id="getdate" class="form-control date" autocomplete="off" name="date">
                                        </div>
                                        <div class="col-lg-4">
                                            <label class="control-label">@lang('layout.DueDate')</label>
                                            <input type="text" id="dueDate" class="form-control date" autocomplete="off" name="dueDate">
                                        </div>
                                        <div class="col-lg-4">
                                            <label class="control-label ">@lang('layout.BranchTransfer')</label>
                                            <div class="input-group">
                                                <span class="input-group-addon">
                                                    <input type="checkbox" name="branch_type" v-model="branch_type" value="on">
                                                    <span></span>
                                                </span>
                                                <v-select v-if="branch_type" label="name" :options="company" v-model="selected_company" placeholder="@lang('layout.Company')" :select-on-tab="true"></v-select>
                                                <input type="hidden" name="company_id" :value="(!selected_company)?null:selected_company.id" >
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-lg-4" v-if="!sender" >
                                        <label class="control-label">@lang('layout.Sender')</label>
                                        <div class="input-group">
                                            <span class="input-group-addon">
                                                <input type="checkbox" v-model="sender">
                                                <span></span>
                                            </span>
                                            <input type="text" class="form-control " placeholder="@lang('layout.Name')" autocomplete="off" name="sender">
                                        </div>
                                    </div>
                                    <div class="col-lg-4" v-if="!sender" >
                                        <label class="control-label">@lang('layout.SSN') / @lang('layout.PassportNumber')</label>
                                        <input type="text" class="form-control " autocomplete="off" name="sen_ssn_number">
                                    </div>
                                    <div class="col-lg-4" v-if="!sender">
                                        <label class="control-label">@lang('layout.FatherName')</label>
                                        <input type="text" class="form-control" autocomplete="off" name="sen_father_name">
                                    </div>
                                    <div class="col-lg-4" v-if="!sender">
                                        <label class="control-label">@lang('layout.Phone')</label>
                                        <input type="text" class="form-control" autocomplete="off" name="sen_phone">
                                    </div>
                                    <div class="col-lg-4" v-if="!sender">
                                        <label class="control-label">@lang('layout.Address')</label>
                                        <input type="text" class="form-control" autocomplete="off" name="sen_address">
                                    </div>
                                    <div class="col-lg-4" v-if="sender" >
                                        <label class="control-label ">@lang('layout.Sender')</label>
                                        <div class="input-group">
                                            <span class="input-group-addon">
                                                <input type="checkbox" v-model="sender">
                                                <span></span>
                                            </span>
                                            <v-select :class="selectSCF + ' vue-select2 '" v-model="selectedSender" label="name" :options="simple_member" @search="SimpleMemberSearch" >
                                            </v-select>
                                            <input type="hidden" name="sender_id" :value="(!selectedSender)?null:selectedSender.id" >
                                        </div>
                                    </div>
                                    @if (fingerprint() == 'true')
                                    <div class="col-lg-4" v-if="sender">
                                        <label class=" control-label">@lang('layout.Fingerprint')</label>
                                        <div class="col-md-12 mt-checkbox">
                                            <label class="mt-checkbox mt-checkbox-outline">
                                                <input type="checkbox" @click="clearFinger('finger1')" name="finger1" v-model="finger1">
                                                <span></span>
                                            </label>
                                        </div>
                                    </div>
                                    @endif
                                    <div class="col-lg-4" v-if="!reciever">
                                        <label class="control-label">@lang('layout.Reciever')</label>
                                        <div class="input-group">
                                            <span class="input-group-addon">
                                                <input type="checkbox" v-model="reciever">
                                                <span></span>
                                            </span>
                                            <input type="text" class="form-control " placeholder="@lang('layout.Name')" autocomplete="off" name="reciever">
                                        </div>
                                    </div>
                                    <div class="col-lg-4" v-if="!reciever" >
                                        <label class="control-label">@lang('layout.SSN') / @lang('layout.PassportNumber')</label>
                                        <input type="text" class="form-control " autocomplete="off" name="rec_ssn_number">
                                    </div>
                                    <div class="col-lg-4" v-if="!reciever">
                                        <label class="control-label">@lang('layout.FatherName')</label>
                                        <input type="text" class="form-control" autocomplete="off" name="rec_father_name">
                                    </div>                     
                                    <div class="col-lg-4" v-if="!reciever">
                                        <label class="control-label">@lang('layout.Phone')</label>
                                        <input type="text" class="form-control" autocomplete="off" name="rec_phone">
                                    </div>
                                    <div class="col-lg-4" v-if="!reciever">
                                        <label class="control-label">@lang('layout.Address')</label>
                                        <input type="text" class="form-control" autocomplete="off" name="rec_address">
                                    </div>
                                    <div class="col-lg-4" v-if="reciever" >
                                        <label class="control-label ">@lang('layout.Reciever')</label>
                                        <div class="input-group">
                                            <span class="input-group-addon">
                                                <input type="checkbox" v-model="reciever">
                                                <span></span>
                                            </span>
                                            <v-select :class="selectRCF + ' vue-select2 '" v-model="selectedReciever" label="name" :options="simple_member" @search="SimpleMemberSearch" @input="averageRate = false" >
                                            </v-select>
                                            <input type="hidden" name="reciever_id" :value="(!selectedReciever)?null:selectedReciever.id" >
                                        </div>
                                    </div>
                                    @if (fingerprint() == 'true')
                                    <div class="col-lg-4" v-if="reciever">
                                        <label class=" control-label">@lang('layout.Fingerprint')</label>
                                        <div class="col-md-12 mt-checkbox">
                                            <label class="mt-checkbox mt-checkbox-outline">
                                                <input type="checkbox" @click="clearFinger('finger2')" name="finger2" v-model="finger2">
                                                <span></span>
                                            </label>
                                        </div>
                                    </div>
                                    @endif
                                    <div class="col-lg-4">
                                        <label class="control-label">@lang('layout.MonetarySource')</label>
                                            {!! Form::text('monetary_source', null, array('placeholder' => __('layout.MonetarySource'),'class' => 'form-control')) !!}
                                    </div>
                                    <div class="col-lg-4" style="padding: 0px !important;">
                                        <div class="col-lg-6">
                                            <label class=" control-label">@lang('layout.Implemented')</label>
                                            <div class="col-md-12 mt-checkbox">
                                                <label class="mt-checkbox mt-checkbox-outline">
                                                    <input type="checkbox" name="status" value="off">
                                                    <span></span>
                                                </label>
                                            </div>
                                        </div>
                                            
                                        <div class="col-lg-6">
                                            <label class=" control-label">@lang('layout.TransactionConfirm')</label>
                                            <div class="col-md-12 mt-checkbox">
                                                <label class="mt-checkbox mt-checkbox-outline"> 
                                                    <input type="checkbox" name="transaction_confirm" value="On">
                                                    <span></span>
                                                </label>
                                            </div>
                                        </div>
        
                                        @if(getTelegramBot()=="true")
                                        <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                            <table class="table table-striped table-bordered table-advance ">
                                                <tr>
                                                    <td class="t_body">
                                                        <div>
                                                            <label class="mt-checkbox mt-checkbox-outline"><i class="fa fa-telegram" style="color:rgb(14 177 177); font-size:20px"></i>
                                                                <input type="checkbox" name="telegram" value="ok">
                                                                <span></span>
                                                            </label>
                                                        </div>
                                                    </td>
                                                </tr>
                                            </table>
                                        </div>
                                        @endif
        
                                        @if(getWhatsApp() =='true')                    
                                            <!-- <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                                <label class="control-label"> <span class="fa fa-whatsapp" style="color:green;"></span> @lang('layout.Whatsapp')</label>
                                                <div class="col-md-12 mt-checkbox">
                                                    <label class="mt-checkbox mt-checkbox-outline">
                                                        <input type="checkbox"  name="whatsapp" value="2" />
                                                        <span></span>
                                                    </label>
                                                </div>
                                            </div> -->
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-6 col-md-12 col-sm-12">
                        <div class="col-lg-12 col-md-12 col-sm-12" style="box-shadow: 0px 0px 3px rgba(172, 171, 171, 0.877);border-radius: 8px;">
                            <div class="row" style="padding: 0.5% 1%;">
                                <div class="col-lg-4">
                                    <label class="control-label">
                                        @lang('layout.Commission') &nbsp;&nbsp;&nbsp; 
                                        <span class="btn " @click="commission2 = true">@lang('layout.More')....</span> 
                                    </label>
                                    <div class="input-group">
                                        <vue-numeric
                                            class="form-control"
                                            v-model="commiss_amount"
                                            :max="99999999999999"
                                            currency=" "
                                            :precision="precision()"
                                            >
                                        </vue-numeric>
                                        <input type="hidden" name="commiss_amount" v-bind:value="commiss_amount" />
                                        <span class="input-group-addon">
                                            <input type="checkbox" name="select_commiss_currency" v-model="commiss_currency">
                                            <span></span>
                                        </span>
                                    </div>
                                </div>
                                <div class="col-lg-4">
                                    <label class="control-label">@lang('layout.Type') @lang('layout.Commission')</label>
                                    <div class="input-group" style="margin-top: .4em;">
                                        <select class="form-control" name="commission_type" v-model="commission_type">
                                            <option value="Simple">@lang('type.Simple')</option>
                                            <option value="ReceiveByOtherBranch">@lang('type.ReceiveByOtherBranch')</option>
                                            <option value="BelongsToOtherBranch">@lang('type.BelongsToOtherBranch')</option>
                                            <option value="FromSenderAccount">@lang('type.FromSenderAccount')</option>
                                        </select>
                                        <span class="input-group-addon" style="padding: 2px 4px;">
                                            <input type="checkbox" name="commiss_expense" v-model="commiss_expense">
                                            <span></span>
                                        </span>
                                    </div>
                                </div>
                                <div class="col-lg-4" v-if="commiss_currency">
                                    <div :class="comcurrency_len">
                                        <label class="control-label">@lang('layout.Currency')</label>
                                        <v-select v-model="selectedCurrency2" label="code" :options="currency" @input="setCommSize(selectedCurrency2.code)"> </v-select>
                                        <input type="hidden" name="commiss_currency" v-bind:value="(selectedCurrency2)?selectedCurrency2.code:null" />
                                    </div>
                                    <div :class="comrate_len" v-if="selectedCurrency2.code != code">
                                        <label class="control-label">@lang('layout.Rate') </label>
                                        <input v-model="selected_rate2" class="form-control" type="number" step="any" min="0">
                                        <input type="hidden" name="commiss_rate" :value="selected_rate2">
                                    </div>
                                </div>
                                <div class="col-lg-4" v-if="commiss_currency && commission_type != 'FromSenderAccount'">
                                    <label class="control-label">@lang('layout.Account')</label>
                                    <select class="form-control" name="commiss_account_id" v-model="defaultAccount1">
                                        <option v-for="Account in accountUpdateComm" :value="Account.id">@{{ Account.name }}</option>
                                    </select>
                                </div>
                                <div class="col-lg-4" v-if="commission_type != 'BelongsToOtherBranch' && !commiss_expense" >
                                    <label class="control-label">@lang('layout.Income')</label>
                                    <v-select class="vue-select2" v-model="selectedIncome" label="name" :options="income">
                                    </v-select>
                                    <input type="hidden" name="income_id" :value="(!selectedIncome)?null:selectedIncome.id" >
                                </div>
                                <div class="col-lg-4" v-if="commission_type != 'BelongsToOtherBranch' && commiss_expense" >
                                    <label class="control-label">@lang('layout.Expense')</label>
                                    <v-select class="vue-select2" v-model="selectedExpense" label="name" :options="expense">
                                    </v-select>
                                    <input type="hidden" name="expense_id" :value="(!selectedExpense)?null:selectedExpense.id" >
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-12 col-md-12 col-sm-12" v-if="commission2 == true" style="box-shadow: 0px 0px 3px rgba(172, 171, 171, 0.877);border-radius: 8px; margin-top: 20px;">
                            <div class="row">
                                <div class="col-lg-4">
                                    <label class="control-label">@lang('layout.Commission') </label>
                                    <div class="input-group">
                                        <input type="number" name="commiss_amount2" class="form-control">
                                        <span class="input-group-addon">
                                            <input type="checkbox" name="select_commiss_currency2" v-model="commiss_currency2">
                                            <span></span>
                                        </span>
                                    </div>
                                </div>
                                <div class="col-lg-4">
                                    <label class="control-label">@lang('layout.Type') @lang('layout.Commission')</label>
                                    <div class="input-group">
                                        <select class="form-control" name="commission_type2" v-model="commission_type2">
                                            <option value="Simple">@lang('type.Simple')</option>
                                            <option value="ReceiveByOtherBranch">@lang('type.ReceiveByOtherBranch')</option>
                                            <option value="BelongsToOtherBranch">@lang('type.BelongsToOtherBranch')</option>
                                            <option value="FromSenderAccount">@lang('type.FromSenderAccount')</option>
                                        </select>
                                        <span class="input-group-addon">
                                            <input type="checkbox" name="commiss_expense2" v-model="commiss_expense2">
                                            <span></span>
                                        </span>
                                    </div>
                                </div>
                                <div class="col-lg-4" v-if="commiss_currency2" style="padding: 0px !important;">
                                    <div :class="comcurrency2_len">
                                        <label class="control-label">@lang('layout.Currency')</label>
                                        <v-select v-model="selectedCurrency3" label="code" :options="currency" @input="setCommSize2(selectedCurrency3.code)"> </v-select>
                                        <input type="hidden" name="commiss_currency2" v-bind:value="(selectedCurrency3)?selectedCurrency3.code:null" />
                                    </div>
                                    <div :class="comrate2_len" v-if="selectedCurrency3.code != code">
                                        <label class="control-label">@lang('layout.Rate') </label>
                                        <input v-model="selected_rate3" class="form-control" type="number" step="any" min="0">
                                        <input type="hidden" name="commiss_rate2" :value="selected_rate3">
                                    </div>
                                </div>
                                <div class="col-lg-4" v-if="commiss_currency2 && commission_type2 != 'FromSenderAccount'" >
                                    <label class="control-label">@lang('layout.Account')</label>
                                    <select class="form-control" name="commiss_account2_id" v-model="defaultAccount2">
                                        <option v-for="Account in accountUpdateComm2" :value="Account.id">@{{ Account.name }}</option>
                                    </select>
                                </div>
                                <div class="col-lg-4" v-if="commission_type2 != 'BelongsToOtherBranch' && !commiss_expense2" >
                                    <label class="control-label">@lang('layout.Income')</label>
                                    <v-select class="vue-select2" v-model="selectedIncome2" label="name" :options="income">
                                    </v-select>
                                    <input type="hidden" name="income2_id" :value="(!selectedIncome2)?null:selectedIncome2.id" >
                                </div>
                                <div class="col-lg-4" v-if="commission_type2 != 'BelongsToOtherBranch' && commiss_expense2" >
                                    <label class="control-label">@lang('layout.Expense')</label>
                                    <v-select class="vue-select2" v-model="selectedExpense2" label="name" :options="expense">
                                    </v-select>
                                    <input type="hidden" name="expense2_id" :value="(!selectedExpense2)?null:selectedExpense2.id" >
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-12 col-md-12 col-sm-12" style="box-shadow: 0px 0px 3px rgba(172, 171, 171, 0.877);border-radius: 8px; margin-top: 20px; padding-bottom: 20px;">
                            <div class="col-lg-12">
                                <div class="col-lg-12">
                                    <label class="control-label">@lang('layout.Description')</label>
                                    {!! Form::textarea('description', null, array('class' => 'form-control','rows' => 1)) !!}
                                    <span v-if="description1 == false" class="btn " @click="description1 = true">@lang('layout.More')....</button>
                                </div>
                                <div class="col-lg-12">
                                    <div class="row" v-if="description1 == true">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Description')1</label>
                                            {!! Form::textarea('description1', null, array('class' => 'form-control','rows' => 1)) !!}
                                            <span v-if="description2 == false" class="btn " @click="description2 = true">@lang('layout.More')....</button>
                                        </div>
                                    </div>
                                    <div class="row"v-if="description2 == true">
                                        <div class="col-lg-12">
                                            <label class="control-label">@lang('layout.Description')2</label>
                                            {!! Form::textarea('description2', null, array('class' => 'form-control','rows' => 1)) !!}
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-lg-12 col-md-12 col-sm-12" style="border-radius: 8px; margin-top: 20px; padding-bottom: 20px;">
                            <div class="row">
                                <div class="dashboard-stat2" v-if="all_currency && gain_loss_status" style="margin-bottom: 10px; padding-bottom: 5px;box-shadow: 0px 0px 3px rgba(172, 171, 171, 0.877);" >
                                    <table class="dashboard-tabel table-bordered" width="100%">
                                        <thead>
                                            <tr>
                                                <th colspan="2" style="background-color: #add8e6; text-align: center;">@lang('layout.TodayRate') -- @lang('layout.BaseCurrency') ( {!! getHomeCurrency()["code"] !!} )</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <span>
                                                <tr v-for="crr in all_currency">
                                                    <span v-if="selectedCurrency">
                                                        <td v-if="selectedCurrency.code == crr.code">
                                                            @{{ crr.code }}
                                                        </td>
                                                        <td  v-if="selectedCurrency.code == crr.code">
                                                            @{{(crr.rate)}} <input type="hidden" name="today_rate" :value="crr.rate" />
                                                        </td>
                                                    </span>
                                                    <span v-if="selectedCurrency && paymentCurrency">
                                                        <td v-if="selectedCurrency.code != paymentCurrency.code && paymentCurrency.code == crr.code">
                                                            @{{ crr.code }}
                                                        </td>
                                                        <td v-if="selectedCurrency.code != paymentCurrency.code && paymentCurrency.code == crr.code">
                                                            @{{(crr.rate)}}
                                                        </td>
                                                        <td v-if="paymentCurrency.code == crr.code" v-show="false">
                                                            <input type="hidden" name="ex_today_rate" :value="crr.rate" />
                                                        </td>
                                                    </span>
                                                </tr>
                                            </span>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                            <div class="row">
                                <div class="dashboard-stat2" v-if="selectedMember" style="margin-bottom: 0px; padding-bottom: 5px;box-shadow: 0px 0px 3px rgba(172, 171, 171, 0.877);" >
                                    <table class="dashboard-tabel table-bordered" width="100%">
                                        <thead>
                                            <tr>
                                                <th style="background-color: #add8e6;">@lang('layout.Currency') </th>
                                                <th style="background-color: #add8e6;">@lang('layout.Payable')</th>
                                                <th style="background-color: #add8e6;">@lang('layout.Receivable')</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <span>
                                                <tr v-for="summ in summary">
                                                    <td>
                                                        @{{ summ.currency }}
                                                    </td>
                                                    <td class="hidden-xs"> @{{ format_number(Number(summ.payment)) }}</td>
                                                    <td>
                                                        @{{format_number(Number(summ.invoice)) }}
                                                    </td>
                                                </tr>
                                            </span>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row" v-show="show_create">
                        <div class="col-lg-12 col-md-12 col-sm-12 text-center">
                            <br>
                            <button v-if="isError ==false" type="button" @click="handleSubmit($event)" :disabled="disabled" class="btn green">@lang('layout.Submit')</button>
                            <button v-if="isError ==false" type="button" class="btn blue" @click="checkOldList($event)" :disabled="disabled">@lang('layout.SaveAndNew')</button>
                            <a @click="show_create = false, clearData()" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                            <br>
                            <br>
                        </div>
                    </div>
                    <cmodal :show='showModal' @close="showModal=false">
                    </cmodal>
                </div>
            </div>

            {!! Form::close() !!}

            @endpermission

            <!-- END FORM-->
            <!-- start list -->
            <table class="table table-striped table-bordered table-hover" id="loan" cellspacing="0" width="100%">
                <thead>
                    <tr>
                        <th width="1%">@lang('layout.Record')</th>
                        <th width="1%">@lang('layout.Number')</th>
                        <th width="1%">@lang('layout.ChequeNumber')</th>
                        <th>@lang('layout.Member')</th>
                        <th>@lang('layout.Account')</th>
                        <th>@lang('layout.Amount')</th>
                        <th>@lang('layout.Currency')</th>
                        <th>@lang('layout.Rate')</th>
                        <th>@lang('layout.Type')</th>
                        <th>@lang('layout.Type') @lang('layout.Commission')</th>
                        <th>@lang('layout.Amount')</th>
                        <th>@lang('layout.Sender')</th>
                        <th>@lang('layout.Reciever')</th>
                        <th>@lang('layout.TransactionType')</th>
                        <th>@lang('layout.ProfitAndLost')</th>
                        <th>@lang('layout.Date')</th>
                        <th>@lang('layout.Status')</th>
                        <th>@lang('layout.User')</th>
                        <th>@lang('layout.Description')</th> 
                        <th>@lang('layout.Actions')</th>
                    </tr>
                </thead>
            </table>
        </div>
    </div>
    <!-- END EXAMPLE TABLE PORTLET-->
</div>

<!-- END TAB PORTLET-->
<!-- END CONTENT BODY -->

@stop
@include('print.modal')
@include('groupCompanyFilter.select')
@push('scripts')

<script>
    
    @if(App::getLocale())
    Vue.use(VeeValidate, {
        locale: '{{App::getLocale()}}',
    });
    @else
    Vue.use(VeeValidate, {
        locale: 'en',
    });
    @endif

    Vue.component("v-select", VueSelect.VueSelect);
    Vue.use(VueNumeric.default);

    function printVoucher(id,sendWhatsapp = null) {
        var a = document.createElement('a');
        a.href = "{{url('chequePrintVoucher')}}/" + id + "/" + sendWhatsapp;
        a.target = "_blank";
        document.body.appendChild(a);
        a.click();
        document.body.removeChild(a);
    }

    function sendVoucherToWhatsapp(id,sendWhatsapp) {
        if (id && sendWhatsapp) {
			axios.get("{{url('chequePrintVoucher')}}/" + id + "/1", {
			})
			.then(function(response) {
				// console.log(response);
				if (response.data) {
                    if (sendWhatsapp == 1) {
                        var a = document.createElement('a');
                        a.href = "https://wa.me/?text=" + response.data;
                        a.target = "_blank";
                        document.body.appendChild(a);
                        a.click();
                        document.body.removeChild(a);
                    }
                    if (sendWhatsapp == 2) {
                        var a = document.createElement('a');
                        a.href = "https://telegram.me/share/url?url=Hi&text=" + response.data;
                        a.target = "_blank";
                        document.body.appendChild(a);
                        a.click();
                        document.body.removeChild(a);
                    }
				}
			})
			.catch(function(error) {
				console.log(error);
			})
		}
    }

    /**
     * we load approperiat datable according
     * to it's site_id
     */
    var my_table = 0;
    $(document).ready(function() {
        getRecord();
    });

    function getRecord() {
        $.fn.dataTable.ext.errMode = '{{dataTableWarning()}}';
        if (my_table != 0) {
            my_table.destroy();
        }
        my_table = $('#loan').DataTable({
            ajax: '{{route("cheque.index")}}',
            pageLength: '{{getPageRows()}}',
            order: [
                ["{{orderByColumn()=='number'?0:12}}", "{{getRowOrder()}}"]
            ],
            responsive: '{{responsiveDataTable()}}',
            pagingType: '{{paginationType()}}',
            serverSide: true,
            destroy: true,
            paging: true,
            buttons: [{
                extend: 'excel',
                text: '',
                key: {
                    key: 'x',
                    altkey: true
                }
            }],
            columns: [
                {
                    data: 'id',
                    name: 'cheque.id',
                    searchable: false
                },
                {
                    data: 'number',
                    name: 'cheque.number'
                },
                {
                    data: 'ref_no',
                    name: 'cheque.ref_no'
                },
                {
                    data: 'Member',
                    name: 'members.name'
                },
                {
                    data: 'Account',
                    name: 'account',
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'amount',
                    name: 'bank_tran.amount'
                },
                {
                    data: 'currency',
                    name: 'cheque.currency'
                },
                {
                    data: 'rate',
                    name: 'rate',
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'type',
                    name: 'type',
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'commission_type',
                    name: 'commission_type',
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'commission_amount',
                    name: 'commission_amount',
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'sender',
                    name: 'sender',
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'reciever',
                    name: 'reciever',
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'transaction_type',
                    name: 'transaction_type',
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'gain_loss_amount',
                    name: 'cheque.gain_loss_amount',
                    searchable: false
                },
                {
                    data: 'Date',
                    name: 'date',
                    searchable: false
                },
                {
                    data: 'status',
                    name: 'status',
                    orderable: true,
                    searchable: false
                },
                {
                    data: 'username',
                    name: 'username',
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'description',
                    name: 'cheque.description'
                },
                {
                    data: 'action',
                    name: 'action',
                    orderable: false,
                    searchable: false
                }

            ]
        });
    }


    // for new modal
    var cust_rep = {!!customeReportNewData('cheque_index') !!};

    var currency2 ={!! $currency!!}
    var member_class  = {!!$memberClass!!}
    var BanksFilter = {!! $bank!!}

    var vu = new Vue({
        el: '#print-modal',
        data: {
            period: 'CustomDates',
            from_date: null,
            to_date: null,
            is_show: false,
            pdfRoute: '{!!route("cheque.report") !!}',
            excelRoute: '{!! route("cheque.report") !!}',
            selectedMember: null,
            currency: currency2,
            selectedCurrency: null,
            member: [],
            selected_class:null,
            selected_bank:null,
            bank:[],
            member_class:member_class,
            financial_classes: {!!getFinancialClassList()!!},
            customReportData: [
                {
                    Name: '@lang("layout.Record")',
                    column_name: 'record',
                    checkedColumn: (cust_rep.record) ? 'checked' : '',
                    column_percentage:(cust_rep.record___percent)?cust_rep.record___percent:''
                },
                
                {
                    Name: '@lang("layout.Number")',
                    column_name: 'number',
                    checkedColumn: (cust_rep.number) ? 'checked' : '',
                    column_percentage:(cust_rep.number___percent)?cust_rep.number___percent:''
                },

                {
                    Name: '@lang("layout.Status")',
                    column_name: 'status',
                    checkedColumn: (cust_rep.status) ? 'checked' : '',
                    column_percentage:(cust_rep.status___percent)?cust_rep.status___percent:''
                },

                {
                    Name: '@lang("layout.ChequeNumber")',
                    column_name: 'reference_number',
                    checkedColumn: (cust_rep.reference_number) ? 'checked' : '',
                    column_percentage:(cust_rep.reference_number___percent)?cust_rep.reference_number___percent:''
                },
                {
                    Name: '@lang("layout.Type")',
                    column_name: 'type',
                    checkedColumn: (cust_rep.type) ? 'checked' : '',
                    column_percentage:(cust_rep.type___percent)?cust_rep.type___percent:''
                },
                {
                    Name: '@lang("layout.Description")',
                    column_name: 'description',
                    checkedColumn: (cust_rep.description) ? 'checked' : '',
                    column_percentage:(cust_rep.description___percent)?cust_rep.description___percent:''
                },
                {
                    Name: '@lang("layout.Description")1',
                    column_name: 'description1',
                    checkedColumn: (cust_rep.description1) ? 'checked' : '',
                    column_percentage:(cust_rep.description1___percent)?cust_rep.description1___percent:''
                },
                {
                    Name: '@lang("layout.Description")2',
                    column_name: 'description2',
                    checkedColumn: (cust_rep.description2) ? 'checked' : '',
                    column_percentage:(cust_rep.description2___percent)?cust_rep.description2___percent:''
                },
                {
                    Name: '@lang("layout.Date")',
                    column_name: 'date',
                    checkedColumn: (cust_rep.date) ? 'checked' : '',
                    column_percentage:(cust_rep.date___percent)?cust_rep.date___percent:''
                },
                {
                    Name: '@lang("layout.Member")',
                    column_name: 'member',
                    checkedColumn: (cust_rep.member) ? 'checked' : '',
                    column_percentage:(cust_rep.member___percent)?cust_rep.member___percent:''
                },
                {
                    Name: '@lang("layout.Amount")',
                    column_name: 'amount',
                    checkedColumn: (cust_rep.amount) ? 'checked' : '',
                    column_percentage:(cust_rep.amount___percent)?cust_rep.amount___percent:''
                },
                {
                    Name: '@lang("layout.Rate")',
                    column_name: 'rate',
                    checkedColumn: (cust_rep.rate) ? 'checked' : '',
                    column_percentage:(cust_rep.rate___percent)?cust_rep.rate___percent:''
                },
                {
                    Name: '@lang("layout.Account")',
                    column_name: 'account',
                    checkedColumn: (cust_rep.account) ? 'checked' : '',
                    column_percentage:(cust_rep.account___percent)?cust_rep.account___percent:''
                },
                {
                    Name: '@lang("layout.Total")',
                    column_name: 'total',
                    checkedColumn: (cust_rep.total) ? 'checked' : '',
                    column_percentage:(cust_rep.total___percent)?cust_rep.total___percent:''
                },
                {
                    Name: '@lang("layout.Sender")',
                    column_name: 'sender',
                    checkedColumn: (cust_rep.sender) ? 'checked' : '',
                    column_percentage:(cust_rep.sender___percent)?cust_rep.sender___percent:''
                },
                {
                    Name: '@lang("layout.Reciever")',
                    column_name: 'reciever',
                    checkedColumn: (cust_rep.reciever) ? 'checked' : '',
                    column_percentage:(cust_rep.reciever___percent)?cust_rep.reciever___percent:''
                },
                {
                    Name: '@lang("layout.IDNumber")',
                    column_name: 'SSN',
                    checkedColumn: (cust_rep.SSN) ? 'checked' : '',
                    column_percentage:(cust_rep.SSN___percent)?cust_rep.SSN___percent:''
                },
                {
                    Name: '@lang("layout.Commission")',
                    column_name: 'commission',
                    checkedColumn: (cust_rep.commission) ? 'checked' : '',
                    column_percentage:(cust_rep.commission___percent)?cust_rep.commission___percent:''
                },
                {
                    Name: '@lang("layout.DueDate")',
                    column_name: 'dueDate',
                    checkedColumn: (cust_rep.dueDate) ? 'checked' : '',
                    column_percentage:(cust_rep.dueDate___percent)?cust_rep.dueDate___percent:''
                },
                {
                    Name: '@lang("layout.FatherName") @lang("layout.Sender")',
                    column_name: 'father_name',
                    checkedColumn: (cust_rep.father_name) ? 'checked' : '',
                    column_percentage:(cust_rep.father_name___percent)?cust_rep.father_name___percent:''
                },
                {
                    Name: '@lang("layout.FatherName") @lang("layout.Reciever")',
                    column_name: 'father_name_reciever',
                    checkedColumn: (cust_rep.father_name_reciever) ? 'checked' : '',
                    column_percentage:(cust_rep.father_name_reciever___percent)?cust_rep.father_name_reciever___percent:''
                },
                {
                    Name: '@lang("layout.Phone")',
                    column_name: 'phone',
                    checkedColumn: (cust_rep.phone) ? 'checked' : '',
                    column_percentage:(cust_rep.phone___percent)?cust_rep.phone___percent:''
                },
                {
                    Name: '@lang("layout.Address")',
                    column_name: 'address',
                    checkedColumn: (cust_rep.address) ? 'checked' : '',
                    column_percentage:(cust_rep.address___percent)?cust_rep.address___percent:''
                },
                {
                    Name: '@lang("layout.Address") @lang("layout.Reciever")',
                    column_name: 'address_reciever',
                    checkedColumn: (cust_rep.address_reciever) ? 'checked' : '',
                    column_percentage:(cust_rep.address_reciever___percent)?cust_rep.address_reciever___percent:''
                },

                {
                    Name: '@lang("layout.Type") @lang("layout.Commission")',
                    column_name: 'comission_type',
                    checkedColumn: (cust_rep.comission_type) ? 'checked' : '',
                    column_percentage:(cust_rep.comission_type___percent)?cust_rep.comission_type___percent:''
                },

                {
                    Name: '@lang("layout.MonetarySource")',
                    column_name: 'monetary_source',
                    checkedColumn: (cust_rep.monetary_source) ? 'checked' : '',
                    column_percentage:(cust_rep.monetary_source___percent)?cust_rep.monetary_source___percent:''
                },
                {
                    Name: '@lang("layout.ProfitAndLost")',
                    column_name: 'profit_lost',
                    checkedColumn: (cust_rep.profit_lost) ? 'checked' : '',
                    column_percentage:(cust_rep.profit_lost___percent)?cust_rep.profit_lost___percent:''
                },

                {
                    Name: '@lang("layout.User")',
                    column_name: 'user',
                    checkedColumn: (cust_rep.user) ? 'checked' : '',
                    column_percentage:(cust_rep.user___percent)?cust_rep.user___percent:''
                },

                {
                    Name: '@lang("layout.TransactionConfirm")',
                    column_name: 'transaction_confirm',
                    checkedColumn: (cust_rep.transaction_confirm) ? 'checked' : '',
                    column_percentage:(cust_rep.transaction_confirm___percent)?cust_rep.transaction_confirm___percent:''
                },
            ],
            cust_rep: cust_rep
        },
        methods: {
            closeModal: function() {
                this.is_show = !this.is_show
            },
            searchAccount(search, loading) {
                loading(true);
                axios.get("{{route('callMethod.search')}}", {
                    params: {
                        method_name: 'anyTable',
                        keyword: search,
                        table_name: 'accounts',
                        filterColumn: 'type',
                        filterValue: 'bank',
                    }
                })
                .then(function (response) {
                    vu.bank = [];
                    if (response.data.length > 0) {
                        vu.bank = response.data;
                    }
                    loading(false);
                })
                .catch(function (error) {
                    console.log(error);
                })
            },

            MemberSearch: _.debounce((search, loading) => {
                loading(true);
                let class_id = (vu.selected_class != undefined) ? vu.selected_class.id : null;
                
                axios.get("{{route('callMethod.search')}}", {
                    params: {
                        method_name: 'SearchMember', 
                        keyword: search,
                        class_id: class_id
                    }
                })
                .then(function(response) {
                    if (response.data.length > 0) {
                        // console.log(response.data);
                        vu.member = [];
                        vu.member = response.data;
                    }
                    loading(false);
                })
                .catch(function(error) {
                    loading(false);
                    console.log(error);
                })
            }, getDebounceTime()),

            //ajax call to get dates
            getDates() {
                setTimeout((function () {
                vu.getDate(vu.period);
                    // console.log(12);
                }), 2e2);
            },
            getDate(period) {
                if (period) {
                // console.log(3232, period);
                if (period != 'CustomDates') {
                    axios.get("{{route('callMethod.search')}}", {
                    params: {
                        method_name: 'getDatesByPeriod',
                        period: period,
                    }
                    })
                    .then(function(response) {
                    vu.from_date = null;
                    vu.to_date = null;
                    if (response.data) {
                        vu.from_date = response.data.start;
                        vu.to_date = response.data.end;
                        // console.log('data', response.data);
                    }
                    })
                    .catch(function(error) {
                    vu.period = 'CustomDates';
                    vu.from_date = null;
                    vu.to_date = null;
                    })
                } else {
                    vu.from_date = null;
                    vu.to_date = null;
                }
                }
            },

        }
    });


    new Vue({
        el: '#anchore-modal',
        methods: {
            showModal: function() {
                console.log('trr')
                vu.$data.is_show = true;

            }
        }
    });

    new Vue({
        el: '#create-modal',
        methods: {
            showModal: function() {
                console.log('trr')
                vm.$data.show_create = true;

            }
        }
    });

    // /for new modal

    new Vue({
        el: '#company_ll',
        methods: {
            setCompany: function(event) {
                window.location.reload()
            }
        }
    });

    //begin new member
    var cm = Vue.component("cmodal", {
        template: '#cmodal-template',

        props: ['show'],
        data() {
            return {
                types: [],
                classes: [],
                receivables: [],
                payables: [],
                code: null,
                selectType: null,
                selectPay: null,
                selectedClass: null,
                selectReceive: null,
            }
        },
        created() {

            axios.get('{{route("customer.create")}}').then(
                response => {
                    this.types = response.data.types;
                    if (this.types) {
                        for (var i = 0; i < this.types.length; i++) {
                            if (this.types[i].type == "Customer") {
                                this.selectType = this.types[i];
                            }
                        }
                    }
                    this.receivables = response.data.receivable;
                    this.payables = response.data.payable;
                    this.code = response.data.code;
                    this.classes = response.data.member_class;
                    if (this.receivables.length > 0) {
                        this.selectReceive = this.receivables[0];
                    }
                    if (this.payables.length > 0) {
                        this.selectPay = this.payables[0];
                    }


                }).catch(error => console.log(error));
        },
        methods: {
            onSubmit() {

                vm.showModal = false;
                //this.member.type = this.member.type.id;
                var datas = $("#modalForm").serializeArray();
                var addfinger = '';
                try {
                    addfinger = datas[5]['value']; 
                } catch (error) {
                }
                
                $.ajax({
                    headers: {
                        'X-CSRF-TOKEN': "{{csrf_token()}}"
                    },
                    url: '{{route("customer.store")}}',
                    method: 'post',
                    data: {
                        "name": datas[0]['value'],
                        "code": datas[1]['value'],
                        'email': datas[2]['value'],
                        'phone': datas[3]['value'],
                        'address1': datas[4]['value'],
                        'addfinger': addfinger,
                        'type': this.selectType.id,
                        'receivable': this.selectReceive.id,
                        'payable': this.selectPay.id,
                        'class': (this.selectedClass) ? this.selectedClass.id : null
                    },

                    dataType: 'json',

                }).done(function(response) {
                    // console.log(321,response);
                    if (response) {
                        if (addfinger) {
                            if (!response.addfinger) {
                                swal({ title:"{{__('message.FDeviceNotConn')}}", dangerMode: true});
                            }else{
                                swal("{{__('message.AddFingerprintSC')}}");
                            }
                        }
                        vm.selectedMember = response.customer;
                    }
                }).fail(function(error) {
                    console.log('error', error);
                });

            }
        }
    });


    var Banks = {!! $bank!!}
    var all_currency = {!! $currencies!!}
    var Currency ={!! $currency!!}
    var memberClass = {!! $memberClass !!};
    var Currency1 ={!! $currency!!}
    var one = {!!json_encode(Currency()->getCurrency()) !!};
    var two = {!! json_encode(Currency()->getCurrency()) !!};
    var tree = {!! json_encode(Currency()->getCurrency()) !!};
    var code = '{!! getHomeCurrency()["code"] !!}';
    let rates ={!! $rates !!};
    let income = {!!$income!!};
    let expense = {!!$expense!!};
    let company = {!!$company!!};

    var vm = new Vue({
        el: '#app',
        data: {
            all_currency: all_currency,
            company:company,
            selected_company:null,
            selectedCurrencyTemp: null,
            paymentCurrency: two,
            selectedCurrency2: tree,
            selectedCurrency3: tree,
            // currency1:{!! json_encode(getCurrencies()) !!},
            currency1: [],
            selected_rate: 0,
            selected_rate1: 0,
            selected_rate2: 0,
            selected_rate3: 0,
            exchange_amount: null,
            finger: null,
            finger1: null,
            finger2: null,
            show_create: true,
            currency_len: 'col-md-12',
            rate_len: 'col-md-0',
            pcurrency_len: 'col-md-12',
            prate_len: 'col-md-0',
            comcurrency_len: 'col-md-12',
            comrate_len: 'col-md-0',
            comcurrency2_len: 'col-md-12',
            comrate2_len: 'col-md-0',
            first_currency: 0,
            second_currency: 0,
            lastAmount: null,
            description1: false,
            description2: false,
            commission2: false,
            code: code,
            selectedCurrency: one,
            currency: {!!json_encode(getCurrencies()) !!},
            averageRate: false,
            bankes: {!!$banks!!},
            number: "{{$number}}",
            old_number: "{{$number}}",
            selectedBank: null,
            defaultValue: 0,
            defaultValue1: 0,
            defaultValue2: 0,
            defaultAmount: 0,
            defaultAccount: 0,
            defaultAccount1: 0,
            defaultAccount2: 0,
            amount: null,
            amount_to_word: null,
            balance: 0,
            chequeType: 'Send',
            commission_type: 'Simple',
            commission_type2: 'Simple',
            income: income,
            selectedIncome: null,
            selectedIncome2: null,
            expense: expense,
            selectedExpense: null,
            selectedExpense2: null,
            listAccounts: [],
            currencyList: Currency,
            selectedMember: null,
            selectedSender: null,
            selectedReciever: null,
            disabled: false,
            type: 'bank',
            account: {},
            ref_no: '',
            msg: '',
            isError: false,
            showModal: false,
            sender: false,
            reciever: false,
            commiss_currency: false,
            commiss_currency2: false,
            commiss_expense: false,
            commiss_expense2: false,
            gain_loss_status: false,
            summary: [],
            memberClass: memberClass,
            selected_class: null,
            member: [],
            simple_member: [],
            branch_type: false,
            commiss_amount: 0,
            fingerCounter: 0,
            selectMem:'',
            selectRCF:'',
            selectSCF:''
        },
        computed: {
            accountUpdate() {
                this.defaultAccount = null;
                var b = _.clone(Banks)
                var test = this.accounts = b.filter((account) => {
                    return (new RegExp(this.selectedCurrency.code.toLowerCase())).test(account.code.toLowerCase())
                })
                if (test.length > 0) {
                    this.defaultValue = test[0].id;
                } else {
                    this.defaultValue = 0;
                }
                for (var x in this.bankes) {
                    for (z in this.bankes[x]) {
                        if (this.bankes[x][z] == this.defaultValue && z == 'id') {
                            this.selectedBank = this.bankes[x];
                            this.defaultAccount = this.defaultValue;

                            this.averageRate = false;
                            // @if(getAverageRate() =="true")
                            // if (this.bankes[x].avg_rate && this.chequeType == "Receive") {
                            //     this.set_avg_rate(this.bankes[x].avg_rate);
                            // }
                            // @endif

                            break;
                        }
                    }

                }
                return test;
            },
            accountUpdateComm() {
                var b = _.clone(Banks)
                var test = b.filter((account) => {
                    return (new RegExp(this.selectedCurrency2.code.toLowerCase())).test(account.code.toLowerCase())
                })
                if (test.length > 0) {
                    this.defaultValue1 = test[0].id;
                } else {
                    this.defaultValue1 = 0;
                }
                for (var x in this.bankes) {
                    for (z in this.bankes[x]) {
                        if (this.bankes[x][z] == this.defaultValue1 && z == 'id') {
                            this.defaultAccount1 = this.defaultValue1;
                            break;
                        }
                    }

                }
                return test;
            },
            accountUpdateComm2() {
                var b = _.clone(Banks)
                var test = b.filter((account) => {
                    return (new RegExp(this.selectedCurrency3.code.toLowerCase())).test(account.code.toLowerCase())
                })
                if (test.length > 0) {
                    this.defaultValue2 = test[0].id;
                } else {
                    this.defaultValue2 = 0;
                }
                for (var x in this.bankes) {
                    for (z in this.bankes[x]) {
                        if (this.bankes[x][z] == this.defaultValue2 && z == 'id') {
                            this.defaultAccount2 = this.defaultValue2;
                            break;
                        }
                    }

                }
                return test;
            },
            checkLoan() {
                var x = (this.chequeType == 'Receive') ? true : false;
                return x;
            },

        },
        mounted: function() {
            if (income.length > 0) {
                this.selectedIncome = income[0];
                this.selectedIncome2 = income[0];
            }
            if (expense.length > 0) {
                this.selectedExpense = expense[0];
                this.selectedExpense2 = expense[0];
            }
            this.setSize(this.selectedCurrency.code);
            this.setCommSize(this.selectedCurrency2.code);
            this.setCommSize2(this.selectedCurrency3.code);

            // console.log(123, this.currency);
        },
        created() {
            this.setRates();
        },
        methods: {
            setRates() {

                let c = _.clone(Currency);
                let c1 = _.clone(Currency1);

                Currency = [];
                Currency1 = [];

                c.forEach((a) => {

                    rates.forEach((rate) => {

                        if (a.code == rate.code)
                            Currency.push({
                                name: a.name,
                                code: a.code,
                                symbol: a.symbol,
                                exchange_rate: rate.rate,
                                rate: rate.rate,
                                hq_rate: rate.hq_rate
                            });
                    });
                });

                c1.forEach((a) => {
                    rates.forEach((rate) => {

                        if (a.code == rate.code)
                            Currency1.push({
                                name: a.name,
                                code: a.code,
                                symbol: a.symbol,
                                exchange_rate: rate.rate,
                                rate: rate.rate,
                                hq_rate: rate.hq_rate
                            });


                    });
                });

                // for ensuring for each currency rate is defined

                c.forEach((a) => {

                    let found = false;
                    Currency.forEach((cur) => {
                        if (a.code == cur.code) {
                            found = true;
                            return;
                        }
                    });

                    if (!found) {
                        Currency.push({
                            name: a.name,
                            code: a.code,
                            symbol: a.symbol,
                            exchange_rate: 1,
                            rate: 1,
                            hq_rate: 1
                        });
                    }
                });

                c1.forEach((a) => {

                    let found = false;

                    Currency1.forEach((cur) => {
                        if (a.code == cur.code) {
                            found = true;
                            return;
                        }

                    });

                    if (!found) {
                        Currency1.push({
                            name: a.name,
                            code: a.code,
                            symbol: a.symbol,
                            exchange_rate: 1,
                            rate: 1,
                            hq_rate: 1
                        });
                    }
                });

                this.currency = Currency;
                this.currency1 = Currency1;


            },
            getSummary() {
                if (vm.selectedMember) {
                    var id = vm.selectedMember.id;
                    axios.get("{{route('callMethod.search')}}", {
                            params: {
                                method_name: 'memberStatment',
                                member_id: id,
                            }
                        })
                        .then(function(response) {
                            if (response.data.length > 0) {
                                vm.summary = response.data;
                            } else {
                                vm.summary = [];
                            }
                        })
                        .catch(function(error) {
                            vm.summary = [];
                            console.log(error);
                        });
                }
            },
            getTranslateToWord() {
                let vm = this;
                vm.amount_to_word = null;
                if (vm.amount) {
                    axios.get("{{route('callMethod.search')}}", {
                            params: {
                                method_name: 'translateNumberToWord',
                                amount: vm.amount,
                            }
                        })
                        .then(function(response) {
                            if (response.data) {
                                // console.log(132, response.data, vm.amount);
                                vm.amount_to_word = response.data;
                            }
                        })
                        .catch(function(error) {
                            console.log(error);
                        });
                }
            },
            clearFinger(fing) {
                setTimeout((function () {
                    vm.fingerCounter = 0;
                    var finger = vm.finger;
                    var finger1 = vm.finger1;
                    var finger2 = vm.finger2;
                    if (finger || finger1 || finger2) {
                        if (finger && fing == 'finger') {
                            vm.selectedMember = null;
                        }
                        if (finger1 && fing == 'finger1') {
                            vm.selectedSender = null;
                        }
                        if (finger2 && fing == 'finger2') {
                            vm.selectedReciever = null;
                        }
                        axios.get("{{route('callCheque.search')}}", {
                                params: {
                                    method_name: 'clearFinger',
                                }
                            })
                            .then(function(response) {
                                if (response.data) {
                                    vm.getFinger(fing)
                                } else {
                                    swal({ title:"{{__('message.FDeviceNotConn')}}", dangerMode: true});
                                }
                            })
                            .catch(function(error) {
                                swal({ title:"{{__('message.FDeviceNotConn')}}", dangerMode: true});
                            });
                    }
                }), 2e2);
            },
            getFinger(fing) {
                var finger = vm.finger;
                var finger1 = vm.finger1;
                var finger2 = vm.finger2;

                if (vm.fingerCounter < 20) {
                    vm.fingerCounter++; 
                    setTimeout((function () {
                        if (finger || finger1 || finger2) {
                            axios.get("{{route('callCheque.search')}}", {
                                    params: {
                                        method_name: 'getFinger',
                                    }
                                })
                                .then(function(response) {
                                    // console.log(12, response.data);
                                    if (response.data) {
                                        axios.get("{{route('callMethod.search')}}", {
                                            params: {
                                                method_name: 'SearchMember', 
                                                id: response.data,
                                            }
                                        })
                                        .then(function(response1) {
                                            if (response1.data) {
                                                if (finger && fing == 'finger') {
                                                    vm.selectedMember = response1.data;
                                                    vm.selectMem = 'v_select_success';
                                                }
                                                if (finger1 && fing == 'finger1') {
                                                    vm.selectedSender = response1.data;
                                                    vm.selectSCF = 'v_select_success';
                                                }
                                                if (finger2 && fing == 'finger2') {
                                                    vm.selectRCF = 'v_select_success';
                                                    vm.selectedReciever = response1.data;
                                                }
                                            }
                                        })
                                    } else {
                                        vm.getFinger(fing);
                                    }
                                })
                                .catch(function(error) {
                                    vm.getFinger(fing);
                                    console.log(error);
                                });
                        }
                    }), 3e3);
                } else {
                    if (finger && fing == 'finger') {
                        vm.selectMem = 'v_select_danger';
                    }
                    if (finger1 && fing == 'finger1') {
                        vm.selectSCF = 'v_select_danger';
                    }
                    if (finger2 && fing == 'finger2') {
                        vm.selectRCF = 'v_select_danger';
                    }
                    
                    swal({ title:"{{__('message.FDeviceNotConn')}}", dangerMode: true});
                }
            },
            get_exchange() {
                if (this.selected_rate > 0) {
                    this.exchange_amount = myRound((this.amount * this.selected_rate1) / this.selected_rate);
                }
            },
            set_rate() {
                let vm = this;
                if (vm.paymentCurrency.code == vm.selectedCurrency.code) {
                    if (vm.exchange_amount > 0) {
                        vm.amount = myRound(vm.exchange_amount);
                    }
                } else if (vm.paymentCurrency.code == vm.code && !vm.gain_loss_status && !vm.averageRate) {
                    if (vm.exchange_amount > 0 && vm.amount > 0) {
                        vm.selected_rate = myRound((vm.amount) / (vm.exchange_amount));
                    }
                } else {
                    if (vm.exchange_amount > 0) {
                        if (vm.gain_loss_status && vm.selected_rate1 > 0 && vm.selected_rate > 0) {
                            vm.amount = myRound((vm.exchange_amount / vm.selected_rate1) * (vm.selected_rate));
                        } else if (vm.averageRate && vm.selected_rate1 > 0 && vm.selected_rate > 0) {
                            vm.amount = myRound((vm.exchange_amount / vm.selected_rate1) * (vm.selected_rate));
                        } else {
                            vm.selected_rate1 = myRound((vm.exchange_amount) / (vm.amount / vm.selected_rate));
                        }
                    }
                }
            },

            setSize(selected_code) {
                this.paymentCurrency = this.selectedCurrency;
                this.selected_rate = this.selectedCurrency.exchange_rate;
                this.selected_rate1 = this.selectedCurrency.exchange_rate;
                if (selected_code == this.code) {
                    this.currency_len = 'col-md-12';
                    this.rate_len = 'col-md-0';
                } else {
                    this.currency_len = 'col-md-6';
                    this.rate_len = 'col-md-6';
                }
                this.pcurrency_len = this.currency_len;
                this.prate_len = this.rate_len;
            },
            setPaymentSize(selected_code) {
                this.averageRate = false;
                // this.selected_rate = this.paymentCurrency.exchange_rate;
                this.selected_rate1 = this.paymentCurrency.exchange_rate;

                if (selected_code == this.code) {
                    this.pcurrency_len = 'col-md-12';
                    this.prate_len = 'col-md-0';
                } else {
                    this.pcurrency_len = 'col-md-6';
                    this.prate_len = 'col-md-6';
                }

                // @if(getAverageRate() =="true")
                // if (this.selectedBank.avg_rate && this.chequeType == "Receive" && !this.selectedReciever) {
                //     this.averageRate = true;
                //     this.selected_rate = this.selectedBank.avg_rate;
                //     if (this.paymentCurrency.code == this.selectedCurrency.code) {
                //         this.selected_rate1 = this.selectedBank.avg_rate;
                //     }
                // }
                // @endif

            },
            setCommSize(selected_code) {
                this.selected_rate2 = this.selectedCurrency2.exchange_rate;
                if (selected_code == this.code) {
                    this.comcurrency_len = 'col-md-12';
                    this.comrate_len = 'col-md-0';
                } else {
                    this.comcurrency_len = 'col-md-6';
                    this.comrate_len = 'col-md-6';
                }
            },
            setCommSize2(selected_code) {
                this.selected_rate3 = this.selectedCurrency3.exchange_rate;
                if (selected_code == this.code) {
                    this.comcurrency2_len = 'col-md-12';
                    this.comrate2_len = 'col-md-0';
                } else {
                    this.comcurrency2_len = 'col-md-6';
                    this.comrate2_len = 'col-md-6';
                }
            },
            check_code(code) {
                if (this.paymentCurrency.code == this.selectedCurrency.code) {
                    this.selected_rate1 = this.selected_rate;
                }

            },

            memberClassChange() {
                if (vm.selected_class) {
                    vm.member = [];
                    vm.selectedMember = null;
                    let class_id = vm.selected_class.id;
                
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'SearchMember',
                            class_id: class_id
                        }
                    })
                    .then(function(response) {
                        if (response.data.length > 0) {
                            // console.log(response.data);
                            vm.member = [];
                            vm.member = response.data;
                        }
                    })
                    .catch(function(error) {
                        console.log(error);
                    })
                }
            },
            MemberSearch: _.debounce((search, loading) => {
                loading(true);
                let class_id = (vm.selected_class != undefined) ? vm.selected_class.id : null;
                
                axios.get("{{route('callMethod.search')}}", {
                    params: {
                        method_name: 'SearchMember', 
                        keyword: search,
                        class_id: class_id
                    }
                })
                .then(function(response) {
                    if (response.data.length > 0) {
                        // console.log(response.data);
                        vm.member = [];
                        vm.member = response.data;
                    }
                    loading(false);
                })
                .catch(function(error) {
                    loading(false);
                    console.log(error);
                })
            }, getDebounceTime()),

            SimpleMemberSearch: _.debounce((search, loading) => {
                loading(true);
                axios.get("{{route('callMethod.search')}}", {
                    params: {
                        method_name: 'SearchMember', 
                        keyword: search
                    }
                })
                .then(function(response) {
                    if (response.data.length > 0) {
                        // console.log(response.data);
                        vm.simple_member = [];
                        vm.simple_member = response.data;
                    }
                    loading(false);
                })
                .catch(function(error) {
                    loading(false);
                    console.log(error);
                })
            }, getDebounceTime()),

            checkRefNo() {

                //console.log(vm.ref_no)

                var chack = 'false';
                var ref_no = vm.ref_no;
                if (ref_no != null) {



                    axios.get("{{route('callMethod.search')}}", {

                            params: {
                                ref_no: vm.ref_no,
                                method_name: 'Search_ref_no',
                                table_name: 'loans'
                            },
                        })
                        .then(function(response) {
                            // console.log(response.data.result);
                            if (response.data.result != null) {
                                console.log(response.data.result);
                                // vm.temp_items=response.data;
                                vm.msg = "@lang('layout.DuplicateData')";
                                vm.isError = true;
                            } else {
                                vm.msg = 'no';
                                vm.isError = false;

                            }
                        })
                        .catch(function(error) {
                            console.log(error);
                        });
                }
            }, 
            handleSubmit(e) {
                    var chequeType = this.chequeType;
                    var date = document.getElementById('getdate').value;
                    var amount = this.amount;
                    var bank = this.defaultAccount; 
                    if (chequeType && this.selectedCurrency && this.selectedMember && amount && bank) {
                    vm.disabled = true;
                        
                    var currencies = this.selectedCurrency.code;
                    var member_id = this.selectedMember.id;
                    // console.log(bank , currencies , expense , date_value , amount_check);
                    axios.get("{{route('cheque.checkOldValue')}}", {
                        params: {
                            chequeType: chequeType,
                            currencies: currencies,
                            member_id: member_id,
                            date: date,
                            amount: amount,
                            bank: bank
                            }}).then(function (response) {
                            if (response.data) {
                                swal({
                                title: "{{__('layout.DuplicateData')}}",
                                text: "",  
                                icon: "warning",
                                buttons: ["@lang('layout.Cancel')", "@lang('layout.Ok')"],
                                warningMode: true,
                            })
                                .then((willDelete) => {
                                    if (willDelete) {
                                        vm.submitForm1();
                                        vm.disabled = false; 
                                    } else {
                                        vm.disabled = false;
                                    }
                                });
                            }else{                                
                                vm.submitForm1(); 
                                vm.disabled = false;        
                            }
                         }) .catch(function (error) {
                            vm.disabled = false; 
                            console.log(error);
                        }) 
                    }
                        else {
                        vm.disabled = false;
                    } 
            },
            submitForm1() {
                vm.disabled = true;
                swal({
                    title: "@lang('layout.AreYouSure?')",
                    buttons: ["@lang('layout.Cancel')", "@lang('layout.Submit')"],
                    text: "",
                    icon: "info",
                    dangerMode: true,
                }).then((willDelete) => {
                    if (willDelete) {
                        document.getElementById("loan-submit").submit()
                    } else {
                        vm.disabled = false;
                    }
                });
            },
            saveAndNew() {
                this.$validator.validate()
                    .then(valid => {
                        if (valid) {
                            vm.disabled = true;
                            var url = "{{route('cheque.store')}}";
                            form_id = 'loan-submit';
                            var data = $('#' + form_id).serialize();
                            toggleBlock(true);
                            axios.post(url, data)
                                .then(function(response) {
                                    toggleBlock(0);
                                    if (response.data.result == 1) {
                                        toastr.success('', response.data.message);
                                        $('#' + form_id).trigger('reset');
                                        vm.number = Number(vm.old_number) + 1;
                                        vm.old_number = Number(vm.old_number) + 1;
                                        vm.chequeType = 'Send';
                                        vm.amount = null;
                                        vm.ref_no = null;
                                        vm.selectedMember = null;
                                        vm.selectedSender = null;
                                        vm.selectedReciever = null;
                                        vm.amount_to_word = null;

                                        getRecord();
                                        // location.reload();
                                        vm.disabled = false;
                                    } else {
                                        var message = "{{__('message.Warning')}}";
                                        //$('#error-sound')[0].play();
                                        toastr.warning('', message);
                                        vm.disabled = false;
                                    }
                                })
                                .catch(function(error) {
                                    toggleBlock(0);
                                    console.log(error);
                                    var message = "{{__('message.Warning')}}";
                                    //$('#error-sound')[0].play();
                                    toastr.warning('', message);
                                    vm.disabled = false;
                                });

                        }
                    })
            },


            checkOldList(){
                var chequeType = this.chequeType;
                 var date = document.getElementById('getdate').value;
                var amount = this.amount;
                var bank = this.defaultAccount; 

                if (chequeType && this.selectedCurrency && this.selectedMember && amount && bank) {
                vm.disabled = true;

                var currencies = this.selectedCurrency.code;
                var member_id = this.selectedMember.id;
                // console.log(chequeType , currencies , member_id, date, amount, bank);
                axios.get("{{route('cheque.checkOldValue')}}", {
                        params: {
                            chequeType: chequeType,
                            currencies: currencies,
                            member_id: member_id,
                            date: date,
                            amount: amount,
                            bank: bank
                    }}).then(function (response) {
                            // console.log(response.data);
                            if (response.data) {
                                swal({
                                title: "{{__('layout.DuplicateData')}}",
                                text: "",
                                icon: "warning",
                                buttons: ["@lang('layout.Cancel')", "@lang('layout.Ok')"],
                                infoMode: true,
                            })
                                .then((willDelete) => {
                                    if (willDelete) {
                                        vm.saveAndNew();  
                                    } else {
                                        vm.disabled = false;
                                    }
                                });
                            }else{
                                vm.saveAndNew(); 
                            }
                            // loading(false); 
                        })
                        .catch(function (error) {
                            vm.disabled = false;
                            console.log(error);
                        }) 
                    }
                        else {
                        vm.disabled = false;
                    } 
                    }, 
                 onComplete: function() {
                document.getElementById("account-form").submit()
                //this.$emit('on-complete')
                //alert('Yay. Done!');s
            },

            onComplete: function() {
                document.getElementById("account-form").submit()
                //                this.$emit('on-complete')
                //                alert('Yay. Done!');
            },

            clearData: function() {
                $('#loan-submit').trigger('reset');
                vm.chequeType = 'Send';
                vm.amount = null;
                vm.ref_no = null;
                vm.selectedMember = null;
                vm.selectedSender = null;
                vm.selectedReciever = null;
                vm.exchange_amount = null;
                vm.amount_to_word = null;
            },

            submitform() {
                swal({
                        title: "Are you sure?",
                        text: "",
                        icon: "info",
                        buttons: true,
                        dangerMode: true,
                    })
                    .then((willDelete) => {
                        if (willDelete) {
                            document.getElementById("bill-submit").submit()
                        } else {}
                    });
            },
            test(defaultAccount) {
                this.averageRate = false;
                for (var x in this.bankes) {
                    for (z in this.bankes[x]) {
                        if (this.bankes[x][z] == defaultAccount && z == 'id') {
                            this.selectedBank = this.bankes[x];

                            // @if(getAverageRate() =="true")
                            // if (this.bankes[x].avg_rate && this.chequeType == "Receive" && !this.selectedReciever) {
                            //     this.averageRate = true;
                            //     this.selected_rate = this.bankes[x].avg_rate;
                            //     if (this.paymentCurrency.code == this.selectedCurrency.code) {
                            //         this.selected_rate1 = this.bankes[x].avg_rate;
                            //     }
                            // }
                            // @endif

                            break;
                        }
                    }

                }
            },
            set_avg_rate(avg_rate) {
                setTimeout(() => {
                    if (!this.selectedReciever) {
                        this.averageRate = true;
                        this.selected_rate = avg_rate;
                        if (this.paymentCurrency.code == this.selectedCurrency.code) {
                            this.selected_rate1 = avg_rate;
                        }
                    }
                }, 300);
            },
        }
    });
</script>


@endpush