@extends('layouts.app')

@section('style')
    <style>
        .iconStyle{
            font-size: 20px;
        }
    </style>
@endsection

@section('content')

<div id="print-modal">

<report-modal :pdf-route="pdfRoute" :excel-route="excelRoute"
    v-if="is_show" 
    :value-type="'member_cloth_details'"
    
    @closed="closeModal">

    <div slot="body">
         <input type="hidden" name="id" value="{{$memberCloth->id}}"/>
    </div>
</report-modal>
</div>


    <div class="portlet">
        <div class="portlet-title" id="backbtn">
            <div class="caption">
                <i class=""></i>@lang('layout.MemberClothShow')
            </div>
            <div class="tools">
            </div>
        </div>
        <div class="portlet-body">
            <div class="table-scrollable">
                <table class="table table-striped table-bordered table-advance table-hover">
                    <thead>
                    <tr>
                      
                        <th>@lang('layout.Number')</th>
                        <th>@lang('menu.ClothCategory')</th>
                        <th>@lang('layout.Date')</th> 
                        <th>@lang('layout.Description')</th> 


                    </tr> 
                    </thead>
                    <tbody>
                    <tr>
                        <td> {{$memberCloth->number}}  </td>
                        <td> {{$memberCloth->category_name}}  </td>
                        <td>  {{convertDate($memberCloth->Date)}} </td>
                        <td>  {{$memberCloth->description}} </td>

                    </tr>
                    </tbody>
                </table> 
            </div>
        </div>
    </div>

<div class="row">
        <div class="col-md-2">
                <div title="{{$memberClothInformations->member_name}}" class="twPc-avatarLink">
                        @if($memberClothInformations->photo ==Null)
                            <img class="twPc-avatarImg " src="{{asset('uploads/avatar.png')}}"
                                    style="width:170px; height:170px;">
                        @else
                            <img class=" twPc-avatarImg"
                                    src="{!!url('/uploads/'.$memberClothInformations->photo)!!}"
                                    style="width:170px; height:170px;">
                        @endif

                        
                    </div>  
        </div>
        <div class="col-md-10">
            <div class="row">


                <div class="col-md-12">
                    <div class="portlet sale-summary">
                        <div class="portlet-title">
                            <div class="caption font-red sbold"> @lang('layout.CustomerDetails') </div>
                            <div class="tools">
                                <a class="reload" href="javascript:;"> </a>
                            </div>
                        </div>
                        <div class="portlet-body">
                            <div class="table-scrollable">
                                <table class="table table-striped table-bordered table-advance table-hover">
                                    <thead>
                                    <tr>
                                    <th>@lang('layout.Phone')</th>
                                    <th>@lang('layout.Phone2')</th>
                                    <th>@lang('layout.ReferenceNumber')</th>
                                    <th>@lang('layout.Description')</th>

                                    </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                        <td>  {{$memberClothInformations->phone}} </td>
                                        <td>  {{$memberClothInformations->phone2}} </td>
                                        <td>  {{$memberClothInformations->ref_no}} </td>
                                        <td>  {{$memberClothInformations->description}} </td>
                                        </tr>
                                    </tbody>
                                </table> 
                                <hr>
                                <hr>
                                <table class="table table-striped table-bordered table-advance table-hover">
                                    <thead>
                                    <tr>
                                    <th>@lang('layout.Country')</th>
                                    <th>@lang('layout.City')</th>
                                    <th>@lang('layout.Address')1</th>
                                    <th>@lang('layout.Address')2</th>

                                    </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                        <td>  {{$memberClothInformations->country}} </td>
                                        <td>  {{$memberClothInformations->city}} </td>
                                        <td>  {{$memberClothInformations->address1}} </td>
                                        <td>  {{$memberClothInformations->address2}} </td>
                                        </tr>
                                    </tbody>
                       
                                </table>
                            </div>

                        </div>
                    </div>
                </div>

                <!--end col-md-4-->
            </div>
            <!--end row-->
        </div>
    </div>

    <div class="row">
        <div class="col-md-12">
            <!-- BEGIN EXAMPLE TABLE PORTLET-->
            <div class="portlet light bordered">
                <div class="portlet-title">
                    <div class="caption font-dark">
                        <i class="icon-settings font-dark"></i>
                        <span class="caption-subject bold uppercase">@lang('layout.Details') </span>
                    </div>
                    <div class="tools"></div>
                    <div class="actions">
                    @permission('membercloth-export')
                        <span id="anchore-modal">
                            <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                                <i class="fa fa-print"></i>
                            </a>
                        </span>
                        @endpermission
                    
                </div>

                </div>
                <div class="portlet-body">
                <div class="tabbable tabbable-tabdrop">
                    <ul class="nav nav-tabs">
                        <li class="active">
                            <a href="#tab1" data-toggle="tab" id="size_tab">@lang('layout.ClothSize')</a>
                        </li>
                        <li class="">
                            <a href="#tab2" data-toggle="tab" id="style_tab">@lang('layout.ClothStyle')</a>
                        </li>
                    </ul>
                    
                    <div class="tab-content">
                        <div class="tab-pane active" id="tab1">
                        <table class="table table-striped table-bordered table-hover" id="member_cloth_size">
                            <thead>
                            <tr>
                                <th>#</th>
                                <th>@lang('menu.ClothProperty') </th>
                                <th>@lang('layout.Description') </th>
                            </tr>
                            </thead>
                        </table>
                        </div>
                        <div class="tab-pane" id="tab2">
                            <table class="table table-striped table-bordered table-hover" id="member_cloth_style">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>@lang('layout.ClothStyle') </th>
                                    <th>@lang('layout.ClothStyle') </th>
                                </tr>
                                </thead>
                            </table>
                        </div>
                    </div>
                </div>

                    
                </div>
            </div>
            <!-- END EXAMPLE TABLE PORTLET--> 
        </div>
    </div>
@endsection
@include('print.modal')
@push('scripts')

    <script>
$(document).ready(function () {
    $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
            $('#member_cloth_size').DataTable({
                ajax: {
                    url: '{{route("memberCloth.show",$memberCloth->id)}}',
                    data: {type: 'size'}
                },
                scrollCollapse: true,
                serverSide: true,
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                paging: true,
                columns: [
                    {data: 'DT_RowIndex', name: 'DT_RowIndex',orderable:false,searchable:false},
                    {data: 'property_name', name: 'cloth_properties.name'},
                    {data: 'description', name: 'member_cloth_details.description'}


                ]

            }); 
        });      
        
        $(document).ready(function () {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
                $('#member_cloth_style').DataTable({
                    ajax: {
                        url: '{{route("memberCloth.show",$memberCloth->id)}}',
                        data: {type: 'style'}
                    },
                    scrollCollapse: true,
                    serverSide: true,
                    responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                    paging: true,
                    columns: [
                        {data: 'DT_RowIndex', name: 'DT_RowIndex',orderable:false,searchable:false},
                        {data: 'styleName', name: 'cloth_styles.name'},
                        {data: 'name', name: 'cloth_style_details.name'}
                    ]

                });
        });

    var vm =new Vue({

            el: '#print-modal',
            data:{
                is_show: false,
                pdfRoute: '{!!route('export.PDFAny') !!}',
                excelRoute: '{!! route('export.exportCsv') !!}',
            },

            methods:{
                closeModal: function(){
                    this.is_show = !this.is_show;
                }
            }
            });

            new Vue({
                el:'#anchore-modal',
                    methods:{
                    showModal:function(){
                        console.log('trr')
                        vm.$data.is_show = true;
                    }
                }
            });
    </script>


@endpush
