@extends('layouts.app')

@section('content')


    <div id="print-modal">
        <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show"
                      :value-type="'allMemberClothReport'"
                      @closed="closeModal">

            <div slot=body> 
                <!-- <div class="row">
                    <div class="form-group">
                        <label class="control-label"> @lang('layout.Number')</label>
                        <input class="form-control" type="number" name="note_number">
                    </div>
                </div> -->

                <div class="row">
                    <div class="form-group">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="control-label"> @lang('layout.Date')</label>
                                <div class="input-group">
                                    <input class="form-control date" id="range-from-example" name="from_date"
                                           autocomplete="off">

                                    <span class="input-group-addon"> @lang('layout.To') </span>
                                    <input class="form-control date" id="range-to-example" name="to_date"
                                           autocomplete="off">

                                </div>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </report-modal>
    </div>


    <!-- BEGIN TAB PORTLET-->
    <div class="row">
        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i> 
                    <span class="caption-subject bold uppercase">  @lang('layout.MemberClothList')  </span>
                </div>
                <div class="tools"></div>
                <div class="pull-right">

                  <!--   <a href="{{route('note.graphicalshow')}}">
                        <button class="btn btn-success">@lang('layout.GraphicalPresintation')</button>
                    </a> -->
                    @permission('membercloth-export')
                    <span id="anchore-modal">
                     <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                        <i class="fa fa-print"></i>
                     </a>
                 </span>
                    @endpermission


                    @permission('membercloth-create')
                    <a href="{{route('memberCloth.create')}}">
                        <!-- <button id="sample_editable_1_new" class="btn green btn-sm btn-outline"> -->
                        <button id="sample_editable_1_new" class="btn btn-success">
                            <i class="fa fa-plus"></i> @lang('layout.AddNew')
                        </button>
                    </a>
                    @endpermission
                </div>


            </div>
            <div class="portlet-body">
                <template v-cloak id="company_all">
                    <company @company="setCompany"></company>
                </template>
                <table class="table table-striped table-bordered table-hover" id="memberCloth">
                    <thead>
                    <tr> 
                        <th>#</th>
                        <th>@lang('layout.Number')</th>
                        <th>@lang('layout.Member')</th>
                        <th>@lang('layout.Phone')</th>
                        <th>@lang('layout.Address')</th>
                        <th>@lang('menu.ClothCategory')</th>
                        <th>@lang('layout.Date')</th> 
                        <th>@lang('layout.OverdueDate')</th> 
                        <th>@lang('layout.User')</th> 
                        <th>@lang('layout.Description')</th>
                        <th>@lang('layout.Actions')</th>

                    </tr>
                    </thead>
                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>


    <!-- END TAB PORTLET-->
    <iframe id="payframe" style="display: none;"></iframe>
    <!-- END CONTENT BODY -->
@stop
@include('print.modal')
@include('groupCompanyFilter.select')
@push('scripts')

    <script>

        
function factorPrint(id) {

var a = document.createElement('a');
a.href = "{{url('memberClothFactorPrint')}}/" + id ;
a.target = "_blank";
document.body.appendChild(a);
a.click();
document.body.removeChild(a);

        // $.ajax({
        //         // This PHP file will generate the PDF and save it to your server
        //         // $pdf->Output('path/to/pdf/file.pdf', 'F');
        //         url: "{{url('/')}}/invoiceFactorPrint/"+id,
        //         type: 'get',
        //         cache: false,

        //     }).done(function () {

        //         var s = ' <object  data="' + '{{url('factor22.pdf')}}' + '" type="application/pdf" width="0" height="0"> </object>'

        //         $('#factor-obj').html(s);
           

        //         // $('#someDiv').html('<iframe src="path/to/pdf/file.pdf"></iframe>');
        //     })
        //         .fail(function () {
        //             console.log("error");
        //         });
}  

        let data_table;
        $(document).ready(function () {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
            data_table =$('#memberCloth').DataTable({
                ajax: '{{route("memberCloth.index")}}',
                pageLength: '{{getPageRows()}}',
                order: [["{{orderByColumn()=='number'?0:1}}", "{{getRowOrder()}}"]],
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                scrollCollapse: true,
                paging: true,
                serverSide: true,
                buttons: [{
                    extend: 'excel',
                    text: '',
                    key: {
                        key: 'x',
                        altkey: true
                    }
                }],
                columns: [
                    {data: 'DT_RowIndex', name: 'DT_RowIndex',orderable:false,searchable:false},
                    {data: 'number', name: 'member_cloths.number'},
                    {data: 'member_name', name: 'members.name'},
                    {data: 'phone', name: 'members.phone'},
                    {data: 'address1', name: 'member_informations.address1'},
                    {data: 'cloth_cat', name: 'cloth_categories.name'}, 
                    {data: 'Date', name: 'member_cloths.date'},
                    {data: 'overdue_date', name: 'member_cloths.overdue_date'},
                    {data: 'username', name: 'users.name', orderable: false, searchable: false},
                    {data: 'description', name: 'member_cloths.description'},
                    {data: 'actions', name: 'actions', orderable: false, searchable: false},


                ]
            });
        });


        var vm = new Vue({
            el: '#print-modal',
            data: {
                is_show: false,
                pdfRoute: '{!!route('export.PDFAll') !!}',
                excelRoute: '{!! route('export.ExcelAll') !!}',

            },
            methods: {
                closeModal: function () {
                    this.is_show = !this.is_show
                },
            }
        });


        new Vue({
            el: '#anchore-modal',
            methods: {
                showModal: function () {
                    console.log('trr')
                    vm.$data.is_show = true;

                }
            }
        });

        new Vue({
            el: '#company_all',
            methods: {
                setCompany: function (event) {
                    if (typeof data_table == 'object'){
                        data_table.clear();
                        data_table.ajax.reload();
                    }
                }
            }
        });


    </script>
@endpush