@extends('layouts.app')
<link href="{{url('css/custome-table.css')}}" rel="stylesheet" type="text/css">

@section('content')
    <div class="row">

        <div class="portlet light bg-inverse" style="min-height: 100%;">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>&nbsp;
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.MemberClothEdit') </span>
                    <!-- <span class="caption-helper">some info...</span> -->
                </div>
                <div class="tools">
                    
                </div>
            </div>
            <div id="app" class="portlet-body form" style="margin-bottom:50%;" v-cloak> 
                <!-- BEGIN FORM-->
                {!! Form::model($memberCloth, ['method' => 'PATCH','class'=>'form-horizontal','route' => ['memberCloth.update',$memberCloth->id]]) !!}
                {{ csrf_field() }}



                <div class="form-body">

                <div class="row">
                            <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                <div class="col-md-12">
                                    <label class="control-label ">@lang('layout.SelectMember')</label>
                                    <v-select 
                                                label="name" 
                                                :options="customer"
                                                v-model="selected_customer"
                                                >
                                            </v-select>
                                            <input type="hidden" name="customer_id"
                                            :value="!selected_customer?null:selected_customer.id">
                                </div>
                            </div> 

                            <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                    <label class="control-label ">@lang('menu.ClothCategory')</label>
                                    <v-select 
                                        label="name" 
                                        :options="clothCategory"
                                        v-model="selected_cloth_category"
                                        @input="clothCategoryChange()"
                                        >
                                    </v-select>
                                            <input type="hidden" name="cloth_cat_id"
                                            :value="!selected_cloth_category?null:selected_cloth_category.id" >
                            </div>
                            <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12">
                                    <div class="col-md-12">
                                    <label class="control-label">@lang('layout.Description')</label>
                                    <textarea name="description" class="form-control" placeholder="@lang('layout.Description')">{{$memberCloth->description}}</textarea>
                                    </div>
                                </div>
                            </div>
                            <div class="row">

                                <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                    <div class="col-md-12">
                                    <label class="control-label">@lang('layout.Number')</label>
                                    <input type="number" name="number" class="form-control" value="{{$memberCloth->number}}" step="any" min="0" autocomplete="off">
                                    </div>
                                </div>
                                
                                <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                    <div class="col-md-12">
                                    <label class="control-label">@lang('layout.Date')</label>
                                    <input type="text" name="date" class="form-control date" value="{{$memberCloth->Date}}" autocomplete="off">
                                    </div>
                                </div>
                                <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                    <div class="col-md-12">
                                    <label class="control-label">@lang('layout.OverdueDate')</label>
                                    <input type="text" name="overdue_date" class="form-control date" value="{{$memberCloth->overdue_date}}" autocomplete="off">
                                    </div>
                                </div>
                                


                            </div>



                    
                <br>
                <table id="table_content" class="table table-bordered">
                    <thead>
                    <tr>
                        <th>#</th>
                        <!-- <th style="min-width: 300px">@lang('menu.ClothCategory') </th> -->

                        <th>@lang('menu.ClothProperty') <span class="required"> * </span></th>
                        <th>@lang('layout.ClothSize') / @lang('layout.ClothStyle') <span class="required"> * </span></th>
                        <th>@lang('layout.Description') </th>
                        <th></th>

                    </tr>
                    </thead>
                    <tbody>
                    <tr v-for="(item,index) in clothProperty">
                        <td><span class="badge badge3 badge-success badge-roundless"> @{{index+1}}</span></td>
                        <!-- <td class="highlight">


                        <v-select label="name" v-model="item.clothCategory" :options="clothCategory" @Click.native="clothCategoryChange(index)" @input="clothCategoryChange(index)"></v-select>
                                        <input type="hidden" :name="'cloth_category_id['+index+']'" :value="(!item.clothCategory)?null:item.clothCategory.id">

                        </td> -->
                        <td class="highlight">


                        <!-- <v-select label="name" v-model="item.clothProperty" :options="clothProperty" ></v-select>
                        <input type="hidden" :name="'cloth_property_id['+index+']'"  :value="(!item.clothProperty)?null:item.clothProperty.id"> -->

                        <input type="hidden" :name="'cloth_property_id['+index+']'"  :value="(!item.id)?null:item.id">
                        <input type="text"   :value="(!item.name)?null:item.name" class="form-control" readonly>

                        </td> 
                        
                        <td class="highlight">
                            <!-- <input type="text" @keyup="addNew(index)" v-on:click="addNew(index)"
                                    :name="'size['+index+']'" class="form-control" autocomplete="off" v-model = "(!item)?null:item.size" > -->
                                    <input type="text"
                                    :name="'size['+index+']'" class="form-control" autocomplete="off" :value="(!item.size)?null:item.size">
                        </td>
                        <td class="highlight">

                            <!-- <textarea :name="'detail_description['+index+']'" class="form-control" placeholder="@lang('layout.Description')" v-model = "(!item)?null:item.detail_description"></textarea> -->
                            <textarea :name="'detail_description['+index+']'" class="form-control" placeholder="@lang('layout.Description')" :value="(!item.description)?null:item.description"></textarea>
                        </td>

                        
                        <td>
                            <span @click="deleteItem(index)"><i
                                        class="paddint-both glyphicon glyphicon-trash" style="color: red;"></i></span>
                        </td>

                    </tr>
                    

                    </tbody>
                </table>
                <table id="table_content" class="table table-bordered" >
                    <thead>
                    <tr>
                        <th>#</th>
                        <th>@lang('menu.ClothProperty') <span class="required"> * </span></th>
                        <th>@lang('layout.ClothStyle') <span class="required"> * </span></th>


                    </tr>
                    </thead>
                    <tbody>
                    <tr v-for="(item,index) in clothStyle">
                        <td><span class="badge badge3 badge-success badge-roundless"> @{{index+1}}</span></td>
                        
                        <td class="highlight">
                        <input type="hidden" :name="'cloth_style_id['+index+']'"  :value="(!item.id)?null:item.id" >
                        <input type="text"   :value="(!item.name)?null:item.name" class="form-control">

                        
                        

                        </td> 
                        
                        <td class="highlight">
                                    
                            <v-select label="name" v-model="item.styleDetail" :options="item.clothStyleDetail" ></v-select>
                            <input type="hidden" :name="'cloth_style_detail['+index+']'"  :value="(!item.styleDetail)?null:item.styleDetail.id" >
                        </td>


                    </tr>

                    </tbody>
                </table>
                </div>
                <div class="col-md-4 col-md-offset-4 text-center">
                    <br>
                    <button type="button" class="btn green" onclick="regForm(this)">@lang('layout.Submit')</button>
                    <a href="{{route('memberCloth.index')}}" class="btn default"><i
                                class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                </div>
                {!! Form::close() !!}

            </div>

            <!-- END FORM-->
        </div>
    </div>

@endsection
@push('scripts')
    <script type="text/javascript">
        Vue.component('v-select', VueSelect.VueSelect);
        let memberClothDetail      = {!! $memberClothDetail !!}
        var customer               = {!! $customer !!}
        var selected_customer      = {!! $selected_customer !!}

        var clothCategory            = {!! $clothCategory !!}
        var selected_cloth_category  = {!! $selected_cloth_category !!}


        var clothProperty          = {!! $clothProperty !!}



        var memberClothStyle          = {!! $memberClothStyle !!}
        var selected_style             = {!! $selected_style !!}


        let v = new Vue({
            el: '#app',
            data: {

                member_cloth: [],
                memberClothDetail: memberClothDetail,
                selected_customer:selected_customer,
                customer:customer,

                selected_cloth_category:selected_cloth_category,
                clothCategory:clothCategory,

                selected_cloth_property:null,
                clothProperty:[],
                selected_index: 0,
                check_data:false,

                clothStyle:[],
                clothStyleDetail:[],
                memberClothStyle:memberClothStyle,
                selected_style:selected_style
            },
     

            mounted: function () {
                console.log('ddd',this.memberClothDetail)
                for (var i = 0; i < this.memberClothDetail.length; i++) {
                    this.clothProperty.push({
                        id: this.memberClothDetail[i].property_id,
                        name: this.memberClothDetail[i].property_name,
                        size: this.memberClothDetail[i].size,
                        description: this.memberClothDetail[i].description,

                    });
                } 
                for (var i = 0; i < this.memberClothStyle.length; i++) {

                    this.clothStyle.push({
                        id:       this.memberClothStyle[i].id,
                        name:     this.memberClothStyle[i].name,
                        clothStyleDetail: this.memberClothStyle[i].clothStyleDetail,
                        styleDetail:this.memberClothStyle[i].selected_style_detail


                    });

                }
            
            },

            methods: {
                setIndex(e) {
                this.selected_index = e;
            },

             

                clothCategoryChange(index) {
                    v.setIndex(index);

                    if(this.check_data!=false)
                    {
                        if (this.selected_cloth_category != null) {
                        // v.selected_cloth_category = this.member_cloth[index]['clothCategory'];
                        let cloth_category_id = this.selected_cloth_category.id;
                        axios.get("{{route('callMethod.search')}}", {
                                params: {
                                    method_name: 'clothPropertiesSearch',
                                    cloth_category_id: cloth_category_id
                                }
                            })
                            .then(function(response) {
                                v.clothProperty = [];
                                if (response.data.item.length > 0) {
                                    v.clothProperty = response.data.item;
                                    console.log('Ressss',response)
                                }
                                v.clothStyle = [];
                                
                                if (response.data.item2.length > 0) {
                                    v.clothStyle = response.data.item2;
                                    console.log('Ressss',response) 
                                }
                            })
                            .catch(function(error) {
                                console.log(error);
                            });
                    }
                    }

                    this.check_data=true
                   

                },


                addNew(index) {
                    if (this.member_cloth[index + 1] == undefined) {
                        this.member_cloth.push({clothCategory:null,clothProperty:null,size:null,detail_description:null});
                    }

                },

                deleteItem(index) {
                    this.clothProperty.splice(index, 1);
                },
            }
        })

    </script>

@endpush
 