@extends('layouts.app')
<link href="{{url('css/custome-table.css')}}" rel="stylesheet" type="text/css">

@section('content')
@include("layouts.Cmodal")
    <div class="row">

        <div class="portlet light bg-inverse" style="min-height: 100%;">
            <div class="portlet-title">
           

                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i> &nbsp;
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.MemberClothCreate') </span>
                    <!-- <span class="caption-helper">some info...</span> -->
                </div>
                <div class="tools">

                   
                    
                </div>

              


            </div>
            <div id="app" v-cloak class="portlet-body form" style="margin-bottom:50%;">
                <!-- BEGIN FORM-->
                {!! Form::open(array('route' => 'memberCloth.store','method'=>'POST','class'=>'form-horizontal','id'=>'memberCloth-submit')) !!}
                {{ csrf_field() }}
                <div class="form-body">
                                <div class="row">
                                            <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                                    <label class="control-label ">@lang('layout.SelectMember')</label>
                                                    <div class="input-group">
                                                    <v-select 
                                                        label="name" 
                                                        :options="customer"
                                                        v-model="selected_customer"
                                                        >
                                                    </v-select>
                                                            <input type="hidden" name="customer_id"
                                                            :value="!selected_customer?null:selected_customer.id"
                                                            v-validate="'required'" data-vv-as="@lang('menu.ClothCategory')">
                                                    <span class="required">@{{ errors.first('customer_id') }}</span>
                                                            <span class="btn  btn-success input-group-addon " @click="showModal = true" style="background-color:  rgb(84, 199, 211)">
                                                                <i class="fa fa-plus" style="color: white"></i>
                                                            </span>
                                                    </div>

                                            </div>  
                                            
                                            <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                                    <label class="control-label ">@lang('menu.ClothCategory')</label>
                                                    <v-select 
                                                        label="name" 
                                                        :options="clothCategory"
                                                        v-model="selected_cloth_category"
                                                        @input="clothCategoryChange()"
                                                        >
                                                    </v-select>
                                                            <input type="hidden" name="cloth_cat_id"
                                                            :value="!selected_cloth_category?null:selected_cloth_category.id"
                                                            v-validate="'required'" data-vv-as="@lang('menu.ClothCategory')">
                                                    <span class="required">@{{ errors.first('cloth_cat_id') }}</span>
                                            </div> 
                                          
                                            <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12">
                                                <div class="col-md-12">
                                                <label class="control-label">@lang('layout.Description')</label>
                                                <textarea name="description" class="form-control" placeholder="@lang('layout.Description')"></textarea>
                                                </div>
                                            </div> 
                  
                                    </div>
                                    <div class="row">
                                    <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                                <div class="col-md-12">
                                                <label class="control-label">@lang('layout.Number')</label>
                                                <input type="number" name="number" class="form-control" value="{{$number}}" step="any" min="0" autocomplete="off">
                                                </div>
                                            </div>
                                        <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                                <div class="col-md-12">
                                                <label class="control-label">@lang('layout.Date')</label>
                                                <input type="text" name="date" class="form-control date" autocomplete="off">
                                                </div>
                                            </div>
                                        <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                                <div class="col-md-12">
                                                <label class="control-label">@lang('layout.OverdueDate')</label>
                                                <input type="text" name="overdue_date" class="form-control date" autocomplete="off">
                                                </div>
                                            </div> 

                                            <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                                        <div class="col-md-12 form-group">
                                                            <label class=" control-label">@lang('layout.Invoice')</label>
                                                            <div class="col-md-12 mt-checkbox" >
                                                                <label class="mt-checkbox mt-checkbox-outline">
                                                                    <input type="checkbox" name="back_to_invoice" value="yes">
                                                                    <span></span>
                                                                </label>
                                                            </div>
                                                        </div>
                                                    </div>

                                            
                                    </div>
                                <br>

                                    <table id="table_content" class="table table-bordered" v-if="clothProperty.length>0">
                                        <thead>
                                        <tr>
                                            <th>#</th>
                                            <!-- <th style="min-width: 300px">@lang('menu.ClothCategory') </th> -->

                                            <th>@lang('menu.ClothProperty') <span class="required"> * </span></th>
                                            <th>@lang('layout.ClothSize')  <span class="required"> * </span></th>
                                            <th>@lang('layout.Description') </th>

                                            <!-- <th></th> -->

                                        </tr>
                                        </thead>
                                        <tbody>
                                        <tr v-for="(item,index) in clothProperty">
                                            <td><span class="badge badge3 badge-success badge-roundless"> @{{index+1}}</span></td>
                                            <!-- <td><span class="badge badge3 badge-success badge-roundless"> @{{item.id}}</span></td> -->
                                            <!-- <td class="highlight">


                                            <v-select label="name" v-model="item.clothCategory" :options="clothCategory" @Click.native="clothCategoryChange(index)" @input="clothCategoryChange(index)"></v-select>
                                                            <input type="hidden" :name="'cloth_category_id['+index+']'" :value="(!item.clothCategory)?null:item.clothCategory.id">

                                            </td> -->
                                            <td class="highlight">


                                            <!-- <v-select label="name" v-model="item.clothProperty" :options="clothProperty" ></v-select>
                                            <input type="hidden" :name="'cloth_property_id['+index+']'"  :value="(!item.clothProperty)?null:item.clothProperty.id"> -->
                                            <input type="hidden" :name="'cloth_property_id['+index+']'"  :value="(!item.name)?null:item.id">
                                            <input type="text"   :value="(!item.name)?null:item.name" class="form-control" readonly>
                                            

                                            </td> 
                                            
                                            <td class="highlight">
                                                <!-- <input type="text" @keyup="addNew(index)" v-on:click="addNew(index)"
                                                       :name="'size['+index+']'" class="form-control" autocomplete="off" > -->
                                                       
                                                       <input type="text"
                                                       :name="'size['+index+']'" class="form-control" autocomplete="off" >
                                            </td>
                                            <td class="highlight">

                                                <textarea :name="'detail_description['+index+']'" class="form-control" placeholder="@lang('layout.Description')"></textarea>
                                            </td>

                                         
                                            <!-- <td>
                                                <span v-on:click="deleteItem(index)"><i
                                                            class="paddint-both glyphicon glyphicon-trash" style="color: red;"></i></span>
                                            </td> -->

                                        </tr>
                                        <!-- <tr style="background-color: rgb(255, 255, 255);">
                                            <td>
                                                <center>
                                                    <button type="button" class="btn btn-success" @click="addNew('index')">
                                                        <i class="fa fa-plus" ></i>
                                                       </button>
                                                   </center>
                                               </td> 
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                        </tr> -->

                                        </tbody>
                                    </table>   
                                    
                                    <table id="table_content" class="table table-bordered" v-if="clothStyle.length>0">
                                        <thead>
                                        <tr>
                                            <th>#</th>
                                            <!-- <th style="min-width: 300px">@lang('menu.ClothCategory') </th> -->

                                            <th>@lang('menu.ClothProperty') <span class="required"> * </span></th>
                                            <th>@lang('layout.ClothStyle') <span class="required"> * </span></th>

                                            <!-- <th></th> -->

                                        </tr>
                                        </thead>
                                        <tbody>
                                        <tr v-for="(item,index) in clothStyle">
                                            <td><span class="badge badge3 badge-success badge-roundless"> @{{index+1}}</span></td>
                                            <!-- <td><span class="badge badge3 badge-success badge-roundless"> @{{item.id}}</span></td> -->
                                            <!-- <td class="highlight">


                                            <v-select label="name" v-model="item.clothCategory" :options="clothCategory" @Click.native="clothCategoryChange(index)" @input="clothCategoryChange(index)"></v-select>
                                                            <input type="hidden" :name="'cloth_category_id['+index+']'" :value="(!item.clothCategory)?null:item.clothCategory.id">

                                            </td> -->
                                            <td class="highlight">


                                            <!-- <v-select label="name" v-model="item.clothProperty" :options="clothProperty" ></v-select>
                                            <input type="hidden" :name="'cloth_property_id['+index+']'"  :value="(!item.clothProperty)?null:item.clothProperty.id"> -->
                                            <input type="hidden" :name="'cloth_style_id['+index+']'"  :value="(!item.id)?null:item.id" >
                                            <input type="text"   :value="(!item.name)?null:item.name" class="form-control">

                                            
                                            

                                            </td> 
                                            
                                            <td class="highlight">
                                                       
                                                <v-select label="name" v-model="item.styleDetail" :options="item.clothStyleDetail" ></v-select>
                                                <input type="hidden" :name="'cloth_style_detail['+index+']'"  :value="(!item.styleDetail)?null:item.styleDetail.id" >
                                                
                                                <!-- <v-select label="name" v-model="item.styleDetail" :options="clothStyleDetail" ></v-select>
                                                <input type="hidden" :name="'cloth_style_detail['+index+']'"  :value="(!item.styleDetail)?null:item.styleDetail.name" > -->
                                            </td>

                                         
                                            <!-- <td>
                                                <span v-on:click="deleteItem(index)"><i
                                                            class="paddint-both glyphicon glyphicon-trash" style="color: red;"></i></span>
                                            </td> -->

                                        </tr>
                                        <!-- <tr style="background-color: rgb(255, 255, 255);">
                                            <td>
                                                <center>
                                                    <button type="button" class="btn btn-success" @click="addNew('index')">
                                                        <i class="fa fa-plus" ></i>
                                                       </button>
                                                   </center>
                                               </td> 
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                        </tr> -->

                                        </tbody>
                                    </table> 

                                   

                </div>
                
                <div class="col-md-4 col-md-offset-4 text-center">
                    <br>
                    <button type="button" @click="handleSubmit($event)" class="btn green" >@lang('layout.Submit')</button>
                    <button type="button" class="btn blue"
                                    @click="saveAndNew($event)">@lang('layout.SaveAndNew')</button>
                    <a href="{{route('memberCloth.index')}}" class="btn default"><i
                                class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                </div>

                <cmodal :show='showModal' @close="showModal=false">

                </cmodal>

                {!! Form::close() !!}

            </div>

            <!-- END FORM-->
        </div>
    </div>

@endsection
@push('scripts')
    <script type="text/javascript">
        @if(App::getLocale())
    Vue.use(VeeValidate, {
        locale: '{{App::getLocale()}}',
    });
    @else
        Vue.use(VeeValidate, {
            locale: 'en',
        });
        @endif

        Vue.component('v-select', VueSelect.VueSelect);

        Vue.component("cmodal", {
        template: '#cmodal-template',

        props: ['show'],
        data() {
            return {
                types: [],
                receivables: [],
                payables: [],
                code: null,
                selectType: null,
                selectPay: null,
                selectReceive: null,
                classes: [],
                selectedClass: null,

            }
        },
        created() {

            axios.get('{{route("customer.create")}}').then(
                response => {
                    this.types = response.data.types; 
                    if (this.types) {
                        for (var i = 0; i < this.types.length; i++) {
                            if (this.types[i].type == "Customer") {
                                this.selectType = this.types[i];
                            }
                        }
                    }
                    this.receivables = response.data.receivable;
                    this.payables = response.data.payable;
                    this.code = response.data.code;
                    this.classes = response.data.member_class;
                    if (this.receivables.length > 0) {
                        this.selectReceive = this.receivables[0];
                    }
                    if (this.payables.length > 0) {
                        this.selectPay = this.payables[0];
                    }

                }).catch(error => console.log(error));
        },
        methods: {
            onSubmit() {

                v.showModal = false;
                var datas = $("#modalForm").serializeArray();
                $.ajax({
                    headers: {
                        'X-CSRF-TOKEN': "{{csrf_token()}}"
                    },
                    url: '{{route("customer.store")}}',
                    method: 'post',
                    data: {
                        "name": datas[0]['value'],
                        'code': datas[1]['value'],
                        'email': datas[2]['value'],
                        'phone': datas[3]['value'],
                        'address1': datas[4]['value'],
                        'type': this.selectType.id,
                        'receivable': this.selectReceive.id,
                        'payable': this.selectPay.id,
                        'class': (this.selectedClass) ? this.selectedClass.id : null

                    },
                    dataType: 'json',

                }).done(function(response) {
                    var customer_id = 0;
                    if (response) {
                        customer_id = response.customer_id;
                    }
                    axios.get('{{route("invoice.create")}}').then(response => {

                        v.customer = response.data.customer;
                        document.getElementById("modalForm").reset();
                        v.selected_customer=_.find(v.customer,(v)=>v.id==customer_id);

                    }).catch(error => console.log(error));

                }).fail(function(error) {
                    console.log('error', error);
                });

            }
        }
    });


 
        var clothCategory = {!! $clothCategory !!}
        var customer      = {!! $customer !!}



        let v = new Vue({
            el: '#app',
            data: {
                member_cloth:
                    [
                        {clothCategory:null,clothProperty:null,size:null,detail_description:null}

                    ],
                    selected_cloth_category:null,
                    clothCategory:clothCategory,

                    selected_cloth_property:null,
                    clothProperty:[],
                    clothStyle:[],
                    clothStyleDetail:[],

                    selected_customer:null,
                    customer:customer,
                    
                    selected_index: 0,
                    showModal: false
            },
            methods: {
                handleSubmit(e) {
                    this.$validator.validate().then(valid => {
                        if (valid) {
                            // alert(e.target);
                            regForm(e.target);
                        }
                    });
                },

                setIndex(e) {
                this.selected_index = e;
            },

                // clothCategoryChange(index) {
                //     v.setIndex(index);

                //     if (this.member_cloth[index]['clothCategory'] != null) {
                //         v.selected_cloth_category = this.member_cloth[index]['clothCategory'];
                //         let cloth_category_id = this.member_cloth[index]['clothCategory'].id;
                //         axios.get("{{route('callMethod.search')}}", {
                //                 params: {
                //                     method_name: 'clothPropertiesSearch',
                //                     cloth_category_id: cloth_category_id
                //                 }
                //             })
                //             .then(function(response) {
                //                 v.clothProperty = [];
                //                 if (response.data.length > 0) {
                //                     v.clothProperty = response.data;
                //                 }
                //             })
                //             .catch(function(error) {
                //                 console.log(error);
                //             });
                //     }

                // },

                clothStyleDetails(index) {
                    v.setIndex(index);

                    if (this.selected_cloth_category != null) {
                        let cloth_style_id = this.clothStyle[index].id;
                        // console.log('ffffff',cloth_style_id,this.clothStyle[index].name)
                        axios.get("{{route('callMethod.search')}}", {
                                params: {
                                    method_name: 'clothStyleDeatilSearch',
                                    cloth_style_id: cloth_style_id
                                }
                            })
                            .then(function(response) {
                                v.clothStyleDetail = [];
                                if (response.data.item.length > 0) {
                                    v.clothStyleDetail = response.data.item;
                                    console.log('Ressss',v.clothStyleDetail) 
                                }
                            })
                            .catch(function(error) {
                                console.log(error);
                            });
                    }

                },                
                
                clothCategoryChange(index) {
                    v.setIndex(index);

                    if (this.selected_cloth_category != null) {
                        // v.selected_cloth_category = this.member_cloth[index]['clothCategory'];
                        let cloth_category_id = this.selected_cloth_category.id;
                        axios.get("{{route('callMethod.search')}}", {
                                params: {
                                    method_name: 'clothPropertiesSearch',
                                    cloth_category_id: cloth_category_id
                                }
                            })
                            .then(function(response) {
                                v.clothProperty = [];
                                if (response.data.item.length > 0) {
                                    v.clothProperty = response.data.item;
                                    console.log('Ressss',response) 
                                }
                                v.clothStyle = [];
                                
                                if (response.data.item2.length > 0) {
                                    v.clothStyle = response.data.item2;
                                    console.log('Ressss',response) 
                                }
                            })
                            .catch(function(error) {
                                console.log(error);
                            });
                    }

                },
                saveAndNew() {
                    this.$validator.validate()
                        .then(valid => {
                            if (valid) {

                                var url = "{{route('memberCloth.store')}}";
                                form_id = 'memberCloth-submit';
                                var data = $('#' + form_id).serialize();
                                toggleBlock(true);
                                axios.post(url, data)
                                    .then(function (response) {
                                        toggleBlock(0);
                                        if (response.data.result == 1) {
                                            $('#' + form_id).trigger('reset');
                                            toastr.success('', response.data.message);
                                            location.reload();
                                        }
                                        else {
                                            var message = "{{__('message.Warning')}}";
                                            //$('#error-sound')[0].play();
                                            toastr.warning('', message); 
                                        }
                                    })
                                    .catch(function (error) {
                                        toggleBlock(0);
                                        var message = "{{__('message.Warning')}}";
                                        //$('#error-sound')[0].play();
                                        toastr.warning('', message);
                                    });

                            }
                        })
                },

                addNew(index) {
                    console.log('ssss',v.selected_cloth_category)
                    if (this.member_cloth[index + 1] == undefined) {
                        this.member_cloth.push({clothCategory:v.selected_cloth_category,clothProperty:null,size:null,detail_description:null});
                    }

                },

                deleteItem(index) {
                    console.log('indddd',index)
                    this.clothProperty.splice(index, 1);
                }
            }
        })
    </script>

@endpush
 