@extends('layouts.app')
@section('content')

<!-- END PAGE HEADER-->

<!-- BEGIN TAB PORTLET--> 
<div class="row"> 
    <div class="portlet light bordered">
        <div class="portlet-title">
            <div class="caption font-dark">
                <i class="icon-settings font-dark"></i>
                <span class="caption-subject bold uppercase">@lang('layout.MemberTypeList') </span>
            </div>
             <div class="btn-group pull-right">
                    <a href="{{route('memberType.create')}}">
                        <button class="btn btn-success">
                            <i class="fa fa-plus"></i> @lang('layout.AddNew')
                    </button></a> 
            </div>
        </div>
        <div class="portlet-body">
            <table class="table table-striped table-bordered table-hover" cellspacing="1" id="memberType" width="100%">
                <thead>
                <tr> 
                   {{-- <th>@lang('layout.ID') </th>--}}
                    <th>@lang('layout.Type') </th>
                    <th>@lang('layout.CreatedAt') </th>
                    <th>@lang('layout.UpdatedAt') </th>
                    <th>@lang('layout.Actions') </th>
                </tr>
                </thead> 
            </table>
        </div>
    </div>
</div> 
@stop
@push('scripts')
<script>
     $(document).ready(function() { 
        $('#memberType').DataTable( {
            ajax:           '{{route("memberType.index")}}',
            serverSide: true,
            paging:         true,
            columns: [
          /*  { data: 'id', name: 'id' },*/
            { data: 'type', name: 'type' },
            { data: 'created_at', name: 'created_at' },
            { data: 'updated_at', name: 'updated_at' },
            { data: 'action', name: 'action' },
            ] 
    }); 
    });
</script>

@endpush
