@extends('layouts.app')
@section('style')
<style type="text/css">
    /* Cubic Bezier Transition */
    /***
        Pricing Table 1
        ***/
    .pricing-content-1 {
        background-color: #fff;
    }
    .pricing-content-1:before,
    .pricing-content-1:after {
        content: " ";
        display: table;
    }
    .pricing-content-1:after {
        clear: both;
    }
    .pricing-content-1 .arrow-down {
        width: 0;
        height: 0;
        border-left: 15px solid transparent;
        border-right: 15px solid transparent;
        border-top: 15px solid;
        margin: auto;
    }
    .pricing-content-1 .arrow-down.arrow-blue {
        border-top-color: #3598DC;
    }
    .pricing-content-1 .arrow-down.arrow-green {
        border-top-color: #32C5D2;
    }
    .pricing-content-1 .arrow-down.arrow-dark {
        border-top-color: #2F353B;
    }
    .pricing-content-1 .arrow-down.arrow-grey {
        border-top-color: #f7f9fb;
    }
    .pricing-content-1 .price-ribbon {
        position: absolute;
        top: 75px;
        right: -4px;
        width: 90px;
        font-size: 14px;
        text-transform: uppercase;
        font-weight: 300;
        padding: 6px 20px 6px 15px;
        color: #fff;
        background-color: #D91E18;
        text-shadow: 0px 1px 2px #bbb;
        -webkit-box-shadow: 0px 2px 4px #888;
        -moz-box-shadow: 0px 2px 4px #888;
        box-shadow: 0px 2px 4px #888;
    }
    .pricing-content-1 .price-ribbon:after {
        content: ' ';
        position: absolute;
        width: 0;
        height: 0;
        right: 0px;
        top: 100%;
        border-width: 5px 10px;
        border-style: solid;
        border-color: #64120f transparent transparent #64120f;
    }
    .pricing-content-1 .pricing-title {
        border-bottom: 1px solid;
        border-color: #fff;
    }
    .pricing-content-1 .pricing-title>h1 {
        margin: 20px 0;
    }
    .pricing-content-1 .price-column-container {
        text-align: center;
        margin: 0;
        background-color: #fff;
    }
    .pricing-content-1 .price-column-container.border-active {
        border: 1px solid #e5e9ee;
    }
    .pricing-content-1 .price-column-container:first-child {
        margin-left: 0;
    }
    .pricing-content-1 .price-column-container:last-child {
        margin-right: 0;
    }
    .pricing-content-1 .price-table-head {
        color: #fff;
        padding: 20px 0;
    }
    .pricing-content-1 .price-table-head h2 {
        font-size: 26px;
    }
    .pricing-content-1 .price-table-head.price-1 {
        background-color: #3598DC;
    }
    .pricing-content-1 .price-table-head.price-2 {
        background-color: #32C5D2;
    }
    .pricing-content-1 .price-table-head.price-3 {
        background-color: #2F353B;
    }
    .pricing-content-1 .price-table-pricing>h3 {
        font-size: 60px;
        position: relative;
    }
    .pricing-content-1 .price-table-pricing>h3>.price-sign {
        font-size: 24px;
        position: absolute;
        margin-left: -15px;
    }
    .pricing-content-1 .price-table-pricing>p {
        margin-top: 0;
    }
    .pricing-content-1 .price-table-content {
        background-color: #f7f9fb;
        color: #5c6d7e;
        font-weight: 600;
        font-size: 16px;
    }
    .pricing-content-1 .price-table-content .row {
        padding-top: 10px;
        padding-bottom: 10px;
    }
    .pricing-content-1 .price-table-content .row i {
        color: #6cade6;
    }
    .pricing-content-1 .price-table-content .row:first-child {
        padding-top: 20px;
    }
    .pricing-content-1 .price-table-content .row:last-child {
        padding-bottom: 20px;
    }
    .pricing-content-1 .price-table-footer {
        padding: 20px 0;
    }
    .pricing-content-1 .price-table-footer>.price-button {
        font-weight: bold;
        padding: 10px 20px;
    }
    @media (max-width: 1024px) {
        .pricing-content-1 .mobile-padding {
            padding: 0;
            margin: 0;
        }
        .pricing-content-1 .mobile-padding>i {
            margin-right: 5px;
        }
        .pricing-content-1 .price-table-content {
            padding-left: 10px;
            padding-right: 10px;
        }
    }
    @media (max-width: 1024px) {
        .pricing-content-1 .mobile-padding {
            padding: 0 15px;
            margin: 0 -15px;
        }
        .pricing-content-1 .mobile-padding>i {
            margin-right: 20px;
        }
        .pricing-content-1 .price-table-content {
            padding-left: 15px;
            padding-right: 15px;
        }
    }
    /***
        Pricing Table 2
    ***/
    .pricing-content-2 {
        background-color: #fff;
    }
    .pricing-content-2 .no-padding {
        padding: 0;
    }
    .pricing-content-2 .text-left {
        text-align: left;
    }
    .pricing-content-2 .text-right {
        text-align: right;
    }
    .pricing-content-2.pricing-bg-dark {
        background-color: #2F353B;
    }
    .pricing-content-2 .pricing-title {
        border-color: #444;
    }
    .pricing-content-2 .pricing-title>h1 {
        color: #fff;
    }
    .pricing-content-2 .pricing-table-container {
        padding-top: 40px;
        padding-bottom: 40px;
    }
    .pricing-content-2 .pricing-table-container .padding-fix {
        padding-left: 15px;
        padding-right: 15px;
    }
    .pricing-content-2 .pricing-table-container .price-column-container {
        background-color: #fff;
        margin: 30px 0;
        padding: 60px 0;
        text-align: center;
        border-bottom: 4px solid #ccc;
    }
    .pricing-content-2 .pricing-table-container .price-column-container.border-right {
        border-right: 1px solid #ccc;
    }
    .pricing-content-2 .pricing-table-container .price-column-container.border-left {
        border-left: 1px solid #ccc;
    }
    .pricing-content-2 .pricing-table-container .price-column-container.border-top {
        border-top: 1px solid #ccc;
    }
    .pricing-content-2 .pricing-table-container .price-column-container.featured-price {
        margin: 0;
        padding: 89px 0;
        border: 1px solid;
        border-bottom: 4px solid;
        border-color: #ccc;
    }
    .pricing-content-2 .pricing-table-container .price-column-container.featured-price>.price-feature-label {
        position: absolute;
        top: 0;
        left: 50%;
        display: inline-block;
        width: 110px;
        margin: 0 0 0 -60px;
        padding: 7px 15px;
        color: #fff;
        font-weight: 300;
    }
    .pricing-content-2 .pricing-table-container .price-column-container>.price-table-head>h2 {
        letter-spacing: 1px;
        font-weight: 600;
        font-size: 18px;
        color: #ACB5C3;
    }
    .pricing-content-2 .pricing-table-container .price-column-container>.price-table-head>h2.opt-pricing-5 {
        padding: 7px 15px;
        display: inline;
        margin: 0 auto 20px auto;
        font-size: 16px;
    }
    .pricing-content-2 .pricing-table-container .price-column-container>.price-table-pricing>h3 {
        font-size: 60px;
        position: relative;
        font-weight: 600;
    }
    .pricing-content-2 .pricing-table-container .price-column-container>.price-table-pricing>h3>.price-sign {
        font-size: 24px;
        position: absolute;
        margin-left: -15px;
    }
    .pricing-content-2 .pricing-table-container .price-column-container>.price-table-pricing>p {
        margin-top: 0;
    }
    .pricing-content-2 .pricing-table-container .price-column-container>.price-table-content {
        color: #333;
        font-weight: 300;
        font-size: 16px;
    }
    .pricing-content-2 .pricing-table-container .price-column-container>.price-table-content .row {
        padding-top: 20px;
        padding-bottom: 20px;
        border-bottom: 1px solid;
        border-color: #eee;
    }
    .pricing-content-2 .pricing-table-container .price-column-container>.price-table-content .row:first-child {
        border-top: 1px solid;
        border-color: #eee;
    }
    .pricing-content-2 .pricing-table-container .price-column-container>.price-table-footer {
        padding: 40px 0 0 0;
    }
    .pricing-content-2 .pricing-table-container .price-column-container>.price-table-footer>.featured-price {
        font-size: 20px;
        font-weight: 300;
        border-bottom: 3px solid #3FABA4;
    }
    @media (max-width: 991px) {
        .pricing-content-2 .price-column-container {
            border-left: 1px solid;
            border-right: 1px solid;
            border-color: #ccc;
        }
    }
</style>
@stop
@section('content')
@include('receives.modal')
<!-- BEGIN CONTENT -->
<div id="print-modal">
    <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show" :value-type="'member_transfer_details'" @closed="closeModal">
        <div slot="body">
            <div class="row">
                <div class="form-group">
                </div>
            </div>
            <div class="row">
                <div class="form-group">
                    <input type="hidden" name="id" value="{{$memberTransfer->id}}" />
                </div>
            </div>
        </div>
    </report-modal>
</div>
<div class="row">
    @if (count($errors) > 0)
    <div class="m-heading-1 border-red m-bordered errors-action">
        <h4 class="error-title"><strong>Whoops!</strong> There were some problems with your input</h4>
        <ul class="error-body">
            @foreach ($errors->all() as $error)
            <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
    @endif
    <div class="portlet light bg-inverse">
        <div class="portlet-title">
            <div class="caption">
                <i class="icon-equalizer font-green-haze"></i>
                <span class="caption-subject font-green-haze bold uppercase">@lang('layout.TransferInformation')</span>
            </div>
        </div>
        <div class="portlet-body form" id="item-service" style="margin-bottom:50%;">
            <div class="caption" align="center">
                <span class="caption-subject font-green-sharp bold uppercase" style="font-size: 1.9em;">@lang('layout.MemberTransfer')</span>
            </div>
            <br><br>
            <div class="pull-right">
                <span id="anchore-modal">
                    <a href="#" @click.prevent="showModal" id="" class="btn  btn-danger">
                        <i class="fa fa-print"></i>
                    </a>
                </span>
            </div>
            <div class="portlet light portlet-fit">
                <div class="portlet-body">
                    <div class="pricing-content-1">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="price-column-container border-active">
                                    <div class="price-table-head bg-dark">
                                        <h2 class="no-margin">@lang('layout.FromMember')</span></h2>
                                    </div>
                                    <div class="arrow-down"></div>
                                    <div class="price-table-pricing">
                                        <h4>
                                            <span>{{$memberTransfer->from_member_name}}</span>
                                        </h4>
                                    </div>
                                    <div class="price-table-content">
                                        <div class="row mobile-padding">
                                            <div class="col-md-4 col-xs-3 text-right mobile-padding">
                                                <i><b> @lang('layout.Currency'):</b><br></i>
                                            </div>
                                            <div class="col-md-8 col-xs-9 text-left mobile-padding">
                                                <p>{{$memberTransfer->currency}}</p>
                                            </div>
                                            <div class="row mobile-padding">
                                                <div class="col-md-4 col-xs-3 text-right mobile-padding">
                                                    <i><b> @lang('layout.Receivable'):</b><br></i>
                                                </div>
                                                <div class="col-md-8 col-xs-9 text-left mobile-padding">
                                                    <p>{{myRound($memberTransfer->receivable)}}</p>
                                                </div>
                                            </div>
                                            <div class="row mobile-padding">
                                                <div class="col-md-4 col-xs-3 text-right mobile-padding">
                                                    <i><b> @lang('layout.Rate'):</b><br></i>
                                                </div>
                                                <div class="col-md-8 col-xs-9 text-left mobile-padding">
                                                    <p>{{myRound($memberTransfer->rate)}}</p>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row mobile-padding">
                                            <div class="col-md-4 col-xs-3 text-right mobile-padding">
                                                <i><b> @lang('layout.Payable'):</b><br></i>
                                            </div>
                                            <div class="col-md-8 col-xs-9 text-left mobile-padding">
                                                <p>{{myRound($memberTransfer->payable)}}</p>
                                            </div>
                                        </div>
                                        <div class="row mobile-padding">
                                            <div class="col-md-4 col-xs-3 text-right mobile-padding">
                                                <i><b> @lang('layout.Date'):</b><br></i>
                                            </div>
                                            <div class="col-md-8 col-xs-9 text-left mobile-padding">
                                                <p>{{convertDate($memberTransfer->date)}}</p>
                                            </div>
                                        </div>
                                        <div class="row mobile-padding">
                                            <div class="col-md-4 col-xs-3 text-right mobile-padding">
                                                <i><b> @lang('layout.Description'):</b><br></i>
                                            </div>
                                            <div class="col-md-8 col-xs-9 text-left mobile-padding">
                                                <p>{{$memberTransfer->description}}</p>
                                            </div>
                                        </div>
                                        <div class="row mobile-padding">
                                            <div class="col-md-4 col-xs-3 text-right mobile-padding">
                                                <i><b> @lang('layout.MonetarySource'):</b><br></i>
                                            </div>
                                            <div class="col-md-8 col-xs-9 text-left mobile-padding">
                                                <p>{{$memberTransfer->monetary_source}}</p>
                                            </div>
                                        </div>
                                        <div class="row mobile-padding">
                                            <div class="col-md-4 col-xs-3 text-right mobile-padding">
                                                <i><b> @lang('layout.TransactionType'):</b><br></i>
                                            </div>
                                            <div class="col-md-8 col-xs-9 text-left mobile-padding">
                                                <p>{{$memberTransfer->trans_type}}</p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="arrow-down arrow-grey"></div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="price-column-container border-active">
                                    <div class="price-table-head bg-dark">
                                        <h2 class="no-margin">@lang('layout.ToMember')</span></h2>
                                    </div>
                                    <div class="arrow-down"></div>
                                    <div class="price-table-pricing">
                                        <h4>
                                            <span>{{$memberTransfer->to_member_name}}</span>
                                        </h4>
                                    </div>
                                    <div class="price-table-content">
                                        <div class="row mobile-padding">
                                            <div class="col-md-4 col-xs-3 text-right mobile-padding">
                                                <i><b> @lang('layout.Currency'):</b><br></i>
                                            </div>
                                            <div class="col-md-8 col-xs-9 text-left mobile-padding">
                                                <p>{{$memberTransfer->currency2}}</p>
                                            </div>
                                            <div class="row mobile-padding">
                                                <div class="col-md-4 col-xs-3 text-right mobile-padding">
                                                    <i><b> @lang('layout.Receivable'):</b><br></i>
                                                </div>
                                                <div class="col-md-8 col-xs-9 text-left mobile-padding">
                                                    <p>{{myRound($memberTransfer->receivable2)}}</p>
                                                </div>
                                            </div>
                                            <div class="row mobile-padding">
                                                <div class="col-md-4 col-xs-3 text-right mobile-padding">
                                                    <i><b> @lang('layout.Rate'):</b><br></i>
                                                </div>
                                                <div class="col-md-8 col-xs-9 text-left mobile-padding">
                                                    <p>{{myRound($memberTransfer->rate2)}}</p>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row mobile-padding">
                                            <div class="col-md-4 col-xs-3 text-right mobile-padding">
                                                <i><b> @lang('layout.Payable'):</b><br></i>
                                            </div>
                                            <div class="col-md-8 col-xs-9 text-left mobile-padding">
                                                <p>{{myRound($memberTransfer->payable2)}}</p>
                                            </div>
                                        </div>
                                        <div class="row mobile-padding">
                                            <div class="col-md-4 col-xs-3 text-right mobile-padding">
                                                <i><b> @lang('layout.Date'):</b><br></i>
                                            </div>
                                            <div class="col-md-8 col-xs-9 text-left mobile-padding">
                                                <p>{{convertDate($memberTransfer->date)}}</p>
                                            </div>
                                        </div>
                                        <div class="row mobile-padding">
                                            <div class="col-md-4 col-xs-3 text-right mobile-padding">
                                                <i><b> @lang('layout.Description'):</b><br></i>
                                            </div>
                                            <div class="col-md-8 col-xs-9 text-left mobile-padding">
                                                <p>{{$memberTransfer->description2}}</p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="arrow-down arrow-grey"></div>
                                </div>
                            </div>
                        </div>
                        <table class="table table-striped table-bordered" id="loan_table" >
                            <thead> 
                                <tr>
                                    @if(systemConfig()[29] == 1)
                                    <th>
                                        <i class="fa "></i> @lang('layout.TransactionConfirm')
                                    </th> 
                                    <th>
                                        <i class="fa "></i> @lang('layout.Description')
                                    </th>   
                                    <th>
                                        <i class="fa "></i> @lang('layout.Status')
                                    </th>  
                                    @endif      
                                </tr>
                            </thead>
                            <tbody>
                            <tr>  
                                @if(systemConfig()[29] == 1)
                                @if($memberTransfer->transaction_confirm)
                                <td class="">
                                    @lang('layout.yes')
                                </td>
                                @else
                                <td class="">
                                    @lang('layout.no')
                                </td>
                                @endif
                                <td class="">
                                    {{$memberTransfer->position_description}}
                                </td>
                                <td class="">
                                @if($memberTransfer->position_status == 'accept')
                                @lang('type.accept')
                                @elseif($memberTransfer->position_status == 'true')
                                @lang('type.pending') &nbsp;&nbsp;&nbsp;&nbsp;
                                @if (getPositionCurrencyAmount() > ($memberTransfer->exchanged_amount + $memberTransfer->exchanged_amount1))
                                <form action="{{route('memberTransfer.position_status', ['id' => $memberTransfer->id, 'type' => 'accupt'])}}" method="post" class="inline">
                                    <input type="hidden" name="_method" value="PATCH" />
                                    <input type="hidden" name="_token" value="{{csrf_token()}}"/>
                                    <input type="text" name="position_description" required style="width: 40%;" />
                                    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                    <label class="mt-checkbox mt-checkbox-outline"  style="color: green;">
                                        <input type="radio" value="accupt" required name="type"><span></span> @lang('layout.Accept')
                                    </label>
                                    &nbsp;&nbsp;
                                    <label class="mt-checkbox mt-checkbox-outline" style="color: red;">
                                        <input type="radio" value="reject" required name="type"><span></span> @lang('layout.Reject')
                                    </label>
                                    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                    <button type="button" onclick="regForm(this)" class="btn btn-info " title="{{__('layout.Submit')}}" role="button">{{__('layout.Submit')}}</button>
                                </form>
                                {{-- &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                <form action="{{route('memberTransfer.position_status', ['id' => $memberTransfer->id, 'type' => 'false'])}}" method="post" class="inline">
                                    <input type="hidden" name="_method" value="PATCH" />
                                    <input type="hidden" name="_token" value="{{csrf_token()}}"/>
                                    <input type="text" name="position_description" style="width: 35%;" />
                                    <button type="button" onclick="regForm(this)" class="btn btn-warning " title="{{__('type.on')}}" role="button"><span class="fa fa-ban"></button>
                                </form>   --}}
                                @endif
                                @elseif($memberTransfer->position_status == 'reject')
                                    @lang('type.Rejected')
                                @elseif($memberTransfer->position_status == 'false')
                                    @lang('type.cancel')
                                @endif
                                </td>
                                @endif
                            </tr>
                            </tbody>
                        </table>
                        
                        <br/>
                        <div class="row hidden-print">
                            <div class="tabbable tabbable-tabdrop">
                                <ul class="nav nav-tabs">
                                    <li class="active">
                                        <a href="#tab2" data-toggle="tab" id="tab_payment">@lang('layout.Attachments')</a>
                                    </li>
                                </ul>
                                <div class="tab-content">
                                    <div class="tab-pane active" id="tab2">
                                        <div class="tab-pane" id="tab2">
                                            <div class="portlet light">
                                                <div class="portlet-title">
                                                    <div class="caption font-dark">
                                                        <i class="icon-settings font-dark"></i>
                                                        <span class="caption-subject bold uppercase">@lang('layout.Attachments')</span>
                                                    </div>
                                                </div>
                                                <div class="portlet-body">
                                                    <div class="portlet light" style="box-shadow: 0px 0px 3px rgba(172, 171, 171, 0.877);border-radius: 8px;">
                                                        <div class="portlet-body">
                                                            <form role="form" action="{{route('attachment.store')}}" method="post" enctype="multipart/form-data">
                                                                @csrf
                                                                <input type="hidden" name="redirect_route" value="memberTransfer.show">
                                                                <input type="hidden" name="foreign_data_id" value="{{$memberTransfer->id}}">
                                                                <input type="hidden" name="path" value="uploads/member_transfers">
                                                                <input type="hidden" name="table_name" value="member_transfers">
                                                                <div class="row">
                                                                    <div class="col-lg-12">
                                                                        <div class="form-group">
                                                                            <label class="control-label">@lang('layout.AttachmentTitle')</label>
                                                                            <input type="text" name="title" class="form-control">
                                                                        </div>
                                                                    </div>
                                                                    <div class="col-lg-6">
                                                                        <div class="form-group">
                                                                            <label class="control-label">@lang('layout.Description')</label>
                                                                            <textarea name="description" class="form-control" rows="8" style="resize: none;"></textarea>
                                                                        </div>
                                                                    </div>
                                                                    <div class="col-lg-6">
                                                                        <div class="form-group">
                                                                            <div class="fileinput fileinput-new" data-provides="fileinput" style="width: 100%;">
                                                                                <div>
                                                                                    <span class="btn default btn-file">
                                                                                        <span class="fileinput-new">@lang('layout.SelectFile')</span>
                                                                                        <span class="fileinput-exists">@lang('layout.Change')</span>
                                                                                        <input type="hidden" value="" name=""><input type="file" name="photo"> 
                                                                                    </span>
                                                                                    <a href="javascript:;" class="btn default fileinput-exists" data-dismiss="fileinput"> @lang('layout.Remove') </a>
                                                                                </div>
                                                                                <div class="fileinput-new thumbnail" style="width: 100%; height: 165px;">
                                                                                    <img src="" alt=""> </div>
                                                                                <div class="fileinput-preview fileinput-exists thumbnail" style="max-width: 100%; max-height: 150px; line-height: 10px;"> </div>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="margin-top-10 text-center">
                                                                    <button type="button" onclick="regForm(this)" class="btn green"> @lang('layout.Submit') </button>
                                                                    <a href="{{route('receive.index')}}" class="btn default">@lang('layout.Cancel')</a>
                                                                </div>
                                                            </form>
                                                        </div>
                                                    </div>
                                                    <table class="table table-striped table-bordered table-hover" id="attachment">
                                                        <thead>
                                                            <tr>
                                                                <th>@lang('layout.AttachmentTitle')</th>
                                                                <th>@lang('layout.Description')</th>
                                                                <th>@lang('layout.Action')</th>
                                                            </tr>
                                                        </thead>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>


                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>
</div>


@endsection
@include('print.modal')

@push('scripts')

<script>
    $('#excell_all').on('click', function(e) {
        $('#show-modal2').click();
        e.preventDefault();
    })

    var vm = new Vue({

        el: '#print-modal',
        data: {
            is_show: false,
            pdfRoute: '{!!route("export.PDFAny") !!}',
            excelRoute: '{!! route("export.exportCsv") !!}'
        },

        methods: {
            closeModal: function() {
                this.is_show = !this.is_show;
            }
        }
    });

    var anchor = new Vue({
        el: '#anchore-modal',
        methods: {
            showModal: function() {
                console.log('trr')
                vm.$data.is_show = true;
            }
        }
    });


    $(document).ready(function() {
        $.fn.dataTable.ext.errMode = '{{dataTableWarning()}}';
        $('#attachment').DataTable({
            ajax: {
                url: '{{route("memberTransfer.show",$memberTransfer->id)}}',
                data: {
                    type: 'attachment'
                }
            },

            scrollCollapse: true,
            responsive: '{{responsiveDataTable()}}',
            pagingType: '{{paginationType()}}',
            serverSide: true,
            paging: true,
            columns: [

                {
                    data: 'title',
                    name: 'attachments.title'
                },
                {
                    data: 'description',
                    name: 'attachments.description'
                },
                {
                    data: 'actions',
                    name: 'actions',
                    orderable: false,
                    searchable: false
                },
            ]
        });



    });

</script>
@endpush