@extends('layouts.app')
@section('style')
<style>
    .modal-container {
        width: 60% !important;
    }
</style>
@endsection
@section('content')

    <!-- END PAGE HEADER-->
    {{-- <div id="print-modal">
        <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show"
                      :value-type="'memberTransferList'"
                      @closed="closeModal">
            <div slot="body">
                <div class="row">
                    <div class="form-group">
                        <div class="col-md-4">
                            <label class="control-label ">@lang('layout.SelectClass')</label>
                            <v-select class="vue-select2"
                                      v-model="selected_class"
                                      label="name"
                                      :options="member_class">
                            </v-select>
                            <input type="hidden" name="class_id" :value="(!selected_class)?null:selected_class.id">
                        </div>
                        <div class="col-md-4">
                            <label class="control-label">@lang('layout.Member')</label>
                            <v-select v-model="selectedToMember" label="name" :options="member"  @search="MemberSearch" >
                            </v-select>
                            <input type="hidden" name="member_id" v-model.number="(!selectedToMember)?null:selectedToMember.id" >
                        </div>
                        @if(systemConfig()[20] == 1)
                        <div class="col-md-4">
                            <label class="control-label">@lang('layout.ContractName')</label>
                            <v-select class="vue-select2" placeholder="@lang('layout.Select')"
                                    v-model="selectedContract" label="company_name"
                                    :options="{{$contract}}">
                            </v-select>
                            <input type="hidden" name="contract_id" v-model.number="(!selectedContract)?null:selectedContract.id" />
                        </div>
                        @endif 
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-4">
                        <label class="control-label">@lang('layout.Currency')</label>
                        <v-select v-model="selectedCurrency" label="code" :options="currency" > </v-select>
                        <input type="hidden" name="currency" v-bind:value="(!selectedCurrency)?null:selectedCurrency.code">
                    </div>
                    @if(getFinancialClass() =='true') 
                    @permission('financialClass-list')
                    <div class="col-md-4">
                        <label class="control-label"> @lang('menu.FinancialClass')</label>
                        <select name="financial_class_id" class="form-control" >
                            <option value="">@lang('layout.SelectClass')</option>
                            <option value="Unclassified">Unclassified</option>
                            <option v-for="cla in financial_classes" :value="cla.id" :key="cla.id" >@{{cla.name}}</option>
                        </select>
                    </div>
                    @endpermission
                    @endif
                </div>
                <div class="row">
                    <div class="form-group">
                        <div class="col-md-12">
                            <label class="control-label"> @lang('layout.Date')</label>
                                <div class="input-group">
                                    <input class="form-control date" id="range-from-example" name="from_date" autocomplete="off">
                                    <span class="input-group-addon"> @lang('layout.To') </span>
                                    <input class="form-control date" id="range-to-example" name="to_date" autocomplete="off">
                                </div>
                        </div>
                    </div>
                </div>
            </div>
        </report-modal>
    </div> --}}
    <div id="print-modal">
        <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show" :value-type="'memberTransferList'"  @closed="closeModal"> 
            <div slot="body">
                <!----------------------------------------------
                ----Begin Report Body And Custome Report-------
                ----------------------------------------------->
                <div class="row" v-cloak>
                         <div class="tabbable tabbable-tabdrop">
                            <ul class="nav nav-tabs">
                                <li class="active">
                                    <a href="#tab1" data-toggle="tab" id="tab_main">@lang('menu.Report')</a>
                                </li>
                                @if(systemConfig()[2] != 0 )
                                        @permission(['customreport-list'])
                                <li class="">
                                    <a href="#tab2" data-toggle="tab" id="tab_custome">@lang('layout.CustomReportM')</a>
                                </li>
                                @endpermission
                                @endif
                            </ul>
                            <div class="tab-content">
                                <div class="tab-pane active" id="tab1"> 
                                    <div class="portlet light bordered">
                                        <div class="row">
                                            <div class="form-group">
                                                <div class="col-md-4">
                                                    <label class="control-label ">@lang('layout.SelectClass')</label>
                                                    <v-select class="vue-select2"
                                                              v-model="selected_class"
                                                              label="name"
                                                              :options="member_class">
                                                    </v-select>
                                                    <input type="hidden" name="class_id" :value="(!selected_class)?null:selected_class.id">
                                                </div>
                                                <div class="col-md-4">
                                                    <label class="control-label">@lang('layout.FromMember')</label>
                                                    <v-select v-model="selectedFromMember" label="name" :options="member"  @search="MemberSearch" >
                                                    </v-select>
                                                    <input type="hidden" name="from_member_id" v-model.number="(!selectedFromMember)?null:selectedFromMember.id" >
                                                </div>
                                                <div class="col-md-4">
                                                    <label class="control-label">@lang('layout.ToMember')</label>
                                                    <v-select v-model="selectedToMember" label="name" :options="member"  @search="MemberSearch" >
                                                    </v-select>
                                                    <input type="hidden" name="to_member_id" v-model.number="(!selectedToMember)?null:selectedToMember.id" >
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            @if(systemConfig()[20] == 1)
                                            <div class="col-md-4">
                                                <label class="control-label">@lang('layout.ContractName')</label>
                                                <v-select class="vue-select2" placeholder="@lang('layout.Select')"
                                                        v-model="selectedContract" label="company_name"
                                                        :options="{{$contract}}">
                                                </v-select>
                                                <input type="hidden" name="contract_id" v-model.number="(!selectedContract)?null:selectedContract.id" />
                                            </div>
                                            @endif 
                                            <div class="col-md-4">
                                                <label class="control-label">@lang('layout.Currency')</label>
                                                <v-select v-model="selectedCurrency" label="code" :options="currency" > </v-select>
                                                <input type="hidden" name="currency" v-bind:value="(!selectedCurrency)?null:selectedCurrency.code">
                                            </div>
                                            @if(systemConfig()[29] == 1)
                                            <div class="col-md-1">
                                                <label class=" control-label">@lang('layout.TransactionConfirm')</label>
                                                <div class="col-md-12 mt-checkbox">
                                                    <label class="mt-checkbox mt-checkbox-outline"> 
                                                        <input type="checkbox" name="transaction_confirm" value="On">
                                                        <span></span>
                                                    </label>
                                                </div>
                                            </div>
                                            @endif
                                            @if(getFinancialClass() =='true') 
                                            @permission('financialClass-list')
                                            <div class="col-md-4">
                                                <label class="control-label"> @lang('menu.FinancialClass')</label>
                                                <select name="financial_class_id" class="form-control" >
                                                    <option value="">@lang('layout.SelectClass')</option>
                                                    <option value="Unclassified">Unclassified</option>
                                                    <option v-for="cla in financial_classes" :value="cla.id" :key="cla.id" >@{{cla.name}}</option>
                                                </select>
                                            </div>
                                            @endpermission
                                            @endif
                                        </div>
                                        <div class="row">
                                            <div class="form-group">
                                                <div class="col-md-12">
                                                    <label class="control-label"> @lang('layout.Date')</label>
                                                        <div class="input-group">
                                                            <input class="form-control date" id="range-from-example" name="from_date" autocomplete="off">
                                                            <span class="input-group-addon"> @lang('layout.To') </span>
                                                            <input class="form-control date" id="range-to-example" name="to_date" autocomplete="off">
                                                        </div>
                                                </div>
                                            </div>
                                        </div>
                                        
                                    </div>
                                </div> 
                                <div class="tab-pane" id="tab2"> 
                                    <div class="portlet light bordered">
                                        <div class="portlet-body">
                                            <form  id="saveCustomeReport" role="form" action="{{route('customeReport.storeCustomeReport')}}" method="post" >
                                                @csrf
                                                <input type="hidden" name="part_name" value="member_Transfer_money_index">
                                                <div class="col-md-12 col-sm-12 col-xs-12">
                                                    <div class="mt-checkbox-inline col-md-2" style="padding: 0px;" v-for="(row,itemIndex) in customReportData">
                                                        <div class="form-group">
                                                            <table class="table table-striped table-bordered table-advance table-hover">
                                                                <tr>
                                                                    <td style="text-align: center;">@{{ row.Name }}</td>
                                                                </tr>
                                                                <tr>
                                                                    <td style="text-align: center;">
                                                                        <input type="hidden" :name="'column_name['+itemIndex+']'" class="form-control" v-model="row.column_name">
                                                                        <label class="switch">
                                                                            <input type="checkbox" :name="'column_status['+itemIndex+']'" 
                                                                            :checked="row.checkedColumn" >
                                                                            <span class="slider round"></span>
                                                                        </label>
                                                                        <select :name="'column_percentage['+itemIndex+']'" v-model="row.column_percentage" class="form-control" style="width: 90%;">
                                                                            <option value="">@lang('layout.Select')</option>
                                                                            <option value="2">2 %</option>
                                                                            <option value="6">6 %</option>
                                                                            <option value="10">10 %</option>
                                                                            <option value="15">15 %</option>
                                                                            <option value="20">20 %</option>
                                                                            <option value="25">25 %</option>
                                                                            <option value="30">30 %</option>
                                                                            <option value="40">40 %</option>
                                                                            <option value="50">50 %</option>
                                                                            <option value="60">60 %</option>
                                                                        </select>
                                                                    </td>
                                                                </tr>
                                                            </table>
                                                            <!-- <label> @{{ row.Name }}</label>
                                                            <input type="hidden" :name="'column_name['+itemIndex+']'" class="form-control" v-model="row.column_name">
                                                            <label class="switch">
                                                                <input type="checkbox" :name="'column_status['+itemIndex+']'" 
                                                                :checked="row.checkedColumn" >
                                                                <span class="slider round"></span>
                                                            </label> -->
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="margiv-top-10">
                                                    <!-- <button type="button" onclick="regForm(this)" class="btn green"> <i class="fa fa-save"></i> </button> -->
                                                    <button type="button" onclick="saveCustomeReport(this)" class="btn blue"> <i class="fa fa-save"></i> </button>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                            </div>
                    </div>
                </div>
                <!----------------------------------------------
                ----Begin Report Body And Custome Report-------
                ----------------------------------------------->
            </div>
        </report-modal>
    </div>

    <!-- BEGIN TAB PORTLET-->
    <div class="row">

        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>
                    <span class="caption-subject bold uppercase">@lang('layout.MemberTransferList') </span>
                </div>
                <div class="tools"></div>
                <div class=" pull-right">
                 
                    <span id="anchore-modal">
                       <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                          <i class="fa fa-print"></i>
                       </a>
                    </span>

                    <a href="{{route('memberTransfer.create')}}">
                        <button class="btn btn-success">
                            <i class="fa fa-plus"></i> @lang('layout.AddNew')
                        </button>
                    </a>

                </div>
            </div>
            <div class="portlet-body">
                <template v-cloak id="company_ll">
                    <company @company="setCompany"></company>
                </template>
                <table class="table table-striped table-bordered table-hover" cellspacing="0" id="transferAccounts">
                    <thead>
                    <tr>
                        <th>@lang('layout.Number')</th>
                        <th>@lang('layout.FromMember')</th>
                        <th>@lang('layout.ToMember')</th>
                        <th>@lang('layout.Receivable')</th>
                        <th>@lang('layout.Payable') </th>
                        <th>@lang('layout.Currency')</th>
                        <th>@lang('layout.Rate')</th>
                        <th>@lang('layout.Date')</th>
                        <th>@lang('layout.Hour')</th>
                        @if(systemConfig()[20] == 1)
                        <th>@lang('layout.Contract')</th>
                        @endif
                        @if(systemConfig()[29] == 1)
                        <th>@lang('layout.Status')</th>
                        @endif
                        <th>@lang('layout.User')</th>
                        <th>@lang('layout.Description')</th>
                        <th style="width: 10% !important;">@lang('layout.Actions')</th>
                    </tr>
                    </thead>
                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>
    <!-- END TAB PORTLET-->
    <!-- END CONTENT BODY -->
@stop
@include('groupCompanyFilter.select')
@include('print.modal')
@push('scripts')
    <script>
        var cust_rep = {!!customeReportNewData('member_Transfer_money_index')!!};
        let data_table;
        $(document).ready(function () {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
            data_table = $('#transferAccounts').DataTable({
                ajax: '{{route("memberTransfer.index")}}',
                pageLength: '{{getPageRows()}}',
                scrollCollapse: true,
                order: [["{{orderByColumn()=='number'?0:7}}", "{{getRowOrder()}}"]],
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                serverSide: true,
                paging: true,
                buttons: [{
                    extend: 'excel',
                    text: '',
                    key: {
                        key: 'x',
                        altkey: true
                    }
                }],
                columns: [
                    {data: 'number', name: 'number'},
                    {data: 'oname', name: 'oname'},
                    {data: 'nname', name: 'nname'},
                    {data: 'amount', name: 'amount'},
                    {data: 'namount', name: 'namount'},
                    {data: 'currency', name: 'currency'},
                    {data: 'rate', name: 'rate', searchable: false},
                    {data: 'date', name: 'date', searchable: false},
                    {data: 'hour', name: 'hour', searchable: false},
                    @if(systemConfig()[20] == 1)
                    {data: 'company_name', name: 'company_name'},
                    @endif
                    @if(systemConfig()[29] == 1)
                    {
                        data: 'position_status',
                        name: 'position_status',
                        searchable: false
                    },
                    @endif
                    {data: 'username', name: 'username'},
                    {data: 'description', name: 'description'},
                    {data: 'actions', name: 'actions',orderable: false, searchable: false},
                ]
            });
        });
        Vue.component('v-select', VueSelect.VueSelect)
        var member_class  = {!!json_encode($member_class)!!}
        var currency2 ={!! $currency !!}
        var vm = new Vue({
            el: '#print-modal',
            data: {
                member: [],
                selectedToMember: null,
                selectedFromMember: null,
                is_show: false,
                pdfRoute: '{!!route('export.PDFAll') !!}',
                excelRoute: '{!! route('export.ExcelAll') !!}',
                selected_class:null,
                member_class:member_class,
                selectedContract: null,
                currency: currency2,
                selectedCurrency: null,
                financial_classes: {!!getFinancialClassList()!!},
                customReportData:
                [  
                 {Name: '@lang("layout.Number")', column_name: 'number',checkedColumn:(cust_rep.number)?'checked':'',column_percentage:(cust_rep.number___percent)?cust_rep.number___percent:''},
                 {Name: '@lang("layout.Date")', column_name: 'date',checkedColumn:(cust_rep.date)?'checked':'',column_percentage:(cust_rep.date___percent)?cust_rep.date___percent:''},
                 {Name: '@lang("layout.Hour")', column_name: 'hour',checkedColumn:(cust_rep.hour)?'checked':'',column_percentage:(cust_rep.hour___percent)?cust_rep.hour___percent:''},
                 {Name: '@lang("layout.Description")', column_name: 'description',checkedColumn:(cust_rep.description)?'checked':'',column_percentage:(cust_rep.description___percent)?cust_rep.description___percent:''},
                 {Name: '@lang("layout.FromMember")', column_name: 'fromMember',checkedColumn:(cust_rep.fromMember)?'checked':'',column_percentage:(cust_rep.fromMember___percent)?cust_rep.fromMember___percent:''},
                 {Name: '@lang("layout.ToMember")', column_name: 'toMember',checkedColumn:(cust_rep.toMember)?'checked':'',column_percentage:(cust_rep.toMember___percent)?cust_rep.toMember___percent:''}, 
                 {Name: '@lang("layout.Receivable")', column_name: 'receivable',checkedColumn:(cust_rep.receivable)?'checked':'',column_percentage:(cust_rep.receivable___percent)?cust_rep.receivable___percent:''},
                 {Name: '@lang("layout.HomeCurency") @lang("layout.Receivable")', column_name: 'receivableBase',checkedColumn:(cust_rep.receivableBase)?'checked':'',column_percentage:(cust_rep.receivableBase___percent)?cust_rep.receivableBase___percent:''},
                 {Name: '@lang("layout.Payable")', column_name: 'payable',checkedColumn:(cust_rep.payable)?'checked':'',column_percentage:(cust_rep.payable___percent)?cust_rep.payable___percent:''},
                 {Name: '@lang("layout.HomeCurency") @lang("layout.Payable")', column_name: 'payableBase',checkedColumn:(cust_rep.payableBase)?'checked':'',column_percentage:(cust_rep.payableBase___percent)?cust_rep.payableBase___percent:''},
                 {Name: '@lang("layout.Currency")', column_name: 'currency',checkedColumn:(cust_rep.currency)?'checked':'',column_percentage:(cust_rep.currency___percent)?cust_rep.currency___percent:''},
                 {Name: '@lang("layout.Rate")', column_name: 'rate',checkedColumn:(cust_rep.rate)?'checked':'',column_percentage:(cust_rep.rate___percent)?cust_rep.rate___percent:''},
                 {Name: '@lang("layout.Contract")', column_name: 'contract',checkedColumn:(cust_rep.contract)?'checked':'',column_percentage:(cust_rep.contract___percent)?cust_rep.contract___percent:''},
                 {Name: '@lang("layout.User")', column_name: 'user',checkedColumn:(cust_rep.user)?'checked':'',column_percentage:(cust_rep.user___percent)?cust_rep.user___percent:''},
                 {Name: '@lang("layout.TransactionConfirm")', column_name: 'transaction_confirm',checkedColumn:(cust_rep.transaction_confirm)?'checked':'',column_percentage:(cust_rep.transaction_confirm___percent)?cust_rep.transaction_confirm___percent:''},
                 {Name: '@lang("layout.MonetarySource")',
                    column_name: 'monetary_source',
                    checkedColumn: (cust_rep.monetary_source) ? 'checked' : '',
                    column_percentage:(cust_rep.monetary_source___percent)?cust_rep.monetary_source___percent:''
                },
                {Name: '@lang("layout.TransactionType")',
                        column_name: 'trans_type',
                        checkedColumn: (cust_rep.trans_type) ? 'checked' : '',
                        column_percentage:(cust_rep.trans_type___percent)?cust_rep.trans_type___percent:''
                },
                {Name: '@lang("layout.Count")',
                        column_name: 'trans_Count',
                        checkedColumn: (cust_rep.trans_Count) ? 'checked' : '',
                        column_percentage:(cust_rep.trans_Count___percent)?cust_rep.trans_Count___percent:''
                },
                {Name: '@lang("layout.StartDate")',
                        column_name: 'trans_StartDate',
                        checkedColumn: (cust_rep.trans_StartDate) ? 'checked' : '',
                        column_percentage:(cust_rep.trans_StartDate___percent)?cust_rep.trans_StartDate___percent:''
                },
                {Name: '@lang("layout.EndDate")',
                        column_name: 'trans_EndDate',
                        checkedColumn: (cust_rep.trans_EndDate) ? 'checked' : '',
                        column_percentage:(cust_rep.trans_EndDate___percent)?cust_rep.trans_EndDate___percent:''
                },
                {Name: '@lang("layout.ToMember")',
                        column_name: 'trans_ToMember',
                        checkedColumn: (cust_rep.trans_ToMember) ? 'checked' : '',
                        column_percentage:(cust_rep.trans_ToMember___percent)?cust_rep.trans_ToMember___percent:''
                },
                {Name: '@lang("layout.Currency")',
                        column_name: 'trans_Currency',
                        checkedColumn: (cust_rep.trans_Currency) ? 'checked' : '',
                        column_percentage:(cust_rep.trans_Currency___percent)?cust_rep.trans_Currency___percent:''
                },
                {Name: '@lang("layout.Receivable")',
                        column_name: 'trans_Receivable',
                        checkedColumn: (cust_rep.trans_Receivable) ? 'checked' : '',
                        column_percentage:(cust_rep.trans_Receivable___percent)?cust_rep.trans_Receivable___percent:''
                },
                {Name: '@lang("layout.Payable")',
                        column_name: 'trans_Payable',
                        checkedColumn: (cust_rep.trans_Payable) ? 'checked' : '',
                        column_percentage:(cust_rep.trans_Payable___percent)?cust_rep.trans_Payable___percent:''
                },
                {Name: '@lang("layout.Receivable") $',
                        column_name: 'trans_Receivable1',
                        checkedColumn: (cust_rep.trans_Receivable1) ? 'checked' : '',
                        column_percentage:(cust_rep.trans_Receivable1___percent)?cust_rep.trans_Receivable1___percent:''
                },
                {Name: '@lang("layout.Payable") $',
                        column_name: 'trans_Payable1',
                        checkedColumn: (cust_rep.trans_Payable1) ? 'checked' : '',
                        column_percentage:(cust_rep.trans_Payable1___percent)?cust_rep.trans_Payable1___percent:''
                },
                {Name: '@lang("layout.Currency")',
                        column_name: 'trans_currency1',
                        checkedColumn: (cust_rep.trans_currency1) ? 'checked' : '',
                        column_percentage:(cust_rep.trans_currency1___percent)?cust_rep.trans_currency1___percent:''
                },
                {Name: '@lang("layout.Amount")',
                        column_name: 'trans_amount1',
                        checkedColumn: (cust_rep.trans_amount1) ? 'checked' : '',
                        column_percentage:(cust_rep.trans_amount1___percent)?cust_rep.trans_amount1___percent:''
                },
                {Name: '@lang("layout.Amount") $',
                        column_name: 'trans_amount2',
                        checkedColumn: (cust_rep.trans_amount2) ? 'checked' : '',
                        column_percentage:(cust_rep.trans_amount2___percent)?cust_rep.trans_amount2___percent:''
                },
                {Name: '@lang("layout.AverageRate") $',
                        column_name: 'trans_AverageRate',
                        checkedColumn: (cust_rep.trans_AverageRate) ? 'checked' : '',
                        column_percentage:(cust_rep.trans_AverageRate___percent)?cust_rep.trans_AverageRate___percent:''
                },
                ],
                  cust_rep:cust_rep
            },
            methods: {
                MemberSearch: _.debounce((search, loading) => {
                    loading(true);
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'SearchMember', 
                            keyword: search
                        }
                    })
                    .then(function(response) {
                        if (response.data.length > 0) {
                            // console.log(response.data);
                            vm.member = [];
                            vm.member = response.data;
                        }
                        loading(false);
                    })
                    .catch(function(error) {
                        loading(false);
                        console.log(error);
                    })
                }, getDebounceTime()),
                closeModal: function () {
                    this.is_show = !this.is_show
                },
            }
        });
        new Vue({
            el: '#anchore-modal',
            methods: {
                showModal: function () {
                    console.log('trr')
                    vm.$data.is_show = true;
                }
            }
        });

        new Vue({
            el: '#company_ll',
            methods: {
                setCompany: function (event) {
                    if (typeof data_table == 'object'){
                        data_table.clear();
                        data_table.ajax.reload();
                    }
                }
            }
        });
    </script>
@endpush