@extends('layouts.app')
<link href="{{url('css/custome-table.css')}}" rel="stylesheet" type="text/css">
@section('style')
    <link href="{{URL::asset('assets/global/plugins/bootstrap-timepicker/css/bootstrap-timepicker.min.css')}}" rel="stylesheet" type="text/css" />
    <style>
    </style>
@stop
@section('content')
    <div class="">
        <div class="portlet light bg-inverse" style="min-height: 100%;">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>&nbsp;
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.MemberTransfer') </span>
                    <!-- <span class="caption-helper">some info...</span> -->
                </div>
                <div class="tools"></div>
            </div>
            <div class="portlet-body form" style="margin-bottom:50%;" id="member-transfer" v-cloak>
                <!-- BEGIN FORM-->
                {!! Form::model($memberTransfer,array('route' => ['memberTransfer.update',$memberTransfer->id],'method'=>'patch','class'=>'form-horizontal','id'=>'member-transfer-form')) !!}
                {{ csrf_field() }}
                <div class="form-body">
                    <div class="row" style="margin-bottom: 20px; padding-bottom: 20px;">
                        <div class="col-lg-8 col-md-12 col-sm-12" style="box-shadow: 0px 0px 3px rgba(172, 171, 171, 0.877);border-radius: 8px; margin-bottom: 10px; padding: 23px 0px;">
                            <div class="row" style="padding: 0.5% 1%;">
                                <div class="col-lg-6">
                                    <div class="col-lg-12">
                                        <label class="control-label">@lang('layout.FromMember')</label>
                                        <v-select @input="getSummary" v-model="selectedFromMember" label="name" @search="MemberSearch" :options="fromMember">
                                        </v-select>
                                        <input type="hidden" name="from_member_id"
                                               v-model.number="(!selectedFromMember)?null:selectedFromMember.id"
                                               v-validate="'required'" data-vv-as="@lang('layout.FromMember')">
                                        <span class="required">@{{errors.first('from_member_id')}}</span>
                                    </div>
                                    <div class="col-lg-12" style="padding: 0px !important;">
                                        <div class="col-lg-6">
											<label class="control-label">@lang('layout.Currency')</label>
											<v-select label="code" :options="currency" v-model="selected_currency"
													  @input="setAmount(), setAmount1()"></v-select>
											<input type="hidden" name="currency" v-validate="'required'"
												   data-vv-as="@lang('layout.Currency')" :value="selected_currency.code">
											<span class="required">@{{ errors.first('currency') }}</span>
										</div>
                                        <div class="col-lg-6">
											<label class="control-label">@lang('layout.Rate')</label>
											<input type="number" name="currency_rate" v-validate="'required'"
												   data-vv-as="@lang('layout.Rate')" @input="setAmount1()" 
												   v-model="!selected_currency?0:selected_currency.rate"
												   class="form-control">
											<span class="required">@{{ errors.first('currency_rate') }}</span>
										</div>
                                    </div>
                                    <div class="col-lg-6">
                                        <label class="control-label">@lang('layout.Payable')</label>
                                        <vue-numeric
                                            class="form-control"
                                            v-model="payable"
                                            :readonly="payable < receivable"
                                            :max="99999999999999"
                                            :currency="(selected_currency)?selected_currency.code:''"
                                            :precision="precision()"
                                            @input="setAmount1()"
                                            >
                                        </vue-numeric>
                                        <input type="hidden" v-validate="" data-vv-as="@lang('layout.Payable')" class="form-control" name="payable" v-model="payable" />
                                        <span class="required">@{{ errors.first('payable') }}</span>
                                    </div>
                                    <div class="col-lg-6">
                                        <label class="control-label">@lang('layout.Payable')</label>
                                        <input type="number" readonly v-validate=""
                                               data-vv-as="@lang('layout.Payable')" class="form-control" name="payable2"
                                               v-model="payable2" />
                                        <span class="required">@{{ errors.first('payable2') }}</span>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="col-lg-12">
                                        <label class="control-label">@lang('layout.ToMember')</label>
                                        <v-select v-model="selectedToMember" label="name" @input="setAmount1(), getSummary2()" @search="MemberSearch" :options="toMember">
                                        </v-select>
                                        <input type="hidden" name="to_member_id"
                                               v-model.number="(!selectedToMember)?null:selectedToMember.id"
                                               v-validate="'required'" data-vv-as="@lang('layout.ToMember')">
                                        <span class="required">@{{errors.first('to_member_id')}}</span>
                                    </div>
                                    <div class="col-lg-12" style="padding: 0px !important;">
                                        <div class="col-lg-6">
                                            <label class="control-label">@lang('layout.ToCurrency2')</label>
                                           <v-select label="code" :options="currency" v-model="selected_currency2"
                                                     @input="setAmount1()"></v-select>
                                           <input type="hidden" name="currency2" v-validate="'required'"
                                                  data-vv-as="@lang('layout.Currency')" :value="selected_currency2.code">
                                           <span class="required">@{{ errors.first('currency2') }}</span>
                                        </div>
                                       <div class="col-lg-6">
                                            <label class="control-label">@lang('layout.ToRate')</label>
                                            <input type="number" name="currency_rate2" v-validate="'required'"
                                                data-vv-as="@lang('layout.Rate')" @input="setAmount1()"
                                                v-model="!selected_currency2?0:selected_currency2.rate"
                                                class="form-control">
                                            <span class="required">@{{ errors.first('currency_rate2') }}</span>
                                       </div>
                                    </div>
                                    <div class="col-lg-6">
                                        <label class="control-label">@lang('layout.Receivable')</label>
                                        <vue-numeric
                                            class="form-control"
                                            v-model="receivable"
                                            :readonly="payable > receivable"
                                            :max="99999999999999"
                                            :currency="(selected_currency)?selected_currency.code:''"
                                            :precision="precision()"
                                            @input="setAmount1()">
                                        </vue-numeric>
                                        <input type="hidden" class="form-control" name="receivable" v-model="receivable" v-validate="" data-vv-as="@lang('layout.Receivable')" />
                                        <span class="required">@{{ errors.first('receivable') }}</span>
                                    </div>
                                    <div class="col-lg-6">
                                        <label class="control-label">@lang('layout.Receivable')</label>
                                        <input type="number" readonly class="form-control"
                                               name="receivable2" v-model="receivable2" v-validate=""
                                               data-vv-as="@lang('layout.Receivable')" />
                                        <span class="required">@{{ errors.first('receivable2') }}</span>
                                    </div>
                                </div>
                                <div class="col-lg-12">
                                    <div class="col-lg-4">
                                        <label class="control-label">@lang('layout.Date')</label>
                                        <input type="text" class="form-control date" value="{{$memberTransfer->date}}" autocomplete="off" name="date">
                                    </div>
                                    <div class="col-lg-4">
                                        <label class="control-label">@lang('layout.Hour')</label>
                                        <div class="input-group"> 
                                            @if(getHourType() == 24)
                                            <input type="text" class="form-control timepicker timepicker-24" name="hour" value="{{$memberTransfer->hour}}">
                                            @else
                                            <input type="text" class="form-control timepicker timepicker-no-seconds" name="hour" value="{{$memberTransfer->hour}}">
                                            @endif
                                            <span class="input-group-btn">
                                                <button class="btn default" type="button">
                                                    <i class="fa fa-clock-o"></i>
                                                </button>
                                            </span>
                                        </div>
                                    </div>
                                    <div class="col-lg-4">
                                        <label class="control-label">@lang('layout.Number')</label>
                                        <input type="number" class="form-control" name="number" v-validate="'required'" value="{{ $memberTransfer->number }}"
                                               data-vv-as="@lang('layout.Number')" />
										<span class="required">@{{ errors.first('number') }}</span>
                                    </div>
                                    @if(systemConfig()[20] == 1)
                                    <div class="col-lg-4">
                                        <label class="control-label">@lang('layout.ContractName')</label>
                                        <v-select class="vue-select2" placeholder="@lang('layout.Select')"
                                                v-model="selectedContract" label="company_name"
                                                :options="{{$contract}}">
                                        </v-select>
                                        <input type="hidden" name="contract_id" v-model.number="(!selectedContract)?null:selectedContract.id" />
                                    </div>
                                    @endif
                                    <div class="col-lg-4">
                                        <label class="control-label">@lang('layout.MonetarySource')</label>
                                            {!! Form::text('monetary_source', null, array('placeholder' => __('layout.MonetarySource'),'class' => 'form-control')) !!}
                                    </div>
                                    <div class="col-lg-4">
                                        <label class="control-label">@lang('layout.TransactionType')</label>
                                        {!! Form::text('trans_type', null, array('placeholder' => __('layout.TransactionType'),'class' => 'form-control')) !!}
                                    </div>
                                    @if(systemConfig()[29] == 1)
                                    <div class="col-lg-4">
                                        <label class=" control-label">@lang('layout.TransactionConfirm')</label>
                                        <div class="col-md-12 mt-checkbox">
                                            <label class="mt-checkbox mt-checkbox-outline"> 
                                                <input type="checkbox" name="transaction_confirm" v-model="show_transaction_confirm_checked" value="On" v-validate="'required'" data-vv-as="@lang('layout.TransactionConfirm')" >
                                                <span></span>
                                            </label>
                                        </div>
                                        <span class="required">@{{ errors.first('transaction_confirm') }}</span>
                                    </div>
                                    @endif
                                </div>
                                <div class="col-lg-12">
                                    <div class="col-lg-6">
                                        <label class="control-label">@lang('layout.Description') 1</label>
                                        <textarea name="description" rows="2" class="form-control">{{$memberTransfer->description}}</textarea>
                                    </div>
                                    <div class="col-lg-6">
                                        <label class="control-label">@lang('layout.Description') 2</label>
                                        <textarea name="description2" rows="2" class="form-control">{{$memberTransfer->description2}}</textarea>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-4 col-md-12 col-sm-12">
                            <div class="col-lg-12 col-md-12 col-sm-12" style="box-shadow: 0px 0px 3px rgba(172, 171, 171, 0.877);border-radius: 8px;padding: 0px !important;margin-bottom: 10px; padding: 10px;">
                                <div class="panel panel-default" style="padding: 10px;">
                                    <h3>@lang('layout.FromMember')</h3>
                                    <div class="panel-body">
                                        <table class="table table-bordered">
                                            <thead>
                                                <tr>
                                                    <th class="text-center">@lang('layout.Currency') </th>
                                                    <th class="text-center">@lang('layout.Payable')</th>
                                                    <th class="text-center">@lang('layout.Receivable')</th>
                                                    <th class="text-center">@lang('layout.AverageRate')</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <span v-if="selectedFromMember">
                                                    <tr v-for="summ in summary">
                                                        <td class="highlight text-center">
                                                            @{{ summ.currency }}
                                                        </td>
                                                        <td class="text-center"> 
                                                            @{{ format_number(Number(summ.payment)) }}
                                                        </td>
                                                        <td class="text-center">
                                                            @{{ format_number(Number(summ.invoice)) }}
                                                        </td>
                                                        <td class="text-center">
                                                            @{{format_number(Number(summ.rate))}}
                                                        </td>
                                                    </tr>
                                                </span>
                                            </tbody>
                                        </table>
                                        @if(systemConfig()[22] == 1) 
                                            <br/>
                                            <table class="dashboard-tabel table-bordered" width="100%">
                                                <thead>
                                                    <tr v-if="selectedFromMember">
                                                        <th style="background-color: #add8e6;text-align: center;" v-if="selectedFromMember.risk_step">
                                                            @lang('layout.RiskStep')
                                                        </th>
                                                        <th v-if="selectedFromMember.risk_step == 'High'" style="background-color: #ff5353;text-align: center;" > @lang('type.High')</th>
                                                        <th v-if="selectedFromMember.risk_step == 'Medium'" style="background-color: #ffe291;text-align: center;" > @lang('type.Medium')</th>
                                                        <th v-if="selectedFromMember.risk_step == 'Low'" style="background-color: #8aff9a;text-align: center;" > @lang('type.Low')</th>
                                                    </tr>
                                                </thead>
                                            </table>    
                                        @endif
                                    </div>
                                </div>
                                <div class="panel panel-default" style="padding: 10px;">
                                    <h3>@lang('layout.ToMember')</h3>
                                    <div class="panel-body">
                                        <table class="table table-bordered">
                                            <thead>
                                                <tr>
                                                    <th class="text-center">@lang('layout.Currency') </th>
                                                    <th class="text-center">@lang('layout.Payable')</th>
                                                    <th class="text-center">@lang('layout.Receivable')</th>
                                                    <th class="text-center">@lang('layout.AverageRate')</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <span v-if="selectedToMember">
                                                    <tr v-for="summ in summary2">
                                                        <td class="highlight text-center">
                                                            @{{ summ.currency }}
                                                        </td>
                                                        <td class="text-center"> 
                                                            @{{ format_number(Number(summ.payment)) }}
                                                        </td>
                                                        <td class="text-center">
                                                            @{{format_number(Number(summ.invoice)) }}
                                                        </td>
                                                        <td class="text-center">
                                                            @{{format_number(Number(summ.rate))}}
                                                        </td>
                                                    </tr>
                                                </span>
                                            </tbody>
                                        </table>
                                        @if(systemConfig()[22] == 1) 
                                        <br/>
                                        <table class="dashboard-tabel table-bordered" width="100%">
                                            <thead>
                                                <tr v-if="selectedToMember">
                                                    <th style="background-color: #add8e6;text-align: center;" v-if="selectedToMember.risk_step">
                                                        @lang('layout.RiskStep')
                                                    </th>
                                                    <th v-if="selectedToMember.risk_step == 'High'" style="background-color: #ff5353;text-align: center;" > @lang('type.High')</th>
                                                    <th v-if="selectedToMember.risk_step == 'Medium'" style="background-color: #ffe291;text-align: center;" > @lang('type.Medium')</th>
                                                    <th v-if="selectedToMember.risk_step == 'Low'" style="background-color: #8aff9a;text-align: center;" > @lang('type.Low')</th>
                                                </tr>
                                            </thead>
                                        </table>    
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12 text-center">
                    <button type="button" @click="handleSubmit($event)" class="btn green">@lang('layout.Submit')</button>
                    <a href="{{route('inventorySite.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                    <hr>
                </div>
                {!! Form::close() !!}
            </div>
            <!-- END FORM-->
        </div>
    </div>
@endsection

@push('scripts')
    <script src="{{URL::asset('assets/global/plugins/bootstrap-timepicker/js/bootstrap-timepicker.min.js')}}" type="text/javascript"></script>
    <script src="{{URL::asset('assets/pages/scripts/components-date-time-pickers.min.js')}}" type="text/javascript"></script>
    <script>
        /**
         * for creating shortcuts
         */


        @if(App::getLocale())
        Vue.use(VeeValidate, {
            locale: '{{App::getLocale()}}',
        });
        @else
        Vue.use(VeeValidate, {
            locale: 'en',
        });
        @endif

        Vue.component('v-select', VueSelect.VueSelect);
        Vue.use(VueNumeric.default);

        var currency ={!! $currency !!};
        var selectedCurrency = {!! $selectedCurrency !!};
        var selectedCurrency2 = {!! $selectedCurrency2 !!};
        var contract = {!! $contract !!};
        let vm = new Vue({
            el: '#member-transfer',
            data: {
                memberTransfer:{!! $memberTransfer !!},
                selectedCurrency: selectedCurrency,
                selectedCurrency2: selectedCurrency2,
                fromMember: [],
                toMember: [],
                selectedFromMember: null,
                selectedToMember: null,
                show_transaction_confirm_checked: "{{$memberTransfer->transaction_confirm == 'On'}}",
                summary: [],
                summary2: [],
                selectedContract: null,
                currency: currency,
                selected_currency: defaultCurrency(),
				selected_currency2: defaultCurrency(),
                payable2: 0,
                receivable2: 0,
                payable: 0,
                receivable: 0,
                maxpayable: 0,
                maxreceivable: 0,
                payable_flag: false,
                receivable_flag: false,
                flag: false,
            },
            mounted: function () {
                if (this.memberTransfer) {

                    @if($selectedFromMember)
                    this.selectedFromMember = {!! $selectedFromMember !!};
                    @endif

                    this.selected_currency = this.selectedCurrency;
                    this.selected_currency2 = this.selectedCurrency2;

                    setTimeout(function () {
                        @if($selectedToMember)
                        this.selectedToMember = {!! $selectedToMember !!};
                        @endif
                        this.payable = this.memberTransfer.payable;
                        this.receivable = this.memberTransfer.receivable;
						this.payable2 = this.memberTransfer.payable2;
                        this.receivable2 = this.memberTransfer.receivable2;
                        this.payable_flag = false;

                        this.receivable_flag = false;
                        if (this.payable > this.receivable) {
                            this.payable_flag = true;
                        }
                        else {
                            this.receivable_flag = true;
                        }
                    }.bind(this), 2000);

                }

                @if($memberTransfer->contract_id != null)    
                    this.selectedContract = _.find(contract, (e) => e.id == {{$memberTransfer->contract_id}});
                @endif

            },
            methods: {

                setAmount() {

                    this.payable = 0;
                    this.receivable = 0;
                    this.payable2 = 0;
                    this.receivable2 = 0;
                    this.maxpayable = 0;
                    this.maxreceivable = 0;
                    if (this.selected_currency && this.selectedFromMember) {
						// this.selected_currency2 = this.selected_currency;
                        this.payable_flag = false;

                        this.receivable_flag = false;

                        if (this.summary.length > 0) {
                            for (var i = 0; i < this.summary.length; i++) {
                                if (this.summary[i].currency == this.selected_currency.code) {


                                    this.payable = this.summary[i].payment;
                                    this.payable2 = this.summary[i].payment;
                                    this.receivable = this.summary[i].invoice;
                                    this.receivable2 = this.summary[i].invoice;
                                    if (this.payable > this.receivable) {
                                        this.payable_flag = true;
                                    }
                                    else {
                                        this.receivable_flag = true;
                                    }
                                    this.maxpayable = this.payable;
                                    this.maxreceivable = this.receivable;
                                }
                            }


                        }
                    }

                },
				setAmount1() {
                    var payable = 0;
                    var receivable = 0;
                    if (this.selected_currency2 && this.selectedToMember) {
						// console.log(this.selected_currency2 , this.selectedToMember);
                    if (this.payable > this.receivable) {
						
						if (this.selected_currency2.rate > 0 && this.selected_currency.rate > 0) {
                            @if(systemConfig()[30] == 1)
							payable = myRound((this.payable / this.selected_currency.static_rate * this.selected_currency.rate) * this.selected_currency2.static_rate / this.selected_currency2.rate);
							this.payable2 = payable;
                            @else 
							payable = myRound((this.payable / this.selected_currency.rate) * this.selected_currency2.rate);
							this.payable2 = payable;
                            @endif
						}
                            
                    }
                    if (this.receivable > this.payable) {
						if (this.selected_currency2.rate > 0 && this.selected_currency.rate > 0) {
                            @if(systemConfig()[30] == 1)
							receivable = myRound((this.receivable / this.selected_currency.static_rate * this.selected_currency.rate) * this.selected_currency2.static_rate / this.selected_currency2.rate);
							this.receivable2 = receivable;
                            @else 
							receivable = myRound((this.receivable / this.selected_currency.rate) * this.selected_currency2.rate);
							this.receivable2 = receivable;
                            @endif
						}
                            
                    }
                    }

                },

                MemberSearch: _.debounce((search, loading) => {
                    loading(true);
                    
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'SearchMember', 
                            keyword: search
                        }
                    })
                    .then(function(response) {
                        if (response.data.length > 0) {
                            // console.log(response.data);
                            vm.fromMember = [];
                            vm.fromMember = response.data;
                            vm.toMember = [];
                            vm.toMember = response.data;
                        }
                        loading(false);
                    })
                    .catch(function(error) {
                        loading(false);
                        console.log(error);
                    })
                }, getDebounceTime()),
                
                getSummary() {
                    if (this.selectedFromMember) {
                        this.selectedToMember = null;
                        this.getSummaryRecor(this.selectedFromMember.id, this);

                    }

                },
                getSummaryRecor(id, vm) {
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'memberStatment',
                            member_id: id,
                        }
                    })
                        .then(function (response) {
                                vm.summary = [];

                            if (response.data.length > 0) {

                                vm.summary = response.data;
                                if (vm.selected_currency != null) {
                                    vm.setAmount();
                                }
                            }
                        })
                        .catch(function (error) {
                            console.log(error);
                        });
                },
                getSummary2() {
                    if (this.selectedToMember) {
                        // this.fillToMember();
                        this.getSummaryRecor2(this.selectedToMember.id, this); 
                    }

                },
                getSummaryRecor2(id, vm) {
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'memberStatment',
                            member_id: id,
                        }
                    })
                        .then(function (response) {
                                vm.summary2 = [];
                            if (response.data.length > 0) {
                                vm.summary2 = response.data;
                                // console.log(12222,response.data);
                                // if (vm.selected_currency != null) {
                                //     vm.setAmount();
                                // }
                            }
                        })
                        .catch(function (error) {
                            console.log(error);
                        });
                },
                handleSubmit(e) {
                    this.$validator.validate()
                        .then(valid => {
                            if (valid) {
                                if (Number.parseFloat(this.payable) > 0 || Number.parseFloat(this.receivable) > 0) {
									regForm(e.target);
                                }
                                else {
                                    var message = "{{__('message.Warning')}}";
                                    toastr.warning('', message);
                                }
                            }
                        })
                },


            }
        })
    </script>
@endpush