@extends('layouts.app')
@section('content')
@section('style')
@stop
<div class="row">

    <div class="portlet light bg-inverse" style="min-height: 100%;">
        <div class="portlet-title">
            <div class="caption">
                <i class="icon-equalizer font-green-haze"></i>&nbsp;
                <span class="caption-subject font-green-haze bold uppercase">@lang('layout.OpeningBalance')</span>
                <!-- <span class="caption-helper">some info...</span> -->
            </div>
            <div class="tools">

            </div>
        </div>
        <div class="table-scrollable">
            <table class="table table-striped table-bordered table-advance">
                <thead>
                    <tr>
                        <th>
                            <i class="fa  fa-user"></i> @lang('layout.Name')
                        </th>
                        <th>
                            <i class="fa fa-mobile"></i> @lang('layout.Phone')
                        </th>
                        <th>
                            <i class="fa fa-envelope-o"></i> @lang('layout.Email')
                        </th>
                        <th>
                            <i class="fa fa-bars"></i> @lang('layout.Code')
                        </th>


                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td class=""> {{ $memberInfo->name}}  </td>
                        <td class=""> {{ $memberInfo->phone}}  </td>
                        <td class=""> {{ $memberInfo->email}}  </td>
                        <td class=""> {{ $memberInfo->code}}  </td>
                    </tr>
                </tbody>
            </table>
        </div>
        <div class="portlet-body form" style="margin-bottom:50%;">
            <!-- BEGIN FORM-->
            <div class="form-body" id="app" v-cloak style="border: 1px solid rgb(214, 214, 214);padding: 20px;border-radius: 5px;">
                {!! Form::open(['route'=>['memberOpeningBalance.store',$memberInfo->id],'id'=>'memberOpeningBalance','method'=>'POST']) !!}
                <div>
                    <div class="row" style="margin-bottom: 10px;">
                        <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                            <label class="control-label">@lang('layout.Date') </label>
                            <div>
                                <input class="form-control date" id="range-from-example" name="date" value="{{$date}}" autocomplete="off">
                            </div>
                        </div>
                    </div>
                    <div class="row" style="background-color: rgb(80, 129, 141);width: 100% !important; margin: auto auto;">
                        <div class="col-md-2 text-center" style="color: white;">
                            <strong>@lang('layout.Currency')</strong>
                        </div>
                        <div class="col-md-2 text-center" style="color: white;">
                            <strong>@lang('layout.Rate')</strong>
                        </div>
                        <div class="col-md-2 text-center" style="color: white;">
                            <strong>@lang('layout.Receivable')</strong>
                        </div>
                        <div class="col-md-2 text-center" style="color: white;">
                            <strong>@lang('layout.Payable')</strong>
                        </div>
                        <div class="col-md-4 text-center" style="color: white;">
                            <strong>@lang('layout.Description')</strong>
                        </div>
                    </div>
                    <?php $x = 0;  ?>
                    <div style="border: 1px solid rgb(80, 129, 141);padding: 20px;">
                        @foreach(currency()->getCurrencies() as $currency)
                        <div class="row" v-for="(row,itemIndex) in rows">
                            <div class="col-md-2" style="margin-bottom: 5px;" v-if="itemIndex == {{ $x }}">
                                <div class="form-group">
                                    <input type="text" class="form-control" readonly name="currency[]"
                                           value="{{$currency['code']}}">
                                    <input type="hidden" name="currency_id[]" value="{{$currency['id']}}">
                                </div>
                            </div>
                            <div class="col-md-2" v-if="itemIndex == {{ $x }}">
                                <div class="form-group">
                                    <input type="text" name="exchange_rate[]" class="form-control"
                                           :value=" (row.rate && row.rate !=null && row.rate !=0)?row.rate:{{$currency['exchange_rate']}}" ref="rate" @input="setNewRate(itemIndex)">
                                </div>
                            </div>
                            <div class="col-md-2" v-if="itemIndex == {{ $x }}">
                                <div class="form-group">
                                    <input type="number" name="receivable[]" class="form-control" :disabled="!!row.payable"
                                           v-model.number="row.receivable">
                                    <input type="hidden" name="receivableWithCurrencyId[{{$currency['id']}}]"
                                           class="form-control" :disabled="!!row.payable" v-model.number="row.receivable">
    
                                    <input type="hidden" name="type[]" class="form-control"
                                           :value="(row.payable && row.payable !=null && row.payable !=0)?'payable':(row.receivable && row.receivable !=null && row.receivable !=0)?'receivable':''">
    
                                </div>
                            </div>
                            <div class="col-md-2" v-if="itemIndex == {{ $x }}">
                                <div class="form-group">
                                    <input type="number" name="payable[]" class="form-control" :disabled="!!row.receivable"
                                           v-model.number="row.payable">
                                    <input type="hidden" name="payableWithCurrencyId[{{$currency['id']}}]"
                                           class="form-control" :disabled="!!row.receivable" v-model.number="row.payable">
    
                                </div>
                            </div>
                            <div class="col-md-4" v-if="itemIndex == {{ $x }}">
                                <div class="form-group">
                                    <textarea name="description[]" id="" cols="30" rows="1" class="form-control"></textarea>
    
                                </div>
                            </div>
                            {{-- <div class="col-md-2">
                                <div class="form-group">
                                <label class="control-label">@lang('layout.Description') </label>
                                    <textarea name="description" id="" cols="30" rows="1" class="form-control"></textarea>
                            </div>
                        </div>  --}}
                        </div>
                        <?php $x++; ?>
                    @endforeach
                    </div>
                </div>
                {!!Form::close()!!}
            </div>
            <div class="col-xs-12 col-sm-12 col-md-12 text-center" style="margin-top: 10px;">
                <button type="submit" onClick="me()" class="btn green">@lang('layout.Submit')</button>
                <a href="{{route('customer.index')}}" class="btn default"><i class="fa fa-mail-reply"></i>@lang('layout.Cancel')</a>
            </div>
            {!! Form::close() !!}
        </div>
        <!-- END FORM-->
    </div>
</div>
@endsection

@push('scripts')
    <script src="{{url('/vue/sweetalert1.min.js')}}"></script>

    <script>
        var code = "{!! getHomeCurrency()["code"] !!}";
        var opening = {!! $memberOpeningBlance !!};
        var myc ={!!  json_encode(getCurrencies()) !!};
        new Vue({
            el: '#app',
            data: {
                currency:{!!  json_encode(getCurrencies()) !!},
                currencylength:{!!  count(Currency()->getCurrencies()) !!},
                openingList: opening,
                mycList: myc,
                selectedMember: null,
                rows: [],
            },
            created() {
                this.adddata();
            },
            computed: {},
            methods: {
                adddata() {
                    var temp = 0;
                    for (item in this.mycList) {

                        for (var i = 0; i < this.currencylength; i++) {
                            if (this.openingList[i] && this.openingList[i]['currency'] != null && this.openingList[i]['currency']) {
                                if (item == this.openingList[i]['currency']) {
                                    this.rows.push({
                                        receivable: this.openingList[i]['receivable'],
                                        payable: this.openingList[i]['payable'],
                                        rate: this.openingList[i]['rate'],
                                    });
                                }
                            }
                        }
                        temp++;
                        if (this.rows.length != temp) {
                            this.rows.push({
                                receivable: null,
                                payable: null,
                            });
                        }

                    }
                    console.log('ddddd',this.rows)

                },
                  setNewRate(index = null) {

                            if (this.rows[index]) {

                                this.rows[index].rate = this.$refs.rate[index].value;
                            }
                    
                    },
                openingSubmit() {
                    swal({
                        title: "Are you sure?",
                        text: "",
                        icon: "info",
                        buttons: true,
                        dangerMode: true,
                    })
                        .then((willDelete) => {
                            if (willDelete) {
                                document.getElementById("memberOpeningBalance").submit()

                            } else {

                            }
                        });
                },

            }
        });

        function me() {
            swal({
                title: "@lang('layout.AreYouSure?')",
                buttons: ["@lang('layout.Cancel')", "@lang('layout.Submit')"],
                text: "",
                icon: "info",
                dangerMode: true,
            })
                .then((willDelete) => {
                    if (willDelete) {
                        document.getElementById("memberOpeningBalance").submit();
                    }
                });
        }
    </script>


@endpush
